/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginLoader;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.plugins.PluginViewInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Icon;

public class WsOMAView
implements WsBaseView {
    private static WAdminResource bundle = WAdminResource.getBundle(WsOMAView.class);
    protected WAInternalFrame m_frame;
    protected Root m_metadata;
    private String m_sFQID;
    protected MdObjectListener m_lsnrMetadata;

    public WAInternalFrame getFrame() {
        return this.m_frame;
    }

    public void setMetadata(Root mdoObject) {
        try {
            this.m_metadata = mdoObject;
            this.m_sFQID = mdoObject != null ? mdoObject.getFQID() : null;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    public Root getMetadata() {
        return this.m_metadata;
    }

    @Override
    public String getID() {
        return this.m_sFQID;
    }

    public void setFrame(WAInternalFrame frame) {
        if (this.m_frame != null) {
            throw new UnsupportedOperationException("Can not change a view's frame once it has been set");
        }
        this.m_frame = frame;
        frame.setView(this);
        if (this.m_metadata != null) {
            WsLockManager.getInstance().addLock(this.m_sFQID);
            this.m_lsnrMetadata = this.createMetadataListener();
            try {
                this.m_metadata.addMdObjectListener(this.m_lsnrMetadata);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
        frame.setDefaultsName(this.getClass().getName());
        frame.useDefaultSize(true);
        frame.setTitle(this.getFrameTitle());
        frame.setFrameIcon(this.getFrameIcon());
    }

    public void updateFrameTitle() {
        this.m_frame.setTitle(this.getFrameTitle());
    }

    @Override
    public void dispose() {
        if (this.m_metadata != null) {
            WsLockManager.getInstance().removeLock(this.m_sFQID);
            try {
                this.m_metadata.removeMdObjectListener(this.m_lsnrMetadata);
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
            this.m_lsnrMetadata = null;
            this.m_metadata = null;
        }
        this.m_frame.setView(null);
        this.m_frame = null;
    }

    protected String getFrameTitle() {
        String sName;
        try {
            sName = this.m_metadata.getName();
        }
        catch (RemoteException ex) {
            sName = "";
        }
        return bundle.formatString("Common.Properties.fmt", sName);
    }

    protected Icon getFrameIcon() {
        Icon icon = WAdminResource.getTypeIcon((CMetadata)this.m_metadata);
        icon = WAdminResource.getCMTypeIcon((CMetadata)this.m_metadata, icon, false);
        return icon;
    }

    protected boolean getShouldShowAdvancedTabs() {
        WorkspaceFile appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        return appDefaultsFile.getPropertyBoolean("Workspace.ShowAdvancedPropertyTabs", true);
    }

    protected void addAuthorizationTab(WAPropertyTabGroup tabs, CMetadata oMetadata) {
        ArrayList alPlugins = this.getAuthorizationPluginTabs(oMetadata);
        int nTabs = alPlugins.size();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)alPlugins.get(iTab);
            tabs.addTab(tab.getTitle(), tab);
        }
    }

    protected void addAuthorizationTab(WATabbedPanel tabPanel, CMetadata oMetadata) {
        ArrayList alPlugins = this.getAuthorizationPluginTabs(oMetadata);
        int nTabs = alPlugins.size();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = (WAPropertyTab)alPlugins.get(iTab);
            tabPanel.addTab(tab.getTitle(), tab);
        }
    }

    protected ArrayList getAuthorizationPluginTabs(CMetadata oMetadata) {
        ArrayList<WAPropertyTab> alPluginTabs = new ArrayList<WAPropertyTab>();
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader == null) {
            return alPluginTabs;
        }
        ArrayList alPlugins = pluginLoader.getPlugins("com.sas.wadmin.plugins.authtab.AuthorizationTabPluginInterface", true);
        int nPlugins = alPlugins.size();
        for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
            PluginViewInterface plugTabs = (PluginViewInterface)alPlugins.get(iPlugin);
            ArrayList alTabs = plugTabs.getPropertyTabs(oMetadata);
            if (alTabs == null) continue;
            int nTabs = alTabs.size();
            for (int iTab = 0; iTab < nTabs; ++iTab) {
                WAPropertyTab tab = (WAPropertyTab)alTabs.get(iTab);
                alPluginTabs.add(tab);
            }
        }
        return alPluginTabs;
    }

    protected MdObjectListener createMetadataListener() {
        return new cMetadataListener();
    }

    protected class cMetadataListener
    implements MdObjectListener {
        protected cMetadataListener() {
        }

        public void MdObjectModified(MdEvent e) {
            WsOMAView.this.m_frame.setFrameIcon(WsOMAView.this.getFrameIcon());
            WsOMAView.this.m_frame.setTitle(WsOMAView.this.getFrameTitle());
        }
    }
}

