/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsWorkspaceComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class WsMessagesPropertyTab
extends WAPropertyTab
implements WsWorkspaceComponent {
    private static final long serialVersionUID = 1L;
    public static final int INFO_MESSAGE = 0;
    public static final int ERROR_MESSAGE = 1;
    protected JTextPane m_messagePane = null;
    private int m_nMaximumLineCount = 200;
    private static WAdminResource bundle = WAdminResource.getBundle(WsMessagesPropertyTab.class);
    private static SimpleAttributeSet errorMsgSet = new SimpleAttributeSet();
    private static SimpleAttributeSet infoMsgSet = new SimpleAttributeSet();
    private WsAbstractAction m_actClear;
    private OutputStream outputStream = new OutputStream();
    private LogStream logStream = new LogStream();
    private boolean m_bAddCR = false;
    private static WsMessagesPropertyTab g_instance;

    private WsMessagesPropertyTab() {
        WATextPane txt = new WATextPane();
        txt.setEditable(false);
        txt.setAutoSelect(false);
        txt.getAdapter().setPrintable(true);
        txt.getAdapter().setPrintTitle(bundle.getString("WsMessagesWindow.title"));
        txt.getAdapter().setPopupMenuRequestListener(new PopupMenuRequestListener());
        this.m_messagePane = txt;
        this.m_actClear = new ClearAction();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_messagePane), "Center");
        g_instance = this;
    }

    public static WsMessagesPropertyTab getInstance() {
        if (g_instance == null) {
            g_instance = new WsMessagesPropertyTab();
        }
        return g_instance;
    }

    public void setMaximumLineCount(int nMaximumLineCount) {
        this.m_nMaximumLineCount = nMaximumLineCount;
    }

    public int getMaximumLineCount() {
        return this.m_nMaximumLineCount;
    }

    public void addMessage(String msg) {
        this.addMessage(msg, 0);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public void addMessage(String msg, int type) {
        SimpleAttributeSet set;
        Workspace.getDefaultLogger().info(msg);
        int nMessageLines = this.countLines(msg);
        int nExistingLines = this.m_messagePane.getStyledDocument().getDefaultRootElement().getElementCount();
        if (nMessageLines >= this.m_nMaximumLineCount) {
            this.clear();
        } else if (nExistingLines + nMessageLines > this.m_nMaximumLineCount) {
            this.removeLines(nExistingLines + nMessageLines - this.m_nMaximumLineCount);
        }
        if (0 == type) {
            set = infoMsgSet;
        } else if (1 == type) {
            set = errorMsgSet;
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        if (this.m_bAddCR) {
            msg = "\n" + msg;
        } else {
            this.m_bAddCR = true;
        }
        try {
            this.m_messagePane.getDocument().insertString(this.m_messagePane.getDocument().getLength(), msg, set);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private int countLines(String sText) {
        int nLines = 0;
        int iEnd = -1;
        do {
            ++nLines;
        } while ((iEnd = sText.indexOf(10, iEnd + 1)) != -1);
        return nLines;
    }

    private void removeLines(int nLines) {
        StyledDocument doc = this.m_messagePane.getStyledDocument();
        try {
            for (int iLine = 0; iLine < nLines; ++iLine) {
                Element ele = doc.getParagraphElement(0);
                doc.remove(0, Math.min(ele.getEndOffset(), doc.getLength()));
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.m_messagePane.setText("");
        this.m_bAddCR = false;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actClear.setActive(bActive);
    }

    static {
        Font fntText = UIManager.getFont("TextField.font");
        StyleConstants.setForeground(errorMsgSet, Color.red);
        StyleConstants.setFontFamily(errorMsgSet, fntText.getName());
        StyleConstants.setFontSize(errorMsgSet, fntText.getSize());
        StyleConstants.setForeground(infoMsgSet, Color.black);
        StyleConstants.setFontFamily(infoMsgSet, fntText.getName());
        StyleConstants.setFontSize(infoMsgSet, fntText.getSize());
    }

    private class PopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private PopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = ((WATextPane)WsMessagesPropertyTab.this.m_messagePane).getAdapter().createDefaultPopupMenu();
            int iInsert = Math.max(mnuPopup.getComponentCount() - 2, 0);
            mnuPopup.add((Component)new JMenuItem(WsMessagesPropertyTab.this.m_actClear), iInsert);
            mnuPopup.show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    private class ClearAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ClearAction() {
            super(bundle, "WsMessagesWindow.Action.Clear", 257);
            this.setHidable(true);
            this.setMenuSupportId("clear");
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsMessagesPropertyTab.this.clear();
        }
    }

    public class LogStream
    extends java.io.OutputStream {
        @Override
        public void write(int x) {
            WsMessagesPropertyTab.this.m_bAddCR = false;
            WsMessagesPropertyTab.this.addMessage(new Integer(x).toString(), 0);
        }

        @Override
        public void write(byte[] data, int offset, int length) {
            WsMessagesPropertyTab.this.m_bAddCR = false;
            WsMessagesPropertyTab.this.addMessage(new String(data, offset, length), 0);
        }
    }

    public class OutputStream
    extends java.io.OutputStream {
        @Override
        public void write(int x) {
            WsMessagesPropertyTab.this.m_bAddCR = false;
            WsMessagesPropertyTab.this.addMessage(bundle.getString("WsMessagesWindows.MetadataError.txt") + new Integer(x).toString(), 1);
        }

        @Override
        public void write(byte[] data, int offset, int length) {
            WsMessagesPropertyTab.this.m_bAddCR = false;
            WsMessagesPropertyTab.this.addMessage(bundle.getString("WsMessagesWindows.MetadataError.txt") + new String(data, offset, length), 1);
        }
    }
}

