/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.io.OutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class WsLoggerStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 640;
    private String _context;
    private int _priority;
    private Logger _logger;
    private StringBuffer _buffer;
    private int _bufferSize = 640;

    public WsLoggerStream(Logger log, String context, int priority) {
        this._logger = log;
        this._priority = priority;
        this._context = context;
        this._buffer = new StringBuffer(640);
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        for (int i = offset; i < offset + length && i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public void write(int i) {
        if (i == 13) {
            return;
        }
        if (i == 10) {
            this.flush(true);
            return;
        }
        this._buffer.append((char)i);
        if (this._buffer.length() >= this._bufferSize) {
            this.flush();
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
        if (this._buffer.length() >= this._bufferSize) {
            this.flush();
        }
    }

    private void flush(boolean hard) {
        if (hard || this._buffer.length() > 0) {
            this._logger.log(Level.FATAL, this._buffer.toString());
            this._buffer.setLength(0);
        }
    }
}

