/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsServerRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WsJobSubmissionManager {
    private Map m_serverRequestMap;
    private Vector m_propChangeListeners;
    private List m_serverRequestList;
    private static WsJobSubmissionManager m_WsJobSubmissionManagerInstance = new WsJobSubmissionManager();

    public static WsJobSubmissionManager getInstance() {
        return m_WsJobSubmissionManagerInstance;
    }

    private WsJobSubmissionManager() {
        this.initialize();
    }

    private void initialize() {
        this.m_serverRequestMap = new HashMap();
        this.m_serverRequestList = new ArrayList();
        this.m_propChangeListeners = new Vector();
    }

    public WsServerRequest makeWsServerRequest(CMetadata oMetadata) {
        try {
            WsServerRequest serverRequest = new WsServerRequest(oMetadata);
            this.m_serverRequestMap.put(oMetadata.getFQID(), serverRequest);
            this.m_serverRequestList.add(oMetadata.getFQID());
            serverRequest.addPropertyChangeListener(new cServerRequestDataChangedListener());
            return serverRequest;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public void termWsServerRequest(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        serverRequest.termWsServerRequest();
    }

    public void termWsServerRequestCode(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        serverRequest.terminateRunningSasCodeSubmit();
    }

    public void killAppServer(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        serverRequest.killWsAppServer();
    }

    public void resubmitWsServerRequest(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        serverRequest.startCodeSubmit();
    }

    public WsServerRequest getWsServerRequest(String metadataFQID) {
        return (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
    }

    public String getWsServerRequestStatus(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        if (serverRequest != null) {
            return serverRequest.getPropertyString("jobstatus");
        }
        return null;
    }

    public CMetadata getWsServerRequestMetadata(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        return serverRequest.getMetadata();
    }

    public Map getAllWsServerRequests() {
        return this.m_serverRequestMap;
    }

    public List getOrderedKeyList() {
        return this.m_serverRequestList;
    }

    public void clearServerRequest(String metadataFQID) {
        WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(metadataFQID);
        serverRequest.termWsServerRequest();
        this.m_serverRequestList.remove(metadataFQID);
        this.m_serverRequestMap.remove(metadataFQID);
    }

    public void clearAllServerRequests() {
        ArrayList lOldServerRequestList = new ArrayList();
        lOldServerRequestList.addAll(this.m_serverRequestList);
        for (int iKey = 0; iKey < this.m_serverRequestList.size(); ++iKey) {
            String sKey = (String)this.m_serverRequestList.get(iKey);
            WsServerRequest serverRequest = (WsServerRequest)this.m_serverRequestMap.get(sKey);
            if (serverRequest.getPropertyString("jobstatus").equals(WsServerRequest.JOBRUNNING)) continue;
            serverRequest.termWsServerRequest();
            lOldServerRequestList.remove(serverRequest.getMetadataFQID());
            this.m_serverRequestMap.remove(sKey);
        }
        this.m_serverRequestList.clear();
        this.m_serverRequestList.addAll(lOldServerRequestList);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.m_propChangeListeners.contains(listener)) {
            this.m_propChangeListeners.addElement(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propChangeListeners.contains(listener)) {
            this.m_propChangeListeners.removeElement(listener);
        }
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener client : this.m_propChangeListeners) {
            client.propertyChange(evt);
        }
    }

    protected class cServerRequestDataChangedListener
    implements PropertyChangeListener {
        protected cServerRequestDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            WsJobSubmissionManager.this.firePropertyChange(e);
        }
    }
}

