/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.DefaultTableRowModel;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsSorterInterface;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;

public class WsDefaultTableRowModel
extends DefaultTableRowModel {
    private static final long serialVersionUID = 1L;

    public WsDefaultTableRowModel(TableView tbl) {
        super(tbl);
    }

    public int getRowCount() {
        if (this.tableRows == null) {
            return 0;
        }
        return this.tableRows.size();
    }

    public void sort(int[] aColumns, int[] aDirections) {
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getTable().getModel();
        if (aColumns == null && aDirections == null) {
            this.resetRowMappings();
        } else {
            int iColumn;
            if (aColumns == null || aDirections == null || aColumns.length != aDirections.length) {
                throw new IllegalArgumentException("Illegal arguments");
            }
            int nColumns = aColumns.length;
            int[] aSortIndexes = new int[nColumns];
            Comparator[] aComparators = new Comparator[nColumns];
            for (iColumn = 0; iColumn < nColumns; ++iColumn) {
                aSortIndexes[iColumn] = iColumn;
                aComparators[iColumn] = mdl.getColumn(aColumns[iColumn]).getComparator();
            }
            int nRows = this.getRowCount();
            Object[][] aaValues = new Object[nRows][nColumns];
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (iColumn = 0; iColumn < nColumns; ++iColumn) {
                    aaValues[iRow][iColumn] = mdl.getValueAt(iRow, aColumns[iColumn]);
                }
            }
            WsSorterInterface sorter = ((WsTable)this.getTable()).getSorter();
            sorter.setColumns(aSortIndexes);
            sorter.setDirections(aDirections);
            sorter.setComparators(aComparators);
            int[] aRowIndexes = sorter.sort(aaValues);
            this.setRowMappings(aRowIndexes);
        }
    }

    public boolean isOriginalOrder() {
        int nRows = this.tableRows.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (iRow == (Integer)this.tableRows.get(iRow)) continue;
            return false;
        }
        return true;
    }

    public int[] getRowMappings() {
        int nRows = this.tableRows.size();
        int[] aRows = new int[nRows];
        for (int iRow = 0; iRow < nRows; ++iRow) {
            aRows[iRow] = (Integer)this.tableRows.get(iRow);
        }
        return aRows;
    }

    public void setRowMappings(int[] aRowIndexes) {
        int nRows = this.getTable().getRowCount();
        if (nRows != aRowIndexes.length) {
            throw new IllegalArgumentException("aRowIndexes.length != nRows in setRowMappings");
        }
        this.tableRows.clear();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.tableRows.add(new Integer(aRowIndexes[iRow]));
        }
        this.fireRowsRemapped(new ChangeEvent((Object)this));
    }

    protected void resetRowMappings() {
        ArrayList newTableRows = new ArrayList(this.tableRows.size());
        while (this.tableRows.size() > 0) {
            int iSmallRow = 0;
            int iSmallVal = (Integer)this.tableRows.get(iSmallRow);
            int nRows = this.tableRows.size();
            for (int iRow = 1; iRow < nRows; ++iRow) {
                int iVal = (Integer)this.tableRows.get(iRow);
                if (iVal >= iSmallVal) continue;
                iSmallRow = iRow;
                iSmallVal = iVal;
            }
            newTableRows.add(this.tableRows.get(iSmallRow));
            this.tableRows.remove(iSmallRow);
        }
        this.tableRows = newTableRows;
        this.fireRowsRemapped(new ChangeEvent((Object)this));
    }

    public void hideRows(int[] aRows) {
        int nRows = aRows.length;
        for (int iRow = nRows - 1; iRow >= 0; --iRow) {
            this.tableRows.remove(this.tableRows.indexOf(new Integer(aRows[iRow])));
        }
        this.fireRowsHidden(new WsTableRowModelEvent((TableRowModel)this, aRows));
    }

    public void showRows(int[] aRows) {
        int nRows = aRows.length;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.tableRows.add(new Integer(aRows[iRow]));
        }
        this.fireRowsShown(new WsTableRowModelEvent((TableRowModel)this, aRows));
    }

    public void addRowModelListener(WsTableRowModelListener lsnr) {
        this.listenerList.add(WsTableRowModelListener.class, lsnr);
    }

    public void removeRowModelListener(WsTableRowModelListener lsnr) {
        this.listenerList.remove(WsTableRowModelListener.class, lsnr);
    }

    public void rowDragged(int iStart, int iFinished) {
        this.fireRowDragged(new TableRowModelEvent((TableRowModel)this, iStart, iFinished));
    }

    protected void fireRowDragged(TableRowModelEvent e) {
        Object[] aListeners = this.listenerList.getListenerList();
        int nListeners = aListeners.length;
        for (int iListener = nListeners - 2; iListener > 0; iListener -= 2) {
            if (aListeners[iListener] != WsTableRowModelListener.class) continue;
            ((WsTableRowModelListener)aListeners[iListener + 1]).rowDragged(e);
        }
    }

    protected void fireRowsHidden(WsTableRowModelEvent e) {
        Object[] aListeners = this.listenerList.getListenerList();
        int nListeners = aListeners.length;
        for (int iListener = nListeners - 2; iListener > 0; iListener -= 2) {
            if (aListeners[iListener] != WsTableRowModelListener.class) continue;
            ((WsTableRowModelListener)aListeners[iListener + 1]).rowsHidden(e);
        }
    }

    protected void fireRowsShown(WsTableRowModelEvent e) {
        Object[] aListeners = this.listenerList.getListenerList();
        int nListeners = aListeners.length;
        for (int iListener = nListeners - 2; iListener > 0; iListener -= 2) {
            if (aListeners[iListener] != WsTableRowModelListener.class) continue;
            ((WsTableRowModelListener)aListeners[iListener + 1]).rowsShown(e);
        }
    }

    protected void fireRowsRemapped(ChangeEvent e) {
        Object[] aListeners = this.listenerList.getListenerList();
        int nListeners = aListeners.length;
        for (int iListener = nListeners - 2; iListener > 0; iListener -= 2) {
            if (aListeners[iListener] != WsTableRowModelListener.class) continue;
            ((WsTableRowModelListener)aListeners[iListener + 1]).rowsRemapped(e);
        }
    }

    private void createRowMappings() {
        int rowCount = this.getTable().getModel().getRowCount();
        if (this.tableRows == null) {
            this.tableRows = new Vector(rowCount);
        } else {
            this.tableRows.clear();
        }
        for (int i = 0; i < rowCount; ++i) {
            this.tableRows.add(new Integer(i));
        }
    }

    public int convertRowIndexToView(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return modelRowIndex;
        }
        Integer rowIndex = new Integer(modelRowIndex);
        return this.tableRows.indexOf(rowIndex);
    }

    protected void tableRowsInserted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int nRowsInserted = end - start + 1;
        if (this.tableRows == null) {
            this.createRowMappings();
            return;
        }
        for (int iRow = 0; iRow < this.tableRows.size(); ++iRow) {
            int rowValue = (Integer)this.tableRows.get(iRow);
            if (rowValue < start) continue;
            this.tableRows.set(iRow, new Integer(rowValue + nRowsInserted));
        }
        for (int i = start; i <= end; ++i) {
            this.tableRows.add(i, new Integer(i));
        }
        WsTable tbl = (WsTable)this.getTable();
        if (tbl.isKeepSortedEnabled()) {
            tbl.resort();
        }
    }
}

