/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsObjectsSelectionModel;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class WsDefaultObjectsSelectionModel
implements WsObjectsSelectionModel {
    protected EventListenerList m_listListeners = new EventListenerList();
    protected int m_eSelectionMode = 1;
    protected ArrayList m_alSelectedObjects = new ArrayList();
    private static WAdminResource bundle = WAdminResource.getBundle(WsDefaultObjectsSelectionModel.class);

    @Override
    public int getSelectionMode() {
        return this.m_eSelectionMode;
    }

    @Override
    public void setSelectionMode(int eSelectionMode) {
        if (eSelectionMode != 0 && eSelectionMode != 1) {
            throw new IllegalArgumentException(bundle.getString("WsDefaultOpbjectsSelectionModel.InvalidSelection.txt"));
        }
        this.m_eSelectionMode = eSelectionMode;
    }

    @Override
    public boolean isObjectSelected(Object obj) {
        return this.m_alSelectedObjects.contains(obj);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.m_alSelectedObjects.isEmpty();
    }

    @Override
    public void selectObject(Object obj) {
        if (this.isObjectSelected(obj)) {
            return;
        }
        if (this.m_eSelectionMode == 0 && !this.isSelectionEmpty()) {
            this.deselectObject(this.m_alSelectedObjects.get(0));
        }
        this.m_alSelectedObjects.add(obj);
        this.fireObjectChangedSelection(obj, true);
    }

    @Override
    public void deselectObject(Object obj) {
        if (!this.isObjectSelected(obj)) {
            return;
        }
        this.m_alSelectedObjects.remove(obj);
        this.fireObjectChangedSelection(obj, false);
    }

    @Override
    public void deselectAllObjects() {
        ArrayList alSelectedObjects = this.m_alSelectedObjects;
        this.m_alSelectedObjects = new ArrayList();
        int nObjects = alSelectedObjects.size();
        for (int iObject = 0; iObject < nObjects; ++iObject) {
            this.fireObjectChangedSelection(alSelectedObjects.get(iObject), false);
        }
    }

    @Override
    public ArrayList getSelectedObjects() {
        return (ArrayList)this.m_alSelectedObjects.clone();
    }

    @Override
    public void addObjectSelectionListener(WsObjectSelectionListener l) {
        this.m_listListeners.add(WsObjectSelectionListener.class, l);
    }

    @Override
    public void removeObjectSelectionListener(WsObjectSelectionListener l) {
        this.m_listListeners.remove(WsObjectSelectionListener.class, l);
    }

    protected void fireObjectChangedSelection(Object obj, boolean bSelected) {
        Object[] alListeners = this.m_listListeners.getListenerList();
        WsObjectSelectionEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != WsObjectSelectionListener.class) continue;
            if (e == null) {
                e = new WsObjectSelectionEvent(this, obj, bSelected);
            }
            ((WsObjectSelectionListener)alListeners[iListener + 1]).objectChangedSelection(e);
        }
    }
}

