/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WADecimalTextField;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsForwardInputMap;
import com.sas.workspace.WsListCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class WsDefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor,
WsListCellEditor {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsDefaultCellEditor.class);
    protected JComponent m_cmpEditor;
    protected cEditorDelegate m_delegate;
    protected int m_nClicksToStart;
    private Object m_oMissingValue;

    protected WsDefaultCellEditor() {
        this.m_nClicksToStart = 3;
    }

    protected WsDefaultCellEditor(JComponent cmpEditor) {
        this.m_cmpEditor = cmpEditor;
        this.m_nClicksToStart = 3;
        cmpEditor.setBorder(new LineBorder(Color.black));
    }

    public WsDefaultCellEditor(JTextField txtEditor) {
        this.initialize(txtEditor, (cEditorDelegate)new cTextFieldDelegate(txtEditor));
    }

    public WsDefaultCellEditor(WATextField txtEditor) {
        this.initialize(txtEditor, (cEditorDelegate)new cTextFieldDelegate(txtEditor));
    }

    public WsDefaultCellEditor(WAIntTextField txtEditor) {
        this.initialize(txtEditor, (cEditorDelegate)new cIntTextFieldDelegate(txtEditor));
    }

    public WsDefaultCellEditor(WADecimalTextField txtEditor) {
        this.initialize(txtEditor, (cEditorDelegate)new cDecimalTextFieldDelegate(txtEditor));
    }

    public WsDefaultCellEditor(JCheckBox ckbEditor) {
        this.initialize(ckbEditor, (cEditorDelegate)new cCheckBoxDelegate(ckbEditor));
    }

    public WsDefaultCellEditor(JComboBox cmbEditor) {
        this.initialize(cmbEditor, (cEditorDelegate)new cComboBoxDelegate(cmbEditor));
    }

    protected void initialize(JComponent cmpEditor, cEditorDelegate delegate) {
        this.m_cmpEditor = cmpEditor;
        this.m_nClicksToStart = 3;
        this.m_delegate = delegate;
        this.m_cmpEditor.setBorder(new LineBorder(Color.black));
    }

    protected void initialize(JTextField txtEditor, cEditorDelegate delegate) {
        this.initialize((JComponent)txtEditor, delegate);
        txtEditor.addActionListener(this.m_delegate);
    }

    protected void initialize(WATextField txtEditor, cEditorDelegate delegate) {
        this.initialize((JTextField)txtEditor, delegate);
        txtEditor.setAutoSelect(false);
    }

    protected void initialize(JComboBox cmbEditor, cEditorDelegate delegate) {
        this.initialize((JComponent)cmbEditor, delegate);
        cmbEditor.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        cmbEditor.addActionListener(this.m_delegate);
        if (cmbEditor instanceof WAComboBox) {
            ((WAComboBox)cmbEditor).setAutoSelect(false);
        }
        if (cmbEditor.isEditable()) {
            WsForwardInputMap.install(cmbEditor, (JComponent)cmbEditor.getEditor().getEditorComponent());
        }
    }

    protected void initialize(JCheckBox ckbEditor, cEditorDelegate delegate) {
        this.m_cmpEditor = ckbEditor;
        this.m_nClicksToStart = 1;
        this.m_delegate = new cCheckBoxDelegate(ckbEditor);
        ckbEditor.addActionListener(this.m_delegate);
        ckbEditor.setHorizontalAlignment(0);
        ckbEditor.setOpaque(false);
        ckbEditor.getInputMap().put(KeyStroke.getKeyStroke(' '), "pressedandreleased");
        ckbEditor.getActionMap().put("pressedandreleased", new cPressedAndReleasedAction(ckbEditor));
    }

    public JComponent getComponent() {
        return this.m_cmpEditor;
    }

    public void setClicksToStart(int nClicksToStart) {
        this.m_nClicksToStart = nClicksToStart;
    }

    public int getClicksToStart() {
        return this.m_nClicksToStart;
    }

    public void setCellEditorValue(Object value) {
        this.m_delegate.setValue(value);
    }

    public void setMissingValue(Object oMissingValue) {
        if (oMissingValue != null) {
            if (this.m_cmpEditor instanceof WAIntTextField && !(oMissingValue instanceof Integer)) {
                throw new IllegalArgumentException("Missing value must be an Integer for a WAIntTextField editor");
            }
            if (this.m_cmpEditor instanceof WADecimalTextField && !(oMissingValue instanceof Double)) {
                throw new IllegalArgumentException("Missing value must be a Double for a WADoubleTextField editor");
            }
        }
        this.m_oMissingValue = oMissingValue;
    }

    public Object getMissingValue() {
        return this.m_oMissingValue;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_delegate.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.m_delegate.isCellEditable(e);
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return this.m_delegate.shouldSelectCell(e);
    }

    @Override
    public boolean stopCellEditing() {
        return this.m_delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.m_delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow) {
        String sValue = tree.convertValueToText(value, bSelected, bExpanded, bLeaf, iRow, false);
        this.notify(tree, iRow);
        this.m_delegate.setValue(sValue);
        return this.m_cmpEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean bSelected, int iRow, int iColumn) {
        this.notify(table, iRow, iColumn);
        this.m_delegate.setValue(value);
        return this.m_cmpEditor;
    }

    @Override
    public Component getListCellEditorComponent(JList lst, Object value, boolean bSelected, int iRow) {
        this.notify(lst, iRow);
        this.m_delegate.setValue(value);
        return this.m_cmpEditor;
    }

    public void notify(JTable table, int iRow, int iColumn) {
        this.m_delegate.layout(table, iRow, iColumn);
    }

    public void notify(JTree tree, int iRow) {
        this.m_delegate.layout(tree, iRow);
    }

    public void notify(JList list, int iRow) {
        this.m_delegate.layout(list, iRow);
    }

    static class cPressedAndReleasedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected AbstractButton m_btn;

        public cPressedAndReleasedAction(AbstractButton btn) {
            this.m_btn = btn;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonModel mdl = this.m_btn.getModel();
            mdl.setArmed(true);
            mdl.setPressed(true);
            mdl.setPressed(false);
            mdl.setArmed(false);
        }

        @Override
        public boolean isEnabled() {
            return this.m_btn.getModel().isEnabled();
        }
    }

    protected class cBooleanComboDelegate
    extends cComboBoxDelegate {
        public cBooleanComboDelegate(WAComboBox cmbEditor) {
            super(cmbEditor);
        }

        @Override
        public void setValue(Object value) {
            int iIndex = value != null && value instanceof Boolean ? ((Boolean)value != false ? 1 : 0) : 0;
            this.m_cmbEditor.setSelectedIndex(iIndex);
        }

        @Override
        public Object getValue() {
            return this.m_cmbEditor.getSelectedIndex() == 1;
        }
    }

    protected class cDecimalTextFieldDelegate
    extends cEditorDelegate {
        protected WADecimalTextField m_txtEditor;

        public cDecimalTextFieldDelegate(WADecimalTextField txtEditor) {
            this.m_txtEditor = txtEditor;
        }

        @Override
        public void setValue(Object value) {
            if (value.equals(WsDefaultCellEditor.this.m_oMissingValue)) {
                this.m_txtEditor.setText("");
            } else if (value instanceof Double) {
                this.m_txtEditor.setValue((Double)value);
            } else if (value.toString().length() != 0) {
                this.m_txtEditor.setValue(Double.parseDouble(value.toString()));
            } else {
                this.m_txtEditor.setText("");
            }
            this.m_txtEditor.selectAll();
        }

        @Override
        public Object getValue() {
            if (this.m_txtEditor.getText().trim().length() == 0 && WsDefaultCellEditor.this.m_oMissingValue != null) {
                return WsDefaultCellEditor.this.m_oMissingValue;
            }
            try {
                return new Double(this.m_txtEditor.getValue());
            }
            catch (WADecimalTextField.IllegalDecimalException e) {
                return new Double(Double.MAX_VALUE);
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (this.m_txtEditor.getText().trim().length() == 0 && WsDefaultCellEditor.this.m_oMissingValue != null) {
                return super.stopCellEditing();
            }
            try {
                this.m_txtEditor.getValue();
            }
            catch (WADecimalTextField.IllegalDecimalException e) {
                MessageUtil.displayMessage(bundle.formatString("WsDefaultCellEditor.DecimalException.Error.txt", this.m_txtEditor.getText()), 0);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    protected class cIntTextFieldDelegate
    extends cEditorDelegate {
        WAIntTextField m_txtEditor;

        public cIntTextFieldDelegate(WAIntTextField txtEditor) {
            this.m_txtEditor = txtEditor;
        }

        @Override
        public void setValue(Object value) {
            if (value.equals(WsDefaultCellEditor.this.m_oMissingValue)) {
                this.m_txtEditor.setText("");
            } else if (value instanceof Integer) {
                this.m_txtEditor.setValue((Integer)value);
            } else if (value.toString().length() != 0) {
                this.m_txtEditor.setValue(Integer.parseInt(value.toString()));
            } else {
                this.m_txtEditor.setText("");
            }
            this.m_txtEditor.selectAll();
        }

        @Override
        public Object getValue() {
            if (this.m_txtEditor.getText().trim().length() == 0 && WsDefaultCellEditor.this.m_oMissingValue != null) {
                return WsDefaultCellEditor.this.m_oMissingValue;
            }
            try {
                return new Integer(this.m_txtEditor.getValue2());
            }
            catch (WAIntTextField.IllegalIntegerException e) {
                return new Integer(Integer.MAX_VALUE);
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (this.m_txtEditor.getText().trim().length() == 0 && WsDefaultCellEditor.this.m_oMissingValue != null) {
                return super.stopCellEditing();
            }
            try {
                this.m_txtEditor.getValue2();
            }
            catch (WAIntTextField.IllegalIntegerException e) {
                MessageUtil.displayMessage(bundle.formatString("WsDefaultCellEditor.IntegerException.Error.txt", this.m_txtEditor.getText()), 0);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    protected class cComboBoxDelegate
    extends cEditorDelegate {
        protected JComboBox m_cmbEditor;

        public cComboBoxDelegate(JComboBox cmbEditor) {
            this.m_cmbEditor = cmbEditor;
        }

        @Override
        public void setValue(Object value) {
            this.m_cmbEditor.setSelectedItem(value);
            this.m_cmbEditor.getEditor().selectAll();
        }

        @Override
        public Object getValue() {
            return this.m_cmbEditor.getSelectedItem();
        }

        @Override
        public boolean shouldSelectCell(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent eMouse = (MouseEvent)e;
                return eMouse.getID() != 506;
            }
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.m_cmbEditor.isEditable()) {
                this.m_cmbEditor.actionPerformed(new ActionEvent(WsDefaultCellEditor.this, 0, ""));
            }
            return super.stopCellEditing();
        }
    }

    protected class cCheckBoxDelegate
    extends cEditorDelegate {
        protected JCheckBox m_ckbEditor;

        public cCheckBoxDelegate(JCheckBox ckbEditor) {
            this.m_ckbEditor = ckbEditor;
        }

        @Override
        public void setValue(Object value) {
            boolean bSelected = value instanceof Boolean ? (Boolean)value : (value instanceof String ? value.equals("true") : false);
            this.m_ckbEditor.setSelected(bSelected);
        }

        @Override
        public Object getValue() {
            return new Boolean(this.m_ckbEditor.isSelected());
        }
    }

    protected class cTextFieldDelegate
    extends cEditorDelegate {
        protected JTextField m_txtEditor;

        public cTextFieldDelegate(JTextField txtEditor) {
            this.m_txtEditor = txtEditor;
        }

        @Override
        public void setValue(Object value) {
            this.m_txtEditor.setText(value != null ? value.toString() : "");
            this.m_txtEditor.selectAll();
        }

        @Override
        public Object getValue() {
            return this.m_txtEditor.getText();
        }
    }

    protected class cEditorDelegate
    implements ActionListener,
    ItemListener {
        protected Object m_value;

        protected cEditorDelegate() {
        }

        public Object getValue() {
            return this.m_value;
        }

        public void setValue(Object value) {
            this.m_value = value;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= WsDefaultCellEditor.this.m_nClicksToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject e) {
            return true;
        }

        public boolean startCellEditing(EventObject e) {
            return true;
        }

        public boolean stopCellEditing() {
            WsDefaultCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            WsDefaultCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsDefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WsDefaultCellEditor.this.stopCellEditing();
        }

        public void layout(JTree tree, int iRow) {
        }

        public void layout(JTable table, int iRow, int iColumn) {
        }

        public void layout(JList list, int iRow) {
        }
    }
}

