/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TextStore;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class WsColumnMetadataUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(WsColumnMetadataUtil.class);
    protected static final String g_sViewCharacterType = bundle.getString("WsColumnMetadataUtil.Character.txt");
    protected static final String g_sViewNumericType = bundle.getString("WsColumnMetadataUtil.Numeric.txt");
    protected static final String g_sDataCharacterType = "C";
    protected static final String g_sDataNumericType = "N";
    public static final String NONE = bundle.getString("Common.None.txt");
    static final int TYPE_CHARACTER = 0;
    static final int TYPE_NUMERIC = 1;
    private static final String[] g_saDefaultCharacterFormats = new String[]{NONE, "$.", "$ascii.", "$bidi.", "$binary.", "$char.", "$ebcdic.", "$hex.", "$kanji.", "$kanjix.", "$msgcase.", "$octal.", "$quote.", "$reverj.", "$revers.", "$ucs2b.", "$ucs2l.", "$ucs2x.", "$upcase.", "$utf8x.", "$varying."};
    private static final String[] g_saDefaultCharacterInformats = new String[]{NONE, "$.", "$ascii.", "$binary.", "$char.", "$charzb.", "$ebcdic.", "$hex.", "$kanji.", "$kanjix.", "$octal.", "$phex.", "$quote.", "$reverj.", "$revers.", "$ucs2b.", "$ucs2l.", "$ucs2x.", "$upcase.", "$utf8x.", "$varying."};
    private static final String[] g_saDefaultNumericFormats = new String[]{NONE, "Best.", "Binary.", "Comma.", "Commax.", "d.", "date.", "dateampm.", "Datetime.", "day.", "ddmmyy.", "Dollar.", "dollarx.", "downame.", "dtdate.", "dtmonyy.", "dtwkdatx.", "dtyear.", "dtyyqc.", "e.", "eurdfdd.", "eurdfde.", "eurdfdn.", "eurdfdt.", "eurdfdwn.", "eurdfmn.", "eurdfmy.", "eurdfwdx.", "eurdfwkx.", "eurfrats.", "eurfrbef.", "eurfrchf.", "eurfrczk.", "eurfrdem.", "eurfrdkk.", "eurfresp.", "eurfrfim.", "eurfrfrf.", "eurfrgbp.", "eurfrgrd.", "eurfrhuf.", "eurfriep.", "eurfritl.", "eurfrluf.", "eurfrnlg.", "eurfrnok.", "eurfrplz.", "eurfrpte.", "eurfrrol.", "eurfrrur.", "eurfrsek.", "eurfrsit.", "eurfrtrl.", "eurfryud.", "euro.", "eurox.", "eurtoats.", "eurtobef.", "eurtochf.", "eurtoczk.", "eurtodem.", "eurtodkk.", "eurtoesp.", "eurtofim.", "eurtofrf.", "eurtogbp.", "eurtogrd.", "eurtohuf.", "eurtoiep.", "eurtoitl.", "eurtoluf.", "eurtonlg.", "eurtonok.", "eurtoplz.", "eurtopte.", "eurtorol.", "eurtorur.", "eurtosek.", "eurtosit.", "eurtotrl.", "eurtoyud.", "float.", "fract.", "hhmm.", "hour.", "ib.", "ibr.", "ieee.", "julday.", "julian.", "minguo.", "mmss.", "mmyy.", "monname.", "month.", "monyy.", "negparen.", "nengo.", "nldate.", "nldatemn.", "nldatew.", "nldatewn.", "nldatm.", "nldatmap.", "nldatmtm.", "nldatmw.", "nltime.", "nltimap.", "numx.", "pd.", "pdjulg.", "pdjuli.", "Percent.", "pib.", "pibr.", "pk.", "pvalue.", "qtr.", "qtrr.", "rb.", "roman.", "s370fib.", "s370fibu.", "s370fpd.", "s370fpdu.", "s370fpib.", "s370frb.", "s370fzd.", "s370fzdl.", "s370fzds.", "s370fzdt.", "s370fzdu.", "s370off.", "ssn.", "time.", "timeampm.", "tod.", "vaxrb.", "weekdate.", "weekdatx.", "weekday.", "worddate.", "worddatx.", "wordf.", "words.", "year.", "yen.", "yymm.", "yymmdd.", "yymon.", "yyq.", "yyqr.", "z.", "zd."};
    private static final String[] g_saDefaultNumericInformats = new String[]{NONE, "Binary.", "bits.", "Bz.", "cb.", "Comma.", "Commax.", "Datetime.", "date.", "ddmmyy.", "e.", "eurdfde.", "eurdfdt.", "eurdfmy.", "euro.", "eurox.", "float.", "hex.", "ibr.", "ib.", "ieee.", "jdateymd.", "jnengo.", "julian.", "minguo.", "mmddyy.", "monyy.", "msec.", "nengo.", "nldate.", "nldatm.", "nltime.", "nltimap.", "numx.", "octal.", "pd.", "pdjulg.", "pdjuli.", "pdtime.", "Percent.", "pib.", "pibr.", "pk.", "punch.", "rb.", "rmfdur.", "rmfstamp.", "row.", "s370ff.", "s370fib.", "s370fibu.", "s370fpd.", "s370fpdu.", "s370fpib.", "s370frb.", "s370fzd.", "s370fzdl.", "s370fzds.", "s370fzdt.", "s370fzdu.", "shrstamp.", "stimer.", "time.", "todstamp.", "tu.", "vaxrb.", "yen.", "yymmdd.", "yymmn.", "yyq.", "zd.", "zdb.", "zdv."};
    protected static final Icon g_iconCharacter = bundle.getImageIcon("WsColumnMetadataUtil.Character.image");
    protected static final Icon g_iconNumeric = bundle.getImageIcon("WsColumnMetadataUtil.Numeric.image");

    private WsColumnMetadataUtil() {
    }

    public static String getDataCharacterType() {
        return g_sDataCharacterType;
    }

    public static String getDataNumericType() {
        return g_sDataNumericType;
    }

    public static String getViewCharacterType() {
        return g_sViewCharacterType;
    }

    public static String getViewNumericType() {
        return g_sViewNumericType;
    }

    public static String[] getViewTypes() {
        String[] saTypes = new String[]{g_sViewCharacterType, g_sViewNumericType};
        return saTypes;
    }

    public static boolean isColumnTypeCharacter(String sType) {
        return sType.equals(g_sDataCharacterType);
    }

    public static boolean isColumnTypeCharacter(Column oColumn) {
        try {
            return WsColumnMetadataUtil.isColumnTypeCharacter(oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isColumnViewTypeCharacter(String sType) {
        return sType.equals(g_sViewCharacterType);
    }

    public static void setColumnTypeToCharacter(Column oColumn) {
        try {
            oColumn.setSASColumnType(WsColumnMetadataUtil.getDataCharacterType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public static boolean isColumnTypeNumeric(String sType) {
        return sType.equals(g_sDataNumericType);
    }

    public static boolean isColumnTypeNumeric(Column oColumn) {
        try {
            return WsColumnMetadataUtil.isColumnTypeNumeric(oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isColumnViewTypeNumeric(String sType) {
        return sType.equals(g_sViewNumericType);
    }

    public static void setColumnTypeToNumeric(Column oColumn) {
        try {
            oColumn.setSASColumnType(WsColumnMetadataUtil.getDataNumericType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public static String convertColumnTypeToView(String sDataType) {
        return g_sDataCharacterType.equals(sDataType) ? WsColumnMetadataUtil.getViewCharacterType() : WsColumnMetadataUtil.getViewNumericType();
    }

    public static String convertColumnTypeToData(String sViewType) {
        return g_sViewCharacterType.equals(sViewType) ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
    }

    public static void updateType(Column oColumn, String sViewType) {
        try {
            String sDataType;
            String string = sDataType = g_sViewCharacterType.equals(sViewType) ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
            if (!oColumn.getSASColumnType().equals(sDataType)) {
                oColumn.setSASColumnType(sDataType);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public static Icon getColumnViewTypeIcon(String sType) {
        if (sType.equals(g_sViewCharacterType)) {
            return g_iconCharacter;
        }
        return g_iconNumeric;
    }

    public static Icon getColumnTypeIcon(String sType) {
        if (WsColumnMetadataUtil.isColumnTypeCharacter(sType)) {
            return g_iconCharacter;
        }
        return g_iconNumeric;
    }

    public static Icon getColumnTypeIcon(Column oColumn) {
        try {
            return WsColumnMetadataUtil.getColumnTypeIcon(oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public static String getColumnViewTypeString(String sType) {
        if (WsColumnMetadataUtil.isColumnTypeCharacter(sType)) {
            return g_sViewCharacterType;
        }
        return g_sViewNumericType;
    }

    public static String getColumnViewTypeString(Column oColumn) {
        try {
            return WsColumnMetadataUtil.getColumnViewTypeString(oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public static String[] getDefaultCharacterFormats() {
        return g_saDefaultCharacterFormats;
    }

    public static String[] getDefaultCharacterInformats() {
        return g_saDefaultCharacterInformats;
    }

    public static String[] getDefaultNumericFormats() {
        return g_saDefaultNumericFormats;
    }

    public static String[] getDefaultNumericInformats() {
        return g_saDefaultNumericInformats;
    }

    public static Column createMetadataColumnCopy(Column oOldColumn, MdObjectStore store, String sReposId) {
        try {
            Column oNewColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, oOldColumn.getName(), "Column", sReposId);
            oNewColumn.setPublicType("Column");
            oNewColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            oNewColumn.setColumnName(oOldColumn.getColumnName());
            oNewColumn.setColumnLength(oOldColumn.getColumnLength());
            oNewColumn.setColumnType(oOldColumn.getColumnType());
            oNewColumn.setSASColumnName(oOldColumn.getSASColumnName());
            oNewColumn.setSASColumnLength(oOldColumn.getSASColumnLength());
            oNewColumn.setSASColumnType(oOldColumn.getSASColumnType());
            oNewColumn.setIsDiscrete(oOldColumn.getIsDiscrete());
            oNewColumn.setIsNullable(oOldColumn.getIsNullable());
            oNewColumn.setSASFormat(oOldColumn.getSASFormat());
            oNewColumn.setSASInformat(oOldColumn.getSASInformat());
            oNewColumn.setSortOrder(oOldColumn.getSortOrder());
            oNewColumn.setSummaryRole(oOldColumn.getSummaryRole());
            oNewColumn.setDesc(oOldColumn.getDesc());
            if (oOldColumn.getNotes().size() > 0) {
                TextStore oOldPrivateNote = (TextStore)oOldColumn.getNotes().get(0);
                TextStore oNewPrivateNote = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, oOldPrivateNote.getName(), "TextStore", sReposId);
                oNewPrivateNote.setStoredText(oOldPrivateNote.getStoredText());
                oNewColumn.getNotes().add((Object)oNewPrivateNote);
            }
            if (oOldColumn.getExtensions().size() > 0) {
                AssociationList lOldExtensions = oOldColumn.getExtensions();
                for (int i = 0; i < oOldColumn.getExtensions().size(); ++i) {
                    Extension oOldExtension = (Extension)lOldExtensions.get(i);
                    Extension oNewExtension = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, oOldExtension.getName(), "Extension", sReposId);
                    oNewExtension.setDesc(oOldExtension.getDesc());
                    oNewExtension.setValue(oOldExtension.getValue());
                    oNewColumn.getExtensions().add((Object)oNewExtension);
                }
            }
            if (oOldColumn.getDocuments().size() > 0) {
                AssociationList lExistingDocuments = oOldColumn.getDocuments();
                for (int i = 0; i < lExistingDocuments.size(); ++i) {
                    oNewColumn.getDocuments().add(lExistingDocuments.get(i));
                }
            }
            return oNewColumn;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public static boolean isFormatNameValid(Column oColumn) {
        try {
            return WsColumnMetadataUtil.isFmtNameValid(oColumn.getSASFormat(), true, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isFormatNameValid(Column oColumn, String formatName) {
        try {
            return WsColumnMetadataUtil.isFmtNameValid(formatName, true, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isFormatNameValid(String formatName, String sType) {
        return WsColumnMetadataUtil.isFmtNameValid(formatName, true, sType);
    }

    public static boolean isInformatNameValid(Column oColumn) {
        try {
            return WsColumnMetadataUtil.isFmtNameValid(oColumn.getSASInformat(), false, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isInformatNameValid(Column oColumn, String informatName) {
        try {
            return WsColumnMetadataUtil.isFmtNameValid(informatName, false, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    public static boolean isInformatNameValid(String informatName, String sType) {
        return WsColumnMetadataUtil.isFmtNameValid(informatName, false, sType);
    }

    public static boolean isFmtNameValid(String name, boolean isFormat, String columnType) {
        String newName = WsColumnMetadataUtil.makeValidFmtName(name, isFormat, columnType);
        return newName.equals(name);
    }

    public static String makeValidFormatName(Column oColumn) {
        try {
            return WsColumnMetadataUtil.makeValidFmtName(oColumn.getSASFormat(), true, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public static String makeValidFormatName(Column oColumn, String formatName) {
        try {
            return WsColumnMetadataUtil.makeValidFmtName(formatName, true, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public static String makeValidInformatName(Column oColumn) {
        try {
            return WsColumnMetadataUtil.makeValidFmtName(oColumn.getSASInformat(), false, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public static String makeValidInformatName(Column oColumn, String informatName) {
        try {
            return WsColumnMetadataUtil.makeValidFmtName(informatName, false, oColumn.getSASColumnType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public static String makeValidFmtName(String name, boolean isFormat, String columnType) {
        if (name == null || name.length() == 0) {
            return "";
        }
        if (name.contains("$") && name.contains(".0")) {
            return name;
        }
        if (columnType.equals(g_sDataCharacterType)) {
            boolean hasDollarSign = name.charAt(0) == '$';
            String strippedName = name;
            strippedName = strippedName.replaceAll("[$]", "").replaceAll("[.]", "");
            int maxLength = 31;
            if (!isFormat) {
                maxLength = 30;
            }
            name = strippedName.length() > maxLength ? strippedName.substring(0, maxLength) + "." : strippedName + ".";
            if (hasDollarSign) {
                name = "$" + name;
            }
        } else if (columnType.equals(g_sDataNumericType)) {
            int dotIndex;
            if (name.trim().startsWith("$")) {
                name = name.replaceFirst("[$]", "");
            }
            if ((dotIndex = name.indexOf(".")) == 0) {
                name = name.replaceAll("[.]", "");
            }
            String strippedName = name;
            String nums = "";
            if (dotIndex > 0 && dotIndex != name.length() - 1) {
                boolean foundDot = false;
                boolean allNumbers = true;
                for (int i = name.length() - 1; i >= 0; --i) {
                    char c = name.charAt(i);
                    if (i == dotIndex && !foundDot) {
                        char p = name.charAt(i - 1);
                        if (!Character.isDigit(p)) {
                            allNumbers = false;
                            break;
                        }
                        foundDot = true;
                    } else if (!Character.isDigit(c)) {
                        if (foundDot) break;
                        allNumbers = false;
                        break;
                    }
                    strippedName = strippedName.substring(0, i);
                    nums = String.valueOf(c) + nums;
                }
                if (!allNumbers) {
                    nums = "";
                }
            } else {
                strippedName = strippedName.replaceAll("[.]", "");
                nums = ".";
            }
            int maxLength = 32;
            if (!isFormat) {
                maxLength = 31;
            }
            name = strippedName.length() > maxLength ? strippedName.substring(0, maxLength) + nums : strippedName + nums;
        }
        return name;
    }

    public static Icon getColumnTypeIcon(int sType) {
        if (sType == 0) {
            return g_iconCharacter;
        }
        return g_iconNumeric;
    }
}

