/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsDefaultTableCellRenderer;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WsBooleanTableColumn
extends WsAbstractTableColumn {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsBooleanTableColumn.class);
    private static final String[] g_saValues = new String[]{bundle.getString("Common.No.nomnem.txt"), bundle.getString("Common.Yes.nomnem.txt")};
    protected boolean m_bDefault;
    protected boolean m_bUseCheckboxSemantics;

    public WsBooleanTableColumn() {
        this(0);
    }

    public WsBooleanTableColumn(int iModelIndex) {
        this(iModelIndex, 75);
    }

    public WsBooleanTableColumn(int iModelIndex, int cxWidth) {
        this(iModelIndex, "", cxWidth);
    }

    public WsBooleanTableColumn(int iModelIndex, String sName, int cxWidth) {
        this(iModelIndex, sName, cxWidth, false);
    }

    public WsBooleanTableColumn(int iModelIndex, String sName, int cxWidth, boolean bDefault) {
        this(iModelIndex, sName, cxWidth, bDefault, false);
    }

    public WsBooleanTableColumn(int iModelIndex, String sName, int cxWidth, boolean bDefault, boolean bUseCheckboxSemantics) {
        super(iModelIndex, sName, cxWidth);
        this.m_bDefault = bDefault;
        this.m_bUseCheckboxSemantics = bUseCheckboxSemantics;
        this.setColumnClass(Boolean.class);
    }

    @Override
    public Object createDefaultValue() {
        return this.m_bDefault;
    }

    @Override
    public TableCellEditor createCellEditor() {
        if (this.m_bUseCheckboxSemantics) {
            return new WsDefaultCellEditor(new JCheckBox());
        }
        return new cStringCellEditor(new WAComboBox(g_saValues));
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        if (this.m_bUseCheckboxSemantics) {
            return new cCheckboxCellRenderer();
        }
        return new cStringCellRenderer();
    }

    public void setDefaultValue(boolean bDefault) {
        this.m_bDefault = bDefault;
    }

    public boolean getDefaultValue() {
        return this.m_bDefault;
    }

    public void setUseCheckboxSemantics(boolean bUseCheckboxSemantics) {
        if (this.m_bUseCheckboxSemantics != bUseCheckboxSemantics) {
            this.m_bUseCheckboxSemantics = bUseCheckboxSemantics;
            if (this.m_edtCell != null) {
                this.m_edtCell = this.createCellEditor();
            }
            if (this.m_rdrCell != null) {
                this.m_rdrCell = this.createCellRenderer();
            }
        }
    }

    public boolean isUsingCheckboxSemantics() {
        return this.m_bUseCheckboxSemantics;
    }

    protected int getValueIndex(Object oValue) {
        if (oValue != null && oValue instanceof Boolean) {
            return (Boolean)oValue != false ? 1 : 0;
        }
        return 0;
    }

    protected class cCheckboxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public cCheckboxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            if (bSelected) {
                super.setForeground(tbl.getSelectionForeground());
                super.setBackground(tbl.getSelectionBackground());
            } else {
                super.setForeground(tbl.getForeground());
                super.setBackground(tbl.getBackground());
            }
            if (bFocused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setSelected((Boolean)value);
            return this;
        }
    }

    protected class cStringCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected cStringCellRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            int iValue = WsBooleanTableColumn.this.getValueIndex(value);
            this.setText(g_saValues[iValue]);
        }
    }

    protected class cStringCellEditor
    extends WsDefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public cStringCellEditor(WAComboBox cmb) {
            this.initialize(cmb, (WsDefaultCellEditor.cEditorDelegate)new WsDefaultCellEditor.cBooleanComboDelegate((WsDefaultCellEditor)this, cmb));
            cmb.setEditable(false);
        }
    }
}

