/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;

public class WsBasicCaret
extends DefaultCaret
implements UIResource {
    private static final long serialVersionUID = 1L;
    protected boolean m_bFocusViaMouse;
    protected boolean m_bAutoSelect = true;
    private boolean m_bSelectionVisibleWhenUnfocused = false;

    public boolean isAutoSelect() {
        return this.m_bAutoSelect;
    }

    public void setAutoSelect(boolean bAutoSelect) {
        this.m_bAutoSelect = bAutoSelect;
    }

    public boolean isSelectionVisibleWhenUnfocused() {
        return this.m_bSelectionVisibleWhenUnfocused;
    }

    public void setSelectionVisibleWhenUnfocused(boolean bVisible) {
        this.m_bSelectionVisibleWhenUnfocused = bVisible;
        this.setSelectionVisible(bVisible);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getComponent().isEnabled()) {
            if (this.m_bAutoSelect) {
                if (!this.m_bFocusViaMouse) {
                    this.getComponent().selectAll();
                } else {
                    this.m_bFocusViaMouse = false;
                }
            }
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (this.m_bSelectionVisibleWhenUnfocused) {
            this.setSelectionVisible(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_bFocusViaMouse = true;
        super.mousePressed(e);
        if (SwingUtilities.isRightMouseButton(e) && this.getComponent().getSelectedText() == null) {
            this.positionCaret(e);
            this.getComponent().requestFocusInWindow();
        }
    }
}

