/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.editor.LogListHolder;
import com.sas.entities.GUID;
import com.sas.framework.commons.holders.ClientApplicationNameHolder;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataServicePackage.InvalidEngine;
import com.sas.iom.SAS.IDataServicePackage.LibraryInUse;
import com.sas.iom.SAS.IDataServicePackage.NoLibrary;
import com.sas.iom.SAS.IDataServicePackage.NoWorkDeassign;
import com.sas.iom.SAS.IFileInfo;
import com.sas.iom.SAS.IFileInfoHelper;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IFormatService;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.ILanguageService_1_1;
import com.sas.iom.SAS.ILanguageService_1_1Helper;
import com.sas.iom.SAS.IOptionService;
import com.sas.iom.SAS.IOptionServicePackage.DataTypeSeqHolder;
import com.sas.iom.SAS.IOptionServicePackage.GetErrorSeqHolder;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SAS.InvalidLName;
import com.sas.iom.SAS.InvalidPName;
import com.sas.iom.SAS.LNameNoAssign;
import com.sas.iom.SAS.NoAccessMethod;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASEvents.ILanguageEventsHelper;
import com.sas.iom.SASEvents.ILanguageEvents_1_1Helper;
import com.sas.iom.SASEvents.ILanguageLogEventHelper;
import com.sas.iom.SASEvents._ILanguageEvents_1_1ImplBase;
import com.sas.iom.SASEvents._ILanguageLogEventImplBase;
import com.sas.iom.SASIOMCommon.ISessionControl;
import com.sas.iom.SASIOMCommon.ISessionControlHelper;
import com.sas.iom.SASIOMDefs.BooleanSeqHolder;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.orb.CP_IDConverter;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1Package.AuthDomainDoesNotExist;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionName;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionValue;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAStatement;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerEvent;
import com.sas.workspace.WsAppServerEventListener;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Frame;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.help.UnsupportedOperationException;
import javax.swing.SwingUtilities;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;

public class WsAppServer {
    private static WAdminResource bundle = WAdminResource.getBundle(WsAppServer.class);
    private static Map s_mapEncodings = new HashMap();
    public static final String DEFAULT_SERVER_FQID_KEY = "AppServer.Default";
    private static final String OPERATING_SYSTEM_MVS = "OS";
    public static final String WORKSPACE_CLSID = "440196D4-90F0-11D0-9F41-00A024BB830C";
    public static final String BLOCK_START_ID = "DIS_START_ID:";
    public static final String BLOCK_END_ID = "DIS_END_ID:";
    public static final String SUBMIT_COMPLETE = "DIS:SUBMIT_COMPLETE";
    public static final String GRID_CLSID = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    public static String FILE_ACCESS_METHOD_HADOOP;
    public static final String PRODUCT_NAME_HADOOPSERVER = "HADOOP";
    public static String FILE_ACCESS_METHOD_DEFAULT;
    public static String FILE_ACCESS_METHOD_FTP;
    public static String FILE_ACCESS_METHOD_URL;
    private ServerContextInterface m_oServer;
    private LogicalServerInterface m_oLogicalServer;
    private IWorkspace m_svcWorkspace;
    private ISessionControl m_svcSessionControl;
    private ILanguageService_1_1 m_svcLanguage_1_1;
    private ILanguageService m_svcLanguage;
    private ConnectionPoint m_cpLanguage;
    private int m_hLanguageListener;
    private ConnectionPoint m_cpLanguageLog;
    private int m_hLanguageLogListener;
    private LogListHolder m_abortLog;
    private LogListHolder m_abortList;
    private List m_lListeners;
    private boolean m_bErrorInCode;
    private boolean m_bSubmissionCancelled;
    private boolean m_bKilled;
    private IFileService m_svcFile;
    private int m_nLinesReadFromFile;
    private static int LINE_CHUNK_SIZE;
    private static String TEMP_FILE_REF;
    private IDataService m_svcData;
    private MVAConnection m_sqlConnection;
    private Map m_mapConnections;
    private IFormatService m_svcFormat;
    private String m_sName;
    private String m_serverVersion;
    private String m_hotFix;
    private static UserContextInterface m_userContext;
    private InformationServiceInterface m_informationService;
    private ConnectionInterface m_connection;
    private boolean bServerVersionCheckInProgress = false;
    private static final int BUFFER_SIZE = 32768;

    private String findServerVersion() throws WsAppServerCodeException, WsAppServerFailException, SQLException {
        this.submitSASCode("data work.sasver;\n ver= \"&sysvlong\";\n run;\n");
        try {
            ResultSet results = this.openSQLConnection().createStatement().executeQuery("Select sasver.ver from work.sasver");
            results.next();
            String string = results.getString("ver");
            return string;
        }
        finally {
            this.closeSQLConnection();
        }
    }

    public String getServerVersion() throws WsAppServerCodeException, WsAppServerFailException, SQLException {
        if (this.m_serverVersion == null) {
            this.m_serverVersion = this.findServerVersion();
        }
        return this.m_serverVersion;
    }

    private boolean isServerVersionCompatible() throws WsAppServerFailException {
        this.bServerVersionCheckInProgress = true;
        return true;
    }

    public LogicalServerInterface getLogicalServer() throws MdException, RemoteException, WsAppServerFailException {
        this.findLogicalServer();
        return this.m_oLogicalServer;
    }

    protected String getLogicalServerDomain() throws MdException, WsAppServerFailException, RemoteException, ServiceException, ConnectionFactoryException {
        LogicalServerInterface lg = this.getLogicalServer();
        if (lg != null) {
            PlatformConnectionFactoryInterface platformFactory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)new PlatformConnectionFactoryConfiguration(lg));
            List dms = platformFactory.getDomains();
            return dms == null || dms.isEmpty() ? null : (String)dms.get(0);
        }
        return null;
    }

    public ServerComponent getWorkspaceComponent() throws MdException, RemoteException, ServiceException {
        if (this.m_oServer != null) {
            List logicalServers = this.m_oServer.getServers();
            for (int index = 0; index < logicalServers.size(); ++index) {
                LogicalServerInterface logicalServer = (LogicalServerInterface)logicalServers.get(index);
                if (!logicalServer.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                List components = logicalServer.getServers();
                for (int componentIndex = 0; componentIndex < components.size(); ++componentIndex) {
                    ServerComponentInterface component = (ServerComponentInterface)components.get(componentIndex);
                    if (!component.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                    return (ServerComponent)component.getRepositoryEntity();
                }
            }
        }
        return null;
    }

    public ServerComponent getGridServerComponent() throws MdException, RemoteException, ServiceException {
        if (this.m_oServer != null) {
            List logicalServers = this.m_oServer.getServers();
            for (int index = 0; index < logicalServers.size(); ++index) {
                LogicalServerInterface logicalServer = (LogicalServerInterface)logicalServers.get(index);
                if (!logicalServer.getClassIdentifier().equals(GRID_CLSID)) continue;
                List components = logicalServer.getServers();
                for (int componentIndex = 0; componentIndex < components.size(); ++componentIndex) {
                    ServerComponentInterface component = (ServerComponentInterface)components.get(componentIndex);
                    if (!component.getClassIdentifier().equals(GRID_CLSID)) continue;
                    return (ServerComponent)component.getRepositoryEntity();
                }
            }
        }
        return null;
    }

    private String findHotFix() throws WsAppServerCodeException, WsAppServerFailException, SQLException {
        StringBuffer code = new StringBuffer();
        code.append("%macro etls_gethotfix();\n\n");
        code.append("  data sasspinfo;\n");
        code.append("     length spinfo $200;\n");
        code.append("     spinfo = '';\n");
        code.append("     rc = tslvl('uwuhotfi');\n");
        code.append("     if rc ne '' then do;\n");
        code.append("     spinfo = hotfix();\n");
        code.append("     if index(upcase(spinfo),'SERVICE') then\n");
        code.append("        spinfo=substr(spinfo,length(spinfo));\n");
        code.append("     else if index(upcase(spinfo),'SP ') then\n");
        code.append("        spinfo=substr(spinfo,index(upcase(spinfo),'SP')+3,1);\n");
        code.append("     else if index(upcase(spinfo),'SP') then\n");
        code.append("        spinfo=substr(spinfo,index(upcase(spinfo),'SP')+2,1);\n");
        code.append("     end;\n");
        code.append("  run;\n");
        code.append("%mend etls_gethotfix;\n\n");
        code.append("%etls_gethotfix;\n");
        this.submitSASCode(code.toString());
        ResultSet results = this.openSQLConnection().createStatement().executeQuery("Select sasspinfo.spinfo from work.sasspinfo");
        results.next();
        return results.getString("spinfo");
    }

    public String getHotFix() throws WsAppServerCodeException, WsAppServerFailException, SQLException {
        if (this.m_hotFix == null) {
            this.m_hotFix = this.findHotFix();
        }
        return this.m_hotFix;
    }

    public int getHotFixNumber() throws WsAppServerCodeException, WsAppServerFailException, SQLException {
        Integer hotfixnumber = new Integer(0);
        String hotfix = this.m_hotFix == null ? this.getHotFix().trim() : this.m_hotFix;
        if (hotfix.length() > 0) {
            hotfix = hotfix.trim();
            hotfix = hotfix.substring(hotfix.length() - 1);
            hotfixnumber = new Integer(hotfix);
        }
        return hotfixnumber;
    }

    public static ServerContextInterface[] getAppServers() throws MdException, RemoteException {
        String sFoundationName = Workspace.getMdFactory().getOMIUtil().getFoundationRepository().getName();
        ArrayList<String> repositories = new ArrayList<String>();
        repositories.add(sFoundationName);
        RepositoryGroup repositoryGroup = new RepositoryGroup();
        for (int index = 0; index < repositories.size(); ++index) {
            repositoryGroup.addRepository((String)repositories.get(index));
        }
        try {
            InformationServiceInterface informationService = CorePlatformServices.getInformationService();
            Filter filter = new Filter();
            filter.setType("ServerContext");
            List servers = informationService.searchGroup(WsAppServer.getUserContext(), repositoryGroup, (FilterInterface)filter);
            return servers.toArray(new ServerContextInterface[0]);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return null;
    }

    public static ServerContextInterface[] getAppServers(ServerInterface server) throws MdException, RemoteException, ServiceException {
        Filter filter = new Filter();
        filter.setType("ServerContext");
        List servers = server.search((FilterInterface)filter);
        return servers.toArray(new ServerContextInterface[servers.size()]);
    }

    public static ServerContextInterface[] getAppServers(UserContextInterface userContext) throws MdException, RemoteException {
        List repositories = Workspace.getWorkspace().getSelectedRepositoryNames();
        RepositoryGroup repositoryGroup = new RepositoryGroup();
        for (int index = 0; index < repositories.size(); ++index) {
            repositoryGroup.addRepository((String)repositories.get(index));
        }
        try {
            InformationServiceInterface informationService = CorePlatformServices.getInformationService();
            Filter filter = new Filter();
            filter.setType("ServerContext");
            List servers = informationService.searchGroup(userContext, repositoryGroup, (FilterInterface)filter);
            return servers.toArray(new ServerContextInterface[0]);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return null;
    }

    public static String getDefaultAppServerName() throws MdException, RemoteException {
        String AppServerID = Workspace.getWorkspace().getWorkspaceFile().getPropertyString(DEFAULT_SERVER_FQID_KEY);
        if (AppServerID != null && AppServerID.length() > 0) {
            ArrayList<String> lAttrs = new ArrayList<String>();
            lAttrs.add("Name");
            List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple("ServerContext", AppServerID, lAttrs);
            if (!lValues.isEmpty()) {
                return (String)lValues.get(0);
            }
        }
        return null;
    }

    public static String getDefaultAppServerFQID() {
        return Workspace.getWorkspace().getWorkspaceFile().getPropertyString(DEFAULT_SERVER_FQID_KEY);
    }

    public static void setDefaultAppServerFQID(String sDefaultServerFQID) {
        WorkspaceFile wsf = Workspace.getWorkspace().getWorkspaceFile();
        wsf.setPropertyString(DEFAULT_SERVER_FQID_KEY, sDefaultServerFQID);
        wsf.saveExisting();
    }

    public static WsAppServer createDefaultAppServer() {
        return WsAppServer.createDefaultAppServer(true);
    }

    public static WsAppServer createDefaultAppServer(boolean bPrompt) {
        String sServerFQID = WsAppServer.getDefaultAppServerFQID();
        if (sServerFQID == null || sServerFQID.length() == 0 || WsAppServer.findAppServer(sServerFQID) == null || !Workspace.getWorkspace().isDefaultAppServerSupported()) {
            if (!bPrompt) {
                return null;
            }
            WsAppServer.showDefaultAppServerPrompt();
            sServerFQID = WsAppServer.getDefaultAppServerFQID();
            if (sServerFQID.length() == 0) {
                return null;
            }
        }
        try {
            return new WsAppServer(sServerFQID);
        }
        catch (WsAppServerFailException ex) {
            return null;
        }
    }

    public static WsAppServer createAppServer(ServerContext oServer) {
        return new WsAppServer(oServer);
    }

    public static WsAppServer createAppServer(ServerContextInterface oServer) {
        return new WsAppServer(oServer);
    }

    public static WsAppServer createAppServer(String id) {
        try {
            return new WsAppServer(id);
        }
        catch (WsAppServerFailException ex) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", ex);
            return null;
        }
    }

    private WsAppServer(ServerContext oServer) {
        try {
            this.m_oServer = WsAppServer.findAppServer(oServer.getFQID());
            this.setName(Integer.toString((int)(Math.random() * 100000.0)));
            this.m_mapConnections = new HashMap();
            this.m_lListeners = new ArrayList();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    private WsAppServer(ServerContextInterface oServer) {
        this.m_oServer = oServer;
        this.setName(Integer.toString((int)(Math.random() * 100000.0)));
        this.m_mapConnections = new HashMap();
        this.m_lListeners = new ArrayList();
    }

    private WsAppServer(String sServerFQID) throws WsAppServerFailException {
        this.m_lListeners = new ArrayList();
        ServerContextInterface serverContext = WsAppServer.findAppServer(sServerFQID);
        if (serverContext == null) {
            throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.InvalidServerDefinition.txt"));
        }
        this.m_oServer = serverContext;
        this.setName(Integer.toString((int)(Math.random() * 100000.0)));
        this.m_mapConnections = new HashMap();
    }

    public void dispose() {
        this.close();
        Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " disposed.");
    }

    public void setServerFQID(String sFQID) {
        if (this.getServerFQID().equals(sFQID)) {
            return;
        }
        ServerContextInterface serverContext = WsAppServer.findAppServer(sFQID);
        if (serverContext != null) {
            this.setServerContext(serverContext);
        }
    }

    public String getServerFQID() {
        try {
            return this.m_oServer.getIdentifier();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
            return "";
        }
    }

    public void setServerContext(ServerContextInterface oServer) {
        if (this.isOpen()) {
            throw new UnsupportedOperationException("Attempt to change server FQID while AppServer is open");
        }
        this.m_oServer = oServer;
        this.m_oLogicalServer = null;
    }

    public void setServerContext(ServerContext oServer) {
        if (this.isOpen()) {
            throw new UnsupportedOperationException("Attempt to change server FQID while AppServer is open");
        }
        try {
            String id = oServer.getFQID();
            this.m_oServer = WsAppServer.findAppServer(id);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.m_oLogicalServer = null;
    }

    public ServerContext getServerContext() {
        try {
            return (ServerContext)this.m_oServer.getRepositoryEntity();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return null;
        }
    }

    public String getServerName() throws RemoteException {
        return this.m_oServer.getName();
    }

    public String getUserName() throws RemoteException, ServiceException, MdException, WsAppServerFailException, ConnectionFactoryException {
        String domain = this.getLogicalServerDomain();
        if (domain != null) {
            PasswordAuthentication pw = Workspace.getWorkspace().getConnectionManager().getLogin(domain);
            return pw.getUserName();
        }
        return null;
    }

    public void removeCredentials() {
        if (this.m_oLogicalServer == null) {
            throw new UnsupportedOperationException("The logical server for the server must have been retrieved before the credentials can be removed");
        }
        try {
            Workspace.getWorkspace().removeAppServerCredentials(this.m_oLogicalServer.getIdentifier());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
    }

    public String getPassword() throws RemoteException, ServiceException, MdException, WsAppServerFailException, ConnectionFactoryException {
        String domain = this.getLogicalServerDomain();
        if (domain != null) {
            PasswordAuthentication pw = Workspace.getWorkspace().getConnectionManager().getLogin(domain);
            return new String(pw.getPassword());
        }
        return null;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    public IWorkspace getWorkspace() {
        return this.m_svcWorkspace;
    }

    public IFileService getFileService() throws WsAppServerFailException {
        this.openFileService();
        return this.m_svcFile;
    }

    public static void setUserContext(UserContextInterface userContext) {
        m_userContext = userContext;
    }

    public static UserContextInterface getUserContext() {
        if (m_userContext == null) {
            m_userContext = Workspace.getWorkspace().getUserContext();
        }
        return m_userContext;
    }

    public void setInformationService(InformationServiceInterface informationService) {
        this.m_informationService = informationService;
    }

    public InformationServiceInterface getInformationService() {
        return this.m_informationService;
    }

    public void test() throws WsAppServerFailException {
        this.open();
        this.close();
    }

    public void open() throws WsAppServerFailException {
        this.open(true);
    }

    public void open(boolean bPromptForPassword) throws WsAppServerFailException {
        if (bPromptForPassword && !this.bServerVersionCheckInProgress && !this.isServerVersionCompatible()) {
            return;
        }
        try {
            this.m_bKilled = false;
            if (this.isOpen()) {
                Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + ": already open");
                return;
            }
            try {
                this.findLogicalServer();
            }
            catch (MdException e) {
                throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
            }
            int iPrompts = 0;
            for (int iAttempt = 0; iAttempt < 4 && iPrompts < 3; ++iAttempt) {
                try {
                    this.openConnection(bPromptForPassword);
                    Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " opened.");
                    return;
                }
                catch (ConnectionFactoryException e) {
                    Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " open(" + iAttempt + ") failed.");
                    this.close();
                    if (e instanceof LoginException) {
                        if (!bPromptForPassword) {
                            throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonFailed.txt"));
                        }
                        if (iAttempt >= 4) {
                            throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonAttemptLimitReached.txt"));
                        }
                        if (this.containsCause((Exception)((java.lang.Object)e), CallbackCancelledException.class)) {
                            throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonCancelled.txt"));
                        }
                        if (this.containsCause((Exception)((java.lang.Object)e), InvalidCredentialsException.class)) {
                            InvalidCredentialsException invalidCredentialsException = (InvalidCredentialsException)this.getCause((Exception)((java.lang.Object)e), InvalidCredentialsException.class);
                            if (!invalidCredentialsException.isLoginCallbackError()) continue;
                            if (++iPrompts >= 3) {
                                throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonAttemptLimitReached.txt"));
                            }
                            MessageUtil.displayDetailsMessage(bundle.getString("WsAppServer.Error.InvalidCredentials.txt"), Workspace.getWorkspace().getApplicationName(), 0, MessageUtil.getCauseMessageString((Exception)((java.lang.Object)e)));
                            continue;
                        }
                        throw new WsAppServerFailException(e.getLocalizedMessage(), this.getCauseMessageString((Exception)((java.lang.Object)e)));
                    }
                    String[] causeMessages = MessageUtil.getCauseMessages((Exception)((java.lang.Object)e));
                    if (causeMessages.length > 0) {
                        throw new WsAppServerFailException(e.getLocalizedMessage(), this.getCauseMessageString((Exception)((java.lang.Object)e)));
                    }
                    throw new WsAppServerFailException(e.getLocalizedMessage());
                }
                catch (AuthDomainDoesNotExist e) {
                    Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " open(" + iAttempt + ") failed.");
                    this.close();
                    if (!bPromptForPassword) {
                        throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonFailed.txt"));
                    }
                    if (iAttempt >= 4) {
                        throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonAttemptLimitReached.txt"));
                    }
                    MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
                    continue;
                }
                catch (InvalidOptionName e) {
                    throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
                }
                catch (InvalidOptionValue e) {
                    throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
                }
                catch (InvalidCredHandle e) {
                    Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " open(" + iAttempt + ") failed.");
                    this.close();
                    if (!bPromptForPassword) {
                        throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonFailed.txt"));
                    }
                    if (iAttempt >= 4) {
                        throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.LogonAttemptLimitReached.txt"));
                    }
                    MessageUtil.displayMessage(bundle.getString("WsAppServer.Error.InvalidCredentials.txt"));
                    continue;
                }
                catch (GenericError e) {
                    throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
                }
                catch (RemoteException e) {
                    throw new WsAppServerFailException(this.getExceptionMessage(e));
                }
                catch (MdException e) {
                    throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected boolean containsCause(Exception exception, Class causeType) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!causeType.isAssignableFrom(cause.getClass())) continue;
            return true;
        }
        return false;
    }

    protected Throwable getCause(Exception exception, Class causeType) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!causeType.isAssignableFrom(cause.getClass())) continue;
            return cause;
        }
        return null;
    }

    protected String[] getCauseMessages(Exception exception) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            messages.add(cause.getLocalizedMessage());
        }
        return messages.toArray(new String[messages.size()]);
    }

    protected String getCauseMessageString(Exception exception) {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            buffer.append(separator);
            buffer.append(cause.getLocalizedMessage());
            separator = "\n";
        }
        return buffer.toString();
    }

    public String getOperatingSystem() throws WsAppServerFailException {
        try {
            this.open();
            IUtilities utilities = this.m_svcWorkspace.Utilities();
            IHostSystem hostSystem = utilities.HostSystem();
            StringSeqHolder softwareInfo = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfo = new VariableArray2dOfStringHolder();
            hostSystem.GetInfo(softwareInfo, hardwareInfo);
            String sOS = softwareInfo.value[3];
            Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + ":OperatingSystem=" + sOS);
            return sOS;
        }
        catch (GenericError ge) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)ge)));
        }
    }

    public boolean isFileBrowseEnabled() {
        boolean b;
        try {
            b = !this.getOperatingSystem().equals(OPERATING_SYSTEM_MVS);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(bundle.getString("WsAppServer.Error.ConnectionFailed.txt"), 0);
            return false;
        }
        if (!b) {
            MessageUtil.displayMessage(bundle.getString("WsAppServer.MVSBrowseDisabled.txt"), bundle.getString("WsAppServer.MVSBrowseDisabled.title"), 0);
        }
        return b;
    }

    public void validateDefinition() throws MdException, RemoteException, WsAppServerFailException {
        this.findLogicalServer();
    }

    private void findLogicalServer() throws MdException, RemoteException, WsAppServerFailException {
        try {
            List servers = this.m_oServer.getServers();
            for (int index = 0; index < servers.size(); ++index) {
                LogicalServerInterface logicalServer = (LogicalServerInterface)servers.get(index);
                if (!logicalServer.getClassIdentifier().equals(WORKSPACE_CLSID)) continue;
                this.m_oLogicalServer = logicalServer;
                return;
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        throw new WsAppServerFailException(bundle.getString("WsAppServer.Error.InvalidServerDefinition.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnection(boolean bPromptForPassword) throws ConnectionFactoryException, MdException, RemoteException, InvalidCredHandle, InvalidOptionName, InvalidOptionValue, AuthDomainDoesNotExist, GenericError {
        UserContextInterface userContext;
        UserContextInterface userContextInterface = userContext = WsAppServer.getUserContext();
        synchronized (userContextInterface) {
            RemoteCallbackHandler handler = userContext.getChallengeCallbackHandler();
            if (!bPromptForPassword) {
                userContext.setChallengeCallbackHandler(null);
            }
            try {
                String _applicationSoftwareComponentClassId = Workspace.getApplicationSoftwareComponentClassId();
                if (_applicationSoftwareComponentClassId != null && _applicationSoftwareComponentClassId.length() > 0) {
                    try {
                        ClientApplicationNameHolder.set((String)Workspace.getWorkspace().getApplicationName(Workspace.getWorkspace().getUserContext().getAuthServer(), _applicationSoftwareComponentClassId));
                    }
                    catch (ServiceException e) {
                        Workspace.getDefaultLogger().debug((java.lang.Object)e);
                    }
                }
                PlatformConnectionFactoryConfiguration configuration = new PlatformConnectionFactoryConfiguration(this.m_oLogicalServer);
                PlatformConnectionFactoryInterface platformFactory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)configuration);
                if (bPromptForPassword) {
                    Workspace.getWorkspace().getConnectionManager().setLoginCallbackHostName(this.m_oServer.getName());
                }
                this.m_connection = platformFactory.getConnection(WsAppServer.getUserContext());
                if (bPromptForPassword) {
                    Workspace.getWorkspace().getConnectionManager().setLoginCallbackHostName(null);
                }
                this.m_svcWorkspace = IWorkspaceHelper.narrow((Object)this.m_connection.getObject());
            }
            finally {
                if (!bPromptForPassword) {
                    WsAppServer.getUserContext().setChallengeCallbackHandler(handler);
                } else {
                    Workspace.getWorkspace().getConnectionManager().setLoginCallbackHostName(null);
                }
            }
        }
    }

    public static ServerContextInterface findAppServer(String fqid) {
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            RepositoryInterface reposInterface = null;
            if (fqid == null || fqid.length() == 0) {
                return null;
            }
            String sRepositoryID = fqid.startsWith("A0000001") ? fqid.substring(9) : fqid.substring(0, 8);
            String reposName = server.getRepositoryName("A0000001." + sRepositoryID);
            if (fqid == null || reposName == null) {
                return null;
            }
            reposInterface = server.getRepository(reposName);
            Filter filter = new Filter();
            filter.setType("ServerContext");
            FilterComponent fqidComponent = new FilterComponent("Id", 0, fqid);
            filter.setFilterComponent(fqidComponent);
            List servers = reposInterface.search((FilterInterface)filter);
            if (servers.size() > 0) {
                return (ServerContextInterface)servers.get(0);
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return null;
    }

    public static ServerContextInterface[] findAppServers() {
        List appServers = new ArrayList();
        try {
            InformationServiceInterface informationService = CorePlatformServices.getInformationService();
            Filter filter = new Filter();
            filter.setType("ServerContext");
            appServers = informationService.search(WsAppServer.getUserContext(), (FilterInterface)filter);
            return appServers.toArray(new ServerContextInterface[0]);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return null;
    }

    public static LogicalServerInterface findLogicalServer(String fqid) {
        try {
            InformationServiceInterface informationService = CorePlatformServices.getInformationService();
            Filter filter = new Filter();
            filter.setType("LogicalServer");
            FilterComponent fqidComponent = new FilterComponent("Id", 0, fqid);
            filter.setFilterComponent(fqidComponent);
            List servers = informationService.search(WsAppServer.getUserContext(), (FilterInterface)filter);
            if (servers.size() > 0) {
                return (LogicalServerInterface)servers.get(0);
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return null;
    }

    public static LogicalServerInterface[] findWorkspaceServers() {
        ArrayList appServers = new ArrayList();
        try {
            InformationServiceInterface informationService = CorePlatformServices.getInformationService();
            Filter filter = new Filter();
            filter.setType("LogicalServer");
            FilterComponent classIdComponent = new FilterComponent("ClassIdentifier", 0, WORKSPACE_CLSID);
            filter.setFilterComponent(classIdComponent);
            List servers = informationService.search(WsAppServer.getUserContext(), (FilterInterface)filter);
            for (int index = 0; index < servers.size(); ++index) {
                java.lang.Object server = servers.get(index);
                if (server instanceof LogicalServerInterface) {
                    appServers.add(server);
                }
                Workspace.getDefaultLogger().debug("Server: " + server.getClass().getName());
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        return appServers.toArray(new LogicalServerInterface[0]);
    }

    public boolean isOpen() {
        return this.m_svcWorkspace != null;
    }

    public void close() {
        this.closeSASCodeSession();
        this.closeDataService();
        this.closeFileService();
        this.closeFormatService();
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
        if (this.m_svcWorkspace != null) {
            this.m_svcWorkspace._release();
            this.m_svcWorkspace = null;
        }
        Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " closed.");
    }

    public void kill() {
        this.m_bKilled = true;
        this.m_svcSessionControl = ISessionControlHelper.narrow((Object)this.m_svcWorkspace);
        try {
            if (this.m_svcSessionControl != null) {
                this.m_svcSessionControl.Kill(5);
            }
        }
        catch (GenericError genericError) {
        }
        finally {
            this.m_svcLanguage = null;
            this.m_svcLanguage_1_1 = null;
            this.m_svcData = null;
            this.m_svcWorkspace = null;
            Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " killed.");
        }
    }

    public void openSASCodeSession() throws WsAppServerFailException {
        if (!this.isOpen()) {
            this.open();
        }
        if (this.isSASCodeSessionOpen()) {
            Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + ": SAS code session already open");
            return;
        }
        try {
            this.m_svcLanguage = this.m_svcWorkspace.LanguageService();
            this.m_svcLanguage_1_1 = ILanguageService_1_1Helper.narrow((Object)this.m_svcLanguage);
            this.grabConnectionPoint();
            this.registerLanguageListener(new cLanguageEventsListener());
            if (this.m_svcLanguage_1_1 != null) {
                this.registerLanguageLogListener(new cLanguageLogEventListener());
            }
            Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " SAS code session opened.");
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    public boolean isSASCodeSessionOpen() {
        if (this.m_svcLanguage_1_1 != null) {
            return true;
        }
        return this.m_svcLanguage != null;
    }

    public void closeSASCodeSession() {
        this.unregisterLanguageListener();
        this.unregisterLanguageLogListener();
        this.releaseConnectionPoint();
        if (this.m_svcLanguage_1_1 != null) {
            this.m_svcLanguage_1_1._release();
            this.m_svcLanguage_1_1 = null;
        }
        if (this.m_svcLanguage != null) {
            this.m_svcLanguage._release();
            this.m_svcLanguage = null;
            Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + " SAS code session closed.");
        }
    }

    public boolean isKilled() {
        return this.m_bKilled;
    }

    public void resetServer() throws WsAppServerFailException {
        if (this.isSASCodeSessionOpen()) {
            try {
                if (this.m_svcLanguage_1_1 != null) {
                    this.m_svcLanguage_1_1.Reset();
                } else if (this.m_svcLanguage != null) {
                    this.m_svcLanguage.Reset();
                }
            }
            catch (GenericError e) {
                Workspace.getDefaultLogger().error(e.getLocalizedMessage());
                throw new WsAppServerFailException(e.getLocalizedMessage());
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error(e.getLocalizedMessage());
                throw new WsAppServerFailException(e.getLocalizedMessage());
            }
        }
    }

    public void submitSASCode(String sSASCode) throws WsAppServerFailException, WsAppServerCodeException {
        this.submitSASCode(sSASCode, false);
    }

    public void submitSASCode(String sSASCode, boolean bLogPerStep) throws WsAppServerFailException, WsAppServerCodeException {
        this.submitSASCode(sSASCode, bLogPerStep, true);
    }

    public boolean isFlushLogLinesPerStep() {
        if (this.m_svcLanguage_1_1 != null) {
            return this.m_svcLanguage_1_1.FlushLogPerStep();
        }
        return false;
    }

    public void submitSASCode(String sSASCode, boolean bLogPerStep, boolean doReset) throws WsAppServerFailException, WsAppServerCodeException {
        if (!this.isOpen()) {
            this.open();
        }
        if (!this.isSASCodeSessionOpen()) {
            this.openSASCodeSession();
        }
        try {
            this.m_bSubmissionCancelled = false;
            this.m_bErrorInCode = false;
            Workspace.getDefaultLogger().info("AppServer:" + this.m_sName + " code submitted.");
            Workspace.getDefaultLogger().info(sSASCode);
            this.clearAbortHolders();
            if (this.m_svcLanguage_1_1 != null) {
                if (doReset) {
                    this.m_svcLanguage_1_1.Reset();
                }
                this.m_svcLanguage_1_1.FlushLogPerStep(bLogPerStep);
                this.m_svcLanguage_1_1.Submit(sSASCode);
            } else {
                if (doReset) {
                    this.m_svcLanguage.Reset();
                }
                this.m_svcLanguage.Submit(sSASCode);
            }
        }
        catch (GenericError e) {
            throw new WsAppServerFailException(e.getLocalizedMessage());
        }
        catch (SystemException e) {
            if (e instanceof OBJECT_NOT_EXIST) {
                this.close();
                throw new WsAppServerCodeException(bundle.getString("WsAppServer.CodeError.Abort.txt"), 3);
            }
            throw new WsAppServerFailException(e.getLocalizedMessage());
        }
        if (this.m_bErrorInCode) {
            throw new WsAppServerCodeException(bundle.getString("WsAppServer.CodeError.StepError.txt"), 1);
        }
        if (this.m_bSubmissionCancelled) {
            throw new WsAppServerCodeException(bundle.getString("WsAppServer.CodeError.Cancelled.txt"), 2);
        }
    }

    public void cancelRunningSASCode() throws WsAppServerFailException {
        try {
            if (this.m_svcLanguage_1_1 != null) {
                this.m_bSubmissionCancelled = true;
                this.m_svcLanguage_1_1.Cancel();
            } else if (this.m_svcLanguage != null) {
                this.m_bSubmissionCancelled = true;
                this.m_svcLanguage.Cancel();
            }
        }
        catch (GenericError ex) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)ex)));
        }
        catch (SystemException ex) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)ex)));
        }
    }

    public LogListHolder getLog() throws WsAppServerFailException {
        if (!this.isSASCodeSessionOpen()) {
            return null;
        }
        CarriageControlSeqHolder logCCHolder = new CarriageControlSeqHolder();
        LineTypeSeqHolder logTypeHolder = new LineTypeSeqHolder();
        StringSeqHolder logLinesHolder = new StringSeqHolder();
        LogListHolder logHolder = new LogListHolder(logLinesHolder, logCCHolder, logTypeHolder);
        try {
            if (this.m_svcLanguage_1_1 != null) {
                this.m_svcLanguage_1_1.FlushLogLines(Integer.MAX_VALUE, logCCHolder, logTypeHolder, logLinesHolder);
            } else {
                this.m_svcLanguage.FlushLogLines(Integer.MAX_VALUE, logCCHolder, logTypeHolder, logLinesHolder);
            }
            return logHolder;
        }
        catch (GenericError ex) {
            String sMessage = this.getExceptionMessage((Exception)((java.lang.Object)ex));
            String sException = bundle.formatString("WsAppServer.Error.RetrieveLogException.fmt.txt", sMessage);
            throw new WsAppServerFailException(sException);
        }
        catch (SystemException ex) {
            String sMessage = this.getExceptionMessage((Exception)((java.lang.Object)ex));
            String sException = bundle.formatString("WsAppServer.Error.RetrieveLogException.fmt.txt", sMessage);
            throw new WsAppServerFailException(sException);
        }
    }

    public StringBuffer getLogBuffer() throws WsAppServerFailException {
        StringBuffer logBuffer = new StringBuffer();
        LogListHolder logHolder = this.getLog();
        String[] logLines = logHolder.getLineArray();
        for (int i = 0; i < logLines.length; ++i) {
            logBuffer.append(logLines[i]).append("\n");
        }
        return logBuffer;
    }

    public LogListHolder getOutput() throws WsAppServerFailException {
        if (!this.isSASCodeSessionOpen()) {
            return null;
        }
        CarriageControlSeqHolder listCCHolder = new CarriageControlSeqHolder();
        LineTypeSeqHolder listTypeHolder = new LineTypeSeqHolder();
        StringSeqHolder listLinesHolder = new StringSeqHolder();
        LogListHolder listHolder = new LogListHolder(listLinesHolder, listCCHolder, listTypeHolder);
        try {
            if (this.m_svcLanguage_1_1 != null) {
                this.m_svcLanguage_1_1.FlushListLines(Integer.MAX_VALUE, listCCHolder, listTypeHolder, listLinesHolder);
            } else {
                this.m_svcLanguage.FlushListLines(Integer.MAX_VALUE, listCCHolder, listTypeHolder, listLinesHolder);
            }
            return listHolder;
        }
        catch (GenericError ex) {
            String sMessage = this.getExceptionMessage((Exception)((java.lang.Object)ex));
            String sException = bundle.formatString("WsAppServer.Error.RetrieveOutputException.fmt.txt", sMessage);
            throw new WsAppServerFailException(sException);
        }
        catch (SystemException ex) {
            String sMessage = this.getExceptionMessage((Exception)((java.lang.Object)ex));
            String sException = bundle.formatString("WsAppServer.Error.RetrieveOutputException.fmt.txt", sMessage);
            throw new WsAppServerFailException(sException);
        }
    }

    private void grabConnectionPoint() {
        CP_ID cpid = null;
        ConnectionPointContainer cpContainer = null;
        if (this.m_svcLanguage_1_1 == null) {
            int i;
            String cpidString = ILanguageEventsHelper.id();
            int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
            short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
            short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
            byte[] d4 = new byte[8];
            for (i = 0; i < 2; ++i) {
                d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
            }
            for (i = 0; i < 6; ++i) {
                d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
            }
            cpid = new CP_ID(d1, d2, d3, d4);
        } else {
            String cpidStr = ILanguageEvents_1_1Helper.id();
            cpid = CP_IDConverter.stringToCP_ID((String)cpidStr);
        }
        cpContainer = ConnectionPointContainerHelper.narrow((Object)this.m_svcLanguage);
        ConnectionPointHolder cpHolder = new ConnectionPointHolder();
        if (cpid != null) {
            cpContainer.FindConnectionPoint(cpid, cpHolder);
            this.m_cpLanguage = cpHolder.value;
        }
        String cpidLogStr = ILanguageLogEventHelper.id();
        CP_ID cpidLog = CP_IDConverter.stringToCP_ID((String)cpidLogStr);
        ConnectionPointHolder cpLogHolder = new ConnectionPointHolder();
        if (cpidLog != null) {
            cpContainer.FindConnectionPoint(cpidLog, cpLogHolder);
            this.m_cpLanguageLog = cpLogHolder.value;
        }
    }

    private void releaseConnectionPoint() {
        if (this.m_cpLanguage != null) {
            this.m_cpLanguage._release();
            this.m_cpLanguage = null;
        }
        if (this.m_cpLanguageLog != null) {
            this.m_cpLanguageLog._release();
            this.m_cpLanguageLog = null;
        }
    }

    private void registerLanguageListener(cLanguageEventsListener lsnr) {
        IntHolder handleHolder = new IntHolder();
        this.m_cpLanguage.Advise((Object)lsnr, handleHolder);
        this.m_hLanguageListener = handleHolder.value;
    }

    private void registerLanguageLogListener(cLanguageLogEventListener lsnr) {
        IntHolder handleHolder = new IntHolder();
        this.m_cpLanguageLog.Advise((Object)lsnr, handleHolder);
        this.m_hLanguageLogListener = handleHolder.value;
    }

    private void unregisterLanguageLogListener() {
        if (this.m_cpLanguageLog != null && this.m_hLanguageLogListener != 0) {
            this.m_cpLanguageLog.Unadvise(this.m_hLanguageLogListener);
            this.m_hLanguageLogListener = 0;
        }
    }

    private void unregisterLanguageListener() {
        if (this.m_cpLanguage != null && this.m_hLanguageListener != 0) {
            this.m_cpLanguage.Unadvise(this.m_hLanguageListener);
            this.m_hLanguageListener = 0;
        }
    }

    private void openDataService() throws WsAppServerFailException {
        if (!this.isOpen()) {
            this.open();
        }
        try {
            if (this.m_svcData == null) {
                this.m_svcData = this.m_svcWorkspace.DataService();
            }
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    private void closeDataService() {
        this.closeSQLConnection();
        if (this.m_svcData != null) {
            this.m_svcData._release();
            this.m_svcData = null;
        }
    }

    public MVAResultSet submitSQLStatement(String sSQLStatement) throws WsAppServerFailException {
        return this.submitSQLStatement(sSQLStatement, null, 1000);
    }

    public MVAResultSet submitSQLStatement(String sSQLStatement, int iFetchRows) throws WsAppServerFailException {
        return this.submitSQLStatement(sSQLStatement, null, iFetchRows);
    }

    public MVAResultSet submitSQLStatement(String sSQLStatement, MVAStatement oSQLStatement, int iFetchRows) throws WsAppServerFailException {
        this.openDataService();
        MVAResultSet resultSet = null;
        try {
            if (oSQLStatement == null) {
                this.openSQLConnection();
                oSQLStatement = (MVAStatement)this.m_sqlConnection.createStatement();
            }
            resultSet = (MVAResultSet)oSQLStatement.executeQuery(sSQLStatement);
            resultSet.setFetchSize(iFetchRows);
        }
        catch (SQLException se) {
            throw new WsAppServerFailException(this.getExceptionMessage(se));
        }
        return resultSet;
    }

    public MVAResultSet submitAssignedSQLStatement(String sSQLStatement) throws WsAppServerFailException {
        return this.submitAssignedSQLStatement(sSQLStatement, null, 1000);
    }

    public MVAResultSet submitAssignedSQLStatement(String sSQLStatement, int iFetchRows) throws WsAppServerFailException {
        return this.submitAssignedSQLStatement(sSQLStatement, null, iFetchRows);
    }

    public MVAResultSet submitAssignedSQLStatement(String sSQLStatement, MVAStatement oSQLStatement, int iFetchRows) throws WsAppServerFailException {
        this.openDataService();
        MVAResultSet resultSet = null;
        try {
            if (oSQLStatement == null) {
                String sId = this.openAssignedSQLConnection();
                MVAConnection sqlConnection = this.getAssignedSQLConnection(sId);
                oSQLStatement = (MVAStatement)sqlConnection.createStatement();
            }
            resultSet = (MVAResultSet)oSQLStatement.executeQuery(sSQLStatement);
            resultSet.setFetchSize(iFetchRows);
        }
        catch (SQLException se) {
            throw new WsAppServerFailException(this.getExceptionMessage(se));
        }
        return resultSet;
    }

    public MVAConnection openSQLConnection() throws WsAppServerFailException {
        Properties JDBCProperties = new Properties();
        JDBCProperties.put("APPLYFORMATS", "true");
        return this.openSQLConnection(JDBCProperties);
    }

    public String openAssignedSQLConnection() throws WsAppServerFailException {
        Properties JDBCProperties = new Properties();
        JDBCProperties.put("APPLYFORMATS", "true");
        return this.openAssignedSQLConnection(JDBCProperties);
    }

    public MVAConnection openSQLConnection(Properties JDBCProperties) throws WsAppServerFailException {
        this.openDataService();
        try {
            if (this.isSQLConnectionOpen()) {
                Workspace.getDefaultLogger().debug("AppServer:" + this.m_sName + ": SQL Connection already open");
                return null;
            }
            this.m_sqlConnection = new MVAConnection(this.m_svcData, JDBCProperties);
            return this.m_sqlConnection;
        }
        catch (SQLException se) {
            throw new WsAppServerFailException(this.getExceptionMessage(se));
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    public String openAssignedSQLConnection(Properties JDBCProperties) throws WsAppServerFailException {
        String strId = GUID.newGUID();
        this.openDataService();
        try {
            this.m_mapConnections.put(strId, new MVAConnection(this.m_svcData, JDBCProperties));
            return strId;
        }
        catch (SQLException se) {
            throw new WsAppServerFailException(this.getExceptionMessage(se));
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    public void closeSQLConnection() {
        try {
            if (this.m_sqlConnection != null) {
                this.m_sqlConnection.close();
                this.m_sqlConnection = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeAssignedSQLConnection(String strId) {
        try {
            MVAConnection sqlConnection = this.getAssignedSQLConnection(strId);
            if (this.m_mapConnections != null) {
                this.m_mapConnections.remove(strId);
            }
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isAssignedSQLConnectionOpen(String strId) {
        return this.getAssignedSQLConnection(strId) != null;
    }

    public boolean isSQLConnectionOpen() {
        return this.m_sqlConnection != null;
    }

    public MVAConnection getSQLConnection() {
        return this.m_sqlConnection;
    }

    public MVAResultSet getTable(String strLibref, String strTable, String strMemType, String[] sasPasswords, String strOptions) throws WsAppServerFailException {
        MVAResultSet m_rsltSet = null;
        try {
            this.openSQLConnection();
            MVAStatement oSQLStatement = (MVAStatement)this.m_sqlConnection.createStatement();
            m_rsltSet = (MVAResultSet)oSQLStatement.getTable(strLibref, strTable, strMemType, sasPasswords, strOptions);
            m_rsltSet.setFetchSize(1000);
        }
        catch (SQLException se) {
            throw new WsAppServerFailException(this.getExceptionMessage(se));
        }
        return m_rsltSet;
    }

    public MVAConnection getAssignedSQLConnection(String strId) {
        return (MVAConnection)this.m_mapConnections.get(strId);
    }

    public void assignLibref(String sLibrefName, String sEngine, String sPath, String sOptions) throws WsAppServerLibraryException, WsAppServerFailException {
        this.openDataService();
        try {
            if (!this.isLibrefAssigned(sLibrefName)) {
                this.m_svcData.AssignLibref(sLibrefName, sEngine, sPath, sOptions);
            }
        }
        catch (InvalidPName pe) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)pe)));
        }
        catch (LNameNoAssign ln) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)ln)));
        }
        catch (InvalidLName le) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)le)));
        }
        catch (GenericError e) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
        }
        catch (NoAccessMethod am) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)am)));
        }
        catch (InvalidEngine ie) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)ie)));
        }
        catch (NoLibrary nl) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)nl)));
        }
    }

    public String assignLibref(SASLibrary iLib) throws MdException, RemoteException, WsAppServerLibraryException, WsAppServerFailException, WsAppServerCodeException {
        return this.assignLibref(iLib, true);
    }

    public String assignLibref(SASLibrary iLib, boolean bPromptCredentials) throws MdException, RemoteException, WsAppServerLibraryException, WsAppServerFailException, WsAppServerCodeException {
        this.openDataService();
        int numtmplib = 0;
        String strLibref = iLib.getLibref();
        String strLibref0 = iLib.getLibref();
        boolean fLibRef = false;
        if (iLib.getIsPreassigned() == 0) {
            while (!fLibRef) {
                try {
                    this.m_svcData.UseLibref(strLibref);
                    String suffix = String.valueOf(numtmplib);
                    int suffixLen = suffix.length();
                    if (strLibref0.length() + suffixLen > 8) {
                        strLibref0 = strLibref0.substring(0, 8 - suffixLen);
                    }
                    strLibref = strLibref0 + String.valueOf(numtmplib);
                    ++numtmplib;
                }
                catch (LNameNoAssign ln) {
                    fLibRef = true;
                }
                catch (GenericError e) {
                    fLibRef = true;
                }
                catch (NoLibrary nl) {
                    fLibRef = true;
                }
            }
        }
        MdFactory factory = Workspace.getMdFactory();
        MdObjectStore tempStore = factory.createObjectStore(null, "WsAppServer: AccessPath Store");
        try {
            SASLibrary tempLib = (SASLibrary)factory.createComplexMetadataObject(tempStore, null, (CMetadata)iLib);
            tempLib = (SASLibrary)factory.getOMIUtil().getMetadataAllDepths((CMetadata)tempLib, null, null, "", 8);
            String tempLibRef = strLibref.compareToIgnoreCase(iLib.getLibref()) != 0 ? LibraryUtil.getAccessPath(tempLib, strLibref, true, true, bPromptCredentials) : LibraryUtil.getAccessPath(tempLib, null, true, true, bPromptCredentials);
            this.submitSASCode(tempLibRef);
            this.m_svcData.UseLibref(strLibref);
        }
        catch (LNameNoAssign ln) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)ln)));
        }
        catch (GenericError e) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
        }
        catch (NoLibrary nl) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)nl)));
        }
        finally {
            if (tempStore != null) {
                tempStore.dispose();
            }
        }
        return strLibref;
    }

    public void clearLibref(String sLibref) throws WsAppServerLibraryException, WsAppServerFailException {
        this.openDataService();
        try {
            this.m_svcData.DeassignLibref(sLibref);
        }
        catch (LNameNoAssign lNameNoAssign) {
        }
        catch (GenericError e) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)e)));
        }
        catch (NoWorkDeassign NWD) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)NWD)));
        }
        catch (LibraryInUse LIU) {
            throw new WsAppServerLibraryException(this.getExceptionMessage((Exception)((java.lang.Object)LIU)));
        }
    }

    public boolean isLibrefAssigned(String sLibref) throws WsAppServerFailException {
        this.openDataService();
        try {
            this.m_svcData.UseLibref(sLibref);
        }
        catch (LNameNoAssign ln) {
            return false;
        }
        catch (NoLibrary nl) {
            return false;
        }
        catch (GenericError ge) {
            return false;
        }
        return true;
    }

    public void openFileService() throws WsAppServerFailException {
        if (!this.isOpen()) {
            this.open();
        }
        try {
            if (this.m_svcFile == null) {
                this.m_svcFile = this.m_svcWorkspace.FileService();
            }
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    public void closeFileService() {
        if (this.m_svcFile != null) {
            this.m_svcFile._release();
            this.m_svcFile = null;
        }
    }

    public LogListHolder getAbortLog() {
        return this.m_abortLog != null ? this.m_abortLog : new LogListHolder(new String[0], new Integer[0]);
    }

    public LogListHolder getAbortList() {
        return this.m_abortList != null ? this.m_abortList : new LogListHolder(new String[0], new Integer[0]);
    }

    public void clearAbortHolders() {
        this.m_abortList = null;
        this.m_abortLog = null;
    }

    public String getFileFullPath(String sDirectory, String sFile) throws WsAppServerFailException, GenericError {
        this.openFileService();
        return this.m_svcFile.FullName(sFile, sDirectory);
    }

    public String[] readLinesFromFile(int iStartLine, int iNumberOfLines, Directory oDirectory, File oFile) throws WsAppServerFailException, GenericError {
        this.openFileService();
        String sFullName = "";
        try {
            sFullName = this.getFileFullPath(oDirectory.getDirectoryName(), oFile.getFileName());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return this.readLinesFromFile(iStartLine, iNumberOfLines, sFullName);
    }

    public String[] readLinesFromFile(int iStartLine, int iNumberOfLines, String sFullName) throws WsAppServerFailException, GenericError {
        return this.readLinesFromFile(iStartLine, iNumberOfLines, sFullName, "");
    }

    public String[] readLinesFromFile(int iStartLine, int iNumberOfLines, String sFullName, String sOptions) throws WsAppServerFailException, GenericError {
        return this.readLinesFromFile(iStartLine, iNumberOfLines, sFullName, sOptions, FILE_ACCESS_METHOD_DEFAULT);
    }

    /*
     * Exception decompiling
     */
    public String[] readLinesFromFile(int iStartLine, int iNumberOfLines, String sFullName, String sOptions, String accessMethod) throws WsAppServerFailException, GenericError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 26[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getNumberOfLinesReadFromFile() {
        return this.m_nLinesReadFromFile;
    }

    public String readFile(Directory oDirectory, File oFile) throws WsAppServerFailException, GenericError {
        return this.readFile(oDirectory, oFile, true);
    }

    public String readFile(Directory oDirectory, File oFile, boolean deleteExtraCharacter) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            return this.readFile(this.m_svcFile.FullName(oFile.getFileName(), oDirectory.getDirectoryName()), deleteExtraCharacter);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return "";
        }
    }

    public String readFile(String sFullName) throws WsAppServerFailException, GenericError {
        return this.readFile(sFullName, true);
    }

    public String readFile(String sFullName, boolean deleteExtraCharacter) throws WsAppServerFailException, GenericError {
        return this.readFile(sFullName, "", deleteExtraCharacter);
    }

    public String readFile(String sFullName, String sOptions) throws WsAppServerFailException, GenericError {
        return this.readFile(sFullName, sOptions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String sFullName, String sOptions, boolean deleteExtraCharacter) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            IFileref fileRef = this.m_svcFile.AssignFileref(TEMP_FILE_REF, "DISK", sFullName, sOptions, new StringHolder());
            String string = this.readFile(fileRef, sOptions, deleteExtraCharacter);
            return string;
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(IFileref fileRef, String sOptions, boolean deleteExtraCharacter) throws WsAppServerFailException, GenericError {
        if (fileRef == null) {
            return null;
        }
        this.openFileService();
        try {
            String string;
            ITextStream textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, this.getLineLength());
            try {
                LongSeqHolder truncatedLines = new LongSeqHolder();
                StringSeqHolder lines = new StringSeqHolder();
                StringBuffer buffer = new StringBuffer();
                do {
                    textStream.ReadLines(LINE_CHUNK_SIZE, truncatedLines, lines);
                    for (int iLine = 0; iLine < lines.value.length; ++iLine) {
                        buffer.append(lines.value[iLine]);
                        buffer.append("\n");
                    }
                } while (lines.value.length == LINE_CHUNK_SIZE);
                if (deleteExtraCharacter && buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                string = buffer.toString();
            }
            catch (Throwable throwable) {
                try {
                    textStream.Close();
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                textStream.Close();
            }
            catch (GenericError genericError) {
                // empty catch block
            }
            return string;
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    public String readFile(IFileref fileRef, String sOptions) throws WsAppServerFailException, GenericError {
        return this.readFile(fileRef, sOptions, true);
    }

    public void writeFile(String sData, Directory oDirectory, File oFile) throws WsAppServerFailException, GenericError {
        this.openFileService();
        String sFullName = "";
        try {
            sFullName = this.m_svcFile.FullName(oFile.getFileName(), oDirectory.getDirectoryName());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        this.writeFile(sData, sFullName);
    }

    public void writeFile(String sData, String sFullName) throws WsAppServerFailException, GenericError {
        this.writeFile(sData, sFullName, "");
    }

    public void writeFile(String sData, String sFileName, String sDirectoryName, String sOptions) throws WsAppServerFailException, GenericError {
        this.openFileService();
        String sFullName = this.m_svcFile.FullName(sFileName, sDirectoryName);
        this.writeFile(sData, sFullName, sOptions);
    }

    public void writeFile(String sData, String sFullName, String sOptions) throws WsAppServerFailException, GenericError {
        this.writeFile(sData, sFullName, sOptions, this.getLineLength());
    }

    public void writeFile(String sData, String sFileName, String sDirectoryName, String sOptions, int length) throws WsAppServerFailException, GenericError {
        this.openFileService();
        String sFullName = this.m_svcFile.FullName(sFileName, sDirectoryName);
        this.writeFile(sData, sFullName, sOptions, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String sData, String sFullName, String sOptions, int length) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            Workspace.getDefaultLogger().debug("Saving remote file " + this.m_svcWorkspace.Name() + ":" + sFullName);
            IFileref fileRef = this.m_svcFile.AssignFileref(TEMP_FILE_REF, "DISK", sFullName, sOptions, new StringHolder("test"));
            ITextStream textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, length);
            try {
                textStream.Write(sData);
            }
            finally {
                try {
                    textStream.Close();
                }
                catch (GenericError genericError) {}
            }
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFile(byte[] baData, String sFullName, String sOptions) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            Workspace.getDefaultLogger().debug("Writing remote file " + this.m_svcWorkspace.Name() + ":" + sFullName);
            IFileref fileRef = this.m_svcFile.AssignFileref(TEMP_FILE_REF, "DISK", sFullName, sOptions, new StringHolder("test"));
            IBinaryStream stream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
            try {
                if (baData.length > 32768) {
                    int iData;
                    byte[] baBuffer = new byte[32768];
                    for (iData = 0; iData < baData.length - 32768; iData += 32768) {
                        System.arraycopy(baData, iData, baBuffer, 0, 32768);
                        stream.Write(baBuffer);
                    }
                    baBuffer = new byte[baData.length - iData];
                    System.arraycopy(baData, iData, baBuffer, 0, baData.length - iData);
                    stream.Write(baBuffer);
                } else {
                    stream.Write(baData);
                }
            }
            finally {
                try {
                    stream.Close();
                }
                catch (GenericError genericError) {}
            }
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileExists(String sFileName) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            IFileref fileRef = this.m_svcFile.AssignFileref(TEMP_FILE_REF, "DISK", sFileName, "", new StringHolder("test"));
            ITextStream textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, this.getLineLength());
            try {
                textStream.Close();
            }
            catch (GenericError genericError) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMacroVariableValue(String macroName) throws SQLException, WsAppServerFailException {
        this.openSQLConnection();
        String query = "SELECT value FROM SASHELP.VMACRO WHERE upcase(name) = '" + macroName.toUpperCase() + "'";
        Statement stmt = this.m_sqlConnection.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery(query);
        String value = null;
        try {
            if (rs.next()) {
                java.lang.Object o = rs.getObject(1);
                if (o != null) {
                    value = rs.getString(1);
                }
                if (value != null) {
                    value = value.trim();
                }
            }
        }
        finally {
            rs.close();
            stmt.close();
        }
        return value;
    }

    public boolean doesFileExist(String sFileName) throws WsAppServerFailException, GenericError {
        return this.doesFileExist(sFileName, FILE_ACCESS_METHOD_DEFAULT, "", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesFileExist(String sFileName, String accessMethod, String options, String preCode) throws WsAppServerFailException, GenericError {
        this.openFileService();
        try {
            IFileref fileRef;
            IFileInfo fileInfo;
            if (preCode != null && preCode.length() > 0) {
                this.openSASCodeSession();
                this.submitSASCode(preCode);
            }
            if ((fileInfo = IFileInfoHelper.narrow((Object)(fileRef = this.m_svcFile.AssignFileref(TEMP_FILE_REF, accessMethod, sFileName, options, new StringHolder("test"))))).StatusValue() == 0) {
                boolean bl = true;
                return bl;
            }
            if (fileInfo.StatusValue() == 6) {
                boolean bl = false;
                return bl;
            }
            throw new WsAppServerFailException(bundle.formatString("WsAppServer.Error.CannotAccessRemoteFile.fmt.txt", sFileName));
        }
        catch (WsAppServerCodeException e) {
            throw new WsAppServerFailException(e.getLocalizedMessage());
        }
        finally {
            try {
                this.m_svcFile.DeassignFileref(TEMP_FILE_REF);
            }
            catch (GenericError genericError) {}
        }
    }

    public boolean doesTableExist(String libref, String tableName, boolean caseSensitive) throws WsAppServerFailException, SQLException {
        this.openSQLConnection();
        String query = "SELECT COUNT(memname) FROM SASHELP.VTABLE WHERE memname='" + (caseSensitive ? tableName : tableName.toUpperCase()) + "' and libname='" + libref.toUpperCase() + "'";
        Statement stmt = this.m_sqlConnection.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery(query);
        int count = -1;
        if (rs.next()) {
            java.lang.Object o = rs.getObject(1);
            if (o != null) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        return count > 0;
    }

    public void deleteTable(String tableName, String passwordOption, boolean caseSensitive) throws WsAppServerFailException, SQLException, MdException, RemoteException, WsAppServerCodeException {
        String dsName;
        StringBuffer code = new StringBuffer();
        String lib = DBMSNamesUtil.getLibrefPart(tableName);
        if (lib.length() <= 0) {
            lib = "WORK";
        }
        if (this.doesTableExist(lib, dsName = DBMSNamesUtil.getTableNamePart(tableName), caseSensitive)) {
            if (caseSensitive) {
                dsName = DBMSNamesUtil.getQuotedString(dsName);
            }
            code.append("proc datasets lib = ").append(lib).append(" nolist nowarn memtype = (data view);\n").append("delete ").append(dsName).append(passwordOption != null && passwordOption.length() > 0 ? "(" + passwordOption + ")" : "").append(";\n").append("quit;\n\n");
            this.submitSASCode(code.toString());
        }
    }

    public List listFiles(String sDirectoryName) throws WsAppServerFailException, GenericError {
        ArrayList<String> files = new ArrayList<String>();
        this.openFileService();
        boolean[] fieldMask = new boolean[]{true, false, false, false, false, false};
        StringHolder listedPath = new StringHolder();
        StringSeqHolder existingFiles = new StringSeqHolder();
        try {
            this.m_svcFile.ListFiles(sDirectoryName, ListFilesMode.ListFilesModePath, fieldMask, listedPath, existingFiles, new StringSeqHolder(), new TypeCategorySeqHolder(), new LongSeqHolder(), new DateTimeSeqHolder(), new StringSeqHolder());
        }
        catch (InvalidFieldMask e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
        }
        for (int fileIndex = 0; fileIndex < existingFiles.value.length; ++fileIndex) {
            files.add(existingFiles.value[fileIndex]);
        }
        return files;
    }

    private int getLineLength() throws WsAppServerFailException {
        String sOS = this.getOperatingSystem();
        if (sOS.equals(OPERATING_SYSTEM_MVS)) {
            return 0;
        }
        return Short.MAX_VALUE;
    }

    public void deleteFile(Directory oDirectory, File oFile) throws GenericError, WsAppServerFailException {
        this.openFileService();
        try {
            this.deleteFile(this.m_svcFile.FullName(oFile.getFileName(), oDirectory.getDirectoryName()));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void deleteFile(String sFullName) throws GenericError, WsAppServerFailException {
        this.openFileService();
        this.m_svcFile.DeleteFile(sFullName);
    }

    public String promptForFilename(String title, String filename, HashMap fileTypes) throws GenericError, WsAppServerFailException {
        List lFiles = this.promptForFilenamesAndDirectories(title, filename, fileTypes, false, false);
        if (lFiles != null && lFiles.size() > 0) {
            return (String)lFiles.get(0);
        }
        return null;
    }

    public List promptForFilenames(String title, String filename, HashMap fileTypes) throws GenericError, WsAppServerFailException {
        List lFiles = this.promptForFilenamesAndDirectories(title, filename, fileTypes, false, true);
        if (lFiles != null && lFiles.size() > 0) {
            return lFiles;
        }
        return null;
    }

    public String promptForDirectory(String title, String filename, HashMap fileTypes) throws GenericError, WsAppServerFailException {
        return this.promptForDirectory(title, filename, fileTypes, true);
    }

    public String promptForDirectory(String title, String filename, HashMap fileTypes, boolean bAllowNonExistentSelections) throws GenericError, WsAppServerFailException {
        List lFiles = this.promptForFilenamesAndDirectories(title, filename, fileTypes, true, false, bAllowNonExistentSelections);
        if (lFiles != null && lFiles.size() > 0) {
            return (String)lFiles.get(0);
        }
        return null;
    }

    public List promptForDirectories(String title, String filename, HashMap fileTypes) throws GenericError, WsAppServerFailException {
        List lFiles = this.promptForFilenamesAndDirectories(title, filename, fileTypes, true, true);
        return lFiles;
    }

    private List promptForFilenamesAndDirectories(String title, String filename, HashMap fileTypes, boolean pickDirectoryOnly, boolean bMultipleSelectionAllowed) throws GenericError, WsAppServerFailException {
        return this.promptForFilenamesAndDirectories(title, filename, fileTypes, pickDirectoryOnly, bMultipleSelectionAllowed, true);
    }

    private List promptForFilenamesAndDirectories(String title, String filename, HashMap fileTypes, boolean pickDirectoryOnly, boolean bMultipleSelectionAllowed, boolean bAllowNonExistentSelections) throws GenericError, WsAppServerFailException {
        List lFiles;
        if (!this.isFileBrowseEnabled()) {
            return null;
        }
        this.openFileService();
        StringHolder fileNameHolder = new StringHolder();
        StringHolder directoryNameHolder = new StringHolder();
        if (filename != null && filename.length() > 0) {
            this.m_svcFile.SplitName(filename, fileNameHolder, directoryNameHolder);
        }
        String directory = directoryNameHolder.value != null ? directoryNameHolder.value : "";
        IFileServiceSelectorPanel pnlSelector = new IFileServiceSelectorPanel(directory, this.m_svcWorkspace, (Map)fileTypes, pickDirectoryOnly);
        pnlSelector.setMultiSelectionEnabled(bMultipleSelectionAllowed);
        pnlSelector.setInitialFilterTypeIndex(0);
        if (directory.length() == 0) {
            String sFileNavigationValue = WsMetadataUtil.getFileNavigationValue(this);
            if (sFileNavigationValue.equals("$")) {
                ((BaseIFileServiceModel)pnlSelector.getModel()).setLocation(10);
            } else if (sFileNavigationValue.equals(".")) {
                ((BaseIFileServiceModel)pnlSelector.getModel()).setLocation(11);
            } else {
                ((BaseIFileServiceModel)pnlSelector.getModel()).setLocation(sFileNavigationValue);
            }
        }
        if ((lFiles = IFileServiceSelectorPanel.showDialog((Frame)Workspace.getWorkspace(), (String)title, (boolean)true, (int)2, (String)directory, (IWorkspace)this.m_svcWorkspace, (boolean)true, (boolean)pickDirectoryOnly, (IFileServiceSelectorPanel)pnlSelector, (boolean)bAllowNonExistentSelections)) != null && lFiles.size() > 0) {
            return lFiles;
        }
        return null;
    }

    public List promptForFilenamesWithDirectories(String title, String dir, HashMap fileTypes, boolean pickDirectoryOnly, boolean bMultipleSelectionAllowed, boolean bAllowNonExistentSelections, String initialFileName) throws GenericError, WsAppServerFailException {
        if (!this.isFileBrowseEnabled()) {
            return null;
        }
        this.openFileService();
        StringHolder fileNameHolder = new StringHolder();
        StringHolder directoryNameHolder = new StringHolder();
        IFileServiceSelectorPanel pnlSelector = new IFileServiceSelectorPanel(dir, this.m_svcWorkspace, (Map)fileTypes, pickDirectoryOnly);
        pnlSelector.setMultiSelectionEnabled(bMultipleSelectionAllowed);
        pnlSelector.setInitialFilterTypeIndex(0);
        String[] strArray = new String[]{initialFileName};
        pnlSelector.setFileSelections(strArray);
        List lFiles = IFileServiceSelectorPanel.showDialog((Frame)Workspace.getWorkspace(), (String)title, (boolean)true, (int)2, (String)dir, (IWorkspace)this.m_svcWorkspace, (boolean)true, (boolean)pickDirectoryOnly, (IFileServiceSelectorPanel)pnlSelector, (boolean)bAllowNonExistentSelections);
        if (lFiles != null && lFiles.size() > 0) {
            return lFiles;
        }
        return null;
    }

    public String[] getSplitFileName(String fullFilePath) throws GenericError, WsAppServerFailException {
        this.openFileService();
        StringHolder fileNameHolder = new StringHolder();
        StringHolder directoryNameHolder = new StringHolder();
        if (fullFilePath != null && fullFilePath.length() > 0) {
            this.m_svcFile.SplitName(fullFilePath, fileNameHolder, directoryNameHolder);
        }
        String directory = directoryNameHolder.value != null ? directoryNameHolder.value : "";
        String filename = fileNameHolder.value != null ? fileNameHolder.value : "";
        return new String[]{directory, filename};
    }

    public String getLibraryPath(String libref) throws WsAppServerFailException {
        this.openDataService();
        boolean[] fieldInclusionMask = new boolean[]{};
        StringSeqHolder engineName = new StringSeqHolder();
        VariableArray2dOfLongHolder engineAttrs = new VariableArray2dOfLongHolder();
        LongSeqHolder libraryAttrs = new LongSeqHolder();
        StringSeqHolder physicalName = new StringSeqHolder();
        VariableArray2dOfStringHolder infoPropertyNames = new VariableArray2dOfStringHolder();
        VariableArray2dOfStringHolder infoPropertyValues = new VariableArray2dOfStringHolder();
        try {
            this.m_svcData.UseLibref(libref).LevelInfo(fieldInclusionMask, engineName, engineAttrs, libraryAttrs, physicalName, infoPropertyNames, infoPropertyValues);
        }
        catch (Exception e) {
            return "";
        }
        String libraryPath = physicalName.value.length > 0 ? physicalName.value[0] : "";
        return libraryPath;
    }

    public String getParentDirectory(String filename) throws GenericError, WsAppServerFailException {
        this.openFileService();
        StringHolder fileNameHolder = new StringHolder();
        StringHolder directoryNameHolder = new StringHolder();
        if (filename != null && filename.length() > 0) {
            this.m_svcFile.SplitName(filename, fileNameHolder, directoryNameHolder);
        }
        return directoryNameHolder.value != null ? directoryNameHolder.value : "";
    }

    public void openFormatService() throws WsAppServerFailException {
        this.open();
        try {
            if (this.m_svcFormat == null) {
                this.m_svcFormat = this.m_svcWorkspace.Utilities().FormatService();
            }
        }
        catch (SystemException se) {
            throw new WsAppServerFailException(this.getExceptionMessage((Exception)((java.lang.Object)se)));
        }
    }

    public IFormatService getFormatService() throws WsAppServerFailException {
        this.openFormatService();
        return this.m_svcFormat;
    }

    public void closeFormatService() {
        if (this.m_svcFormat != null) {
            this.m_svcFormat._release();
            this.m_svcFormat = null;
        }
    }

    public byte[] convertToBinaryUsingServerEncoding(String sText) throws GenericError, WsAppServerFailException, UnsupportedEncodingException {
        return sText.getBytes(this.getEncoding());
    }

    private String getExceptionMessage(Exception ex) {
        if (ex instanceof ConnectionFactoryException) {
            Throwable exRoot = ((ConnectionFactoryException)((java.lang.Object)ex)).getRootException();
            if (exRoot instanceof UnknownHostException) {
                return bundle.getString("WsAppServer.Error.UnknownHost.txt");
            }
            if (exRoot instanceof ConnectException) {
                return bundle.getString("WsAppServer.Error.ConnectionFailed.txt");
            }
            if (ex instanceof LoginException) {
                return bundle.getString("WsAppServer.Error.LogonFailed.txt");
            }
            if (exRoot instanceof IllegalArgumentException) {
                return bundle.getString("WsAppServer.Error.IllegalPort.txt");
            }
            if (exRoot instanceof ConnectionFactoryException) {
                return bundle.getString("WsAppServer.Error.InvalidServerDefinition.txt");
            }
            return ex.getLocalizedMessage();
        }
        return ex.getLocalizedMessage();
    }

    public static void showDefaultAppServerPrompt() {
        cDefaultAppServerPromptRunnable run = new cDefaultAppServerPromptRunnable();
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((java.lang.Object)"", ex);
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((java.lang.Object)"", ex);
            }
        }
    }

    public String getPathToFile(String libref, String filename) throws WsAppServerFailException {
        String strLibraryPath = this.getLibraryPath(libref);
        StringBuffer sbFilePath = new StringBuffer(strLibraryPath);
        sbFilePath.append("/");
        sbFilePath.append(filename);
        return sbFilePath.toString();
    }

    public String getEncoding() throws GenericError, WsAppServerFailException {
        String sSASEncodeing = this.getSASEncoding();
        String sEncoding = (String)s_mapEncodings.get(sSASEncodeing = sSASEncodeing.toLowerCase());
        return sEncoding != null ? sEncoding : "UTF8";
    }

    public String getSASEncoding() throws GenericError, WsAppServerFailException {
        String[] options = new String[]{"ENCODING"};
        DataTypeSeqHolder types = new DataTypeSeqHolder();
        BooleanSeqHolder isPortable = new BooleanSeqHolder();
        BooleanSeqHolder isStartupOnly = new BooleanSeqHolder();
        StringSeqHolder values = new StringSeqHolder();
        LongSeqHolder errorIndices = new LongSeqHolder();
        GetErrorSeqHolder errorTypes = new GetErrorSeqHolder();
        StringSeqHolder errorMessages = new StringSeqHolder();
        IOptionService optionService = this.m_svcWorkspace.Utilities().OptionService();
        optionService.GetOptions(options, types, isPortable, isStartupOnly, values, errorIndices, errorTypes, errorMessages);
        if (errorIndices.value.length > 0) {
            throw new WsAppServerFailException(errorMessages.value[0]);
        }
        return values.value[0];
    }

    public static byte[] findDataWidths(String str, String encoding) throws UnsupportedEncodingException {
        int length = str.length();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)str.substring(i, i + 1).getBytes(encoding).length;
        }
        return result;
    }

    public synchronized void addWsAppServerEventListener(WsAppServerEventListener listener) {
        if (!this.m_lListeners.contains(listener)) {
            this.m_lListeners.add(listener);
        }
    }

    public synchronized void removeWsAppServerEventListener(WsAppServerEventListener listener) {
        if (this.m_lListeners.contains(listener)) {
            this.m_lListeners.remove(listener);
        }
    }

    public void fireWsAppServerEvent(int iEventId, LogListHolder listHolder) {
        this.fireWsAppServerEvent(iEventId, listHolder, null);
    }

    public void fireWsAppServerEvent(int iEventId, LogListHolder listHolder, java.lang.Object additionalInfo) {
        WsAppServerEvent evt = new WsAppServerEvent(this, iEventId, listHolder, additionalInfo);
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            WsAppServerEventListener listener = (WsAppServerEventListener)this.m_lListeners.get(iListener);
            listener.eventHappened(evt);
        }
    }

    static {
        s_mapEncodings.put("aarabic", "MacArabic");
        s_mapEncodings.put("agreek", "MacGreek");
        s_mapEncodings.put("ahebrew", "MacHebrew");
        s_mapEncodings.put("aiceland", "MacIceland");
        s_mapEncodings.put("arabic", "ISO8859_6");
        s_mapEncodings.put("aroman", "MacRoman");
        s_mapEncodings.put("athai", "MacThai");
        s_mapEncodings.put("aturkish", "MacTurkish");
        s_mapEncodings.put("aukrainian", "MacUkraine");
        s_mapEncodings.put("big5", "Big5-HKSCS");
        s_mapEncodings.put("cyrillic", "ISO8859_5");
        s_mapEncodings.put("dec-cn", "GBK");
        s_mapEncodings.put("dec-jp", "EUC_JP");
        s_mapEncodings.put("dec-tw", "Cp964");
        s_mapEncodings.put("ebcdic037", "Cp037");
        s_mapEncodings.put("ebcdic1025", "Cp1025");
        s_mapEncodings.put("ebcdic1026", "Cp1026");
        s_mapEncodings.put("ebcdic1047", "Cp1047");
        s_mapEncodings.put("ebcdic1112", "Cp1112");
        s_mapEncodings.put("ebcdic1122", "Cp1122");
        s_mapEncodings.put("ebcdic1140", "Cp1140");
        s_mapEncodings.put("ebcdic1141", "Cp1141");
        s_mapEncodings.put("ebcdic1142", "Cp1142");
        s_mapEncodings.put("ebcdic1143", "Cp1143");
        s_mapEncodings.put("ebcdic1144", "Cp1144");
        s_mapEncodings.put("ebcdic1145", "Cp1145");
        s_mapEncodings.put("ebcdic1146", "Cp1146");
        s_mapEncodings.put("ebcdic1147", "Cp1147");
        s_mapEncodings.put("ebcdic1148", "Cp1148");
        s_mapEncodings.put("ebcdic420", "Cp420");
        s_mapEncodings.put("ebcdic424", "Cp424");
        s_mapEncodings.put("ebcdic838", "Cp838");
        s_mapEncodings.put("ebcdic870", "Cp870");
        s_mapEncodings.put("ebcdic875", "Cp875");
        s_mapEncodings.put("ebcdic924", "Cp924");
        s_mapEncodings.put("euc-cn", "GBK");
        s_mapEncodings.put("euc-jp", "EUC_JP");
        s_mapEncodings.put("euc-kr", "EUC_KR");
        s_mapEncodings.put("euc-tw", "Cp964");
        s_mapEncodings.put("greek", "ISO8859_7");
        s_mapEncodings.put("hebrew", "ISO8859_8");
        s_mapEncodings.put("ibm-1381", "Cp1381");
        s_mapEncodings.put("ibm-930", "Cp930");
        s_mapEncodings.put("ibm-933", "Cp933");
        s_mapEncodings.put("ibm-935", "Cp935");
        s_mapEncodings.put("ibm-937", "Cp937");
        s_mapEncodings.put("ibm-939", "Cp939");
        s_mapEncodings.put("ibm-942", "Cp942");
        s_mapEncodings.put("ibm-949", "Cp949");
        s_mapEncodings.put("latin1", "ISO8859_1");
        s_mapEncodings.put("latin2", "ISO8859_2");
        s_mapEncodings.put("latin5", "ISO8859_9");
        s_mapEncodings.put("latin6", "ISO8859_10");
        s_mapEncodings.put("latin9", "ISO8859_15");
        s_mapEncodings.put("macos-1", "SJIS");
        s_mapEncodings.put("macos-2", "Big5-HKSCS");
        s_mapEncodings.put("macos-3", "EUC-KR");
        s_mapEncodings.put("ms-932", "SJIS");
        s_mapEncodings.put("ms-936", "GBK");
        s_mapEncodings.put("ms-949", "EUC_KR");
        s_mapEncodings.put("ms-950", "Big5-HKSCS");
        s_mapEncodings.put("msdos737", "Cp737");
        s_mapEncodings.put("msdos775", "Cp775");
        s_mapEncodings.put("open_ed-037", "Cp037");
        s_mapEncodings.put("open_ed-1025", "Cp1025");
        s_mapEncodings.put("open_ed-1026", "Cp1026");
        s_mapEncodings.put("open_ed-1047", "Cp1047");
        s_mapEncodings.put("open_ed-1112", "Cp1112");
        s_mapEncodings.put("open_ed-1122", "Cp1122");
        s_mapEncodings.put("open_ed-1140", "Cp1140");
        s_mapEncodings.put("open_ed-1141", "Cp1141");
        s_mapEncodings.put("open_ed-1142", "Cp1142");
        s_mapEncodings.put("open_ed-1143", "Cp1143");
        s_mapEncodings.put("open_ed-1144", "Cp1144");
        s_mapEncodings.put("open_ed-1145", "Cp1145");
        s_mapEncodings.put("open_ed-1146", "Cp1146");
        s_mapEncodings.put("open_ed-1147", "Cp1147");
        s_mapEncodings.put("open_ed-1148", "Cp1148");
        s_mapEncodings.put("open_ed-275", "Cp275");
        s_mapEncodings.put("open_ed-420", "Cp420");
        s_mapEncodings.put("open_ed-424", "Cp424");
        s_mapEncodings.put("open_ed-838", "Cp838");
        s_mapEncodings.put("open_ed-870", "Cp870");
        s_mapEncodings.put("open_ed-875", "Cp875");
        s_mapEncodings.put("pcoem437", "Cp437");
        s_mapEncodings.put("pcoem850", "Cp850");
        s_mapEncodings.put("pcoem852", "Cp852");
        s_mapEncodings.put("pcoem857", "Cp857");
        s_mapEncodings.put("pcoem858", "Cp858");
        s_mapEncodings.put("pcoem860", "Cp860");
        s_mapEncodings.put("pcoem862", "Cp862");
        s_mapEncodings.put("pcoem863", "Cp863");
        s_mapEncodings.put("pcoem864", "Cp864");
        s_mapEncodings.put("pcoem865", "Cp865");
        s_mapEncodings.put("pcoem866", "Cp866");
        s_mapEncodings.put("pcoem869", "Cp869");
        s_mapEncodings.put("pcoem874", "Cp874");
        s_mapEncodings.put("pcoem921", "Cp921");
        s_mapEncodings.put("pcoem922", "Cp922");
        s_mapEncodings.put("shift-jis", "SJIS");
        s_mapEncodings.put("thai", "TIS620");
        s_mapEncodings.put("utf-8", "UTF8");
        s_mapEncodings.put("warabic", "Cp1256");
        s_mapEncodings.put("wbaltic", "Cp1257");
        s_mapEncodings.put("wcyrillic", "Cp1251");
        s_mapEncodings.put("wgreek", "Cp1253");
        s_mapEncodings.put("whebrew", "Cp1255");
        s_mapEncodings.put("wlatin1", "Cp1252");
        s_mapEncodings.put("wlatin2", "Cp1250");
        s_mapEncodings.put("wturkish", "Cp1254");
        s_mapEncodings.put("wvietnamese", "Cp1258");
        FILE_ACCESS_METHOD_HADOOP = PRODUCT_NAME_HADOOPSERVER;
        FILE_ACCESS_METHOD_DEFAULT = "DISK";
        FILE_ACCESS_METHOD_FTP = "ftp";
        FILE_ACCESS_METHOD_URL = "url";
        LINE_CHUNK_SIZE = 100;
        TEMP_FILE_REF = "TempRef";
    }

    private class cLanguageEventsListener
    extends _ILanguageEvents_1_1ImplBase {
        private cLanguageEventsListener() {
        }

        public void ProcStart(String sProc) {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": Proc started: " + sProc);
        }

        public void SubmitComplete(int sasrc) {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": Submit completed");
        }

        public void ProcComplete(String sProc) {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": Proc completed: " + sProc);
        }

        public void DatastepStart() {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": DataStep started");
        }

        public void DatastepComplete() {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": DataStep completed");
        }

        public void StepError() {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": step error");
            WsAppServer.this.m_bErrorInCode = true;
        }

        public void GlobalstmtError(String sStmt) {
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": global statement error");
            WsAppServer.this.m_bErrorInCode = true;
        }

        public void GlobalstmtComplete(String sStmt) {
            if (sStmt.contains(WsAppServer.BLOCK_START_ID)) {
                Workspace.getDefaultLogger().debug(sStmt);
                LogListHolder logHolder = null;
                try {
                    if (WsAppServer.this.isFlushLogLinesPerStep()) {
                        logHolder = WsAppServer.this.getLog();
                        WsAppServer.this.fireWsAppServerEvent(1, logHolder);
                    }
                }
                catch (WsAppServerFailException e) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"WsAppServerFailException", e);
                }
                WsAppServer.this.fireWsAppServerEvent(3, logHolder, sStmt.replaceAll("\"", ""));
            } else if (sStmt.contains(WsAppServer.BLOCK_END_ID)) {
                Workspace.getDefaultLogger().debug(sStmt);
                LogListHolder logHolder = null;
                try {
                    if (WsAppServer.this.isFlushLogLinesPerStep()) {
                        logHolder = WsAppServer.this.getLog();
                        WsAppServer.this.fireWsAppServerEvent(1, logHolder);
                    }
                }
                catch (WsAppServerFailException e) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"WsAppServerFailException", e);
                }
                WsAppServer.this.fireWsAppServerEvent(4, logHolder, sStmt.replaceAll("\"", ""));
            } else if (sStmt.contains(WsAppServer.SUBMIT_COMPLETE)) {
                Workspace.getDefaultLogger().debug(sStmt);
                try {
                    WsAppServer.this.fireWsAppServerEvent(5, WsAppServer.this.getLog(), sStmt.replaceAll("\"", ""));
                }
                catch (WsAppServerFailException e) {
                    Workspace.getDefaultLogger().error((java.lang.Object)"WsAppServerFailException", e);
                }
            }
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": global statement complete");
        }
    }

    private class cLanguageLogEventListener
    extends _ILanguageLogEventImplBase {
        private cLanguageLogEventListener() {
        }

        public void StepLogLines(CarriageControl[] ccs, LineType[] ltaLineTypes, String[] saLines) {
            CarriageControlSeqHolder logCCHolder = new CarriageControlSeqHolder(ccs);
            LineTypeSeqHolder logTypeHolder = new LineTypeSeqHolder(ltaLineTypes);
            StringSeqHolder logLinesHolder = new StringSeqHolder(saLines);
            LogListHolder logHolder = new LogListHolder(logLinesHolder, logCCHolder, logTypeHolder);
            WsAppServer.this.fireWsAppServerEvent(1, logHolder);
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": step Log lines");
        }

        public void AbortLogLines(CarriageControl[] ccs, LineType[] ltaLineTypes, String[] saLines) {
            CarriageControlSeqHolder logCCHolder = new CarriageControlSeqHolder(ccs);
            LineTypeSeqHolder logTypeHolder = new LineTypeSeqHolder(ltaLineTypes);
            StringSeqHolder logLinesHolder = new StringSeqHolder(saLines);
            LogListHolder logHolder = new LogListHolder(logLinesHolder, logCCHolder, logTypeHolder);
            WsAppServer.this.m_abortLog = logHolder;
            WsAppServer.this.fireWsAppServerEvent(1, logHolder);
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": Abort Log lines");
        }

        public void StepListLines(CarriageControl[] ccs, LineType[] ltaLineTypes, String[] saLines) {
            CarriageControlSeqHolder outCCHolder = new CarriageControlSeqHolder(ccs);
            LineTypeSeqHolder outTypeHolder = new LineTypeSeqHolder(ltaLineTypes);
            StringSeqHolder outLinesHolder = new StringSeqHolder(saLines);
            LogListHolder outHolder = new LogListHolder(outLinesHolder, outCCHolder, outTypeHolder);
            WsAppServer.this.fireWsAppServerEvent(2, outHolder);
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": step List lines");
        }

        public void AbortListLines(CarriageControl[] ccs, LineType[] ltaLineTypes, String[] saLines) {
            CarriageControlSeqHolder outCCHolder = new CarriageControlSeqHolder(ccs);
            LineTypeSeqHolder outTypeHolder = new LineTypeSeqHolder(ltaLineTypes);
            StringSeqHolder outLinesHolder = new StringSeqHolder(saLines);
            LogListHolder outHolder = new LogListHolder(outLinesHolder, outCCHolder, outTypeHolder);
            WsAppServer.this.m_abortList = outHolder;
            WsAppServer.this.fireWsAppServerEvent(2, outHolder);
            Workspace.getDefaultLogger().debug("AppServer:" + WsAppServer.this.m_sName + ": Abort List lines");
        }
    }

    private static class cDefaultAppServerPromptRunnable
    implements Runnable {
        private cDefaultAppServerPromptRunnable() {
        }

        @Override
        public void run() {
            WsAppServerPanel pnl = new WsAppServerPanel(bundle.getString("WsAppServer.AppServerDialog.Description.txt"));
            pnl.setUpdateDefault(true);
            WAStandardDialog dlg = new WAStandardDialog(Workspace.getWorkspace(), bundle.getString("WsAppServer.AppServerDialog.Title.txt"), true);
            dlg.setMainPanel(pnl);
            dlg.show();
        }
    }
}

