/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;

public abstract class WsAbstractProgressDialog
extends JDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsAbstractProgressDialog.class);
    public static final int DEFAULT_DELAY = 250;
    protected JProgressBar m_barProgress;
    protected JLabel m_lblText;
    protected Dimension m_dimText;
    protected Timer m_timerProgress;
    private JButton m_btnCancel;
    private AbstractAction m_actCancel;

    public WsAbstractProgressDialog(String sTitle, String sText) {
        this((Frame)Workspace.getWorkspace(), sTitle, sText);
    }

    public WsAbstractProgressDialog(Frame frmOwner, String sTitle, String sText) {
        super(frmOwner, sTitle, true);
        this.initialize(sText);
        this.layoutWidgets();
    }

    public WsAbstractProgressDialog(Dialog dlgOwner, String sTitle, String sText) {
        super(dlgOwner, sTitle, true);
        this.initialize(sText);
        this.layoutWidgets();
    }

    public void setDelay(int msDelay) {
        this.m_timerProgress.setDelay(msDelay);
    }

    public int getDelay() {
        return this.m_timerProgress.getDelay();
    }

    @Override
    public void setModal(boolean bModal) {
        throw new UnsupportedOperationException("Cannot change this dialog to modeless");
    }

    @Override
    public void show() {
        this.m_timerProgress.start();
        super.show();
    }

    public void setText(String sText) {
        this.m_lblText.setText(sText);
    }

    public String getText(String sText) {
        return this.m_lblText.getText();
    }

    public void setCancelEnabled(boolean bEnabled) {
        this.m_actCancel.setEnabled(bEnabled);
        this.m_btnCancel.setVisible(bEnabled);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isCancelEnabled() {
        return this.m_actCancel.isEnabled();
    }

    public void setTextPreferredSize(Dimension dimTextLabel) {
        this.m_lblText.setPreferredSize(dimTextLabel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public Dimension getTextPreferredSize() {
        return this.m_lblText.getPreferredSize();
    }

    protected abstract boolean isComplete();

    protected int getProgressValue() {
        return -1;
    }

    protected void initialize(String sText) {
        this.m_lblText = new JLabel(sText);
        this.m_barProgress = new JProgressBar();
        this.m_lblText.setPreferredSize(this.m_lblText.getPreferredSize());
        this.m_timerProgress = new Timer(250, this.createTimerListener());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (WsAbstractProgressDialog.this.isCancelEnabled()) {
                    WsAbstractProgressDialog.this.dispose();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.m_actCancel = new cCancelAction();
        this.m_btnCancel = new JButton(this.m_actCancel);
        this.setCancelEnabled(false);
        this.m_btnCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.m_btnCancel.getActionMap().put("Cancel", this.m_actCancel);
    }

    protected void layoutWidgets() {
        JPanel pnlContents = (JPanel)this.getContentPane();
        pnlContents.setLayout(new GridBagLayout());
        pnlContents.add((Component)this.m_lblText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        pnlContents.add((Component)this.m_barProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        pnlContents.add((Component)this.m_btnCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.pack();
        try {
            Object obj = UIManager.getDefaults().get("InternalFrame.titleFont");
            Font titleFont = (Font)obj;
            FontMetrics fm = this.getFontMetrics(titleFont);
            int titleWidth = fm.stringWidth(this.getTitle());
            int dialogWidth = titleWidth + 70;
            if (dialogWidth > this.getSize().width) {
                this.setSize(dialogWidth, this.getSize().height);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setLocationRelativeTo(this.getParent());
    }

    protected ActionListener createTimerListener() {
        return new cTimerListener();
    }

    protected class cCancelAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCancelAction() {
            this.putValue("Name", bundle.getString("Common.Cancel.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsAbstractProgressDialog.this.dispose();
        }
    }

    protected class cTimerListener
    implements ActionListener {
        protected cTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int value;
            if (WsAbstractProgressDialog.this.isComplete()) {
                WsAbstractProgressDialog.this.dispose();
                WsAbstractProgressDialog.this.m_timerProgress.stop();
            }
            if ((value = WsAbstractProgressDialog.this.getProgressValue()) != -1) {
                WsAbstractProgressDialog.this.m_barProgress.setValue(value);
            } else {
                value = WsAbstractProgressDialog.this.m_barProgress.getValue();
                if ((value += 5) > WsAbstractProgressDialog.this.m_barProgress.getMaximum()) {
                    value = 0;
                }
                WsAbstractProgressDialog.this.m_barProgress.setValue(value);
            }
        }
    }
}

