/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.WsNewView;
import java.rmi.RemoteException;
import javax.swing.Icon;

public abstract class WsAbstractNewOMAView
implements WsNewView {
    private String m_sID;
    private String m_sName;
    private MdObjectStore m_store;
    private Root m_mdoObject;
    private WAStandardInternalFrame m_frm;
    private MdObjectListener m_lsnrMetadata;

    protected WsAbstractNewOMAView(String sID, String sType, String sName) {
        this.m_sID = sID;
        this.m_sName = sName;
        this.m_lsnrMetadata = new MetadataListener();
        this.createMetadataObject(sID, sType, sName);
        this.m_frm = this.createFrame();
        this.m_frm.setMainPanel(this.createMainPanel());
        this.m_frm.setTitle(this.getFrameTitle());
        this.m_frm.setFrameIcon(this.getFrameIcon());
        this.m_frm.setDefaultsName(this.getDefaultsName());
        this.m_frm.useDefaultSize(true);
        this.m_frm.setView(this);
    }

    protected void createMetadataObject(String sID, String sType, String sName) {
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore(null, this.m_sName + ":" + this.getClass().getName());
            this.m_mdoObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, sName, sType, sID);
            this.m_mdoObject.addMdObjectListener(this.m_lsnrMetadata);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected abstract WAStandardInternalFrame createFrame();

    protected abstract WAPanel createMainPanel();

    protected abstract String getDefaultsName();

    protected abstract String getFrameTitle();

    protected abstract Icon getFrameIcon();

    @Override
    public WAInternalFrame getFrame() {
        return this.m_frm;
    }

    @Override
    public String getID() {
        return this.m_sID;
    }

    protected String getName() {
        return this.m_sName;
    }

    protected Root getObject() {
        return this.m_mdoObject;
    }

    @Override
    public void show() {
        WsLockManager.getInstance().addLock(this.m_sID);
        this.m_frm.show();
    }

    @Override
    public boolean save() {
        return false;
    }

    protected void refreshData() {
        try {
            this.m_sName = this.m_mdoObject.getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    @Override
    public void dispose() {
        WsLockManager.getInstance().removeLock(this.m_sID);
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WsAbstractNewOMAView dispose", ex);
            }
            this.m_store = null;
        }
        if (this.m_mdoObject != null) {
            this.m_mdoObject = null;
        }
        if (this.m_frm != null) {
            this.m_frm.setView(null);
            this.m_frm = null;
        }
    }

    private class MetadataListener
    implements MdObjectListener {
        private MetadataListener() {
        }

        public void MdObjectModified(MdEvent e) {
            WsAbstractNewOMAView.this.refreshData();
            WsAbstractNewOMAView.this.m_frm.setFrameIcon(WsAbstractNewOMAView.this.getFrameIcon());
            WsAbstractNewOMAView.this.m_frm.setTitle(WsAbstractNewOMAView.this.getFrameTitle());
        }
    }
}

