/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;

public abstract class WsAbstractBrowsableTextField
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WsAbstractBrowsableTextField.class);
    protected Object m_data;
    protected JButton m_btn;
    protected WATextField m_txt;

    public WsAbstractBrowsableTextField() {
        this((String)null);
    }

    public WsAbstractBrowsableTextField(String sText) {
        this(sText, null);
    }

    public WsAbstractBrowsableTextField(String sText, Object data) {
        this(sText, data, 30);
    }

    public WsAbstractBrowsableTextField(String sText, Object data, int len) {
        this.initialize(len);
        this.m_data = data;
        this.m_txt.setText(sText);
    }

    protected void initialize(int len) {
        this.m_txt = new WATextField(len);
        Border brdr = this.m_txt.getBorder();
        this.m_txt.setBorder(this.createTextFieldBorder());
        this.m_btn = new JButton(new cShowDialogAction());
        this.m_btn.setBorder(this.createBrowseButtonBorder());
        this.m_btn.setMargin(new Insets(2, 2, 8, 2));
        Dimension dim = this.m_btn.getPreferredSize();
        dim.height = this.m_txt.getPreferredSize().height;
        this.m_btn.setPreferredSize(dim);
        this.setBorder(brdr);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_txt, "Center");
        this.add((Component)this.m_btn, "East");
    }

    protected Border createBrowseButtonBorder() {
        BasicBorders.ButtonBorder brdrOuter = new BasicBorders.ButtonBorder(UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"), UIManager.getColor("ComboBox.buttonBackground"));
        BasicBorders.MarginBorder brdrInner = new BasicBorders.MarginBorder();
        return new CompoundBorder(brdrOuter, brdrInner);
    }

    protected Border createTextFieldBorder() {
        return new EmptyBorder(0, 0, 0, 0);
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        this.m_txt.setEnabled(bEnabled);
        this.m_btn.setEnabled(bEnabled && this.isEditable());
    }

    @Override
    public boolean isEnabled() {
        return this.m_txt.isEnabled();
    }

    public void setEditable(boolean bEditable) {
        this.m_txt.setEditable(bEditable);
        this.m_btn.setEnabled(bEditable && this.isEnabled());
    }

    public boolean isEditable() {
        return this.m_txt.isEditable();
    }

    public String getText() {
        return this.m_txt.getText();
    }

    public void setText(String sText) {
        this.m_txt.setText(sText);
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public WATextField getTextField() {
        return this.m_txt;
    }

    public JButton getBrowseButton() {
        return this.m_btn;
    }

    public int getBrowseButtonOffset() {
        return this.m_btn.getPreferredSize().width + this.getBorder().getBorderInsets((Component)this).right;
    }

    @Override
    public void requestFocus() {
        this.m_txt.requestFocus();
    }

    protected abstract void showDialog();

    protected class cShowDialogAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cShowDialogAction() {
            this.putValue("Name", bundle.getString("WsAbstractBrowsableTextField.Browse.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractBrowsableTextField.this.showDialog();
        }
    }
}

