/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.util.Util;
import com.sas.visuals.util.XMLMenuBar;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class WsAbstractAction
extends AbstractAction {
    public static final String MENU_SUPPORT_ID = "MenuSupportId";
    public static final String MNEMONIC_INDEX = "MnemonicIndex";
    public static final String ENABLED = "enabled";
    public static final int NO_ICON = 0;
    public static final int BLANK_ICON = 1;
    public static final int HAS_ICON = 2;
    public static final int HAS_TEXT = 0;
    public static final int NO_TEXT = 16;
    public static final int NEW_STYLE_MNEMONIC = 0;
    public static final int OLD_STYLE_MNEMONIC = 32;
    public static final int HAS_TOOLTIP = 0;
    public static final int NO_TOOLTIP = 256;
    public static final int NEW_STYLE_TOOLTIP = 0;
    public static final int OLD_STYLE_TOOLTIP = 512;
    private static final WAdminResource s_bundle = WAdminResource.getBundle(WsAbstractAction.class);
    public static final Icon BLANK_ACTION_ICON = s_bundle.getIcon("Common.EmptyIcon.image");
    protected boolean m_bActive;
    protected boolean m_bHidable;

    public WsAbstractAction() {
    }

    public WsAbstractAction(WAdminResource bundle, String sResourceKey, int fFlags) {
        if ((fFlags & 3) != 0) {
            Icon icon = (fFlags & 2) != 0 ? bundle.getImageIcon(sResourceKey + ".image") : BLANK_ACTION_ICON;
            this.putValue("SmallIcon", icon);
        }
        if ((fFlags & 0x10) == 0) {
            int cMnem;
            String sText = bundle.getString(sResourceKey + ".txt");
            int iMnem = -1;
            if ((fFlags & 0x20) == 0) {
                cMnem = Util.getDisplayedMnemonic((String)sText);
                iMnem = Util.getDisplayedMnemonicIndex((String)sText);
                sText = Util.getLabelWithoutMnemonic((String)sText);
            } else {
                cMnem = bundle.getString(sResourceKey + ".mnem").toUpperCase().charAt(0);
            }
            this.putValue("Name", sText);
            this.putValue("MnemonicKey", new Integer(cMnem));
            this.putValue(MNEMONIC_INDEX, new Integer(iMnem));
        }
        if ((fFlags & 0x100) == 0) {
            String sTipExtension = (fFlags & 0x200) == 0 ? ".tip" : ".ToolTip.txt";
            this.putValue("ShortDescription", bundle.getString(sResourceKey + sTipExtension));
        }
    }

    public WsAbstractAction(WAdminResource bundle, String sResourceKey) {
        this(bundle, sResourceKey, false);
    }

    public WsAbstractAction(WAdminResource bundle, String sResourceKey, boolean bLoadIcon) {
        this(bundle, sResourceKey, true, bLoadIcon);
    }

    public WsAbstractAction(WAdminResource bundle, String sResourceKey, boolean bHasIcon, boolean bLoadIcon) {
        this(bundle, sResourceKey + ".txt", sResourceKey + ".mnem", sResourceKey + ".ToolTip.txt", bHasIcon, bLoadIcon ? sResourceKey + ".image" : null);
    }

    public WsAbstractAction(WAdminResource bundle, String sNameKey, String sMnemonicKey, String sToolTipKey, String sIconKey) {
        this(bundle, sNameKey, sMnemonicKey, sToolTipKey, true, sIconKey);
    }

    public WsAbstractAction(WAdminResource bundle, String sNameKey, String sMnemonicKey, String sToolTipKey, boolean bHasIcon, String sIconKey) {
        String sName = bundle.getString(sNameKey);
        Integer mnem = new Integer(bundle.getString(sMnemonicKey).toUpperCase().charAt(0));
        String sToolTip = bundle.getString(sToolTipKey);
        Icon icon = !bHasIcon ? null : (sIconKey != null ? bundle.getImageIcon(sIconKey) : BLANK_ACTION_ICON);
        this.putValue("Name", sName);
        this.putValue("ShortDescription", sToolTip);
        this.putValue("MnemonicKey", mnem);
        this.putValue("SmallIcon", icon);
    }

    public void setActive(boolean bActive) {
        if (this.m_bActive != bActive) {
            this.m_bActive = bActive;
            String sMenuSupportId = this.getMenuSupportId();
            if (sMenuSupportId == null) {
                return;
            }
            WsAbstractApplicationActionsManager mgr = WsAbstractApplicationActionsManager.getInstance();
            if (mgr != null) {
                mgr.attachAction(sMenuSupportId, this, bActive);
                return;
            }
            WorkspaceMenuSupport wms = WorkspaceMenuSupport.getWorkspaceMenuSupport();
            if (wms == null) {
                return;
            }
            if (bActive) {
                wms.addActionListener(sMenuSupportId, this);
            } else {
                wms.removeActionListener(sMenuSupportId, this);
            }
            wms.setItemsState(sMenuSupportId, bActive && this.isEnabled());
            if (this.m_bHidable) {
                wms.setItemsVisible(sMenuSupportId, bActive);
            }
        }
    }

    public void setSelectedItemsState(boolean state) {
        String sMenuSupportId = this.getMenuSupportId();
        if (sMenuSupportId != null) {
            WorkspaceMenuSupport wms = WorkspaceMenuSupport.getWorkspaceMenuSupport();
            if (wms == null) {
                return;
            }
            XMLMenuBar bar = wms.getMenuBar();
            bar.setSelectedItemsState(sMenuSupportId, state);
        }
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void setHidable(boolean bHidable) {
        if (this.m_bHidable != bHidable) {
            this.m_bHidable = bHidable;
            String sMenuSupportId = this.getMenuSupportId();
            if (sMenuSupportId != null) {
                WorkspaceMenuSupport wms = WorkspaceMenuSupport.getWorkspaceMenuSupport();
                if (wms == null) {
                    return;
                }
                wms.setItemsVisible(sMenuSupportId, this.m_bActive);
            }
        }
    }

    public boolean isHidable() {
        return this.m_bHidable;
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setText(String sText) {
        this.putValue("Name", sText);
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    public void setToolTipText(String sToolTip) {
        super.putValue("ShortDescription", sToolTip);
    }

    public String getToolTipText() {
        return (String)super.getValue("ShortDescription");
    }

    public char getMnemonic() {
        Integer mnem = (Integer)super.getValue("MnemonicKey");
        return mnem != null ? (char)mnem.intValue() : (char)'\u0000';
    }

    public void setMnemonic(char cMnemonic) {
        Integer mnem = new Integer(Character.toUpperCase(cMnemonic));
        super.putValue("MnemonicKey", mnem);
    }

    public int getMnemonicIndex() {
        Integer mnemIndex = (Integer)super.getValue(MNEMONIC_INDEX);
        return mnemIndex != null ? mnemIndex : -1;
    }

    public void setMnemonicIndex(int iMnemonic) {
        Integer mnem = new Integer(iMnemonic);
        super.putValue(MNEMONIC_INDEX, mnem);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public void setMenuSupportId(String sMenuSupportId) {
        super.putValue(MENU_SUPPORT_ID, sMenuSupportId);
    }

    public String getMenuSupportId() {
        return (String)super.getValue(MENU_SUPPORT_ID);
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        String sMenuSupportId;
        boolean bOldEnabled = this.isEnabled();
        super.setEnabled(bEnabled);
        if (bOldEnabled != bEnabled && this.m_bActive && WsAbstractApplicationActionsManager.getInstance() == null && (sMenuSupportId = this.getMenuSupportId()) != null) {
            WorkspaceMenuSupport wms = WorkspaceMenuSupport.getWorkspaceMenuSupport();
            if (wms == null) {
                return;
            }
            wms.setItemsState(sMenuSupportId, bEnabled);
        }
    }
}

