/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginLoader;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.plugins.MetadataVisualsPluginInterface;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WAdminResource {
    protected static Hashtable m_bundleCache;
    protected static Hashtable m_ImageCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;
    protected static WAdminResource m_bundleMetadataTypeIcons;
    private static Map s_mapBundles;
    private Class resourceClass;

    public static WAdminResource getBundle(Class cls) {
        String sPackage = cls.getPackage().getName();
        WAdminResource bundle = (WAdminResource)s_mapBundles.get(sPackage);
        if (bundle == null) {
            bundle = new WAdminResource(cls);
            s_mapBundles.put(sPackage, bundle);
        }
        return bundle;
    }

    public static WAdminResource getBundle(String sPackage) {
        WAdminResource bundle = (WAdminResource)s_mapBundles.get(sPackage);
        if (bundle == null) {
            bundle = new WAdminResource(sPackage + ".PropertyBundle");
            s_mapBundles.put(sPackage, bundle);
        }
        return bundle;
    }

    public WAdminResource(String inputResourceFileName, ClassLoader classLoader) {
        this.m_classLoader = classLoader;
        this.m_strResourceFileName = inputResourceFileName;
    }

    public WAdminResource(String inputResourceFileName) {
        this.m_strResourceFileName = inputResourceFileName;
    }

    public WAdminResource(Class cls) {
        this(cls, "PropertyBundle");
    }

    public WAdminResource(Class cls, String strResourceFileName) {
        this.resourceClass = cls;
        String strClassName = cls.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_strResourceFileName = strPackageName + "." + strResourceFileName;
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.getDefault();
        try {
            this.m_classLoader = this.getClassLoader(this.resourceClass);
            returnValue = ResourceBundle.getBundle(strBundlePath, locale, this.m_classLoader);
        }
        catch (MissingResourceException ex) {
            this.m_bResourceFileMissing = true;
            Workspace.getDefaultLogger().error(strBundlePath + " not found!");
            return null;
        }
        this.cacheBundle(strBundlePath, returnValue);
        return returnValue;
    }

    private ClassLoader getClassLoader(Class cls) {
        if (this.m_classLoader == null) {
            this.m_classLoader = cls == null ? ClassLoader.getSystemClassLoader() : cls.getClassLoader();
        }
        return this.m_classLoader;
    }

    public String getString(String key) {
        if (this.m_bundle == null) {
            this.m_bundle = this._getBundle(this.m_strResourceFileName);
        }
        if (this.m_bundle == null) {
            Workspace.getDefaultLogger().error((Object)"Missing resouces file", new Throwable());
            return "Missing resources file";
        }
        if (this.m_bResourceFileMissing) {
            Workspace.getDefaultLogger().error((Object)"Missing resouces file", new Throwable());
            return "Missing resources file";
        }
        try {
            return this.m_bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            Workspace.getDefaultLogger().warn((Object)("Missing resource (" + key + ") is called from the following:"), new Throwable());
            return "Missing resource " + key;
        }
    }

    public String getRawString(String key) {
        if (this.m_bundle == null) {
            this.m_bundle = this._getBundle(this.m_strResourceFileName);
        }
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                return this.m_bundle.getString(key).trim();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        if (this.m_bundle == null) {
            this.m_bundle = this._getBundle(this.m_strResourceFileName);
        }
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (MissingResourceException ex) {
            return notFoundReturnValue;
        }
    }

    public static Icon getBlankIcon() {
        return m_bundleMetadataTypeIcons.getIcon("Common.EmptyIcon.image");
    }

    public Icon getIcon(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        return this.getImageImpl(this.getRawString(sResourceName));
    }

    public URL getIconURL(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        if (this.m_bundle == null) {
            this.m_bundle = this._getBundle(this.m_strResourceFileName);
        }
        String sImageLocation = this.m_bundle.getString("ImageLocation.notrans") + this.m_bundle.getString(sResourceName);
        this.m_classLoader = this.getClassLoader(this.resourceClass);
        return this.m_classLoader.getResource(sImageLocation);
    }

    public ImageIcon getImageIcon(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        return this.getImageImpl(this.getRawString(sResourceName));
    }

    public ImageIcon getImageIcon(String sResourceName, int size) {
        if (sResourceName == null) {
            return null;
        }
        return this.getImageImpl(this.getRawString(sResourceName), size);
    }

    public static ImageIcon getTypeIcon(CMetadata oMetadata) {
        return WAdminResource.getTypeIcon(oMetadata, true);
    }

    public static ImageIcon getTypeIcon(CMetadata oMetadata, boolean bReturnDefault) {
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        if (pluginLoader != null) {
            ArrayList alPlugins = pluginLoader.getPlugins("com.sas.workspace.plugins.MetadataVisualsPluginInterface");
            int nPlugins = alPlugins.size();
            for (int iPlugin = 0; iPlugin < nPlugins; ++iPlugin) {
                MetadataVisualsPluginInterface plugin = (MetadataVisualsPluginInterface)alPlugins.get(iPlugin);
                try {
                    ImageIcon icon = plugin.getIcon(oMetadata);
                    if (icon == null) continue;
                    return icon;
                }
                catch (NullPointerException ex) {
                    break;
                }
            }
        }
        try {
            return WAdminResource.getTypeIcon(oMetadata.getCMetadataType(), bReturnDefault);
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public static ImageIcon getTypeIcon(String sTypeName, boolean bReturnDefault) {
        String sImageName;
        if (m_bundleMetadataTypeIcons == null) {
            m_bundleMetadataTypeIcons = new WAdminResource(WAdminResource.class);
        }
        if ((sImageName = m_bundleMetadataTypeIcons.getRawString("Common.MetadataTypes." + sTypeName + ".image")) == null) {
            if (bReturnDefault) {
                sImageName = m_bundleMetadataTypeIcons.getRawString("Common.MetadataTypes.Default.image");
            } else {
                return null;
            }
        }
        return m_bundleMetadataTypeIcons.getImageImpl(sImageName);
    }

    public ImageIcon getTreeTypeIcon(String sTreeTypeName, boolean bReturnDefault) {
        return this.getTreeTypeIcon(sTreeTypeName, false, bReturnDefault);
    }

    public ImageIcon getTreeTypeIcon(String sTreeTypeName, boolean bExpanded, boolean bReturnDefault) {
        if (sTreeTypeName == null || sTreeTypeName.length() == 0) {
            sTreeTypeName = "Custom";
        }
        String sState = bExpanded ? "Open" : "";
        String sImageName = this.getRawString("Common.TreeType." + sState + sTreeTypeName + ".image");
        if (sImageName == null) {
            if (bReturnDefault) {
                sImageName = this.getRawString("Common.TreeType.Default.image");
            } else {
                return null;
            }
        }
        return this.getImageImpl(sImageName);
    }

    public static Icon getCMTypeIcon(CMetadata oMetadata, Icon icon, boolean bAddSpace) {
        Icon[] aIcons = new Icon[2];
        if (m_bundleMetadataTypeIcons == null) {
            m_bundleMetadataTypeIcons = new WAdminResource(WAdminResource.class);
        }
        if (oMetadata != null) {
            try {
                if (!(((Root)oMetadata).getChangeStateState() != 0 && ((Root)oMetadata).getLockedByState() != 0 || oMetadata.getCMetadataType().equals("Environment"))) {
                    try {
                        if (oMetadata != null) {
                            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oMetadata, null, null, null, 8);
                        }
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", e);
                    }
                }
                if (oMetadata.isCheckedOut() || oMetadata.isLocked()) {
                    aIcons[0] = m_bundleMetadataTypeIcons.getImageIcon("Common.CheckedOutCheck.image");
                    aIcons[1] = icon;
                    WsCompoundIcon iconCompound = new WsCompoundIcon(aIcons);
                    iconCompound.setIconGap(-8);
                    iconCompound.setReverseOrder(true);
                    return iconCompound;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        if (bAddSpace) {
            aIcons[0] = m_bundleMetadataTypeIcons.getImageIcon("Common.EmptyIcon.image");
            aIcons[1] = icon;
            WsCompoundIcon iconCompound = new WsCompoundIcon(aIcons);
            iconCompound.setIconGap(-8);
            iconCompound.setReverseOrder(true);
            return iconCompound;
        }
        return icon;
    }

    public static Icon getCMTypeIcon(CMetadata oMetadata, boolean bAddSpace) {
        Icon icon = WAdminResource.getTypeIcon(oMetadata);
        icon = WAdminResource.getCMTypeIcon(oMetadata, icon, bAddSpace);
        return icon;
    }

    protected ImageIcon getImageImpl(String sFileName) {
        ImageIcon image = null;
        String sImagePath = this.getRawString("ImageLocation.notrans") + sFileName;
        if (m_ImageCache == null) {
            m_ImageCache = new Hashtable();
        } else {
            image = (ImageIcon)m_ImageCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        this.m_classLoader = this.getClassLoader(this.resourceClass);
        try {
            URL url = this.m_classLoader.getResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().warn((Object)("Exception loading image: " + sImagePath), new Throwable());
            String sDefaultPath = "com/sas/workspace/res/DefaultImage.gif";
            try {
                URL urlDefault = this.m_classLoader.getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e2) {
                Workspace.getDefaultLogger().warn((Object)("Exception loading image: " + sDefaultPath), e2);
            }
        }
        if (image != null) {
            m_ImageCache.put(sImagePath, image);
        }
        return image;
    }

    protected ImageIcon getImageImpl(String sFileName, int size) {
        ImageIcon image = null;
        String sImagePath = this.getRawString("ImageLocation.notrans") + "GIF_" + size + "/" + sFileName;
        if (m_ImageCache == null) {
            m_ImageCache = new Hashtable();
        } else {
            image = (ImageIcon)m_ImageCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            this.m_classLoader = this.getClassLoader(this.resourceClass);
            URL url = this.m_classLoader.getResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            image = this.getImageImpl(sFileName);
        }
        if (image != null) {
            m_ImageCache.put(sImagePath, image);
        }
        return image;
    }

    public String messageString(String key) {
        return this.getString(key);
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String formatString(String sKey, Object p1) {
        return this.formatString(sKey, new Object[]{p1});
    }

    public String formatString(String sKey, Object p1, Object p2) {
        return this.formatString(sKey, new Object[]{p1, p2});
    }

    public String formatString(String sKey, Object p1, Object p2, Object p3) {
        return this.formatString(sKey, new Object[]{p1, p2, p3});
    }

    public String formatString(String sKey, Object p1, Object p2, Object p3, Object p4) {
        return this.formatString(sKey, new Object[]{p1, p2, p3, p4});
    }

    public String formatString(String sKey, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.formatString(sKey, new Object[]{p1, p2, p3, p4, p5});
    }

    public String formatString(String sKey, Object[] aParms) {
        return MessageFormat.format(this.getString(sKey), aParms);
    }

    public Enumeration getKeys() {
        if (this.m_bundle == null) {
            this.m_bundle = this._getBundle(this.m_strResourceFileName);
        }
        return this.m_bundle.getKeys();
    }

    static {
        s_mapBundles = new HashMap();
    }
}

