/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WATitledPane
extends JPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(WATitledPane.class);
    private static final long serialVersionUID = 1L;
    public static final Icon MAXIMIZE_ICON = bundle.getIcon("WATitledPane.Maximize.image");
    public static final Icon MINIMIZE_ICON = bundle.getIcon("WATitledPane.Minimize.image");
    public static final Icon RESTORE_ICON = bundle.getIcon("WATitledPane.Restore.image");
    public static final Icon CLOSE_ICON = bundle.getIcon("WATitledPane.Close.image");
    public static final Icon MAXIMIZE_ROLLOVER_ICON = bundle.getIcon("WATitledPane.MaximizeRollover.image");
    public static final Icon MINIMIZE_ROLLOVER_ICON = bundle.getIcon("WATitledPane.MinimizeRollover.image");
    public static final Icon RESTORE_ROLLOVER_ICON = bundle.getIcon("WATitledPane.RestoreRollover.image");
    public static final Icon CLOSE_ROLLOVER_ICON = bundle.getIcon("WATitledPane.CloseRollover.image");
    public static final String MAXIMIZE_TOOLTIP = bundle.getString("WATitledPane.Maximize.txt");
    public static final String MINIMIZE_TOOLTIP = bundle.getString("WATitledPane.Minimize.txt");
    public static final String RESTORE_TOOLTIP = bundle.getString("WATitledPane.Restore.txt");
    public static final String CLOSE_TOOLTIP = bundle.getString("WATitledPane.Close.txt");
    public static final String ACTIVE = "active";
    private cTitlePane m_pnlTitle;
    private Component m_cmpContents;
    private FocusListener m_focusListener;
    private ContainerListener m_containerListener;
    private boolean m_bActive;

    public WATitledPane() {
        this(null, false, false, false, false);
    }

    public WATitledPane(String sTitle) {
        this(sTitle, false, false, false, false);
    }

    public WATitledPane(String sTitle, boolean bIcon, boolean bMin, boolean bMax, boolean bClose) {
        this.setBackground(SystemColor.control);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.createTitlePane(sTitle, bIcon, bMin, bMax, bClose);
        this.createListeners();
    }

    public JComponent getTitleComponent() {
        return this.m_pnlTitle;
    }

    public JButton getIconButton() {
        return this.m_pnlTitle.getIconButton();
    }

    public JButton getMinButton() {
        return this.m_pnlTitle.getMinButton();
    }

    public JButton getMaxButton() {
        return this.m_pnlTitle.getMaxButton();
    }

    public JButton getCloseButton() {
        return this.m_pnlTitle.getCloseButton();
    }

    public String getTitle() {
        return this.m_pnlTitle.getTitle();
    }

    public void setTitle(String sTitle) {
        this.m_pnlTitle.setTitle(sTitle);
    }

    public void setTitleFont(Font fnt) {
        this.m_pnlTitle.setFont(fnt);
    }

    public Font getTitleFont() {
        return this.m_pnlTitle.getFont();
    }

    public void setActiveForeground(Color clr) {
        this.m_pnlTitle.setActiveForeground(clr);
    }

    public Color getActiveForeground() {
        return this.m_pnlTitle.getActiveForeground();
    }

    public void setActiveBackground(Color clr) {
        this.m_pnlTitle.setActiveBackground(clr);
    }

    public Color getActiveBackground() {
        return this.m_pnlTitle.getActiveBackground();
    }

    public void setInactiveForeground(Color clr) {
        this.m_pnlTitle.setInactiveForeground(clr);
    }

    public Color getInactiveForeground() {
        return this.m_pnlTitle.getInactiveForeground();
    }

    public void setInactiveBackground(Color clr) {
        this.m_pnlTitle.setInactiveBackground(clr);
    }

    public Color getInactiveBackground() {
        return this.m_pnlTitle.getInactiveBackground();
    }

    public void setActive(boolean bActive) {
        if (this.m_bActive == bActive) {
            return;
        }
        this.m_bActive = bActive;
        this.firePropertyChange(ACTIVE, !bActive, bActive);
        this.m_pnlTitle.repaint();
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void setContents(Component cmpContents) {
        this.add(cmpContents, "Center");
        this.listenTo(cmpContents);
        this.m_cmpContents = cmpContents;
    }

    public void removeContents() {
        this.remove(this.m_cmpContents);
    }

    @Override
    public void remove(Component c) {
        if (this.m_cmpContents == c) {
            this.stopListeningTo(this.m_cmpContents);
            this.m_cmpContents = null;
        }
        super.remove(c);
    }

    public Component getContents() {
        return this.m_cmpContents;
    }

    private void createTitlePane(String sTitle, boolean bIcon, boolean bMin, boolean bMax, boolean bClose) {
        this.m_pnlTitle = new cTitlePane(sTitle, bIcon, bMin, bMax, bClose);
        this.add((Component)this.m_pnlTitle, "North");
    }

    private void createListeners() {
        this.m_focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                WATitledPane.this.setActive(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    WATitledPane.this.setActive(false);
                }
            }
        };
        this.m_containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                WATitledPane.this.listenTo(e.getChild());
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                WATitledPane.this.stopListeningTo(e.getChild());
            }
        };
    }

    private void listenTo(Component comp) {
        comp.addFocusListener(this.m_focusListener);
        if (!(comp instanceof Container)) {
            return;
        }
        ((Container)comp).addContainerListener(this.m_containerListener);
        Component[] aComps = ((Container)comp).getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            this.listenTo(aComps[iComp]);
        }
    }

    private void stopListeningTo(Component comp) {
        comp.removeFocusListener(this.m_focusListener);
        if (!(comp instanceof Container)) {
            return;
        }
        ((Container)comp).removeContainerListener(this.m_containerListener);
        Component[] aComps = ((Container)comp).getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            this.stopListeningTo(aComps[iComp]);
        }
    }

    private class cTitlePane
    extends JToolBar {
        private static final long serialVersionUID = 1L;
        private String m_sTitle;
        private boolean m_bIcon;
        private boolean m_bMin;
        private boolean m_bMax;
        private boolean m_bClose;
        private JButton m_btnIcon;
        private JButton m_btnMin;
        private JButton m_btnMax;
        private JButton m_btnClose;
        private Color m_clrActiveBack;
        private Color m_clrActiveText;
        private Color m_clrInactiveBack;
        private Color m_clrInactiveText;
        private int CXButton;
        private int CYButton;
        private int CXButtonGap = 2;
        private int CYButtonGap = 1;
        private int CXIconButton = 16;
        private int CYIconButton = 16;
        private int CXIconButtonGap = 2;
        private int CYIconButtonGap = 0;
        private int CYPanel;
        private int CXPanelMin = 100;

        public cTitlePane(String sTitle, boolean bIcon, boolean bMin, boolean bMax, boolean bClose) {
            this.m_sTitle = sTitle;
            this.m_bIcon = bIcon;
            this.m_bMin = bMin;
            this.m_bMax = bMax;
            this.m_bClose = bClose;
            this.setRollover(true);
            this.setFloatable(false);
            this.installDefaults();
            this.setLayout(this.createLayout());
            this.createButtons();
            this.addSubComponents();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Container cnt = WATitledPane.this.getFocusCycleRootAncestor();
                    Component cmp = cnt.getFocusTraversalPolicy().getFirstComponent(WATitledPane.this);
                    if (cmp != null) {
                        cmp.requestFocusInWindow();
                    }
                }
            });
        }

        public JButton getIconButton() {
            return this.m_btnIcon;
        }

        public JButton getMinButton() {
            return this.m_btnMin;
        }

        public JButton getMaxButton() {
            return this.m_btnMax;
        }

        public JButton getCloseButton() {
            return this.m_btnClose;
        }

        public String getTitle() {
            return this.m_sTitle;
        }

        public void setTitle(String sTitle) {
            this.m_sTitle = sTitle;
            this.repaint();
        }

        public void setActiveForeground(Color clr) {
            this.m_clrActiveText = clr;
            this.repaint();
        }

        public Color getActiveForeground() {
            return this.m_clrActiveText;
        }

        public void setActiveBackground(Color clr) {
            this.m_clrActiveBack = clr;
            this.repaint();
        }

        public Color getActiveBackground() {
            return this.m_clrActiveBack;
        }

        public void setInactiveForeground(Color clr) {
            this.m_clrInactiveText = clr;
            this.repaint();
        }

        public Color getInactiveForeground() {
            return this.m_clrInactiveText;
        }

        public void setInactiveBackground(Color clr) {
            this.m_clrInactiveBack = clr;
            this.repaint();
        }

        public Color getInactiveBackground() {
            return this.m_clrInactiveBack;
        }

        private void installDefaults() {
            this.CXButton = CLOSE_ICON.getIconWidth();
            this.CYButton = CLOSE_ICON.getIconHeight();
            this.CYPanel = this.CYButton + 2 * this.CYButtonGap;
            int red = (SystemColor.controlShadow.getRed() + SystemColor.window.getRed()) / 2;
            int green = (SystemColor.controlShadow.getGreen() + SystemColor.window.getGreen()) / 2;
            int blue = (SystemColor.controlShadow.getBlue() + SystemColor.window.getBlue()) / 2;
            this.m_clrActiveBack = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            this.m_clrActiveText = UIManager.getColor("InternalFrame.inactiveTitleForeground");
            this.m_clrInactiveBack = new Color(red, green, blue);
            this.m_clrInactiveText = SystemColor.controlText;
            this.setFont(UIManager.getFont("InternalFrame.titleFont").deriveFont(0));
        }

        private void addSubComponents() {
            this.add(this.m_btnIcon);
            this.add(this.m_btnMin);
            this.add(this.m_btnMax);
            this.add(this.m_btnClose);
        }

        private void createButtons() {
            this.m_btnIcon = new cNoFocusButton();
            this.m_btnMin = new cNoFocusButton();
            this.m_btnMax = new cNoFocusButton();
            this.m_btnClose = new cNoFocusButton();
            this.m_btnMin.setToolTipText(MINIMIZE_TOOLTIP);
            this.m_btnMax.setToolTipText(MAXIMIZE_TOOLTIP);
            this.m_btnClose.setToolTipText(CLOSE_TOOLTIP);
            this.setButtonIcons();
        }

        private void setButtonIcons() {
            this.m_btnIcon.setIcon(UIManager.getIcon("InternalFrame.icon"));
            this.m_btnMin.setIcon(MINIMIZE_ICON);
            this.m_btnMax.setIcon(MAXIMIZE_ICON);
            this.m_btnClose.setIcon(CLOSE_ICON);
            this.m_btnMin.setRolloverIcon(MINIMIZE_ROLLOVER_ICON);
            this.m_btnMax.setRolloverIcon(MAXIMIZE_ROLLOVER_ICON);
            this.m_btnClose.setRolloverIcon(CLOSE_ROLLOVER_ICON);
            this.m_btnMin.setRolloverEnabled(true);
            this.m_btnMax.setRolloverEnabled(true);
            this.m_btnClose.setRolloverEnabled(true);
        }

        private LayoutManager createLayout() {
            return new cTitlePaneLayout();
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(WATitledPane.this.m_bActive ? this.m_clrActiveBack : this.m_clrInactiveBack);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_sTitle != null) {
                int xRight;
                int xLeft;
                Font f = g.getFont();
                g.setFont(this.getFont());
                g.setColor(WATitledPane.this.m_bActive ? this.m_clrActiveText : this.m_clrInactiveText);
                FontMetrics fm = g.getFontMetrics();
                int cyText = fm.getHeight() - fm.getLeading();
                int yText = (this.CYPanel - cyText) / 2 + fm.getAscent() + fm.getLeading();
                boolean bLeftToRight = this.getComponentOrientation().isLeftToRight();
                if (bLeftToRight) {
                    xLeft = this.m_bIcon ? this.m_btnIcon.getX() + this.m_btnIcon.getWidth() + this.CXIconButtonGap : this.CXIconButtonGap;
                    xRight = this.m_bMin ? this.m_btnMin.getX() - this.CXButtonGap : (this.m_bMax ? this.m_btnMax.getX() - this.CXButtonGap : (this.m_bClose ? this.m_btnClose.getX() - this.CXButtonGap : this.getWidth() - this.CXButtonGap));
                } else {
                    xRight = this.m_bIcon ? this.m_btnIcon.getX() - this.CXIconButtonGap : this.getWidth() - this.CXIconButtonGap;
                    xLeft = this.m_bMin ? this.m_btnMin.getX() + this.m_btnMin.getWidth() + this.CXButtonGap : (this.m_bMax ? this.m_btnMax.getX() + this.m_btnMax.getWidth() + this.CXButtonGap : (this.m_bClose ? this.m_btnClose.getX() + this.m_btnClose.getWidth() + this.CXButtonGap : this.CXButtonGap));
                }
                int cxSpace = xRight - xLeft;
                String sText = this.m_sTitle;
                int cxText = SwingUtilities.computeStringWidth(fm, sText);
                if (cxSpace < cxText) {
                    int iEnd = this.m_sTitle.length();
                    while (cxSpace < (cxText = SwingUtilities.computeStringWidth(fm, sText = this.m_sTitle.substring(0, --iEnd) + "...")) && iEnd > 3) {
                    }
                }
                int xText = bLeftToRight ? xLeft : xRight - cxText;
                g.drawString(sText, xText, yText);
                g.setFont(f);
            }
        }

        private class cNoFocusButton
        extends JButton {
            private static final long serialVersionUID = 1L;

            public cNoFocusButton() {
                this.setFocusPainted(false);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setContentAreaFilled(false);
                this.setOpaque(false);
            }

            @Override
            public boolean isFocusable() {
                return false;
            }

            @Override
            public boolean isRequestFocusEnabled() {
                return false;
            }

            @Override
            public void requestFocus() {
            }
        }

        private class cTitlePaneLayout
        implements LayoutManager {
            private cTitlePaneLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component c) {
            }

            @Override
            public void removeLayoutComponent(Component c) {
            }

            @Override
            public Dimension preferredLayoutSize(Container c) {
                return new Dimension(cTitlePane.this.CXPanelMin, cTitlePane.this.CYPanel);
            }

            @Override
            public Dimension minimumLayoutSize(Container c) {
                return this.preferredLayoutSize(c);
            }

            @Override
            public void layoutContainer(Container c) {
                int xBtn;
                boolean bLeftToRight = cTitlePane.this.getComponentOrientation().isLeftToRight();
                int cxPanel = cTitlePane.this.getWidth();
                if (cTitlePane.this.m_bIcon) {
                    xBtn = bLeftToRight ? cTitlePane.this.CXIconButtonGap : cxPanel - cTitlePane.this.CXIconButton - cTitlePane.this.CXIconButtonGap;
                    cTitlePane.this.m_btnIcon.setBounds(xBtn, cTitlePane.this.CYIconButtonGap, cTitlePane.this.CXIconButton, cTitlePane.this.CYIconButton);
                }
                int n = xBtn = bLeftToRight ? cxPanel - cTitlePane.this.CXButton - cTitlePane.this.CXButtonGap : cTitlePane.this.CXButtonGap;
                if (cTitlePane.this.m_bClose) {
                    cTitlePane.this.m_btnClose.setBounds(xBtn, cTitlePane.this.CYButtonGap, cTitlePane.this.CXButton, cTitlePane.this.CYButton);
                    xBtn += bLeftToRight ? -(cTitlePane.this.CXButton + cTitlePane.this.CXButtonGap) : cTitlePane.this.CXButton + cTitlePane.this.CXButtonGap;
                }
                if (cTitlePane.this.m_bMax) {
                    cTitlePane.this.m_btnMax.setBounds(xBtn, cTitlePane.this.CYButtonGap, cTitlePane.this.CXButton, cTitlePane.this.CYButton);
                    xBtn += bLeftToRight ? -(cTitlePane.this.CXButton + cTitlePane.this.CXButtonGap) : cTitlePane.this.CXButton + cTitlePane.this.CXButtonGap;
                }
                if (cTitlePane.this.m_bMin) {
                    cTitlePane.this.m_btnMin.setBounds(xBtn, cTitlePane.this.CYButtonGap, cTitlePane.this.CXButton, cTitlePane.this.CYButton);
                }
            }
        }
    }
}

