/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextComponent;
import com.sas.workspace.WsBasicCaret;
import com.sas.workspace.WsTextComponentAdapter;
import javax.swing.FocusManager;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;

public class WATextPane
extends JTextPane
implements WATextComponent {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_BEHAVIOR = 0;
    public static final int LABEL_BEHAVIOR = 1;
    public static final int NEVEREDITABLE_BEHAVIOR = 2;
    protected boolean m_bFocusable = true;
    protected WsTextComponentAdapter m_adapter;

    public WATextPane() {
        this.initialize();
    }

    public WATextPane(StyledDocument doc) {
        super(doc);
        this.initialize();
    }

    protected void initialize() {
        this.m_adapter = new WsTextComponentAdapter(this);
        this.setUI(new cBasicTextPaneUI());
    }

    public WsTextComponentAdapter getAdapter() {
        return this.m_adapter;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this.isFocusable() && super.isRequestFocusEnabled();
    }

    public void setBehavior(int eBehavior) {
        this.m_adapter.setBehavior(eBehavior);
    }

    public int getBehavior() {
        return this.m_adapter.getBehavior();
    }

    @Override
    public void setFocusable(boolean bFocusable) {
        this.m_bFocusable = bFocusable;
        if (!bFocusable && this.hasFocus()) {
            FocusManager.getCurrentManager().focusNextComponent(this);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.m_bFocusable;
    }

    public boolean isAutoSelect() {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            return ((WsBasicCaret)caret).isAutoSelect();
        }
        return false;
    }

    public void setAutoSelect(boolean bAutoSelect) {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            ((WsBasicCaret)caret).setAutoSelect(bAutoSelect);
        }
    }

    @Override
    public String getPropertyPrefix() {
        return ((cBasicTextPaneUI)this.getUI()).getPropertyPrefix();
    }

    protected static class cBasicTextPaneUI
    extends BasicTextPaneUI {
        protected cBasicTextPaneUI() {
        }

        @Override
        protected Caret createCaret() {
            return new WsBasicCaret();
        }

        @Override
        public String getPropertyPrefix() {
            return super.getPropertyPrefix();
        }
    }
}

