/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WATextComponent;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsBasicCaret;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsTextComponentAdapter;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.FocusManager;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class WATextField
extends JTextField
implements WATextComponent {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_BEHAVIOR = 0;
    public static final int LABEL_BEHAVIOR = 1;
    public static final int NEVEREDITABLE_BEHAVIOR = 2;
    protected boolean m_bFocusable = true;
    protected WsTextComponentAdapter m_adapter;

    public WATextField() {
        this.initialize();
    }

    public WATextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initialize();
    }

    public WATextField(int columns) {
        super(columns);
        this.initialize();
    }

    public WATextField(String text) {
        super(text);
        this.initialize();
    }

    public WATextField(String text, int columns) {
        super(text, columns);
        this.initialize();
    }

    protected void initialize() {
        this.m_adapter = new WsTextComponentAdapter(this);
        this.setUI(new cBasicTextFieldUI());
    }

    public WsTextComponentAdapter getAdapter() {
        return this.m_adapter;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return this.isFocusable() && super.isRequestFocusEnabled();
    }

    public boolean isAutoSelect() {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            return ((WsBasicCaret)caret).isAutoSelect();
        }
        return false;
    }

    public void setAutoSelect(boolean bAutoSelect) {
        Caret caret = this.getCaret();
        if (caret instanceof WsBasicCaret) {
            ((WsBasicCaret)caret).setAutoSelect(bAutoSelect);
        }
    }

    public void setBehavior(int eBehavior) {
        this.m_adapter.setBehavior(eBehavior);
    }

    public int getBehavior() {
        return this.m_adapter.getBehavior();
    }

    @Override
    public void setFocusable(boolean bFocusable) {
        this.m_bFocusable = bFocusable;
        if (!bFocusable && this.hasFocus()) {
            FocusManager.getCurrentManager().focusNextComponent(this);
        }
    }

    @Override
    public boolean isFocusable() {
        return this.m_bFocusable;
    }

    @Override
    public String getPropertyPrefix() {
        return ((cBasicTextFieldUI)this.getUI()).getPropertyPrefix();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.getColumns() != 0) {
            Insets ins = this.getInsets();
            dim.width += ins.left + ins.right + 1;
        }
        return dim;
    }

    public void setMaxCharacters(int maxCharacters) {
        Document doc = this.getDocument();
        if (doc instanceof WsLimitedPlainDocument) {
            ((WsLimitedPlainDocument)doc).setMaxCharacters(maxCharacters);
        }
    }

    public int getMaxCharacters() {
        Document doc = this.getDocument();
        if (doc instanceof WsLimitedPlainDocument) {
            return ((WsLimitedPlainDocument)doc).getMaxCharacters();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected Document createDefaultModel() {
        WsLimitedPlainDocument doc = new WsLimitedPlainDocument();
        doc.setSingleLine(true);
        return doc;
    }

    public void loadItem(String sKey) {
        this.loadDefaultValue(sKey, "");
    }

    public void loadDefaultValue(String sKey, String sDefault) {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sText = appDefaults.getPropertyString(sKey, sDefault);
        this.setText(sText);
    }

    public void saveItem(String sKey) {
        this.saveDefaultValue(sKey);
    }

    public void saveDefaultValue(String sKey) {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sText = this.getText();
        appDefaults.setPropertyString(sKey, sText);
    }

    protected static class cBasicTextFieldUI
    extends BasicTextFieldUI {
        protected cBasicTextFieldUI() {
        }

        @Override
        protected Caret createCaret() {
            return new WsBasicCaret();
        }

        @Override
        public String getPropertyPrefix() {
            return super.getPropertyPrefix();
        }
    }
}

