/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WARowTable;
import com.sas.workspace.WATable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WATableUI
extends BasicTableUI {
    WARowTable rowTable = null;

    public WATableUI(WARowTable wart) {
        this.rowTable = wart;
    }

    public WATableUI() {
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandlerTable();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point minLocation = clip.getLocation();
        Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(minLocation);
        int rMax = this.table.rowAtPoint(maxLocation);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(minLocation);
        int cMax = this.table.columnAtPoint(maxLocation);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = maxCell.x + maxCell.width;
            int y = minCell.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(0, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = maxCell.y + maxCell.height;
            int x = minCell.x;
            for (int column = cMin; column <= cMax; ++column) {
                g.drawLine((x += cm.getColumn(column).getWidth()) - 1, 0, x - 1, tableHeight - 1);
            }
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        int[] dragArray = null;
        if (this.rowTable != null) {
            dragArray = this.rowTable.getDragRows();
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, row, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        if (dragArray == null || dragArray.length > 0) {
            // empty if block
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    private int viewIndexForColumn(TableColumn t) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != t) continue;
            return column;
        }
        return -1;
    }

    public class MouseInputHandlerTable
    extends BasicTableUI.MouseInputHandler {
        public MouseInputHandlerTable() {
            super(WATableUI.this);
        }

        private void setValueIsAdjusting(boolean flag) {
            WATableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            WATableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Point p = me.getPoint();
            int row = WATableUI.this.table.rowAtPoint(p);
            int column = WATableUI.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            boolean edFlag = false;
            TableCellEditor ce = WATableUI.this.table.getCellEditor();
            if (ce != null && WATableUI.this.table.isEditing()) {
                ce.stopCellEditing();
                edFlag = true;
            }
            if (WATableUI.this.table.isEditing()) {
                return;
            }
            if (edFlag) {
                WATableUI.this.table.clearSelection();
            }
            if (me.isShiftDown() || me.isControlDown()) {
                WATableUI.this.table.requestFocus();
                this.setValueIsAdjusting(true);
                if (me.isControlDown() && WATableUI.this.table.getSelectedRows().length > 0) {
                    WATableUI.this.table.changeSelection(row, -1, me.isControlDown(), false);
                } else if (WATableUI.this.table.getSelectedRows().length > 0) {
                    WATableUI.this.table.changeSelection(row, -1, false, true);
                } else {
                    WATableUI.this.table.changeSelection(row, -1, false, false);
                }
                WATableUI.this.table.setColumnSelectionInterval(0, WATableUI.this.table.getColumnCount() - 1);
            } else {
                super.mousePressed(me);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (WATableUI.this.table.isEditing()) {
                return;
            }
            super.mouseDragged(e);
            ((WATable)WATableUI.this.table).mouseDrag(e);
        }
    }
}

