/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsNewView;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class WAStandardInternalFrame
extends WAInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected static final String DATA_CHANGED_PROPERTY = "DataChanged";
    public static final String DataChangedPromptProperty = "PromptAboutDataChanged";
    private static final WAdminResource bundle = WAdminResource.getBundle(WAStandardInternalFrame.class);
    private static boolean s_bDoNotShowMessageCheckBoxVisible = true;
    protected String m_sRealTitle;
    protected String m_sHelpTopic;
    protected String m_sHelpProduct;
    private boolean m_bButtonsPanelVisible;
    protected boolean m_bInitialized = false;
    protected int m_eReturnValue;
    protected boolean m_bDataChanged;
    private boolean m_bOKButtonVisible;
    private boolean m_bCancelButtonVisible;
    private boolean m_bApplyButtonVisible;
    private boolean m_bHelpButtonVisible;
    private boolean m_bCloseButtonVisible;
    private Action m_actOK;
    private Action m_actCancel;
    private WsAbstractAction m_actApply;
    private Action m_actHelp;
    protected JPanel m_pnlButtons;
    protected JButton m_btnOk;
    protected JButton m_btnCancel;
    protected JButton m_btnClose;
    protected JButton m_btnApply;
    protected JButton m_btnHelp;
    protected WAPanel m_pnlMain;
    protected cKeyHandler m_KeyHandler;
    protected PropertyChangeListener m_lsnrDataChanged;
    protected PropertyChangeListener m_lsnrPanelDataChanged;
    protected InputMap m_mapInput;
    private ActionMap m_mapAction;

    public static void setDoNotShowMessageCheckBoxVisible(boolean bVisible) {
        s_bDoNotShowMessageCheckBoxVisible = bVisible;
    }

    public static boolean isDoNotShowMessageCheckBoxVisible() {
        return s_bDoNotShowMessageCheckBoxVisible;
    }

    private static void setUserPreferenceToShowTheDiscardChangesMessage(boolean bShow) {
        WAStandardDialog.setUserPreferenceToShowTheDiscardChangesMessage(bShow);
    }

    private static boolean isUserPreferenceToShowTheDiscardChangesMessage() {
        return WAStandardDialog.isUserPreferenceToShowTheDiscardChangesMessage();
    }

    public WAStandardInternalFrame(String sTitle) {
        this(sTitle, null);
    }

    public WAStandardInternalFrame(String sTitle, WAPanel pnlMain) {
        super(sTitle, true, true, true, true);
        this.setButtonsPanelVisible(true);
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setCloseButtonVisible(false);
        this.setApplyButtonVisible(true);
        this.setHelpButtonVisible(true);
        this.m_KeyHandler = this.createKeyListener();
        this.m_lsnrDataChanged = new cDataChangedListener();
        this.m_lsnrPanelDataChanged = new cPanelDataChangedListener();
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        this.setBackground(SystemColor.control);
        this.setTitle(sTitle);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
    }

    public WAUndoManager getWAUndoManager() {
        return this.m_pnlMain.getWAUndoManager();
    }

    public int getReturnValue() {
        return this.m_eReturnValue;
    }

    public void setMainPanel(WAPanel pnlMain) {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.removePropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.removeKeyListeners(this.m_pnlMain, this.m_KeyHandler);
            this.getContentPane().remove(this.m_pnlMain);
            this.restoreMainPanelBorder();
        }
        this.m_pnlMain = pnlMain;
        if (this.m_pnlMain != null) {
            this.getContentPane().add((Component)this.m_pnlMain, "Center");
            this.addKeyListeners(this.m_pnlMain, this.m_KeyHandler);
            this.m_pnlMain.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.m_pnlMain.setEditable(this.m_bEditable);
            this.createMainPanelBorder();
        }
    }

    public WAPanel getMainPanel() {
        return this.m_pnlMain;
    }

    @Override
    public void setTitle(String sTitle) {
        this.m_sRealTitle = sTitle;
        this.refreshTitle();
    }

    protected void refreshTitle() {
        String sChange = this.isDataChanged() ? " " + bundle.getString("Common.DataChangedIndicator.txt") : "";
        String sBrowse = !this.isEditable() ? " " + bundle.getString("Common.ReadOnlyIndicator.txt") : "";
        super.setTitle(this.m_sRealTitle + sChange + sBrowse);
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.setOKButtonVisible(bEditable);
        this.setApplyButtonVisible(bEditable);
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setEditable(bEditable);
        }
        if (this.m_pnlButtons != null) {
            this.updateButtonsPanel();
        }
        if (this.m_actApply != null) {
            this.m_actApply.setEnabled(bEditable && this.isDataChanged());
        }
        this.refreshTitle();
    }

    public ClassLoader getHelpClassLoader() {
        return this.m_pnlMain != null ? this.m_pnlMain.getHelpClassLoader() : null;
    }

    public void setHelpTopic(String sHelpTopic) {
        this.m_sHelpTopic = sHelpTopic;
    }

    public String getHelpTopic() {
        String sHelpTopic = null;
        if (this.m_pnlMain != null) {
            sHelpTopic = this.m_pnlMain.getHelpTopic();
        }
        if (sHelpTopic == null) {
            sHelpTopic = this.m_sHelpTopic;
        }
        return sHelpTopic;
    }

    public void setHelpProduct(String sHelpProduct) {
        this.m_sHelpProduct = sHelpProduct;
    }

    public String getHelpProduct() {
        String sHelpProduct = null;
        if (this.m_pnlMain != null) {
            sHelpProduct = this.m_pnlMain.getHelpProduct();
        }
        if (sHelpProduct == null) {
            sHelpProduct = this.m_sHelpProduct;
        }
        return sHelpProduct;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public boolean isDataChanged() {
        return this.m_bDataChanged;
    }

    public void setButtonsPanelVisible(boolean bVisible) {
        this.m_bButtonsPanelVisible = bVisible;
    }

    public boolean isButtonsPanelVisible() {
        return this.m_bButtonsPanelVisible;
    }

    public boolean isOKButtonVisible() {
        return this.m_bOKButtonVisible;
    }

    public void setOKButtonVisible(boolean visible) {
        this.m_bOKButtonVisible = visible;
    }

    public boolean isCancelButtonVisible() {
        return this.m_bCancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.m_bCancelButtonVisible = visible;
    }

    public boolean isCloseButtonVisible() {
        return this.m_bCloseButtonVisible;
    }

    public void setCloseButtonVisible(boolean visible) {
        this.m_bCloseButtonVisible = visible;
    }

    public boolean isApplyButtonVisible() {
        return this.m_bApplyButtonVisible;
    }

    public void setApplyButtonVisible(boolean visible) {
        this.m_bApplyButtonVisible = visible;
    }

    public boolean isHelpButtonVisible() {
        return this.m_bHelpButtonVisible;
    }

    public void setHelpButtonVisible(boolean visible) {
        this.m_bHelpButtonVisible = visible;
    }

    public Component getDefaultFocusComponent() {
        Component cmp = null;
        if (this.m_pnlMain != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlMain);
        }
        if (cmp == null && this.m_pnlButtons != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlButtons);
        }
        return cmp != null ? cmp : this;
    }

    @Override
    public void pack() {
        if (!this.m_bInitialized) {
            this.initialize();
            this.layoutWidgets();
            this.m_bInitialized = true;
        }
        super.pack();
    }

    @Override
    public void show() {
        this.pack();
        this.onShow();
        super.show();
        WARootPane root = (WARootPane)this.getRootPane();
        root.setDefaultButton(root.getRealDefaultButton());
        this.getDefaultFocusComponent().requestFocus();
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        WARootPane root = (WARootPane)this.getRootPane();
        root.setDefaultButton(root.getRealDefaultButton());
    }

    protected void createMainPanelBorder() {
        int width = this.isButtonsPanelVisible() ? 4 : 3;
        Border brdrOuter = BorderFactory.createEmptyBorder(width, width, width, width);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    protected void restoreMainPanelBorder() {
        CompoundBorder brdrCompound = (CompoundBorder)this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(brdrCompound.getInsideBorder());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnOk) {
            if (this.onOK()) {
                this.close();
            }
        } else if (src == this.m_btnCancel) {
            this.close();
        } else if (src == this.m_btnApply) {
            this.onApply();
        } else if (src == this.m_btnHelp) {
            this.onHelp();
        }
    }

    protected void onShow() {
        this.doDataExchange(false);
    }

    protected boolean onOK() {
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (this.validateData() && this.doDataExchange(true)) {
            this.m_eReturnValue = 1;
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentOK();
            }
            return true;
        }
        return false;
    }

    protected boolean onCancel() {
        if (!this.isEditable()) {
            this.m_eReturnValue = 2;
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentCancel();
            }
            return true;
        }
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (WAStandardInternalFrame.isUserPreferenceToShowTheDiscardChangesMessage() && this.isDataChanged()) {
            int eAnswer = this.showDiscardChangesMessage();
            if (eAnswer == 0) {
                return this.onOK();
            }
            if (eAnswer == 2 || eAnswer == -1) {
                return false;
            }
        }
        this.m_eReturnValue = 2;
        if (this.m_pnlMain != null) {
            this.m_pnlMain.onParentCancel();
        }
        return true;
    }

    private int showDiscardChangesMessage() {
        String sMessage = bundle.formatString("WAStandardInternalFrame.SaveChanges.Message.fmt", this.m_sRealTitle);
        int eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), sMessage, this.m_sRealTitle, 1, 2);
        return eAnswer;
    }

    protected boolean onApply() {
        if (this.validateData()) {
            this.doDataExchange(true);
            this.setDataChanged(false);
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentApply();
            }
            return true;
        }
        return false;
    }

    protected void onHelp() {
        Workspace.getWorkspace().showHelp(this.getHelpProduct(), this.getHelpTopic(), Workspace.getWorkspace(), this.getHelpClassLoader());
    }

    public void refresh() {
        if (this.m_pnlMain != null) {
            try {
                this.m_pnlMain.refresh();
                this.setDataChanged(false);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
        }
    }

    protected boolean validateData() {
        if (this.m_pnlMain != null) {
            return this.m_pnlMain.validateData();
        }
        return true;
    }

    protected boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel && this.getView() instanceof WsNewView) {
            ((WsNewView)this.getView()).save();
            return true;
        }
        if (this.m_pnlMain != null) {
            try {
                if (!bSaveToModel) {
                    this.m_pnlMain.populateStore();
                    this.m_pnlMain.moveDataToView();
                } else {
                    this.m_pnlMain.moveDataToStore();
                }
                return true;
            }
            catch (MdException e) {
                if (!e.getMessage().equalsIgnoreCase("Undisplayable")) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
                }
                return false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
                return false;
            }
        }
        return true;
    }

    @Override
    protected JRootPane createRootPane() {
        return new WARootPane();
    }

    protected void initialize() {
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                String sProperty = e.getPropertyName();
                if (sProperty.equals("closed")) {
                    boolean bOld = (Boolean)e.getOldValue();
                    boolean bNew = (Boolean)e.getNewValue();
                    if (!bOld && bNew && !WAStandardInternalFrame.this.onCancel()) {
                        throw new PropertyVetoException("close cancelled", e);
                    }
                }
            }
        });
        this.m_actOK = this.createOKAction();
        this.m_actCancel = this.createCancelAction();
        this.m_actApply = this.createApplyAction();
        this.m_actHelp = this.createHelpAction();
        this.m_pnlButtons = new JPanel();
        this.m_btnOk = new JButton(this.m_actOK);
        this.m_btnCancel = new JButton(this.m_actCancel);
        this.m_btnClose = new JButton(this.m_actClose);
        this.m_btnApply = new JButton(this.m_actApply);
        this.m_btnHelp = new JButton(this.m_actHelp);
        this.m_btnOk.setName("OK");
        this.m_btnCancel.setName("Cancel");
        this.m_btnApply.setName("Apply");
        this.m_btnHelp.setName("Help");
        this.updateInputMap();
        this.updateActionMap();
        this.m_actApply.setEnabled(false);
    }

    protected void layoutWidgets() {
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
        if (this.isButtonsPanelVisible()) {
            this.updateButtonsPanel();
            JPanel pnlRightAligned = new JPanel(new FlowLayout(2, 0, 0));
            pnlRightAligned.add(this.m_pnlButtons);
            paneContents.add((Component)pnlRightAligned, "South");
        }
        if (this.m_pnlMain != null) {
            this.m_pnlMain.setNextFocusableComponentOnLastFocusableComponent(CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlButtons));
        }
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new GridLayout(1, 4, 5, 0));
        if (this.isOKButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnOk);
        }
        if (this.isCancelButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        }
        if (this.isCloseButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnClose);
        }
        if (this.isApplyButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnApply);
        }
        if (this.isHelpButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnHelp);
        }
        if (this.isOKButtonVisible()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
        } else if (this.isCloseButtonVisible()) {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnClose);
        } else {
            ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnCancel);
        }
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    @Override
    public void dispose() {
        if (this.m_pnlMain != null) {
            try {
                this.m_pnlMain.saveSettingsAndCleanUp();
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)"Exception during main panel clean up", ex);
            }
        }
        super.dispose();
        this.m_KeyHandler = null;
        this.m_pnlMain = null;
        this.cleanupInputMap();
        this.cleanupActionMap();
    }

    protected void updateInputMap() {
        this.m_mapInput = this.getLayeredPane().getInputMap(1);
        this.m_mapInput.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 0), "help");
    }

    private void updateActionMap() {
        this.m_mapAction = this.getLayeredPane().getActionMap();
        this.m_mapAction.put("cancel", this.m_actCancel);
        this.m_mapAction.put("help", this.m_actHelp);
    }

    protected void cleanupInputMap() {
        if (this.m_mapInput != null) {
            this.m_mapInput.remove(KeyStroke.getKeyStroke(27, 0));
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 0));
        }
    }

    private void cleanupActionMap() {
        if (this.m_mapAction != null) {
            this.m_mapAction.remove("cancel");
            this.m_mapAction.remove("help");
        }
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_pnlMain != null) {
            this.m_pnlMain.updateWorkspaceUIComponents(bActive);
        }
        this.m_actApply.setActive(bActive);
    }

    protected cKeyHandler createKeyListener() {
        return new cKeyHandler();
    }

    protected void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].addKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    protected void removeKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] aComps = container.getComponents();
        int nComps = aComps.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            aComps[iComp].removeKeyListener(keyHandler);
            if (!(aComps[iComp] instanceof Container)) continue;
            this.removeKeyListeners((Container)aComps[iComp], keyHandler);
        }
    }

    private Action createOKAction() {
        return new OKAction();
    }

    private Action createCancelAction() {
        return new CancelAction();
    }

    @Override
    protected WsAbstractAction createCloseAction() {
        return new CloseAction();
    }

    private WsAbstractAction createApplyAction() {
        return new ApplyAction();
    }

    private Action createHelpAction() {
        return new cHelpAction();
    }

    protected class cHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public cHelpAction() {
            this.putValue("Name", bundle.getString("Common.Help.txt"));
            this.putValue("MnemonicKey", new Integer(bundle.getString("Common.Help.mnem").charAt(0)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WAStandardInternalFrame.this.onHelp();
        }
    }

    private class ApplyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ApplyAction() {
            this.putValue("Name", bundle.getString("Common.Apply.txt"));
            this.putValue("MnemonicKey", new Integer(bundle.getString("Common.Apply.mnem").charAt(0)));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() != WAStandardInternalFrame.this.m_btnApply) {
                WAStandardInternalFrame.this.onApply();
            }
        }
    }

    private class CloseAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            this.setText(bundle.getString("Common.Close.txt"));
            this.setMenuSupportId("close");
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WAStandardInternalFrame.this.close();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            this.putValue("Name", bundle.getString("Common.Cancel.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WAStandardInternalFrame.this.close();
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public OKAction() {
            this.putValue("Name", bundle.getString("Common.OK.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (WAStandardInternalFrame.this.onOK()) {
                WAStandardInternalFrame.this.close();
            }
        }
    }

    protected class cPanelDataChangedListener
    implements PropertyChangeListener {
        protected cPanelDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            WAStandardInternalFrame.this.setDataChanged((Boolean)e.getNewValue());
        }
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean bEnable;
            boolean bl = bEnable = (Boolean)e.getNewValue() != false && WAStandardInternalFrame.this.isEditable();
            if (WAStandardInternalFrame.this.m_actApply != null) {
                WAStandardInternalFrame.this.m_actApply.setEnabled(bEnable);
            }
            WAStandardInternalFrame.this.refreshTitle();
        }
    }

    protected class cKeyHandler
    extends KeyAdapter {
        protected cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

