/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsExternalDataPropertyTabInterface;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsTabbedInterface;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class WASplittablePropertyFrame
extends WAPropertyFrame {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WASplittablePropertyFrame.class);
    protected boolean m_bSaveTabsIndividually = true;

    public WASplittablePropertyFrame(CMetadata oData, String sTitle) {
        super(oData, sTitle);
    }

    public WASplittablePropertyFrame() {
        this(null, "");
    }

    @Override
    protected WATabbedPanel createMainPanel() {
        return new cSplittableTabbedPanel();
    }

    @Override
    protected void createMainPanelBorder() {
        Border brdrOuter = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    @Override
    protected WAStandardInternalFrame.cKeyHandler createKeyListener() {
        return new cKeyHandlerExt();
    }

    @Override
    protected void layoutWidgets() {
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
    }

    @Override
    protected void updateInputMap() {
        super.updateInputMap();
        this.m_mapInput.put(KeyStroke.getKeyStroke(112, 0), "help");
    }

    @Override
    protected void cleanupInputMap() {
        super.cleanupInputMap();
        if (this.m_mapInput != null) {
            this.m_mapInput.remove(KeyStroke.getKeyStroke(112, 0));
        }
    }

    @Override
    protected boolean onCancel() {
        boolean fDontWrite = false;
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (!this.m_bSaveTabsIndividually) {
            return super.onCancel();
        }
        if (this.isDataChanged()) {
            WsExternalDataPropertyTabInterface tabExternal;
            WAPropertyTab tab;
            ArrayList<JCheckBox> alCheckBoxes = new ArrayList<JCheckBox>();
            ArrayList<WAPropertyTab> alPropertyTabs = new ArrayList<WAPropertyTab>();
            int nTabs = this.m_pnlTabs.getTabCount();
            int iTab = 0;
            int iCheckBox = 0;
            int nCheckBoxes = 0;
            int iNumChanges = 0;
            for (iTab = 0; iTab < nTabs; ++iTab) {
                WAPropertyTab tab2 = this.m_pnlTabs.getTabAt(iTab);
                if (!tab2.hasDataChanged()) continue;
                ++iNumChanges;
                alPropertyTabs.add(tab2);
            }
            int eAnswer = 0;
            if (iNumChanges > 1) {
                for (iTab = 0; iTab < nTabs; ++iTab) {
                    tab = this.m_pnlTabs.getTabAt(iTab);
                    if (!tab.hasDataChanged()) continue;
                    tabExternal = (WsExternalDataPropertyTabInterface)((Object)tab);
                    JCheckBox ckb = new JCheckBox(tabExternal.getContentsName());
                    ckb.setSelected(tabExternal.getSaveContentsDefault());
                    alPropertyTabs.add(tab);
                    alCheckBoxes.add(ckb);
                }
                Object[] oaMessage = new Object[alCheckBoxes.size() + 1];
                oaMessage[0] = bundle.getString("WASplittablePropertyFrame.SaveChanges.txt");
                nCheckBoxes = alCheckBoxes.size();
                for (iCheckBox = 0; iCheckBox < nCheckBoxes; ++iCheckBox) {
                    oaMessage[iCheckBox + 1] = alCheckBoxes.get(iCheckBox);
                }
                eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), oaMessage, this.getTitle(), 1, 2);
            } else {
                tab = (WAPropertyTab)alPropertyTabs.get(0);
                Object[] oaMessage = new Object[]{bundle.formatString("WASplittablePropertyFrame.SaveChanges.fmt.txt", tab.getTabTypeName())};
                eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), oaMessage, tab.getTabTypeName(), 1, 2);
            }
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return true;
                }
            }
            if (eAnswer == 1) {
                fDontWrite = true;
            } else if (nCheckBoxes > 1) {
                for (iCheckBox = 0; iCheckBox < nCheckBoxes; ++iCheckBox) {
                    JCheckBox ckb = (JCheckBox)alCheckBoxes.get(iCheckBox);
                    tabExternal = (WsExternalDataPropertyTabInterface)alPropertyTabs.get(iCheckBox);
                    if (ckb.isSelected()) {
                        if (tabExternal.saveExternalData()) continue;
                        return false;
                    }
                    if (!tabExternal.noSaveSaysDontWrite()) continue;
                    fDontWrite = true;
                }
            } else {
                WsExternalDataPropertyTabInterface tabExternal2 = (WsExternalDataPropertyTabInterface)alPropertyTabs.get(0);
                if (!tabExternal2.saveExternalData()) {
                    return false;
                }
            }
        } else {
            fDontWrite = true;
        }
        this.m_eReturnValue = 2;
        if (this.m_oMetadata != null && this.isEditable() && !fDontWrite) {
            int iRC;
            if (Workspace.getWorkspace().isServerStatusCheckEnabled() && ((iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
                return false;
            }
            this.writeMetadata(true);
            return true;
        }
        return true;
    }

    public void setSaveTabsIndividually(boolean bSaveTabsIndividually) {
        this.m_bSaveTabsIndividually = bSaveTabsIndividually;
    }

    public boolean isSaveTabsIndividually() {
        return this.m_bSaveTabsIndividually;
    }

    protected class cKeyHandlerExt
    extends WAStandardInternalFrame.cKeyHandler {
        protected cKeyHandlerExt() {
            super(WASplittablePropertyFrame.this);
        }
    }

    protected class cSplittableTabbedPanel
    extends WATabbedPanel {
        private static final long serialVersionUID = 1L;
        protected PropertyChangeListener m_lsnrPanelDataChanged1 = this.createDataChangedListener();
        private boolean m_bRestored;

        @Override
        public void moveDataToView() {
            if (!this.m_bRestored) {
                ((WsSplittableTabbedPane2)this.m_Tabs).restoreState(WASplittablePropertyFrame.this.getDefaultsName() + "SplittableTabs", false);
                this.m_bRestored = true;
            }
            super.moveDataToView();
        }

        @Override
        public void saveSettingsAndCleanUp() {
            ((WsSplittableTabbedPane2)this.m_Tabs).saveState(WASplittablePropertyFrame.this.getDefaultsName() + "SplittableTabs");
            super.saveSettingsAndCleanUp();
        }

        @Override
        protected void addBorderToTab(WAPropertyTab tab) {
        }

        @Override
        protected void removeBorderFromTab(WAPropertyTab tab) {
        }

        @Override
        protected void listenForDataChangesTo(WAPanel pnl) {
            pnl.addPropertyChangeListener("DataChanged", this.m_lsnrPanelDataChanged1);
        }

        @Override
        protected void stopListeningForDataChangesTo(WAPanel pnl) {
            pnl.removePropertyChangeListener("DataChanged", this.m_lsnrPanelDataChanged1);
        }

        @Override
        protected WsTabbedInterface createTabbedPane() {
            return new WsSplittableTabbedPane2();
        }

        @Override
        protected PropertyChangeListener createDataChangedListener() {
            return new cDataChangedListenerExt();
        }

        protected class cDataChangedListenerExt
        implements PropertyChangeListener {
            protected cDataChangedListenerExt() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    cSplittableTabbedPanel.this.setDataChanged(true);
                } else {
                    int nTabs = cSplittableTabbedPanel.this.m_Tabs.getTabCount();
                    for (int iTab = 0; iTab < nTabs; ++iTab) {
                        WAPropertyTab tab = (WAPropertyTab)cSplittableTabbedPanel.this.m_Tabs.getTabAt(iTab);
                        if (!tab.hasDataChanged()) continue;
                        return;
                    }
                    cSplittableTabbedPanel.this.setDataChanged(false);
                }
            }
        }
    }
}

