/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.SplittableTabbedPaneEvent;
import com.sas.workspace.SplittableTabbedPaneListener;
import com.sas.workspace.WATitledPane;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class WASplitableTabbedPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WASplitableTabbedPane.class);
    public static final int SPLIT_NONE = 0;
    public static final int SPLIT_HORIZONTAL = 1;
    public static final int SPLIT_VERTICAL = 2;
    public static final int SPLIT_BOTH = 3;
    protected Component m_cmpMain = null;
    protected JTabbedPane m_pnlTabs = new JTabbedPane(3);
    protected cTabbedPane m_frmTabs;
    protected Vector m_vFrames = new Vector();
    protected Vector m_vSplits = new Vector();
    protected boolean m_bClosable;

    public WASplitableTabbedPane() {
        this(3, true);
    }

    public WASplitableTabbedPane(int fStyle) {
        this(fStyle, true);
    }

    public WASplitableTabbedPane(int fStyle, boolean bClosable) {
        this.m_bClosable = bClosable;
        boolean bVertical = (fStyle & 2) == 2;
        boolean bHorizontal = (fStyle & 1) == 1;
        this.m_frmTabs = new cTabbedPane(bVertical, bHorizontal, bClosable);
        this.m_frmTabs.setContents(this.m_pnlTabs);
        this.updateSplitButtons();
        this.m_cmpMain = this.m_frmTabs;
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_frmTabs, "Center");
    }

    public void setTitle(String sTitle) {
        this.m_frmTabs.setTitle(sTitle);
    }

    public void addTab(String sTitle, Component cmp) {
        this.m_pnlTabs.addTab(sTitle, cmp);
        this.updateSplitButtons();
    }

    public int getTabCount() {
        return this.m_pnlTabs.getTabCount();
    }

    public int getSplitTabCount() {
        return this.m_vFrames.size();
    }

    public int getTotalTabCount() {
        return this.m_pnlTabs.getTabCount() + this.m_vFrames.size();
    }

    public Component getSelectedTab() {
        return this.m_pnlTabs.getSelectedComponent();
    }

    public void setSelectedTab(int iTab) {
        this.m_pnlTabs.setSelectedIndex(iTab);
    }

    public int getTabState(Component cmpTab) {
        int nFrames = this.m_vFrames.size();
        for (int iFrame = 0; iFrame < nFrames; ++iFrame) {
            cSplitOutPane cmpFrame = (cSplitOutPane)this.m_vFrames.get(iFrame);
            if (cmpFrame.getContents() != cmpTab) continue;
            JSplitPane split = (JSplitPane)this.m_vSplits.get(iFrame);
            if (split.getOrientation() == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_pnlTabs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_pnlTabs.removeChangeListener(l);
    }

    public void addSplittableTabbedPaneListener(SplittableTabbedPaneListener l) {
        this.listenerList.add(SplittableTabbedPaneListener.class, l);
    }

    public void removeSplittableTabbedPaneListener(SplittableTabbedPaneListener l) {
        this.listenerList.remove(SplittableTabbedPaneListener.class, l);
    }

    protected void fireSplittableTabbedPaneEvent(SplittableTabbedPaneEvent e) {
        Object[] oaListeners = this.listenerList.getListenerList();
        block6: for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != SplittableTabbedPaneListener.class) continue;
            SplittableTabbedPaneListener listener = (SplittableTabbedPaneListener)oaListeners[iListener + 1];
            switch (e.getID()) {
                case 300: {
                    listener.tabSplit(e);
                    continue block6;
                }
                case 301: {
                    listener.tabClosed(e);
                    continue block6;
                }
                case 302: {
                    listener.tabRejoined(e);
                    continue block6;
                }
                case 303: {
                    listener.splitTabClosed(e);
                }
            }
        }
    }

    public void closeSelectedTab() {
        Component cmpTab = this.m_pnlTabs.getSelectedComponent();
        this.m_pnlTabs.removeTabAt(this.m_pnlTabs.getSelectedIndex());
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 301, cmpTab));
        this.updateSplitButtons();
    }

    public void split(int SplitDir) {
        cSplitOutPane pnlSplitTab = new cSplitOutPane(SplitDir, this.m_bClosable);
        pnlSplitTab.setTitle(this.m_pnlTabs.getTitleAt(this.m_pnlTabs.getSelectedIndex()));
        Component cmpTab = this.m_pnlTabs.getSelectedComponent();
        pnlSplitTab.setContents(cmpTab);
        JSplitPane pnlSplit = new JSplitPane(SplitDir);
        pnlSplit.setLeftComponent(this.m_cmpMain);
        pnlSplit.setRightComponent(pnlSplitTab);
        this.add((Component)pnlSplit, "Center");
        this.m_cmpMain = pnlSplit;
        this.m_vSplits.add(pnlSplit);
        this.m_vFrames.add(pnlSplitTab);
        this.validate();
        cmpTab.setVisible(true);
        cmpTab.requestFocus();
        int nSplits = this.m_vSplits.size();
        double loc = (double)nSplits / ((double)nSplits + 1.0);
        pnlSplit.setDividerLocation(loc);
        pnlSplit.setResizeWeight(0.5);
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 300, cmpTab));
        this.updateSplitButtons();
    }

    public void rejoin(cSplitOutPane pnlSplitTab) {
        Component cmpTab = pnlSplitTab.getContents();
        this.m_pnlTabs.addTab(pnlSplitTab.getTitle(), cmpTab);
        this.removeSplitOutPanel(pnlSplitTab);
        this.m_pnlTabs.requestFocus();
        this.updateSplitButtons();
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 302, cmpTab));
    }

    public void closeSplitOutTab(cSplitOutPane pnlSplitTab) {
        Component cmpTab = pnlSplitTab.getContents();
        this.removeSplitOutPanel(pnlSplitTab);
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 303, cmpTab));
    }

    protected void removeSplitOutPanel(cSplitOutPane pnlSplitTab) {
        int iFrame = this.m_vFrames.indexOf(pnlSplitTab);
        JSplitPane pnlSplit = (JSplitPane)this.m_vSplits.get(iFrame);
        if (iFrame == this.m_vFrames.size() - 1) {
            this.remove(pnlSplit);
            this.m_cmpMain = pnlSplit.getLeftComponent();
            this.add(this.m_cmpMain, "Center");
        } else {
            JSplitPane pnlSplitNext = (JSplitPane)this.m_vSplits.get(iFrame + 1);
            pnlSplitNext.setLeftComponent(pnlSplit.getLeftComponent());
        }
        this.m_vFrames.remove(iFrame);
        this.m_vSplits.remove(iFrame);
        this.validate();
    }

    protected void updateSplitButtons() {
        JButton btnMax;
        boolean bEnabled = this.m_pnlTabs.getTabCount() > 1;
        JButton btnMin = this.m_frmTabs.getMinButton();
        if (btnMin != null) {
            btnMin.setEnabled(bEnabled);
        }
        if ((btnMax = this.m_frmTabs.getMaxButton()) != null) {
            btnMax.setEnabled(bEnabled);
        }
    }

    protected class cSplitOutPane
    extends WATitledPane
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public cSplitOutPane(int iDir, boolean bClosable) {
            super("", false, false, true, bClosable);
            JButton btnMax = this.getMaxButton();
            String sDir = iDir == 1 ? "Left" : "Up";
            btnMax.setIcon(bundle.getImageIcon("WASplittableTabbedPane.Rejoin" + sDir + ".image"));
            btnMax.addActionListener(this);
            if (bClosable) {
                JButton btnClose = this.getCloseButton();
                btnClose.addActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object objSource = e.getSource();
            if (objSource == this.getMaxButton()) {
                WASplitableTabbedPane.this.rejoin(this);
            } else if (objSource == this.getCloseButton()) {
                WASplitableTabbedPane.this.closeSplitOutTab(this);
            }
        }
    }

    protected class cTabbedPane
    extends WATitledPane {
        private static final long serialVersionUID = 1L;

        public cTabbedPane(boolean bVertical, boolean bHorizontal, boolean bClosable) {
            super("", false, bVertical, bHorizontal, bClosable);
            if (bVertical) {
                JButton btnMin = this.getMinButton();
                btnMin.setIcon(bundle.getImageIcon("WASplittableTabbedPane.SplitDown.image"));
                btnMin.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WASplitableTabbedPane.this.split(0);
                    }
                });
            }
            if (bHorizontal) {
                JButton btnMax = this.getMaxButton();
                btnMax.setIcon(bundle.getImageIcon("WASplittableTabbedPane.SplitRight.image"));
                btnMax.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WASplitableTabbedPane.this.split(1);
                    }
                });
            }
            if (bClosable) {
                JButton btnClose = this.getCloseButton();
                btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WASplitableTabbedPane.this.closeSelectedTab();
                    }
                });
            }
        }
    }
}

