/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WAPropertyFrame
extends WAStandardInternalFrame {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WAPropertyDialog.class);
    public static final String RefreshViewsProperty = "RefreshViews";
    public static final int AlwaysRefreshViews = 0;
    public static final int PromptForRefreshViews = 1;
    public static final int NeverRefreshViews = 2;
    protected CMetadata m_oMetadata;
    protected MdObjectStore m_oStore;
    protected WATabbedPanel m_pnlTabs;
    protected VetoableChangeListener m_lsnrVetoableChanges;
    protected MdStoreListener m_lsnrStoreChanges;
    protected boolean m_bUpdateToServer = true;
    private boolean m_isFromClosingFrame = false;
    private boolean m_isFromClosingApplication = false;

    public WAPropertyFrame(CMetadata oMetadata, String sTitle) {
        this(sTitle);
        this.setMetadataObject(oMetadata);
    }

    public WAPropertyFrame(String sTitle) {
        super(sTitle);
        this.setResizable(true);
        this.m_lsnrVetoableChanges = this.createVetoableChangeListener();
        this.m_lsnrStoreChanges = this.createStoreChangeListener();
        this.m_pnlTabs = this.createMainPanel();
        this.setMainPanel(this.m_pnlTabs);
    }

    protected WATabbedPanel createMainPanel() {
        return new WATabbedPanel();
    }

    @Override
    protected boolean onOK() {
        if (!super.onOK()) {
            return false;
        }
        if (this.m_oMetadata != null && this.isEditable()) {
            int iRC;
            if (Workspace.getWorkspace().isServerStatusCheckEnabled() && ((iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
                return false;
            }
            this.writeMetadata(true);
            return true;
        }
        return true;
    }

    @Override
    protected boolean onApply() {
        if (!super.onApply()) {
            return false;
        }
        if (this.m_oMetadata != null && this.isEditable()) {
            int iRC;
            if (Workspace.getWorkspace().isServerStatusCheckEnabled() && ((iRC = Workspace.getWorkspace().checkMetadataServerStatus(true)) == Workspace.SERVERSTATUS_ERROR || iRC == Workspace.SERVERSTATUS_PAUSED)) {
                this.setDataChanged(true);
                return false;
            }
            this.writeMetadata(false);
        }
        return true;
    }

    protected void writeMetadata(boolean bCleanUp) {
        try {
            if (this.m_oMetadata != null) {
                this.m_oMetadata.setName(this.m_oMetadata.getName());
            }
            if (this.m_oMetadata instanceof Root) {
                WsMetadataUtil.updateModifiedByFor((Root)this.m_oMetadata);
            }
            if (!this.m_bUpdateToServer) {
                this.uninstallStoreListeners();
                this.m_oStore.flushUpdatesToParentStore();
                this.installStoreListeners();
                if (bCleanUp) {
                    this.dispose();
                }
            } else {
                String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
                String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title");
                String str3 = bundle.getString("WriteMetadataProgressIndicator.Msg.Cancel.txt");
                OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), str1, str2, str3);
                request.setDelayBeforeProgressCancelDialog(200);
                Runnable runWrite = new Runnable(){

                    @Override
                    public void run() {
                        WAPropertyFrame.this.doThreadedWrite();
                    }
                };
                request.execute(runWrite);
                Workspace.getDefaultLogger().debug("Finished waiting on write");
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error("Error encountered while writing data" + ge.getMessage());
        }
    }

    public void doThreadedWrite() {
        this.uninstallStoreListeners();
        Workspace.getDefaultLogger().debug("Starting write");
        try {
            this.m_oMetadata.updateMetadataAll();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        Workspace.getDefaultLogger().debug("Finished write");
        this.installStoreListeners();
    }

    @Override
    public void doDefaultCloseAction() {
        this.setIsFromClosingFrame(true);
        super.doDefaultCloseAction();
    }

    @Override
    public void setClosed(boolean b) throws PropertyVetoException {
        this.setIsFromClosingApplication(true);
        super.setClosed(b);
    }

    public boolean isFromClosingFrame() {
        return this.m_isFromClosingFrame;
    }

    public boolean isFromClosingApplication() {
        return this.m_isFromClosingApplication;
    }

    public void setIsFromClosingFrame(boolean isClosing) {
        this.m_isFromClosingFrame = isClosing;
    }

    public void setIsFromClosingApplication(boolean isClosing) {
        this.m_isFromClosingApplication = isClosing;
    }

    @Override
    public void dispose() {
        MdObjectStore store = this.m_oStore;
        this.setMetadataObject(null);
        super.dispose();
        if (store != null) {
            try {
                store.dispose();
                Workspace.getMdFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAPropertyFrame.dispose", ex);
            }
        }
    }

    public void setMetadataObject(CMetadata oMetadata) {
        if (this.m_oStore != null) {
            this.uninstallStoreListeners();
        }
        this.m_oMetadata = oMetadata;
        if (this.m_oMetadata != null) {
            try {
                this.m_oStore = (MdObjectStore)this.m_oMetadata.getObjectStore();
                this.installStoreListeners();
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"WAPropertyFrame.setMetadataObject", ex);
                this.m_oStore = null;
            }
        } else {
            this.m_oStore = null;
        }
        Workspace work = Workspace.getWorkspace();
        boolean bEditable = true;
        if (this.m_oMetadata != null) {
            bEditable = work.isObjectEditable(this.m_oMetadata);
        }
        if (!bEditable) {
            this.setEditable(false);
        }
    }

    public CMetadata getMetadataObject() {
        return this.m_oMetadata;
    }

    public void setUpdateToServer(boolean fUpdate) {
        this.m_bUpdateToServer = fUpdate;
    }

    public boolean getUpdateToServer() {
        return this.m_bUpdateToServer;
    }

    protected VetoableChangeListener createVetoableChangeListener() {
        return new cVetoableChangeListener();
    }

    protected MdStoreListener createStoreChangeListener() {
        return new cStoreChangeListener();
    }

    protected void installStoreListeners() {
        try {
            this.m_oStore.addVetoableChangeListener(this.m_lsnrVetoableChanges);
            this.m_oStore.addMdStoreListener(this.m_lsnrStoreChanges);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WAPropertyFrame.installStoreListeners", ex);
        }
    }

    protected void uninstallStoreListeners() {
        try {
            this.m_oStore.removeVetoableChangeListener(this.m_lsnrVetoableChanges);
            this.m_oStore.removeMdStoreListener(this.m_lsnrStoreChanges);
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"WAPropertyFrame.uninstallStoreListeners", ex);
        }
    }

    public void addTabGroup(WAPropertyTabGroup oTabGroup) {
        if (oTabGroup != null) {
            int nTabs = oTabGroup.getTabCount();
            for (int iTab = 0; iTab < nTabs; ++iTab) {
                WAPropertyTab oTab = oTabGroup.getTabAt(iTab);
                this.addKeyListeners(oTab, this.m_KeyHandler);
                this.m_pnlTabs.addTab(oTabGroup.getTitleAt(iTab), oTabGroup.getTabAt(iTab));
            }
        }
    }

    public void addTab(String sTitle, WAPropertyTab tab) {
        this.addTab(sTitle, null, tab, null);
    }

    public void addTab(String sTitle, Icon icon, WAPropertyTab tab, String sToolTipText) {
        this.m_pnlTabs.addTab(sTitle, icon, tab, sToolTipText);
        this.addKeyListeners(tab, this.m_KeyHandler);
    }

    public void showTab(WAPropertyTab tab) {
        this.m_pnlTabs.setSelectedTab(tab);
    }

    public void removeTabAt(int iTab) {
        WAPropertyTab tab = this.m_pnlTabs.getTabAt(iTab);
        this.removeKeyListeners(tab, this.m_KeyHandler);
        this.m_pnlTabs.removeTabAt(iTab);
    }

    public void removeTab(WAPropertyTab tab) {
        this.removeKeyListeners(tab, this.m_KeyHandler);
        this.m_pnlTabs.removeTab(tab);
    }

    public void removeAllTabs() {
        int nTabs = this.m_pnlTabs.getTabCount();
        for (int iTab = 0; iTab < nTabs; ++iTab) {
            WAPropertyTab tab = this.m_pnlTabs.getTabAt(iTab);
            this.removeKeyListeners(tab, this.m_KeyHandler);
        }
        this.m_pnlTabs.removeAllTabs();
    }

    public int getTabCount() {
        return this.m_pnlTabs.getTabCount();
    }

    protected class cStoreChangeListener
    implements MdStoreListener {
        protected cStoreChangeListener() {
        }

        public void MdObjectsAdded(MdEvent e, List lObjects) {
        }

        public void MdObjectsRemoved(MdEvent e, List lObjects) {
        }

        public void MdObjectsModified(MdEvent e, List lObjects) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (WAPropertyFrame.this.m_oStore != null && WAPropertyFrame.this.m_pnlMain != null) {
                            WAPropertyFrame.this.m_pnlMain.moveDataToView();
                        }
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException(re);
                    }
                }
            });
        }
    }

    protected class cVetoableChangeListener
    implements VetoableChangeListener {
        protected Object m_oNew;
        protected Object m_oOld;

        protected cVetoableChangeListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (e.getNewValue() == this.m_oOld && e.getOldValue() == this.m_oNew) {
                this.m_oNew = null;
                this.m_oOld = null;
                return;
            }
            this.m_oNew = e.getNewValue();
            this.m_oOld = e.getOldValue();
            int iRefresh = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(WAPropertyFrame.RefreshViewsProperty, 0);
            if (iRefresh == 0) {
                return;
            }
            if (iRefresh == 2) {
                throw new PropertyVetoException("Changes always rejected", e);
            }
            int eAnswer = MessageUtil.displayMessage(bundle.getString("Common.RefreshData.Message.txt"), WAPropertyFrame.this.getTitle(), 2, 0);
            if (eAnswer == 1) {
                throw new PropertyVetoException("Changes rejected by user", e);
            }
        }
    }
}

