/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAConnectWizard;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class WAConnectDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected Workspace m_workspace;
    protected WorkspaceFile m_workspaceFile;
    protected WorkspaceFile m_appDefaultsFile;
    protected HashMap m_hmWorkspaces;
    protected boolean m_bCreateNewWorkspace;
    protected boolean m_bRepositoryRequired;
    private boolean m_bAddRepositoryEnabled;
    private boolean m_showProjectPanel;
    protected JLabel m_lblNewImage;
    protected JLabel m_lblOpenImage;
    protected JRadioButton m_radNew;
    protected JRadioButton m_radOpen;
    protected WAComboBox m_cmbWorkspace;
    protected JButton m_btnEdit;
    protected JButton m_btnDelete;
    protected JCheckBox m_cbReload;
    protected cWorkspaceComboActionListener m_workspaceComboActionListener;
    private static WAdminResource bundle = WAdminResource.getBundle(WAConnectDialog.class);

    public WAConnectDialog(Frame frame, String title) {
        this(frame, false);
    }

    public WAConnectDialog(Frame frame) {
        this(frame, false);
    }

    public WAConnectDialog(Frame frame, boolean bRepositoryRequired) {
        this(frame, bRepositoryRequired, true);
    }

    public WAConnectDialog(Frame frame, boolean bRepositoryRequired, boolean bAddRepositoryEnabled) {
        this(frame, bRepositoryRequired, bAddRepositoryEnabled, true);
    }

    public WAConnectDialog(Frame frame, boolean bRepositoryRequired, boolean bAddRepositoryEnabled, boolean showProjectPanel) {
        super(frame, bundle.getString("ConnectDialog.Title.txt"), true);
        this.m_bRepositoryRequired = bRepositoryRequired;
        this.m_bAddRepositoryEnabled = bAddRepositoryEnabled;
        this.m_showProjectPanel = showProjectPanel;
        this.setResizable(true);
        this.setHelpProduct("newworkspace");
        this.setHelpTopic("metaserv");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_workspace = Workspace.getWorkspace();
        this.m_workspaceFile = this.m_workspace.getWorkspaceFile();
        this.m_appDefaultsFile = this.m_workspace.getAppDefaultsFile();
        this.m_radNew = new JRadioButton(bundle.getString("ConnectDialog.radNew.txt"));
        this.m_radOpen = new JRadioButton(bundle.getString("ConnectDialog.radOpen.txt"));
        this.m_cmbWorkspace = new WAComboBox();
        this.m_btnEdit = new JButton(bundle.getString("ConnectDialog.btnEdit.txt"));
        this.m_btnDelete = new JButton(bundle.getString("ConnectDialog.btnDelete.txt"));
        this.m_cbReload = new JCheckBox(bundle.getString("ConnectDialog.cbReload.txt"));
        this.m_cmbWorkspace.setSorted(true);
        this.m_cmbWorkspace.setPrototypeDisplayValue("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM");
        this.m_radNew.setMnemonic(bundle.getString("ConnectDialog.radNew.mnem").charAt(0));
        this.m_radOpen.setMnemonic(bundle.getString("ConnectDialog.radOpen.mnem").charAt(0));
        this.m_btnEdit.setMnemonic(bundle.getString("ConnectDialog.btnEdit.mnem").charAt(0));
        this.m_btnDelete.setMnemonic(bundle.getString("ConnectDialog.btnDelete.mnem").charAt(0));
        this.m_cbReload.setMnemonic(bundle.getString("ConnectDialog.cbReload.mnem").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_radNew);
        bg.add(this.m_radOpen);
        this.m_radOpen.setSelected(true);
        this.m_bCreateNewWorkspace = false;
        this.m_cbReload.setSelected(false);
        this.m_workspaceComboActionListener = new cWorkspaceComboActionListener();
        this.m_radNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WAConnectDialog.this.m_cmbWorkspace.setEnabled(false);
                WAConnectDialog.this.m_btnEdit.setEnabled(false);
                WAConnectDialog.this.m_btnDelete.setEnabled(false);
                WAConnectDialog.this.m_cbReload.setEnabled(false);
                WAConnectDialog.this.m_bCreateNewWorkspace = true;
            }
        });
        this.m_radOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WAConnectDialog.this.m_cmbWorkspace.setEnabled(true);
                WAConnectDialog.this.m_btnEdit.setEnabled(true);
                WAConnectDialog.this.m_btnDelete.setEnabled(true);
                WAConnectDialog.this.m_cbReload.setEnabled(true);
                WAConnectDialog.this.m_bCreateNewWorkspace = false;
            }
        });
        this.m_cmbWorkspace.addActionListener(this.m_workspaceComboActionListener);
        this.m_btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WAConnectWizard connectWiz = new WAConnectWizard(WAConnectDialog.this, true, WAConnectDialog.this.m_bRepositoryRequired, WAConnectDialog.this.m_bAddRepositoryEnabled, WAConnectDialog.this.m_showProjectPanel, WAConnectDialog.this.m_cbReload.isSelected());
                WorkspaceUtil.centerFourth(connectWiz);
                connectWiz.show();
                if (connectWiz.getReturnValue() == 3 || connectWiz.getReturnValue() == 1) {
                    WAConnectDialog.this.doDataExchange(false);
                }
            }
        });
        this.m_btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int iChoice = MessageUtil.displayMessage(bundle.formatString("ConnectDialog.DeleteWorkspace.txt", WAConnectDialog.this.m_workspaceFile.getPropertyString("Name")), bundle.getString("ConnectDialog.DeleteWorkspace.Title.txt"), 3, 0);
                if (iChoice == 0) {
                    boolean brc;
                    WAConnectDialog.this.m_workspaceFile.closeExisting();
                    String strFilename = (String)WAConnectDialog.this.m_hmWorkspaces.get(WAConnectDialog.this.m_cmbWorkspace.getSelectedItem());
                    File workspaceFile = new File(strFilename);
                    if (workspaceFile.exists() && !(brc = workspaceFile.delete())) {
                        MessageUtil.displayMessage(bundle.getString("ConnectDialog.DeleteWorkspace.Error.txt"), 0);
                    }
                    WAConnectDialog.this.doDataExchange(false);
                }
            }
        });
    }

    @Override
    protected void layoutWidgets() {
        WAPanel pnlWorkspace = new WAPanel();
        pnlWorkspace.setLayout(new GridBagLayout());
        pnlWorkspace.add((Component)this.m_cmbWorkspace, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        pnlWorkspace.add((Component)this.m_btnEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        pnlWorkspace.add((Component)this.m_btnDelete, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        pnlWorkspace.add((Component)this.m_cbReload, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        WAPanel pnlMain = new WAPanel();
        pnlMain.setLayout(new GridBagLayout());
        pnlMain.add((Component)this.m_radNew, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        pnlMain.add((Component)this.m_radOpen, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        pnlMain.add((Component)pnlWorkspace, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 22, 5, 5), 0, 0));
        this.setMainPanel(pnlMain);
        super.layoutWidgets();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            String strLastWorkspace;
            this.m_cmbWorkspace.removeActionListener(this.m_workspaceComboActionListener);
            this.m_cmbWorkspace.removeAllItems();
            this.m_cmbWorkspace.addActionListener(this.m_workspaceComboActionListener);
            File workspaceDir = new File(this.m_appDefaultsFile.getPropertyString("WorkspacePath"));
            if (workspaceDir.isDirectory()) {
                int i;
                this.m_hmWorkspaces = new HashMap();
                ArrayList<String> alWorkspaceNames = new ArrayList<String>();
                String[] arrWorkspaceFiles = workspaceDir.list();
                for (i = 0; i < arrWorkspaceFiles.length; ++i) {
                    String strFilename = workspaceDir.getAbsolutePath() + System.getProperty("file.separator") + arrWorkspaceFiles[i];
                    WorkspaceFile workspaceFile = new WorkspaceFile(strFilename);
                    String strWorkspaceName = workspaceFile.getPropertyString("Name");
                    String strWorkspaceHost = workspaceFile.getPropertyString("host");
                    String strWorkspacePort = workspaceFile.getPropertyString("port");
                    if (strWorkspaceName.compareTo("") == 0 || strWorkspaceHost.compareTo("") == 0 || strWorkspacePort.compareTo("") == 0) continue;
                    alWorkspaceNames.add(strWorkspaceName);
                    this.m_hmWorkspaces.put(strWorkspaceName, strFilename);
                }
                if (alWorkspaceNames.size() == 0) {
                    this.m_bCreateNewWorkspace = true;
                    this.m_radNew.setSelected(true);
                    this.m_radOpen.setEnabled(false);
                    this.m_cmbWorkspace.setEnabled(false);
                    this.m_btnEdit.setEnabled(false);
                    this.m_btnDelete.setEnabled(false);
                    this.m_cbReload.setEnabled(false);
                    return true;
                }
                Collections.sort(alWorkspaceNames);
                for (i = 0; i < alWorkspaceNames.size(); ++i) {
                    this.m_cmbWorkspace.addItem(alWorkspaceNames.get(i));
                }
            }
            if (this.m_hmWorkspaces.containsValue(strLastWorkspace = this.m_appDefaultsFile.getPropertyString("LastWorkspace"))) {
                String strWorkspaceName;
                WorkspaceFile tmpWorkspaceFile = new WorkspaceFile(strLastWorkspace);
                if (tmpWorkspaceFile.isOpen() && (strWorkspaceName = tmpWorkspaceFile.getPropertyString("Name")).length() > 0) {
                    this.m_cmbWorkspace.setSelectedItem(strWorkspaceName);
                }
            } else if (this.m_cmbWorkspace.getItemCount() > 0) {
                this.m_cmbWorkspace.setSelectedIndex(0);
            }
            this.m_workspaceFile.openExisting((String)this.m_hmWorkspaces.get(this.m_cmbWorkspace.getSelectedItem()));
            this.m_cbReload.setSelected(this.m_appDefaultsFile.getPropertyBoolean("ReloadLastWorkspace", false));
        } else if (this.m_radOpen.isSelected()) {
            this.m_appDefaultsFile.setPropertyString("LastWorkspace", (String)this.m_hmWorkspaces.get(this.m_cmbWorkspace.getSelectedItem()));
            this.m_appDefaultsFile.setPropertyBoolean("ReloadLastWorkspace", this.m_cbReload.isSelected());
            this.m_appDefaultsFile.saveExisting();
        }
        return true;
    }

    @Override
    public boolean validateData() {
        if (this.m_radOpen.isSelected() && (this.m_workspaceFile.getPropertyString("host").compareTo("") == 0 || this.m_workspaceFile.getPropertyString("port").compareTo("") == 0)) {
            this.m_cmbWorkspace.requestFocus();
            MessageUtil.displayMessage(bundle.getString("ConnectDialog.WorkspaceError.txt"), 0);
            return false;
        }
        return true;
    }

    public boolean getCreateNewWorkspace() {
        return this.m_bCreateNewWorkspace;
    }

    public void setAddRepositoryEnabledOnEdit(boolean bAddRepositoryEnabled) {
        this.m_bAddRepositoryEnabled = bAddRepositoryEnabled;
    }

    public boolean isProjectPanelEnabled() {
        return this.m_showProjectPanel;
    }

    class cWorkspaceComboActionListener
    implements ActionListener {
        cWorkspaceComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WAConnectDialog.this.m_workspaceFile.openExisting((String)WAConnectDialog.this.m_hmWorkspaces.get(WAConnectDialog.this.m_cmbWorkspace.getSelectedItem()));
        }
    }
}

