/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.WorkTable;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class TransformUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformUtil.class);

    public static String createWorkTableName() {
        return TransformUtil.createWorkTableName(0);
    }

    public static String createWorkTableName(int offset) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        long time = System.currentTimeMillis() / 100L + (long)(offset * 10);
        boolean done = false;
        StringBuffer base36 = new StringBuffer("");
        do {
            int remainder = (int)(time % 36L);
            base36.insert(0, cArray[remainder]);
            if ((time /= 36L) != 0L) continue;
            done = true;
        } while (!done);
        return base36.insert(0, 'W').substring(0);
    }

    public static boolean isXMLSASTable(DataTable table) throws MdException, RemoteException {
        if (!table.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
            return false;
        }
        RelationalSchema schema = table.getTablePackage();
        if (schema == null) {
            return false;
        }
        if (table instanceof WorkTable && schema == null) {
            return false;
        }
        if (!(schema instanceof SASLibrary)) {
            return false;
        }
        return ((SASLibrary)schema).getEngine().toUpperCase().indexOf("XML") > -1;
    }

    public static String getDBMSProductName(PhysicalTable table) throws MdException, RemoteException {
        RelationalSchema schema = table.getTablePackage();
        if (table instanceof WorkTable && schema == null) {
            return "SAS";
        }
        if (schema == null) {
            return null;
        }
        if (schema instanceof SASLibrary) {
            String libEng = ((SASLibrary)schema).getEngine();
            if (libEng.length() == 0 || !libEng.equalsIgnoreCase("SPDE")) {
                return "SAS";
            }
            return "SPDE";
        }
        AssociationList dcList = schema.getDeployedComponents();
        if (dcList == null || dcList.size() <= 0) {
            throw new MdException(bundle.getString("TransformUtil.NoDeployedComponent.msg.txt"));
        }
        DeployedComponent dc = (DeployedComponent)dcList.get(0);
        if (dc == null) {
            throw new MdException(bundle.getString("TransformUtil.NoDeployedComponent.msg.txt"));
        }
        String productName = dc.getProductName();
        return productName;
    }

    public static String getClientDBMSProductName(PhysicalTable table) throws MdException, RemoteException {
        RelationalSchema schema = table.getTablePackage();
        if (table instanceof WorkTable && schema == null) {
            return "SAS";
        }
        if (schema == null) {
            return null;
        }
        return TransformUtil.getClientDBMSProductName(schema);
    }

    public static String getClientDBMSProductName(RelationalSchema schema) throws MdException, RemoteException {
        AssociationList dcList;
        if (schema == null) {
            throw new IllegalArgumentException("schema cannot be null");
        }
        if (schema instanceof SASLibrary) {
            String libEng = ((SASLibrary)schema).getEngine();
            if (libEng.length() == 0 || !libEng.equalsIgnoreCase("SPDE")) {
                return "SAS";
            }
            return "SPDE";
        }
        SASLibrary sasLib = null;
        if (schema instanceof DatabaseSchema) {
            sasLib = LibraryUtil.getSASLibrary(schema);
            if (sasLib == null) {
                return null;
            }
            dcList = sasLib.getDeployedComponents();
            if (dcList != null) {
                for (int i = 0; i < dcList.size(); ++i) {
                    ServerComponent iSC = (ServerComponent)dcList.get(i);
                    if (!iSC.getClassIdentifier().equals("SHARE")) continue;
                    return "REMOTE";
                }
            }
        }
        if ((dcList = schema.getDeployedComponents()) == null || dcList.size() <= 0) {
            throw new MdException(bundle.getString("TransformUtil.NoDeployedComponent.msg.txt"));
        }
        DeployedComponent dc = (DeployedComponent)dcList.get(0);
        if (dc == null) {
            throw new MdException(bundle.getString("TransformUtil.NoDeployedComponent.msg.txt"));
        }
        String productName = dc.getProductName();
        return productName;
    }
}

