/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.DNDShortcut;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsBasicCaret;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ShortcutBar
extends JPanel
implements DropTargetListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected JScrollPane m_scrollPane;
    protected JPanel m_panel;
    protected int m_selectedIndex;
    protected boolean m_bSelectFirstItem = true;
    static WAdminResource bundle = WAdminResource.getBundle(ShortcutBar.class);
    protected Vector m_items;
    protected Vector m_listeners;
    protected Vector m_drawPoints;
    protected DropTarget m_dropTarget;
    private int m_y;
    private int m_divider_y;
    private final int DROP_TARGET_ICON_HEIGHT = 11;
    private final int DROP_TARGET_SIDE_MARGIN = 10;
    private boolean m_bEnableDrag;

    public ShortcutBar() {
        this(true);
    }

    public ShortcutBar(boolean enableDrag) {
        this.m_bEnableDrag = enableDrag;
        this._initialize();
        this._layoutWidgets();
    }

    public void addItem(ImageIcon icon, Object object) {
        this.m_items.add(new Bar(icon, object.toString(), this.m_items.size()));
        this.refresh();
    }

    public void addItem(ImageIcon icon, String title) {
        this.m_items.add(new Bar(icon, title, this.m_items.size()));
        this.refresh();
    }

    public void addItem(Object object) {
        Separator separator = null;
        if (object == null) {
            separator = new Separator();
        }
        if (object instanceof Separator) {
            separator = (Separator)object;
        }
        if (separator != null) {
            this.m_items.add(separator);
            this.refresh();
        }
    }

    public void addItem(String title) {
        this.m_items.add(new JButton(title));
        this.refresh();
    }

    public Vector getItems() {
        return this.m_items;
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setSelectedIndex(int index) {
        this.m_selectedIndex = index;
    }

    public synchronized void addItemListener(ItemListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        this.m_listeners.addElement(listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.removeElement(listener);
    }

    public void fireItemChange(ItemEvent evt) {
        if (this.m_listeners != null) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                ItemListener listener = (ItemListener)this.m_listeners.elementAt(i);
                listener.itemStateChanged(evt);
            }
        }
    }

    protected void refresh() {
        this.removeAll();
        this.m_panel.removeAll();
        this._layoutWidgets();
    }

    protected void _initialize() {
        this.m_items = new Vector();
        this.m_drawPoints = new Vector();
        this.m_panel = new JPanel();
        this.m_panel.setBackground(SystemColor.control);
        this.m_scrollPane = new JScrollPane(this.m_panel, 20, 31);
        this.m_scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_dropTarget = new DropTarget(this.m_panel, this);
        this.m_dropTarget.setActive(true);
        this.m_dropTarget.setDefaultActions(2);
        this.m_y = 0;
        this.m_divider_y = -1;
        this.addMouseListener(this);
        this.setRequestFocusEnabled(true);
    }

    protected void _layoutWidgets() {
        this._layoutPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.gridheight = 0;
        gbc.fill = 1;
        gridBagLayout.setConstraints(this.m_scrollPane, gbc);
        this.add(this.m_scrollPane);
    }

    protected void _layoutPanel() {
        GridBagConstraints gbc;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_panel.setLayout(gridBagLayout);
        int gridy = 0;
        for (int i = 0; i < this.m_items.size(); ++i) {
            if (this.m_items.elementAt(i) instanceof JButton) {
                JButton groupTitleButton = (JButton)this.m_items.elementAt(i);
                groupTitleButton.setMargin(new Insets(0, 0, 0, 0));
                groupTitleButton.setRequestFocusEnabled(true);
                gbc = new GridBagConstraints();
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.gridwidth = 0;
                gbc.fill = 2;
                gbc.anchor = 11;
                gridBagLayout.setConstraints(groupTitleButton, gbc);
                this.m_panel.add(groupTitleButton);
            }
            if (this.m_items.elementAt(i) instanceof Bar) {
                Bar bar = (Bar)this.m_items.elementAt(i);
                bar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                gbc = new GridBagConstraints();
                gbc.gridy = gridy;
                gbc.anchor = 11;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                Insets insets = i == 0 ? new Insets(13, 0, 6, 0) : new Insets(5, 0, 6, 0);
                gbc.insets = insets;
                gridBagLayout.setConstraints(bar, gbc);
                this.m_panel.add(bar);
                bar.addMouseListener(this);
                bar.m_button.addMouseListener(this);
                bar.m_textArea.addMouseListener(this);
                ++gridy;
            }
            if (!(this.m_items.elementAt(i) instanceof Separator)) continue;
            Separator separator = (Separator)this.m_items.elementAt(i);
            gbc = new GridBagConstraints();
            gbc.gridy = gridy++;
            gbc.anchor = 11;
            gbc.insets = new Insets(4, 0, 6, 0);
            gridBagLayout.setConstraints(separator, gbc);
            this.m_panel.add(separator);
        }
        JPanel eaterpanel = new JPanel();
        eaterpanel.setPreferredSize(new Dimension(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridy = gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gridBagLayout.setConstraints(eaterpanel, gbc);
        this.m_panel.add(eaterpanel);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        int i = 0;
        Bar b = null;
        JComponent next_bar = null;
        Point p = null;
        this.m_y = (int)dtde.getLocation().getY();
        for (i = 0; i < this.m_items.size(); ++i) {
            b = (Bar)this.m_items.get(i);
            p = b.getLocation();
            if (!((double)this.m_y < p.getY())) continue;
            next_bar = b;
            break;
        }
        this.m_divider_y = next_bar == null ? (int)(p.getY() + (double)b.getSize().height + 5.0) : next_bar.getY() - 5;
        this.m_divider_y -= this.m_scrollPane.getVerticalScrollBar().getValue();
        if (this.m_bEnableDrag) {
            this.drawDivider(this.m_divider_y, true);
        } else {
            this.drawDivider(this.m_divider_y, false);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.m_divider_y != -1) {
            this.drawDivider(this.m_divider_y, false);
            this.m_divider_y = -1;
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transfer = dtde.getTransferable();
            if (transfer.isDataFlavorSupported(DNDShortcut.dndShortcutDataFlavor)) {
                int i;
                DNDShortcut dndShortcut = (DNDShortcut)transfer.getTransferData(DNDShortcut.dndShortcutDataFlavor);
                String strName = dndShortcut.getName();
                Bar tempbar = null;
                for (i = 0; i < this.m_items.size(); ++i) {
                    if (!((Bar)this.m_items.elementAt(i)).getCaption().equals(strName)) continue;
                    tempbar = (Bar)this.m_items.elementAt(i);
                    break;
                }
                if (tempbar == null) {
                    dtde.rejectDrop();
                    return;
                }
                Point loc = dtde.getLocation();
                for (i = 0; i < this.m_items.size(); ++i) {
                    Bar b = (Bar)this.m_items.elementAt(i);
                    if (loc.getY() < (double)b.getY()) break;
                }
                this.m_items.add(i, new Bar(tempbar.getIcon(), tempbar.getCaption(), tempbar.getIndex()));
                this.m_items.remove(tempbar);
                this.refresh();
                dtde.dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void drawDivider(int y, boolean draw) {
        Graphics g = this.m_scrollPane.getViewport().getGraphics();
        int width = (int)this.m_scrollPane.getViewportBorderBounds().getWidth();
        int[] left_x = new int[]{9, 9, 20};
        int[] left_y = new int[]{y - 5, y + 5, y};
        int[] right_x = new int[]{width - 10, width - 10, width - 21};
        int[] right_y = new int[]{y - 5, y + 5, y};
        if (draw) {
            g.setColor(Color.black);
        } else {
            g.setColor(SystemColor.control);
        }
        g.drawLine(9, y, width - 11, y);
        g.fillPolygon(left_x, left_y, 3);
        g.fillPolygon(right_x, right_y, 3);
    }

    public class cShortcutCaret
    extends WsBasicCaret {
        private static final long serialVersionUID = 1L;

        @Override
        public void adjustVisibility(Rectangle r) {
        }
    }

    class BarButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        protected int m_index;
        private DragSource m_dragSource;

        public BarButton(ImageIcon icon) {
            super(icon);
        }

        public void setIndex(int index) {
            this.m_index = index;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void initDragSource() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, (DragGestureListener)((Object)this.getParent()));
        }
    }

    class Separator
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JButton m_button;

        public Separator() {
            this.setBackground(SystemColor.control);
            this._initialize();
            this._layoutWidgets();
        }

        protected void _initialize() {
            this.m_button = new JButton();
            this.m_button.setBackground(Color.gray);
            this.m_button.setMargin(new Insets(0, 0, 0, 0));
            this.m_button.setBorder(BorderFactory.createEtchedBorder(0));
            this.m_button.setRequestFocusEnabled(true);
            this.m_button.setEnabled(false);
            this.m_button.setPreferredSize(new Dimension(73, 3));
        }

        protected void _layoutWidgets() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 12, 0, 12);
            gridBagLayout.setConstraints(this.m_button, gbc);
            this.add(this.m_button);
        }
    }

    class Bar
    extends JPanel
    implements DragSourceListener,
    DragGestureListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected BarButton m_button;
        protected ImageIcon m_icon;
        protected WATextArea m_textArea;
        protected String m_text;
        protected int m_buttonIndex;
        protected DragSource m_dragSource;
        protected boolean m_bInButton;

        public Bar(ImageIcon icon, String text, int buttonIndex) {
            this.m_text = text;
            this.m_icon = icon;
            this.m_buttonIndex = buttonIndex;
            this.m_bInButton = false;
            if (ShortcutBar.this.m_bEnableDrag) {
                this.m_dragSource = new DragSource();
                this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            }
            this._initialize();
            this._layoutWidgets();
        }

        public int getIndex() {
            return this.m_buttonIndex;
        }

        public void setIndex(int i) {
            this.m_buttonIndex = i;
        }

        public String getCaption() {
            return this.m_text;
        }

        public ImageIcon getIcon() {
            return this.m_icon;
        }

        protected WATextArea getTextArea() {
            return this.m_textArea;
        }

        protected void onButtonClick(int index) {
            ShortcutBar.this.setSelectedIndex(index);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShortcutBar.this.fireItemChange(new ItemEvent(Bar.this.m_button, 701, null, 1));
                }
            });
        }

        protected void _initialize() {
            this.m_textArea = new WATextArea(this.m_text);
            this.m_textArea.setBehavior(1);
            this.m_textArea.setAutosize(false);
            String centeredText = this.getCenteredText(this.m_textArea);
            this.m_textArea.setText(centeredText);
            this.m_textArea.setCaret(new cShortcutCaret());
            this.m_textArea.setWrapStyleWord(true);
            this.m_textArea.setLineWrap(true);
            this.m_textArea.setForeground(SystemColor.controlText);
            this.m_textArea.setBackground(SystemColor.control);
            ShortcutBar.this.m_bSelectFirstItem = false;
            this.m_textArea.addMouseListener(this);
            this.m_button = new BarButton(this.m_icon);
            this.m_button.setIndex(this.m_buttonIndex);
            this.m_button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.m_button.setBackground(SystemColor.control);
            this.m_button.setRequestFocusEnabled(true);
            this.m_button.addMouseListener(this);
            this.m_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Bar.this.onButtonClick(Bar.this.m_button.getIndex());
                }
            });
        }

        protected void _layoutWidgets() {
            this.setBackground(SystemColor.control);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            int gridy = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = gridy++;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 2, 0);
            gridBagLayout.setConstraints(this.m_button, gbc);
            this.add(this.m_button);
            this.m_button.initDragSource();
            gbc = new GridBagConstraints();
            gbc.gridy = gridy++;
            gbc.fill = 2;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(this.m_textArea, gbc);
            this.add(this.m_textArea);
            this.m_textArea.initDragSource();
        }

        protected String getCenteredText(WATextArea textArea) {
            String origText = textArea.getText();
            String retText = "";
            String newLineText = "";
            int width = textArea.getWidth();
            FontMetrics fontMetrics = this.getFontMetrics(textArea.getFont());
            StringTokenizer tokenizer = new StringTokenizer(origText);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (fontMetrics.stringWidth(newLineText = newLineText + token + " ") > width) {
                    int spaceIndex = (newLineText = newLineText.trim()).lastIndexOf(" ");
                    if (spaceIndex == -1) {
                        spaceIndex = newLineText.length();
                        newLineText = newLineText.substring(0, spaceIndex) + "\n";
                    } else {
                        newLineText = newLineText.substring(0, spaceIndex) + "\n" + newLineText.substring(spaceIndex + 1);
                    }
                    int newLineCharIndex = newLineText.indexOf("\n");
                    if (retText.indexOf("\n") != -1) {
                        retText = retText.substring(0, retText.lastIndexOf("\n") + 1);
                        retText = retText + newLineText;
                    } else {
                        retText = newLineText;
                    }
                    newLineText = newLineText.substring(newLineCharIndex + 1) + " ";
                    continue;
                }
                int newLineCharIndex = retText.lastIndexOf("\n");
                retText = retText.substring(0, newLineCharIndex + 1);
                retText = retText + newLineText;
            }
            String centeredText = "";
            if (!retText.endsWith(" ") && !retText.endsWith("\n")) {
                retText = retText + " ";
            }
            while (retText.indexOf("\n") != -1 || retText.indexOf(" ") != -1) {
                int index = retText.indexOf("\n");
                boolean bLastWord = false;
                if (index == retText.length() - 1) {
                    bLastWord = true;
                }
                if (index == -1) {
                    index = retText.lastIndexOf(" ");
                    bLastWord = true;
                }
                String textWithin = retText.substring(0, index);
                retText = retText.substring(index + 1);
                while (fontMetrics.stringWidth(textWithin) + fontMetrics.stringWidth("   ") <= textArea.getWidth()) {
                    textWithin = " " + textWithin + " ";
                }
                if (!bLastWord) {
                    centeredText = centeredText + textWithin + "\n";
                    continue;
                }
                centeredText = centeredText + textWithin;
            }
            return centeredText;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (ShortcutBar.this.m_bEnableDrag) {
                DNDShortcut shortcutValue = new DNDShortcut(this.getCaption());
                this.m_dragSource.startDrag(dge, DragSource.DefaultMoveDrop, shortcutValue, this);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.m_bInButton = true;
            this.m_button.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.m_bInButton = false;
            this.m_button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.m_button.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.m_bInButton) {
                this.m_button.setBorder(BorderFactory.createRaisedBevelBorder());
                if (e.getSource() instanceof WATextArea && e.getClickCount() == 1 && e.getButton() == 1) {
                    this.m_button.requestFocus();
                    this.onButtonClick(this.m_button.getIndex());
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.m_textArea.getWidth() + 20 != ShortcutBar.this.getWidth()) {
                this.m_textArea.setSize(ShortcutBar.this.getWidth() - 20, this.m_textArea.getHeight());
                this.m_textArea.setText(this.getCenteredText(this.m_textArea));
            }
            super.paintComponent(g);
        }
    }
}

