/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import com.sas.workspace.Workspace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropertyHandler {
    protected Root m_meta = null;
    protected PropertySet m_propSet = null;
    protected String m_setRole = "";
    protected boolean m_usePropertySet = true;
    protected boolean m_useSetProperties = false;
    public static final String VALUE_TRUE = "YES";
    public static final String VALUE_FALSE = "NO";
    public static final String PROPERTY_NAME_SYSTEM_OPTIONS = "SystemOptions";
    public static final String PROPERTY_ROLE_SYSTEM_OPTIONS = "SYSTEM";

    public PropertyHandler() {
    }

    public PropertyHandler(Root meta) {
        this.m_meta = meta;
    }

    public PropertyHandler(Root meta, String setRole) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_setRole = setRole;
        this.m_propSet = this.getPropertySet();
    }

    public PropertyHandler(Root meta, String setRole, boolean useSetProperties) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_setRole = setRole;
        this.m_useSetProperties = useSetProperties;
        this.m_propSet = this.getPropertySet();
    }

    public PropertyHandler(Root meta, boolean usePropertySet) throws MdException, RemoteException {
        this.m_meta = meta;
        this.m_usePropertySet = usePropertySet;
        this.m_propSet = this.getPropertySet();
    }

    public void setParent(Root meta) {
        this.m_meta = meta;
    }

    public Root getParent() throws MdException, RemoteException {
        return this.m_meta;
    }

    public void setPropertySet(PropertySet set) {
        this.m_propSet = set;
    }

    public void setSetRole(String setRole) throws MdException, RemoteException {
        this.m_setRole = setRole;
        this.m_propSet = this.getPropertySet();
    }

    public String getSetRole() {
        return this.m_setRole;
    }

    public void setUsePropertySet(boolean usePropertySet) throws MdException, RemoteException {
        this.m_usePropertySet = usePropertySet;
    }

    public boolean getUsePropertySet() {
        return this.m_usePropertySet;
    }

    public void setUseSetProperties(boolean useSetProperties) throws MdException, RemoteException {
        this.m_useSetProperties = useSetProperties;
    }

    public boolean getUseSetProperties() {
        return this.m_useSetProperties;
    }

    public PropertySet getPropertySet() throws MdException, RemoteException {
        if (this.m_meta == null || !this.m_usePropertySet) {
            return null;
        }
        AssociationList lSets = this.m_meta.getPropertySets();
        PropertySet propSet = null;
        if (lSets == null) {
            return propSet;
        }
        for (int i = 0; i < lSets.size(); ++i) {
            if (((PropertySet)lSets.get(i)).getSetRole().compareToIgnoreCase(this.m_setRole) != 0) continue;
            propSet = (PropertySet)lSets.get(i);
            break;
        }
        return propSet;
    }

    public AssociationList getPropertyList() throws MdException, RemoteException {
        if ((this.m_useSetProperties || this.m_usePropertySet) && this.m_propSet == null) {
            return null;
        }
        AssociationList lProps = this.m_useSetProperties ? this.m_propSet.getSetProperties() : (this.m_usePropertySet ? this.m_propSet.getProperties() : this.m_meta.getProperties());
        return lProps;
    }

    public PropertyGroup createPropertyGroup(String groupName) throws MdException, RemoteException {
        if (this.m_meta == null || this.m_propSet == null || !this.m_usePropertySet) {
            return null;
        }
        PropertyGroup propGroup = this.getPropertyGroup(groupName);
        if (propGroup == null) {
            propGroup = (PropertyGroup)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_meta.getObjectStore(), null, groupName, "PropertyGroup", this.m_meta.getRepositoryID(), null);
        }
        return propGroup;
    }

    public PropertyGroup getPropertyGroup(String groupName) throws MdException, RemoteException {
        if (this.m_meta == null || this.m_propSet == null) {
            return null;
        }
        AssociationList lGroups = this.m_propSet.getGroups();
        PropertyGroup propGroup = null;
        if (lGroups == null) {
            return propGroup;
        }
        for (int i = 0; i < lGroups.size(); ++i) {
            if (((PropertyGroup)lGroups.get(i)).getName().compareToIgnoreCase(groupName) != 0) continue;
            propGroup = (PropertyGroup)lGroups.get(i);
            break;
        }
        return propGroup;
    }

    public PropertySet createPropertySet() throws MdException, RemoteException {
        if (this.m_meta == null || !this.m_usePropertySet) {
            return null;
        }
        if (this.m_propSet == null) {
            this.m_propSet = this.getPropertySet();
            this.createPropertySet(false);
        }
        return this.m_propSet;
    }

    public PropertySet createPropertySet(boolean createNew) throws MdException, RemoteException {
        if (createNew || this.m_propSet == null) {
            this.m_propSet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_meta.getObjectStore(), null, this.m_setRole, "PropertySet", this.m_meta.getRepositoryID(), null);
            this.m_propSet.setSetRole(this.m_setRole);
            this.m_meta.getPropertySets(false).add((Object)this.m_propSet);
        }
        return this.m_propSet;
    }

    public PropertySet getHandlerPropertySet() {
        return this.m_propSet;
    }

    public String getOptionsString() throws MdException, RemoteException {
        return this.getOptionsString("");
    }

    public String getOptionsString(String propertyRole) throws MdException, RemoteException {
        AssociationList lProps;
        if (this.m_propSet == null && this.m_usePropertySet) {
            this.m_propSet = this.getPropertySet();
            if (this.m_propSet == null) {
                return "";
            }
        }
        if ((lProps = this.getPropertyList()) == null) {
            return "";
        }
        StringBuffer propList = new StringBuffer();
        int stringLength = 50;
        for (int i = 0; i < lProps.size(); ++i) {
            String defaultValue;
            Property iProp = (Property)lProps.get(i);
            if (iProp.getPropertyRole().compareToIgnoreCase(propertyRole) != 0 && propertyRole.trim().compareTo("") != 0 || (defaultValue = this.getDefaultValue(iProp)).trim().compareToIgnoreCase("") == 0 || defaultValue.toUpperCase().startsWith("DEFAULT")) continue;
            if (propList.length() > stringLength) {
                propList.append("\n   ");
                stringLength = 50;
            }
            if (iProp.getUseValueOnly() != 0) {
                propList.append(" ").append(defaultValue);
                continue;
            }
            if (iProp.getUseValueOnly() != 0) continue;
            String delim = iProp.getDelimiter();
            if (delim.trim().compareTo("") == 0) {
                delim = "=";
            }
            propList.append(" ").append(iProp.getPropertyName()).append(delim).append(defaultValue);
        }
        if (propList.length() > 0) {
            return propList.substring(1);
        }
        return "";
    }

    public String getSpecificOptionValue(String propertyName) throws MdException, RemoteException {
        return this.getSpecificOptionValue(propertyName, null);
    }

    public String getSpecificOptionValue(String propertyName, String defaultValue) throws MdException, RemoteException {
        Property iProp = this.getSpecificProperty(propertyName);
        String returnValue = "";
        if (iProp != null) {
            returnValue = this.getDefaultValue(iProp);
        } else if (defaultValue != null) {
            returnValue = defaultValue;
        }
        return returnValue;
    }

    protected String getDefaultValue(Property iProp) {
        String returnValue = "";
        try {
            String propertyDefaultValue = iProp.getDefaultValue();
            PromptDefinitionReference defReference = null;
            try {
                defReference = (PromptDefinitionReference)PropertyHandler.getObjectForXML(propertyDefaultValue);
                Object value = defReference.getValue();
                if (value != null) {
                    returnValue = value.toString();
                }
            }
            catch (Exception exc) {
                returnValue = propertyDefaultValue.trim();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return returnValue;
    }

    public Property getSpecificProperty(String propertyName) throws MdException, RemoteException {
        if (this.m_propSet == null && this.m_usePropertySet) {
            this.m_propSet = this.getPropertySet();
            if (this.m_propSet == null) {
                return null;
            }
        }
        AssociationList lProps = this.getPropertyList();
        Property iProperty = null;
        if (lProps != null) {
            for (int i = 0; i < lProps.size(); ++i) {
                Property iProp = (Property)lProps.get(i);
                if (iProp.getPropertyName().compareToIgnoreCase(propertyName) != 0) continue;
                iProperty = iProp;
                break;
            }
        }
        return iProperty;
    }

    public void setSpecificProperty(String option, String value) throws MdException, RemoteException {
        this.setSpecificProperty(option, value, null, null, -1, null, 12);
    }

    public void setSpecificProperty(String option, String value, String propertyRole, int sqlType) throws MdException, RemoteException {
        this.setSpecificProperty(option, value, propertyRole, null, -1, null, sqlType);
    }

    public void setSpecificProperty(String option, String value, String propertyRole, String delimiter, int useValueOnly, PropertyType propType) throws MdException, RemoteException {
        this.setSpecificProperty(option, value, propertyRole, delimiter, useValueOnly, propType, 12);
    }

    public void setSpecificProperty(String propertyName, String value, String propertyRole, String delimiter, int useValueOnly, PropertyType propType, int sqlType) throws MdException, RemoteException {
        this.setSpecificProperty(propertyName, propertyName, value, propertyRole, delimiter, useValueOnly, propType, sqlType, false);
    }

    public void setSpecificProperty(String name, String propertyName, String value, String propertyRole, String delimiter, int useValueOnly, PropertyType propType, int sqlType) throws MdException, RemoteException {
        this.setSpecificProperty(name, propertyName, value, propertyRole, delimiter, useValueOnly, propType, sqlType, false);
    }

    public void setSpecificProperty(String name, String propertyName, String value, String propertyRole, String delimiter, int useValueOnly, PropertyType propType, int sqlType, boolean createPropertyType) throws MdException, RemoteException {
        if (this.m_propSet == null && this.m_usePropertySet) {
            this.m_propSet = this.getPropertySet();
            if (this.m_propSet == null) {
                this.m_propSet = this.createPropertySet();
            }
            if (this.m_propSet == null) {
                return;
            }
        }
        AssociationList lProps = this.getPropertyList();
        Property iProperty = null;
        if (lProps != null) {
            for (int i = 0; i < lProps.size(); ++i) {
                Property iProp = (Property)lProps.get(i);
                if (iProp.getPropertyName().compareToIgnoreCase(propertyName) != 0) continue;
                iProperty = iProp;
                break;
            }
        }
        String currentValue = "";
        if (iProperty == null) {
            if (value == null) {
                return;
            }
            iProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_meta.getObjectStore(), null, name, "Property", this.m_meta.getRepositoryID(), null);
            if (propType == null && createPropertyType) {
                propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_meta.getObjectStore(), null, propertyName, "PropertyType", this.m_meta.getRepositoryID(), null);
                propType.setSQLType(sqlType);
            }
            iProperty.setOwningType(propType);
        } else {
            currentValue = iProperty.getDefaultValue();
        }
        if (!currentValue.equalsIgnoreCase(value)) {
            if (value == null) {
                value = "";
            }
            iProperty.setDefaultValue(value);
        }
        if (useValueOnly < 0) {
            useValueOnly = 1;
        }
        if (delimiter == null && useValueOnly == 0) {
            delimiter = "=";
        } else if (delimiter == null) {
            delimiter = "";
        }
        if (this.m_useSetProperties) {
            iProperty.setAssociatedPropertySet(this.m_propSet);
        } else if (this.m_usePropertySet) {
            iProperty.setAssociatedObject((Root)this.m_propSet);
        } else {
            iProperty.setAssociatedObject(this.m_meta);
        }
        iProperty.setPropertyName(propertyName);
        iProperty.setUseValueOnly(useValueOnly);
        iProperty.setDelimiter(delimiter);
        iProperty.setSQLType(sqlType);
        if (propertyRole != null && propertyRole.trim().compareTo("") != 0 && propertyRole.toUpperCase().compareTo("INPUT") != 0) {
            iProperty.setPropertyRole(propertyRole);
        }
    }

    public boolean stringToBoolean(String value) {
        return this.stringToBoolean(value, false);
    }

    public boolean stringToBoolean(String value, boolean defaultValue) {
        if (value.compareToIgnoreCase(VALUE_FALSE) == 0) {
            return false;
        }
        if (value.compareToIgnoreCase(VALUE_TRUE) == 0) {
            return true;
        }
        return defaultValue;
    }

    public String booleanToString(boolean value) {
        return this.booleanToString(value, VALUE_FALSE);
    }

    public String booleanToString(boolean value, String defaultValue) {
        if (value) {
            return VALUE_TRUE;
        }
        if (!value) {
            return VALUE_FALSE;
        }
        return defaultValue;
    }

    public void setPropertyMetadataObject(MdObjectStore mdStore, String option, CMetadata inObject) throws MdException, RemoteException {
        this.setPropertyMetadataObject(mdStore, option, inObject, 2000);
    }

    public void setPropertyMetadataObject(MdObjectStore mdStore, String option, CMetadata inObject, int sqlType) throws MdException, RemoteException {
        ArrayList<CMetadata> objList = new ArrayList<CMetadata>();
        if (inObject != null) {
            objList.add(inObject);
        }
        this.setPropertyMetadataObjects(mdStore, option, objList, sqlType, option);
    }

    public void setPropertyMetadataObjects(MdObjectStore mdStore, String option, List inObjects) throws MdException, RemoteException {
        this.setPropertyMetadataObjects(mdStore, option, inObjects, 2000, option);
    }

    public void setPropertyMetadataObjects(MdObjectStore mdStore, String option, List inObjects, int sqlType, String value) throws MdException, RemoteException {
        this.setSpecificProperty(option, option, value, "", "", 1, null, sqlType, false);
        Property prop = this.getSpecificProperty(option);
        Transformation trans = null;
        if (prop != null) {
            for (int i = 0; i < prop.getSpecTargetTransformations().size() && trans == null; ++i) {
                if (!((CMetadata)prop.getSpecTargetTransformations().get(i)).getCMetadataType().equals("Transformation")) continue;
                trans = (Transformation)prop.getSpecTargetTransformations().get(i);
            }
            if (inObjects != null && !inObjects.isEmpty()) {
                if (trans == null) {
                    trans = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(mdStore, option, "Transformation", prop.getRepositoryID());
                    trans.setTransformRole(option);
                    prop.getSpecTargetTransformations().add((Object)trans);
                }
                trans.getSourceSpecifications().removeAllElements();
                trans.getSourceSpecifications().addAll((Collection)inObjects);
            } else if (trans != null) {
                MdObjectStore store = (MdObjectStore)trans.getObjectStore();
                store.removeObjectFromStore(trans, null);
            }
        }
    }

    public CMetadata getPropertyMetadataObject(String propertyName) throws MdException, RemoteException {
        CMetadata meta = null;
        List metaList = this.getPropertyMetadataObjects(propertyName);
        if (metaList != null && metaList.size() > 0) {
            meta = (CMetadata)metaList.get(0);
        }
        return meta;
    }

    public List getPropertyMetadataObjects(String propertyName) throws MdException, RemoteException {
        ArrayList metaList = new ArrayList();
        Property prop = this.getSpecificProperty(propertyName);
        if (prop != null) {
            for (int i = 0; i < prop.getSpecTargetTransformations().size(); ++i) {
                Transformation trans;
                if (!((Root)prop.getSpecTargetTransformations().get(i)).getCMetadataType().equals("Transformation") || (trans = (Transformation)prop.getSpecTargetTransformations().get(i)).getSourceSpecifications().isEmpty()) continue;
                metaList.addAll(trans.getSourceSpecifications());
            }
        }
        return metaList;
    }

    public Object getSpecificOptionObjectValue(String propertyName, int sqlType, boolean isMetadata, boolean isList) throws MdException, RemoteException {
        Object object = null;
        Property prop = this.getSpecificProperty(propertyName);
        if (prop != null) {
            if (isMetadata) {
                List objs = this.getPropertyMetadataObjects(propertyName);
                object = prop.getSQLType() != sqlType && (objs == null || objs.isEmpty()) ? this.getSpecificOptionValue(propertyName) : (!isList && !objs.isEmpty() ? objs.get(0) : objs);
            } else {
                object = this.getSpecificOptionValue(propertyName);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectForXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        String encoding = "UTF-8";
        PersistenceInterface obj = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            Log4JFactory2 loggerFactory = new Log4JFactory2();
            PromptsReadingContext rc = PersistenceFactory.newReadingContext((LoggerFactoryInterface)loggerFactory);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            PromptContentHandler handler = PromptContentHandler.newHandler2((LoggerFactoryInterface)loggerFactory, (PromptsReadingContext)rc);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            InputSource source = new InputSource(reader);
            parser.parse(source, (DefaultHandler)handler);
            ((InputStream)stream).reset();
            reader = new InputStreamReader((InputStream)stream, "UTF-8");
            obj = PromptUtil.newObjectFromXML((Reader)reader, null, (PromptsReadingContext)rc);
        }
        return obj;
    }
}

