/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.IndexTableMap;
import com.sas.workspace.WATableModel;
import com.sas.workspace.Workspace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class IndexTableSorter
extends IndexTableMap {
    private static final long serialVersionUID = 1L;
    protected int[] indexes;
    protected Vector sortingColumns = new Vector();
    protected boolean ascending = false;
    protected boolean rowHeaderSort = false;
    protected boolean changeFlag = false;
    protected MouseListener ml = null;
    protected MouseListener rml = null;
    protected int sortedColumn = -1;
    protected int[] rows = null;
    protected int[] columns = null;

    public IndexTableSorter() {
        this.indexes = new int[0];
    }

    public IndexTableSorter(WATableModel Model) {
        this.setModel(Model);
    }

    @Override
    public void setModel(WATableModel Model) {
        super.setModel(Model);
        this.reallocateIndexes();
    }

    public boolean getChangeFlag() {
        return this.changeFlag;
    }

    public void setChangeFlag(boolean f) {
        this.changeFlag = f;
    }

    public int getRowIndex(int i) {
        return this.indexes[i];
    }

    public int convertToView(int iModelRow) {
        int nIndexes = this.indexes.length;
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            if (this.indexes[iIndex] != iModelRow) continue;
            return iIndex;
        }
        return -1;
    }

    public int convertToModel(int iViewRow) {
        return this.indexes[iViewRow];
    }

    public int moveRow(int from, int to) {
        int b;
        if (from < 0 || from >= this.indexes.length || to < 0 || to >= this.indexes.length || to == from) {
            return to;
        }
        int a = this.indexes[from];
        this.indexes[from] = b = this.indexes[to];
        this.indexes[to] = a;
        if (from > to) {
            this.fireTableChanged(new TableModelEvent(this, to, from));
        } else {
            this.fireTableChanged(new TableModelEvent(this, from, to));
        }
        this.changeFlag = true;
        return to;
    }

    @Override
    public int getRowCount() {
        return this.indexes.length;
    }

    @Override
    public boolean deleteRow(int i) {
        return this.model.deleteRow(this.indexes[i]);
    }

    public void revert() {
        this.populateIndexes();
        super.tableChanged(new TableModelEvent(this));
    }

    protected void populateIndexes() {
        int nIndexes = this.indexes.length;
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            this.indexes[iIndex] = iIndex;
        }
    }

    protected int compareRowsByColumn(int row1, int row2, int column) {
        Class type = this.model.getColumnClass(column);
        Object o1 = this.model.getValueAt(row1, column);
        Object o2 = this.model.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type == String.class) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int result = s1.compareToIgnoreCase(s2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Integer.class) {
            Integer i2;
            Integer i1 = o1 instanceof String ? Integer.valueOf((String)o1) : (Integer)o1;
            int result = i1.compareTo(i2 = o2 instanceof String ? Integer.valueOf((String)o2) : (Integer)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Byte.class) {
            Byte b2;
            Byte b1 = o1 instanceof String ? Byte.valueOf((String)o1) : (Byte)o1;
            int result = b1.compareTo(b2 = o2 instanceof String ? Byte.valueOf((String)o2) : (Byte)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Double.class) {
            Double d2;
            Double d1 = o1 instanceof String ? Double.valueOf((String)o1) : (Double)o1;
            int result = d1.compareTo(d2 = o2 instanceof String ? Double.valueOf((String)o2) : (Double)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Float.class) {
            Float f2;
            Float f1 = o1 instanceof String ? Float.valueOf((String)o1) : (Float)o1;
            int result = f1.compareTo(f2 = o2 instanceof String ? Float.valueOf((String)o2) : (Float)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Long.class) {
            Long l2;
            Long l1 = o1 instanceof String ? Long.valueOf((String)o1) : (Long)o1;
            int result = l1.compareTo(l2 = o2 instanceof String ? Long.valueOf((String)o2) : (Long)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Short.class) {
            Short s2;
            Short s1 = o1 instanceof String ? Short.valueOf((String)o1) : (Short)o1;
            int result = s1.compareTo(s2 = o2 instanceof String ? Short.valueOf((String)o2) : (Short)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Character.class) {
            Character c2;
            Character c1 = o1 instanceof String ? new Character(((String)o1).charAt(0)) : (Character)o1;
            int result = c1.compareTo(c2 = o2 instanceof String ? new Character(((String)o2).charAt(0)) : (Character)o2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    protected int compare(int row1, int row2) {
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public Object[] syncModel(Object[] oarray) {
        Object[] tempa = new Object[oarray.length];
        for (int i = 0; i < oarray.length; ++i) {
            tempa[i] = oarray[this.indexes[i]];
        }
        return tempa;
    }

    public void setRowRange(int[] r) {
        this.rows = r;
    }

    public void setColumnRange(int[] c) {
        this.columns = c;
    }

    public int[] getRowRange() {
        return this.rows;
    }

    public int[] getColumnRange() {
        return this.columns;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        if (rowCount < 0) {
            rowCount = 0;
        }
        this.indexes = new int[rowCount];
        this.populateIndexes();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int lastRow;
        int eType = e.getType();
        int firstRow = e.getFirstRow();
        if (firstRow != (lastRow = e.getLastRow()) || this.indexes.length == 0) {
            this.reallocateIndexes();
            super.tableChanged(e);
            return;
        }
        int iViewRow = 0;
        switch (eType) {
            case -1: {
                int i = 0;
                boolean found = false;
                while (i < this.indexes.length && !found) {
                    if (this.indexes[i] == firstRow) {
                        iViewRow = i;
                        found = true;
                        continue;
                    }
                    ++i;
                }
                if (!found) break;
                for (int a = 0; a < this.indexes.length; ++a) {
                    if (this.indexes[a] <= firstRow) continue;
                    int n = a;
                    this.indexes[n] = this.indexes[n] - 1;
                }
                int[] indexes2 = new int[this.model.getRowCount()];
                for (int j = 0; j < i; ++j) {
                    indexes2[j] = this.indexes[j];
                }
                for (int k = i; k < this.model.getRowCount(); ++k) {
                    indexes2[k] = this.indexes[k + 1];
                }
                this.indexes = indexes2;
                break;
            }
            case 1: {
                int i = 0;
                boolean found = false;
                int posRow = firstRow - 1;
                if (posRow >= 0) {
                    while (i < this.indexes.length && !found) {
                        if (this.indexes[i] == posRow) {
                            found = true;
                            continue;
                        }
                        ++i;
                    }
                    if (!found) {
                        int max = 0;
                        for (int b = 0; b < this.indexes.length; ++b) {
                            if (this.indexes[b] <= max) continue;
                            max = this.indexes[b];
                        }
                        i = max;
                        found = true;
                    }
                    if (!found) break;
                    for (int a = 0; a < this.indexes.length; ++a) {
                        if (this.indexes[a] < firstRow) continue;
                        int n = a;
                        this.indexes[n] = this.indexes[n] + 1;
                    }
                    int[] indexes2 = new int[this.model.getRowCount()];
                    if (this.indexes.length > 0) {
                        for (int j = 0; j <= i; ++j) {
                            indexes2[j] = this.indexes[j];
                        }
                    }
                    for (int k = i + 1; k < this.model.getRowCount() - 1; ++k) {
                        indexes2[k + 1] = this.indexes[k];
                    }
                    indexes2[i + 1] = firstRow;
                    iViewRow = i + 1;
                    this.indexes = indexes2;
                    break;
                }
                int[] indexes2 = new int[this.model.getRowCount()];
                indexes2[0] = firstRow;
                int x = 0;
                while (x < this.indexes.length) {
                    int n = x++;
                    this.indexes[n] = this.indexes[n] + 1;
                }
                for (int z = 0; z < this.indexes.length; ++z) {
                    indexes2[z + 1] = this.indexes[z];
                }
                this.indexes = indexes2;
                break;
            }
            case 0: {
                iViewRow = this.convertToView(firstRow);
            }
        }
        TableModelEvent tme = new TableModelEvent((TableModel)e.getSource(), iViewRow, iViewRow, -1, eType);
        super.tableChanged(tme);
    }

    protected void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            Workspace.getDefaultLogger().debug("Sorter not informed of a change in model.");
        }
    }

    protected void sort(Object sender) {
        this.checkModel();
        if (this.rowHeaderSort) {
            this.populateIndexes();
        } else {
            this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        }
        this.changeFlag = true;
    }

    protected void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    protected void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    protected void sortByColumn(int column, boolean asc) {
        this.ascending = asc;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        this.setSortedColumn(column);
        super.tableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1));
    }

    protected void setSortedColumn(int i) {
        this.sortedColumn = i;
    }

    protected int getSortedColumn() {
        return this.sortedColumn;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final IndexTableSorter sorter = this;
        final JTable tableView = table;
        table.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int[] r = tableView.getSelectedRows();
                int[] c = tableView.getSelectedColumns();
                sorter.setRowRange(r);
                sorter.setColumnRange(c);
                TableCellEditor ce = tableView.getCellEditor();
                if (ce != null && tableView.isEditing()) {
                    ce.stopCellEditing();
                }
                if ((e.getModifiers() & 0x10) > 0) {
                    TableColumnModel columnModel = tableView.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = tableView.convertColumnIndexToModel(viewColumn);
                    if (e.getClickCount() == 1 && column != -1) {
                        IndexTableSorter.this.rowHeaderSort = false;
                        boolean ascendingClick = !IndexTableSorter.this.ascending;
                        sorter.sortByColumn(column, ascendingClick);
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.ml = listMouseListener;
    }

    public void removeMouseListenerFromHeaderInTable(JTable table) {
        JTableHeader th = table.getTableHeader();
        th.removeMouseListener(this.ml);
    }

    public void removeMouseListenerFromRowHeaderInTable(JTable table) {
        JTableHeader th = table.getTableHeader();
        th.removeMouseListener(this.rml);
    }

    public void addMouseListenerToRowHeaderInTable(JTable table) {
        final IndexTableSorter sorter = this;
        final JTable tableView = table;
        table.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableCellEditor ce = tableView.getCellEditor();
                if (ce != null && tableView.isEditing()) {
                    ce.stopCellEditing();
                }
                if ((e.getModifiers() & 0x10) > 0) {
                    TableColumnModel columnModel = tableView.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = tableView.convertColumnIndexToModel(viewColumn);
                    if (e.getClickCount() == 1 && column != -1) {
                        IndexTableSorter.this.rowHeaderSort = true;
                        boolean ascendingClick = !IndexTableSorter.this.ascending;
                        sorter.sortByColumn(column, ascendingClick);
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.rml = listMouseListener;
    }

    @Override
    public String[] getColumnChoices(int col) {
        return this.model.getColumnChoices(col);
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return this.model.isCellEditable(r, c);
    }

    @Override
    public boolean insertBlankRow(int i) {
        return this.model.insertBlankRow(i);
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }
}

