/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidInfoType;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionName;
import com.sas.meta.SASOMI.ISecurity_1_1Package.InvalidOptionValue;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class IdentityUtil {
    public static final int UNRESTRICTED = 1;
    public static final int ADMINISTRATOR = 2;
    public static final int OPERATOR = 3;

    public static boolean isUnrestricted(MdFactory m_Factory) {
        ISecurity_1_1 iSec = null;
        String[][] options = new String[0][0];
        VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
        String userClass = null;
        String authId = null;
        boolean isUnrestricted = false;
        try {
            iSec = ISecurity_1_1Helper.narrow((Object)m_Factory.getConnection().getCMRHandle());
            iSec.GetInfo("GetIdentityInfo", "", options, returnAuthorizations);
        }
        catch (InvalidCredHandle e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidInfoType e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionName e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionValue e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (GenericError e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        for (int i = 0; i < returnAuthorizations.value.length; ++i) {
            String key = returnAuthorizations.value[i][0];
            if ((key = key.trim()).equalsIgnoreCase("UserClass")) {
                userClass = returnAuthorizations.value[i][1];
                continue;
            }
            if (!key.equalsIgnoreCase("AuthenticatedUserid")) continue;
            authId = returnAuthorizations.value[i][1];
        }
        if (authId != null) {
            if (userClass.indexOf("Unrestricted") != -1) {
                isUnrestricted = true;
            }
        } else {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user.");
        }
        return isUnrestricted;
    }

    public static boolean isInternalUser(MdFactory m_Factory) {
        ISecurity_1_1 iSec = null;
        String[][] options = new String[0][0];
        VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
        java.lang.Object userClass = null;
        String authId = null;
        String internalIndicator = null;
        boolean isInternal = false;
        try {
            iSec = ISecurity_1_1Helper.narrow((Object)m_Factory.getConnection().getCMRHandle());
            internalIndicator = IdentityUtil.getInternalUserIndicator(iSec);
            iSec.GetInfo("GetIdentityInfo", "", options, returnAuthorizations);
        }
        catch (InvalidCredHandle e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidInfoType e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionName e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionValue e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (GenericError e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        for (int i = 0; i < returnAuthorizations.value.length; ++i) {
            String key = returnAuthorizations.value[i][0];
            if (!(key = key.trim()).equalsIgnoreCase("AuthenticatedUserid")) continue;
            authId = returnAuthorizations.value[i][1];
            break;
        }
        if (authId != null) {
            int atsign;
            String actualInternalValue;
            if (internalIndicator != null && (actualInternalValue = authId.substring((atsign = authId.indexOf(64)) + 1)).equalsIgnoreCase(internalIndicator)) {
                isInternal = true;
            }
        } else {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user.");
        }
        return isInternal;
    }

    private static String getInternalUserIndicator(ISecurity_1_1 iSecurity) {
        if (iSecurity == null) {
            return "saspw";
        }
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] parms = new String[][]{};
        try {
            iSecurity.GetInfo("SASPW_Alias", "", parms, returnInfo);
            for (int i = 0; i < returnInfo.value.length; ++i) {
                if (!returnInfo.value[i][0].trim().equalsIgnoreCase("SASPW_Alias")) continue;
                return returnInfo.value[i][1].trim();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", e);
            return "saspw";
        }
        return "saspw";
    }

    public static boolean isOperator(MdFactory m_Factory) {
        ISecurity_1_1 iSec = null;
        String[][] options = new String[0][0];
        VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
        String userClass = null;
        String authId = null;
        boolean isOperator = false;
        try {
            iSec = ISecurity_1_1Helper.narrow((Object)m_Factory.getConnection().getCMRHandle());
            iSec.GetInfo("GetIdentityInfo", "", options, returnAuthorizations);
        }
        catch (InvalidCredHandle e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidInfoType e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionName e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionValue e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (GenericError e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        for (int i = 0; i < returnAuthorizations.value.length; ++i) {
            String key = returnAuthorizations.value[i][0];
            if ((key = key.trim()).equalsIgnoreCase("UserClass")) {
                userClass = returnAuthorizations.value[i][1];
                continue;
            }
            if (!key.equalsIgnoreCase("AuthenticatedUserid")) continue;
            authId = returnAuthorizations.value[i][1];
        }
        if (authId != null) {
            if (userClass.indexOf("Unrestricted") != -1 || userClass.indexOf("Administrator") != -1 || userClass.indexOf("Operator") != -1) {
                isOperator = true;
            }
        } else {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user.");
        }
        return isOperator;
    }

    public static boolean isAdministrator(MdFactory m_Factory) {
        ISecurity_1_1 iSec = null;
        String[][] options = new String[0][0];
        VariableArray2dOfStringHolder returnAuthorizations = new VariableArray2dOfStringHolder();
        String userClass = null;
        String authId = null;
        boolean isAdministrator = false;
        try {
            iSec = ISecurity_1_1Helper.narrow((Object)m_Factory.getConnection().getCMRHandle());
            iSec.GetInfo("GetIdentityInfo", "", options, returnAuthorizations);
        }
        catch (InvalidCredHandle e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidInfoType e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionName e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (InvalidOptionValue e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (GenericError e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user. Reason: " + e.getLocalizedMessage());
        }
        for (int i = 0; i < returnAuthorizations.value.length; ++i) {
            String key = returnAuthorizations.value[i][0];
            if ((key = key.trim()).equalsIgnoreCase("UserClass")) {
                userClass = returnAuthorizations.value[i][1];
                continue;
            }
            if (!key.equalsIgnoreCase("AuthenticatedUserid")) continue;
            authId = returnAuthorizations.value[i][1];
        }
        if (authId != null) {
            if (userClass.indexOf("Unrestricted") != -1 || userClass.indexOf("Administrator") != -1) {
                isAdministrator = true;
            }
        } else {
            Workspace.getDefaultLogger().info("Could not determine the authorization level of the current user.");
        }
        return isAdministrator;
    }

    public static boolean checkSpecialAuthorization(int authLevel) {
        switch (authLevel) {
            case 1: {
                return IdentityUtil.isUnrestricted(Workspace.getMdFactory());
            }
            case 2: {
                return IdentityUtil.isAdministrator(Workspace.getMdFactory());
            }
            case 3: {
                return IdentityUtil.isOperator(Workspace.getMdFactory());
            }
        }
        return false;
    }

    public static boolean checkSpecialAuthorization(int authLevel, boolean queryServer) {
        return IdentityUtil.checkSpecialAuthorization(authLevel);
    }

    public static String getUserIdentityFQID() throws MdException, RemoteException, GenericError, InvalidCredHandle {
        return IdentityUtil.getUserIdentityFQID(Workspace.getMdFactory().getConnection().getCMRHandle());
    }

    public static String getUserIdentityFQID(IOMI iOMI) throws MdException, RemoteException, GenericError, InvalidCredHandle {
        String sUserIdentity = IdentityUtil.getUserIdentity(iOMI);
        int iSlash = sUserIdentity.lastIndexOf(47);
        return sUserIdentity.substring(iSlash + 1);
    }

    public static Root getUserIdentityObject(MdObjectStore store) throws MdException, RemoteException, GenericError, InvalidCredHandle {
        return IdentityUtil.getUserIdentityObject(store, Workspace.getMdFactory().getConnection().getCMRHandle());
    }

    public static Root getUserIdentityObject(MdObjectStore store, IOMI iOMI) throws MdException, RemoteException, GenericError, InvalidCredHandle {
        String sUserIdentity = IdentityUtil.getUserIdentity(iOMI);
        int iSlash = sUserIdentity.lastIndexOf(47);
        String sType = sUserIdentity.substring(0, iSlash);
        String sFQID = sUserIdentity.substring(iSlash + 1);
        String sName = IdentityUtil.getMetadataSimple(sType, sFQID, "Name");
        return (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID);
    }

    private static String getUserIdentity(IOMI iOMI) throws MdException, RemoteException, GenericError, InvalidCredHandle {
        ISecurity_1_1 iSecurity = Workspace.getMdFactory().getConnection().MakeISecurityConnection(iOMI);
        StringHolder shValue = new StringHolder();
        iSecurity.GetIdentity("", shValue);
        String sValue = shValue.value;
        if (sValue != null && sValue.startsWith("OMSOBJ:")) {
            return sValue.substring(7);
        }
        return null;
    }

    private static String getMetadataSimple(String sType, String sFQID, String sAttr) throws MdException, RemoteException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        lAttrs.add(sAttr);
        List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(sType, sFQID, lAttrs);
        return (String)lValues.get(0);
    }
}

