/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAStandardInternalFrame;
import java.awt.Component;
import java.awt.Container;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;

public class CustomLayoutFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private static final long serialVersionUID = 1L;
    protected static CustomLayoutFocusTraversalPolicy m_policy = new CustomLayoutFocusTraversalPolicy();
    protected WeakHashMap m_forwardMap = new WeakHashMap();
    protected WeakHashMap m_backwardMap = new WeakHashMap();

    private CustomLayoutFocusTraversalPolicy() {
    }

    public static CustomLayoutFocusTraversalPolicy getInstance() {
        return m_policy;
    }

    @Override
    protected boolean accept(Component component) {
        if (!CustomLayoutFocusTraversalPolicy.isComponentTrulyFocusable(component)) {
            return false;
        }
        return super.accept(component);
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        WeakReference nextReference = (WeakReference)this.m_forwardMap.get(aComponent);
        Component nextComponent = null;
        nextComponent = nextReference != null ? (Component)nextReference.get() : super.getComponentAfter(focusCycleRoot, aComponent);
        return nextComponent;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        WeakReference previousComponent = (WeakReference)this.m_backwardMap.get(aComponent);
        if (previousComponent != null) {
            return (Component)previousComponent.get();
        }
        return super.getComponentBefore(focusCycleRoot, aComponent);
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        Component defaultComponent = null;
        defaultComponent = focusCycleRoot instanceof WAStandardInternalFrame ? ((WAStandardInternalFrame)focusCycleRoot).getDefaultFocusComponent() : (focusCycleRoot instanceof WAStandardDialog ? ((WAStandardDialog)focusCycleRoot).getDefaultFocusComponent() : super.getDefaultComponent(focusCycleRoot));
        return defaultComponent;
    }

    public static void setNextFocusableComponent(Component component, Component nextComponent) {
        CustomLayoutFocusTraversalPolicy.m_policy.m_forwardMap.put(component, new WeakReference<Component>(nextComponent));
        CustomLayoutFocusTraversalPolicy.m_policy.m_backwardMap.put(nextComponent, new WeakReference<Component>(component));
    }

    public static boolean isComponentTrulyFocusable(Component cmp) {
        return cmp.isFocusable() && !(cmp instanceof JLabel) && !(cmp instanceof JPanel) && !(cmp instanceof JScrollBar) && !(cmp instanceof JScrollPane);
    }

    public static Component getDefaultFocusComponent(Component cmp) {
        Component cmpFocus;
        if (cmp == null) {
            return null;
        }
        if (!cmp.isVisible()) {
            return null;
        }
        if (cmp instanceof JScrollPane) {
            return CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(((JScrollPane)cmp).getViewport().getView());
        }
        if (cmp instanceof JSplitPane) {
            JSplitPane splt = (JSplitPane)cmp;
            Component cmpFocus2 = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(splt.getLeftComponent());
            if (cmpFocus2 != null) {
                return cmpFocus2;
            }
            cmpFocus2 = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(splt.getRightComponent());
            if (cmpFocus2 != null) {
                return cmpFocus2;
            }
            return cmp;
        }
        if (cmp instanceof WAPanel && (cmpFocus = ((WAPanel)cmp).getDefaultFocusComponent()) != null) {
            return cmpFocus;
        }
        if (cmp instanceof JPanel) {
            Component[] aComponents = ((JPanel)cmp).getComponents();
            for (int iComponent = 0; iComponent < aComponents.length; ++iComponent) {
                Component cmpFocus3 = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(aComponents[iComponent]);
                if (cmpFocus3 == null) continue;
                return cmpFocus3;
            }
        }
        if (CustomLayoutFocusTraversalPolicy.getInstance().accept(cmp)) {
            return cmp;
        }
        return null;
    }
}

