/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class CustomDesktopUI
extends BasicDesktopPaneUI {
    private static final String SELECT_NEXT_FRAME = "selectNextFrame";
    private static final String SELECT_PREVIOUS_FRAME = "selectPreviousFrame";
    private List m_lFramesCache;

    public static ComponentUI createUI(JComponent desktop) {
        return new CustomDesktopUI();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap mapAction = this.desktop.getActionMap();
        mapAction.put(SELECT_NEXT_FRAME, new NextFrameAction());
        mapAction.put(SELECT_PREVIOUS_FRAME, new PreviousFrameAction());
        InputMap mapInput = this.desktop.getInputMap(1);
        mapInput.put(KeyStroke.getKeyStroke(117, 8), SELECT_NEXT_FRAME);
        mapInput.put(KeyStroke.getKeyStroke(117, 9), SELECT_PREVIOUS_FRAME);
        mapInput.put(KeyStroke.getKeyStroke(9, 3), SELECT_PREVIOUS_FRAME);
        mapInput.put(KeyStroke.getKeyStroke(117, 3), SELECT_PREVIOUS_FRAME);
    }

    private void selectFrame(boolean bNext) {
        JInternalFrame frm;
        this.verifyFramesCache();
        if (this.m_lFramesCache.size() == 0) {
            return;
        }
        int iFrame = 0;
        JInternalFrame frmSelected = this.desktop.getSelectedFrame();
        if (frmSelected != null) {
            iFrame = this.m_lFramesCache.indexOf(frmSelected);
        }
        if (iFrame == -1 && (iFrame = this.m_lFramesCache.indexOf(frmSelected.getDesktopIcon())) == -1) {
            return;
        }
        if (bNext) {
            iFrame = (iFrame + 1) % this.m_lFramesCache.size();
        } else if (--iFrame < 0) {
            iFrame = this.m_lFramesCache.size() - 1;
        }
        JComponent cmp = (JComponent)this.m_lFramesCache.get(iFrame);
        if (cmp instanceof JInternalFrame) {
            frm = (JInternalFrame)cmp;
        } else if (cmp instanceof JInternalFrame.JDesktopIcon) {
            frm = ((JInternalFrame.JDesktopIcon)cmp).getInternalFrame();
        } else {
            return;
        }
        try {
            frm.setSelected(true);
            this.desktop.getDesktopManager().activateFrame(frm);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void verifyFramesCache() {
        if (this.m_lFramesCache == null) {
            this.m_lFramesCache = new ArrayList();
        }
        boolean bAFrameHasClosed = false;
        for (int iFrame = 0; iFrame < this.m_lFramesCache.size(); ++iFrame) {
            JInternalFrame frm;
            JComponent cmp = (JComponent)this.m_lFramesCache.get(iFrame);
            if (cmp instanceof JInternalFrame) {
                frm = (JInternalFrame)cmp;
            } else {
                if (!(cmp instanceof JInternalFrame.JDesktopIcon)) continue;
                frm = ((JInternalFrame.JDesktopIcon)cmp).getInternalFrame();
            }
            if (!frm.isClosed()) continue;
            bAFrameHasClosed = true;
            break;
        }
        if (bAFrameHasClosed || this.desktop.getAllFrames().length != this.m_lFramesCache.size()) {
            this.m_lFramesCache.clear();
            for (int iLevel = this.desktop.highestLayer(); iLevel >= this.desktop.lowestLayer(); --iLevel) {
                Component[] aComponents = this.desktop.getComponentsInLayer(iLevel);
                for (int iComponent = 0; iComponent < aComponents.length; ++iComponent) {
                    if (!(aComponents[iComponent] instanceof JInternalFrame) && !(aComponents[iComponent] instanceof JInternalFrame.JDesktopIcon)) continue;
                    this.m_lFramesCache.add(aComponents[iComponent]);
                }
            }
        }
    }

    private class PreviousFrameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private PreviousFrameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            CustomDesktopUI.this.selectFrame(false);
        }
    }

    private class NextFrameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private NextFrameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            CustomDesktopUI.this.selectFrame(true);
        }
    }
}

