/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.plugins.PluginInterface;
import com.sas.visuals.Resources;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class AbstractDesigner
extends WAWizardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(AbstractDesigner.class);
    protected WATransitionWizardModel m_wizardModel;
    protected cAbstractDesignerTreeModel m_treeModel;
    protected cAbstractDesignerTree m_tree;
    public static String DEFAULT_HELP_PRODUCT = "sourcedesigner";

    public AbstractDesigner(Frame frame, String title, MdObjectStore store) {
        super(frame, title, true, store);
    }

    public AbstractDesigner(Frame frame, String title) {
        super(frame, title, true);
    }

    public void buildTree(cAbstractDesignerTreeModel model, String sCategory, cAbstractDesignerTreeNode parentnode, PluginInterface source, boolean fDone, boolean fMultiple) {
        this.buildTree(model, sCategory, parentnode, source, fDone, fMultiple, 0);
    }

    public void buildTree(cAbstractDesignerTreeModel model, String sCategory, cAbstractDesignerTreeNode parentnode, PluginInterface source, boolean fDone, boolean fMultiple, int index) {
        int iNewIndex = sCategory.indexOf(46);
        String sSubCategory = null;
        sSubCategory = iNewIndex > -1 ? sCategory.substring(0, iNewIndex) : sCategory;
        if (iNewIndex == -1) {
            String name = sSubCategory;
            if (!fMultiple) {
                if (sSubCategory.length() > 0) {
                    ArrayList nodeList = model.findNodes(parentnode, sSubCategory);
                    if (nodeList.size() == 0) {
                        cAbstractDesignerFolderNode foldernode = new cAbstractDesignerFolderNode(sSubCategory, parentnode.getToolTip());
                        model.addChild(foldernode, parentnode);
                        parentnode = foldernode;
                    } else {
                        parentnode = (cAbstractDesignerFolderNode)nodeList.get(0);
                    }
                }
                name = source.getName();
            }
            cAbstractDesignerPluginNode newnode = null;
            newnode = !fMultiple ? new cAbstractDesignerPluginNode(name, source) : new cAbstractDesignerPluginNode(name, source, index);
            model.addChild(newnode, parentnode);
            fDone = true;
            return;
        }
        if (fDone) {
            return;
        }
        ArrayList nodeList = model.findNodes(parentnode, sSubCategory);
        if (nodeList.size() == 0) {
            cAbstractDesignerFolderNode foldernode = null;
            try {
                Class<?> cls = source.getClass();
                Method mthd = cls.getMethod("getToolTip", null);
                String sToolTip = (String)mthd.invoke((Object)source, null);
                foldernode = new cAbstractDesignerFolderNode(sSubCategory, sToolTip);
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchMethodException)) {
                    Workspace.getDefaultLogger().error((Object)"", e);
                }
                foldernode = new cAbstractDesignerFolderNode(sSubCategory, parentnode.getToolTip());
            }
            model.addChild(foldernode, parentnode);
            parentnode = foldernode;
        } else {
            parentnode = (cAbstractDesignerFolderNode)nodeList.get(0);
        }
        String newSubString = sCategory.substring(iNewIndex + 1);
        this.buildTree(model, newSubString, parentnode, source, fDone, fMultiple, index);
    }

    public String getDefaultGroupID(CMetadata reposToLookIn, String roleToLookFor) {
        return null;
    }

    public static Tree getDefaultGroup(MdObjectStore store, CMetadata reposToLookIn, String roleToLookFor) {
        return null;
    }

    public class cAbstractDesignerTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;
        cAbstractDesignerTreeNode m_nodeRoot;
        private Comparator m_comparator;

        public cAbstractDesignerTreeModel(cAbstractDesignerTreeNode nodeRoot) {
            super(nodeRoot, true);
            this.m_nodeRoot = nodeRoot;
            this.m_comparator = SASCollatorFactory.createCollator();
        }

        public void addChild(cAbstractDesignerTreeNode nodeNew, cAbstractDesignerTreeNode nodeParent) {
            cAbstractDesignerTreeNode nodeChild;
            int iChild;
            String sNew = nodeNew.getName();
            int nChildren = nodeParent.getChildCount();
            for (iChild = 0; iChild < nChildren && this.m_comparator.compare((nodeChild = (cAbstractDesignerTreeNode)nodeParent.getChildAt(iChild)).getName(), sNew) <= 0; ++iChild) {
            }
            this.insertNodeInto(nodeNew, nodeParent, iChild);
        }

        public ArrayList findNodes(cAbstractDesignerTreeNode nodeTop, String sFQID) {
            ArrayList<cAbstractDesignerTreeNode> alNodes = new ArrayList<cAbstractDesignerTreeNode>();
            Enumeration<TreeNode> enumNodes = nodeTop.breadthFirstEnumeration();
            while (enumNodes.hasMoreElements()) {
                cAbstractDesignerTreeNode nodeCurr = (cAbstractDesignerTreeNode)enumNodes.nextElement();
                String sFQIDCurr = nodeCurr.getName();
                if (!sFQID.equals(sFQIDCurr)) continue;
                alNodes.add(nodeCurr);
                break;
            }
            return alNodes;
        }

        public cAbstractDesignerTreeNode getNodeRoot() {
            return this.m_nodeRoot;
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((cAbstractDesignerTreeNode)node).isLeaf();
        }
    }

    public class cAbstractDesignerTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        protected boolean m_bIsEditable;
        protected boolean m_bIsExpanded;
        protected boolean m_bHasExpanded;
        protected String m_sName;
        protected Icon m_icon;
        protected String m_toolTip;

        public cAbstractDesignerTreeNode(String sName, String sToolTip) {
            super(sName);
            this.m_bIsEditable = false;
            this.m_bIsExpanded = false;
            this.m_bHasExpanded = false;
            this.m_sName = sName;
            this.m_toolTip = sToolTip;
            this.m_icon = Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16);
        }

        public String getName() {
            return this.m_sName;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public String getToolTip() {
            return this.m_toolTip;
        }

        public void setToolTip(String toolTip) {
            this.m_toolTip = toolTip;
        }

        public boolean hasExpanded() {
            return this.m_bHasExpanded;
        }

        public void setHasExpanded(boolean bHasExpanded) {
            this.m_bHasExpanded = bHasExpanded;
        }

        public boolean isExpanded() {
            return this.m_bIsExpanded;
        }

        public void setIsExpanded(boolean bIsExpanded) {
            this.m_bIsExpanded = bIsExpanded;
        }

        public boolean isEditable() {
            return this.m_bIsEditable;
        }

        public void setIsEditable(boolean bIsEditable) {
            this.m_bIsEditable = bIsEditable;
        }

        public void addChildren() {
            System.out.println("AddChildren: " + this.m_sName);
        }

        @Override
        public String toString() {
            return this.m_sName;
        }

        public cAbstractDesignerTreeNode createChild(String sName) {
            return new cAbstractDesignerTreeNode(sName, this.m_toolTip);
        }
    }

    public class cAbstractDesignerPluginNode
    extends cAbstractDesignerTreeNode {
        private static final long serialVersionUID = 1L;
        PluginInterface m_plugin;
        protected boolean allowsChildren;
        protected String m_nodeName;
        protected String m_description;
        protected String m_sToolTip;

        public cAbstractDesignerPluginNode(String name, PluginInterface plugin) {
            super(name, plugin.getDescription());
            this.allowsChildren = false;
            this.m_icon = plugin.getIcon();
            this.m_sToolTip = plugin.getDescription();
            this.m_description = plugin.getDescription();
            this.m_bIsEditable = false;
            this.m_plugin = plugin;
            this.m_nodeName = name;
        }

        public cAbstractDesignerPluginNode(String name, PluginInterface plugin, int index) {
            super(name, "");
            this.allowsChildren = false;
            this.m_description = bundle.getString("DBMSImporter.description.txt");
            this.setToolTip(this.m_description);
            this.m_icon = (ImageIcon)((MultipleNodeInterface)((Object)plugin)).getIcons().get(index);
            this.m_sToolTip = (String)((MultipleNodeInterface)((Object)plugin)).getToolTips().get(index);
            this.m_bIsEditable = false;
            this.m_plugin = plugin;
            this.m_nodeName = name;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Icon getIcon() {
            return this.m_icon;
        }

        @Override
        public String getName() {
            return this.m_plugin.getName();
        }

        public String getNodeName() {
            return this.m_nodeName;
        }

        public String getDescription() {
            return this.m_description;
        }

        @Override
        public String getToolTip() {
            return this.m_sToolTip;
        }

        public PluginInterface getPlugin() {
            return this.m_plugin;
        }
    }

    public class cAbstractDesignerFolderNode
    extends cAbstractDesignerTreeNode {
        private static final long serialVersionUID = 1L;

        public cAbstractDesignerFolderNode(String sName, String sToolTip) {
            super(sName, sToolTip);
            this.m_icon = Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16);
        }
    }

    public class cAbstractDesignerRootNode
    extends cAbstractDesignerTreeNode {
        private static final long serialVersionUID = 1L;

        public cAbstractDesignerRootNode(String name, String tooltip) {
            super(name, tooltip);
            this.m_icon = Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16);
        }
    }

    public class cAbstractDesignerTree
    extends JTree {
        private static final long serialVersionUID = 1L;

        public cAbstractDesignerTree(cAbstractDesignerTreeModel model) {
            this.setModel(model);
            cTreeCellRenderer tcr = new cTreeCellRenderer();
            this.setCellRenderer(tcr);
            this.getSelectionModel().setSelectionMode(1);
            this.setShowsRootHandles(true);
            this.setEditable(false);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setModel(model);
        }

        public class cTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 1L;

            public cTreeCellRenderer() {
                this.setOpenIcon(Resources.getImageIcon((String)bundle.getString("Common.OpenedTree.image"), (int)16));
                this.setClosedIcon(Resources.getImageIcon((String)bundle.getString("Common.ClosedTree.image"), (int)16));
                this.setLeafIcon(bundle.getImageIcon("Common.DefaultLeaf.image"));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean HasFocus) {
                String sToolTip;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, HasFocus);
                if (!(value instanceof cAbstractDesignerTreeNode)) {
                    return this;
                }
                cAbstractDesignerTreeNode node = (cAbstractDesignerTreeNode)value;
                Icon icon = node.getIcon();
                if (icon != null) {
                    this.setIcon(icon);
                }
                if ((sToolTip = node.getToolTip()) != null) {
                    this.setToolTipText(sToolTip);
                }
                return this;
            }
        }
    }
}

