/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common;

import MITI.MIRException;
import MITI.messages.MIRProfilerPartnerSDK.PPSDK;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledAttribute;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import MITI.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class XMLProcessor
implements ProfileLinkProcessor {
    private Profiler profiler;
    private boolean isDebugMode = true;
    private boolean useProfiledObjectIdentity;
    private File outputFile;
    private File currentModelFile;
    private Map<String, String> objectIdentityMap = new TreeMap<String, String>();
    private Set<ObjectIdentifier> visitedObjects = null;
    private PrintStream out = null;
    private PrintStream lineageOut = null;

    public XMLProcessor(Profiler profiler, File file, boolean bl) {
        this.profiler = profiler;
        this.outputFile = file;
        this.useProfiledObjectIdentity = bl;
    }

    public PrintStream updateOutput(ProfileLink profileLink) throws MIRException {
        boolean bl = false;
        ProfiledObject profiledObject = profileLink.getSourceNode();
        ProfiledObject profiledObject2 = profileLink.getDestinationNode();
        File file = null;
        if (profileLink instanceof AggregationProfileLink) {
            file = profiledObject == null ? this.getFile(profiledObject2) : (profiledObject.getObjectDefinition().getModelId() == profiledObject2.getObjectDefinition().getModelId() ? this.currentModelFile : this.getFile(profiledObject2));
        } else if (profileLink instanceof ReferenceProfileLink) {
            file = this.currentModelFile;
        } else if (profileLink instanceof LineageProfileLink) {
            File file2 = this.getFile(profiledObject2);
            if (file2.equals(this.currentModelFile)) {
                file = this.currentModelFile;
            } else {
                if (file2.exists()) {
                    file = this.getLineageFile();
                    if (this.lineageOut == null) {
                        this.lineageOut = this.openOutputStream(file);
                    }
                    return this.lineageOut;
                }
                file = file2;
            }
        }
        if (this.currentModelFile == null || !this.currentModelFile.equals(file)) {
            bl = true;
        }
        if (this.out != null && bl) {
            this.closeOutputStream(this.out);
        }
        if (this.out == null || bl) {
            this.currentModelFile = file;
            this.out = this.openOutputStream(file);
            this.objectIdentityMap.clear();
            this.visitedObjects = new HashSet<ObjectIdentifier>();
        }
        return this.out;
    }

    @Override
    public void process(ProfileLink profileLink) throws MIRException {
        PrintStream printStream = this.updateOutput(profileLink);
        if (profileLink instanceof AggregationProfileLink) {
            this.printAggregationLink((AggregationProfileLink)profileLink, printStream);
        } else if (profileLink instanceof ReferenceProfileLink) {
            this.printReferenceLink((ReferenceProfileLink)profileLink, printStream);
        } else if (profileLink instanceof LineageProfileLink) {
            this.printLineageLink((LineageProfileLink)profileLink, printStream);
        }
    }

    public void close() {
        this.closeOutputStream(this.out);
        this.closeOutputStream(this.lineageOut);
    }

    private String getObjectIdentity(ProfiledObject profiledObject) throws MIRException {
        String string = this.objectIdentityMap.get(profiledObject.toString());
        if (string == null) {
            string = this.useProfiledObjectIdentity ? this.profiler.getProfiledObjectIdentity(profiledObject) : this.profiler.getObjectIdentity(profiledObject);
            this.objectIdentityMap.put(profiledObject.toString(), string);
        }
        return string;
    }

    private void printObject(ProfiledObject profiledObject, boolean bl, PrintStream printStream) throws MIRException {
        ProfiledAttribute[] profiledAttributeArray;
        ProfiledObject profiledObject2;
        MIRProfileEntity mIRProfileEntity;
        boolean bl2;
        String string;
        boolean bl3;
        StringBuilder stringBuilder = new StringBuilder();
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        String string2 = this.getObjectIdentity(profiledObject);
        if (bl) {
            stringBuilder.append("<SrcObj");
        } else {
            stringBuilder.append("<DstObj");
        }
        stringBuilder.append(" n=\"" + XMLProcessor.escapeXMLChars(profiledObjectDefinition.getObjectName()) + "\"");
        if (string2 != null) {
            stringBuilder.append(" id=\"" + XMLProcessor.escapeXMLChars(string2) + "\"");
        }
        if (this.isDebugMode) {
            stringBuilder.append(" mId=\"" + profiledObjectDefinition.serialize() + "\"");
            stringBuilder.append(" mType=\"" + MIRElementType.toString(profiledObjectDefinition.getObjectType()) + "\"");
        }
        if (bl3 = this.profiler.isConnection(profiledObject)) {
            stringBuilder.append(" isConnection=\"true\"");
        }
        if ((string = this.profiler.getChecksum(profiledObject)) != null) {
            stringBuilder.append(" checksum=\"" + string + "\"");
        }
        if (!(bl2 = this.profiler.isRepeatableIdentity(profiledObject)) && !this.useProfiledObjectIdentity) {
            stringBuilder.append(" isRepeatable=\"false\"");
        }
        if ((mIRProfileEntity = this.profiler.getProfileEntity(profiledObject)) != null) {
            boolean bl4;
            stringBuilder.append(" type=\"" + mIRProfileEntity.getName() + "\"");
            if (mIRProfileEntity.isClassifier()) {
                stringBuilder.append(" isClassifier=\"true\"");
                boolean bl5 = this.profiler.isCaseSensitive(profiledObject);
                stringBuilder.append(" isCaseSensitive=\"" + bl5 + "\"");
                bl4 = this.profiler.isTemporary(profiledObject);
                stringBuilder.append(" isTemporary=\"" + bl4 + "\"");
            }
            if (mIRProfileEntity.isFeature()) {
                stringBuilder.append(" isFeature=\"true\"");
                ProfiledObject profiledObject3 = this.profiler.getClassifier(profiledObject);
                stringBuilder.append(" classifier=\"" + profiledObject3.getObjectDefinition().serialize() + "\"");
                bl4 = this.profiler.isCaseSensitive(profiledObject);
                stringBuilder.append(" isCaseSensitive=\"" + bl4 + "\"");
            }
            if (mIRProfileEntity.isReportItem()) {
                stringBuilder.append(" isReportItem=\"true\"");
                ProfiledObject profiledObject4 = this.profiler.getReportItemParent(profiledObject);
                if (profiledObject4 != null) {
                    stringBuilder.append(" parentReportItem=\"" + profiledObject4.getObjectDefinition().serialize() + "\"");
                }
            }
        }
        if ((profiledObject2 = this.profiler.getSynonymTargetSchema(profiledObject)) != null) {
            stringBuilder.append(" synonymTargetSchema=\"" + profiledObject2.getObjectDefinition().serialize() + "\"");
        }
        stringBuilder.append(">");
        printStream.println(stringBuilder.toString());
        MIRProfileGroup mIRProfileGroup = this.profiler.getProfileGroup(profiledObject);
        if (mIRProfileGroup != null) {
            printStream.println(" <Group name=\"" + XMLProcessor.escapeXMLChars(mIRProfileGroup.getName()) + "\"/>");
        }
        if (!bl && (profiledAttributeArray = this.profiler.getAttributes(profiledObject)) != null) {
            for (ProfiledAttribute profiledAttribute : profiledAttributeArray) {
                if (profiledAttribute.getDisplayName().equalsIgnoreCase("Object Id")) continue;
                printStream.println("<Att n=\"" + profiledAttribute.getDisplayName() + "\" v=\"" + XMLProcessor.escapeXMLChars(profiledAttribute.getValue()) + "\"/>");
            }
        }
        if (bl) {
            printStream.println("</SrcObj>");
        } else {
            printStream.println("</DstObj>");
        }
    }

    private void printAggregationLink(AggregationProfileLink aggregationProfileLink, PrintStream printStream) throws MIRException {
        Object object;
        ProfiledObject profiledObject = aggregationProfileLink.getSourceNode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<Agg");
        if (profiledObject != null && (object = aggregationProfileLink.getSourceToDestinationLinkMPath()) != null) {
            stringBuilder.append(" path=\"" + XMLProcessor.escapeXMLChars((String)object) + "\"");
        }
        stringBuilder.append(">");
        printStream.println(stringBuilder.toString());
        if (profiledObject != null) {
            this.printObject(profiledObject, true, printStream);
        }
        if ((object = aggregationProfileLink.getDestinationNode()) != null) {
            this.checkUniqueAggregationLink((ProfiledObject)object);
            this.printObject((ProfiledObject)object, false, printStream);
        }
        printStream.println("</Agg>");
    }

    private void printReferenceLink(ReferenceProfileLink referenceProfileLink, PrintStream printStream) throws MIRException {
        ProfiledObject profiledObject = referenceProfileLink.getSourceNode();
        String string = this.getObjectIdentity(profiledObject);
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        printStream.print("  <Ref");
        if (string != null) {
            printStream.print(" id=\"" + XMLProcessor.escapeXMLChars(string) + "\"");
        }
        if (this.isDebugMode) {
            printStream.print(" mId=\"" + profiledObjectDefinition.serialize() + "\"");
            printStream.print(" mType=\"" + MIRElementType.toString(profiledObjectDefinition.getObjectType()) + "\"");
        }
        printStream.println(">");
        String string2 = referenceProfileLink.getProfileLink().getRoleName();
        String string3 = string2 + ":" + referenceProfileLink.getSourceToDestinationLinkMPath();
        printStream.println("     <Lnk path=\"" + XMLProcessor.escapeXMLChars(string3) + "\">");
        ProfiledObject profiledObject2 = referenceProfileLink.getDestinationNode();
        String string4 = this.getObjectIdentity(profiledObject2);
        ProfiledObjectDefinition profiledObjectDefinition2 = profiledObject2.getObjectDefinition();
        printStream.print("       <Obj");
        if (string4 != null) {
            printStream.print(" id=\"" + XMLProcessor.escapeXMLChars(string4) + "\"");
        }
        if (this.isDebugMode) {
            printStream.print(" mId=\"" + profiledObjectDefinition2.serialize() + "\"");
            printStream.print(" mType=\"" + MIRElementType.toString(profiledObjectDefinition2.getObjectType()) + "\"");
        }
        printStream.println("/>");
        printStream.println("     </Lnk>");
        printStream.println("  </Ref>");
    }

    private void printLineageLink(LineageProfileLink lineageProfileLink, PrintStream printStream) throws MIRException {
        List<List<ProfiledObject>> list;
        int n;
        ProfiledObject profiledObject = lineageProfileLink.getDestinationNode();
        printStream.print("  <Lin ");
        if (this.isDebugMode) {
            printStream.print("dstMirId=\"" + XMLProcessor.escapeXMLChars(profiledObject.getObjectDefinition().toString()) + "\" ");
        } else {
            printStream.println("dst=\"" + XMLProcessor.escapeXMLChars(this.getObjectIdentity(profiledObject)) + "\" ");
        }
        printStream.println(">");
        this.printLineageLinkSource(lineageProfileLink, printStream);
        String[] stringArray = lineageProfileLink.getLinkExpressions();
        if (stringArray != null && stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= 0) continue;
                printStream.println("    <Exp e=\"" + XMLProcessor.escapeXMLChars(stringArray[n]) + "\"/>");
            }
        }
        if ((stringArray = lineageProfileLink.getParentLinkExpressions()) != null && stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= 0) continue;
            }
        }
        if ((list = lineageProfileLink.getSynonymChains()) != null) {
            for (List<ProfiledObject> list2 : list) {
                String string = "";
                for (ProfiledObject profiledObject2 : list2) {
                    if (!string.isEmpty()) {
                        string = string + "|";
                    }
                    string = string + profiledObject2.getObjectDefinition().serialize();
                }
                printStream.println("    <SynonymChain e=\"" + XMLProcessor.escapeXMLChars(string) + "\"/>");
            }
        }
        printStream.println("  </Lin>");
    }

    private void printLineageLinkSource(LineageProfileLink lineageProfileLink, PrintStream printStream) throws MIRException {
        ProfiledObject profiledObject = lineageProfileLink.getSourceNode();
        ProfiledObject profiledObject2 = lineageProfileLink.getDestinationNode();
        String string = this.getObjectIdentity(profiledObject);
        printStream.print("    <Src ");
        if (this.isDebugMode) {
            printStream.print("mirId=\"" + XMLProcessor.escapeXMLChars(profiledObject.getObjectDefinition().toString()) + "\" ");
        } else {
            printStream.println("id=\"" + XMLProcessor.escapeXMLChars(string) + "\" ");
        }
        if (this.isCrossLevelLink(profiledObject, profiledObject2)) {
            printStream.print("isCrossLevel=\"true\" ");
        }
        if (lineageProfileLink.getDatabaseOperation() != null) {
            printStream.print("databaseOperation=\"" + XMLProcessor.escapeXMLChars(lineageProfileLink.getDatabaseOperation().getObjectDefinition().toString()) + "\" ");
        }
        if (lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.STITCHING) {
            printStream.print("isStitchingLink=\"true\" ");
        } else if (lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.SEMANTIC_LINK) {
            printStream.print("isSemantic=\"true\" ");
        } else if (lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.SUMMARY_LINEAGE || lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE) {
            printStream.print("isSum=\"true\" ");
            if (lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE) {
                printStream.print("isControl=\"true\" ");
            }
            if (lineageProfileLink instanceof SummaryLineageProfileLink) {
                SummaryLineageProfileLink summaryLineageProfileLink = (SummaryLineageProfileLink)lineageProfileLink;
                if (!summaryLineageProfileLink.getDecorations().isEmpty()) {
                    printStream.print("decorations=\"" + XMLProcessor.escapeXMLChars(summaryLineageProfileLink.getDecorations()) + "\" ");
                }
                if (!summaryLineageProfileLink.getRuntimePath().isEmpty()) {
                    printStream.print("runtimePath=\"" + XMLProcessor.escapeXMLChars(summaryLineageProfileLink.getRuntimePath()) + "\" ");
                }
            }
        } else if (lineageProfileLink.getLinkType() == ProfileLink.LINK_TYPE.CONTROL_LINEAGE) {
            printStream.print("isControl=\"true\" ");
        }
        printStream.println("/>");
    }

    private void checkUniqueAggregationLink(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (profiledObjectDefinition.getGroupName() == null) {
            if (this.visitedObjects.contains(profiledObjectDefinition)) {
                MIRProfileEntity mIRProfileEntity = this.profiler.getProfileEntity(profiledObject);
                MIRProfile mIRProfile = mIRProfileEntity.getProfile();
                PPSDK.ERR_DUPLICATE_AGGREGATION_LINK.log(profiledObjectDefinition.toString(), mIRProfile.getName());
            } else {
                this.visitedObjects.add(profiledObjectDefinition);
            }
        }
    }

    private boolean isCrossLevelLink(ProfiledObject profiledObject, ProfiledObject profiledObject2) {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject2.getObjectDefinition();
        ProfiledObjectDefinition profiledObjectDefinition2 = profiledObject.getObjectDefinition();
        if (profiledObjectDefinition.isInstanceOf((short)123) && !profiledObjectDefinition2.isInstanceOf((short)77)) {
            return true;
        }
        if (profiledObjectDefinition.isInstanceOf((short)77) && !profiledObjectDefinition2.isInstanceOf((short)77)) {
            return true;
        }
        return profiledObjectDefinition.isInstanceOf((short)75) && !profiledObjectDefinition2.isInstanceOf((short)75);
    }

    private static String escapeXMLChars(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("[\u2019\u201d\u201c]", "'");
        return XmlUtil.escapeXml(string);
    }

    private File getFile(ProfiledObject profiledObject) {
        short s;
        File file = null;
        file = this.outputFile.isDirectory() ? (profiledObject.getObjectDefinition().getModelId() == 0 ? (MIR_Object.isInstanceOf(s = profiledObject.getObjectDefinition().getObjectType(), (short)286) ? new File(this.outputFile, "main.xml") : new File(this.outputFile, "model.xml")) : new File(this.outputFile, profiledObject.getObjectDefinition().getModelId() + ".xml")) : this.outputFile;
        return file;
    }

    private File getLineageFile() {
        File file = this.outputFile.isDirectory() ? new File(this.outputFile, "lineage.xml") : null;
        return file;
    }

    private PrintStream openOutputStream(File file) throws MIRException {
        PrintStream printStream;
        try {
            printStream = new PrintStream((OutputStream)new FileOutputStream(file), true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MIRException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MIRException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<ProfileOutput>");
        return printStream;
    }

    private void closeOutputStream(PrintStream printStream) {
        if (printStream != null) {
            printStream.println("</ProfileOutput>");
            printStream.close();
        }
    }
}

