/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.BrowseResultProcessor;
import MITI.bridges.profilingxml.common.XMLProcessor;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRModel;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.ProfilerFactory;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.sdk.profiles.impl.memory.MIRContentLoopDetector;
import MITI.sdk.profiles.impl.memory.simple.ProfilerSimpleImpl;
import MITI.util.file.FileUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ProfilerSDKDemo {
    private Integer profileId;
    private Profiler profiler;
    private ProfilerOptions options;
    private boolean useProfiledObjectIdentity = false;
    private HashSet<String> uniqueNames = new HashSet();

    public ProfilerSDKDemo() throws MIRException {
        this.options = new ProfilerOptions();
        this.options.setSkipOverOlapModels(false);
    }

    public void setRootProfileId(int n) {
        this.profileId = n;
    }

    public void close() {
    }

    private void harvestProfileEntities(ArrayList<String> arrayList, ArrayList<MIRProfileEntity> arrayList2, MIRProfile mIRProfile) {
        if (!arrayList.contains(mIRProfile.getName())) {
            MIRProfileEntity[] mIRProfileEntityArray;
            arrayList.add(mIRProfile.getName());
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray = mIRProfile.getProfileEntities()) {
                arrayList2.add(mIRProfileEntity);
                if (mIRProfileEntity.getContentProfile() == null) continue;
                MIRProfile mIRProfile2 = MIRProfiler.getProfile(mIRProfileEntity.getContentProfile());
                this.harvestProfileEntities(arrayList, arrayList2, mIRProfile2);
            }
        }
    }

    private void processProfileEntity(MIRProfileEntity mIRProfileEntity, PrintStream printStream) throws MIRException {
        MIRProfileGroup[] mIRProfileGroupArray;
        MIRProfile mIRProfile;
        MIRProfileEntity mIRProfileEntity2;
        String string;
        boolean bl = mIRProfileEntity.isClassifier();
        boolean bl2 = mIRProfileEntity.isFeature();
        boolean bl3 = mIRProfileEntity.isDataPackage();
        String string2 = mIRProfileEntity.getCondition() == null ? "" : mIRProfileEntity.getCondition().toMPath();
        String string3 = mIRProfileEntity.getIcon();
        if (null == string3 || 0 == string3.length()) {
            string = MIRElementType.getName(mIRProfileEntity.getElementType());
            string3 = string + ".gif";
        }
        if (this.uniqueNames.contains(string = mIRProfileEntity.getName())) {
            string = String.format("%d.%s", mIRProfileEntity.getId(), string);
        }
        this.uniqueNames.add(string);
        printStream.println(" <Entity name=\"" + string + "\" icon=\"" + string3 + "\" class=\"" + MIRElementType.toString(mIRProfileEntity.getElementType()) + "\" condition=\"" + string2 + "\" isDataPackage=\"" + bl3 + "\" isClassifier=\"" + bl + "\" isFeature=\"" + bl2 + "\" isRoot=\"" + mIRProfileEntity.isRoot() + "\">");
        printStream.println("  <Props>");
        MIRProfileProperty[] mIRProfilePropertyArray = mIRProfileEntity.getProfileAttributes();
        for (MIRProfileProperty mIRProfileProperty : mIRProfilePropertyArray) {
            this.processProfileProperty(mIRProfileProperty, printStream);
        }
        printStream.println("  </Props>");
        Object[] objectArray = mIRProfileEntity.getProfileLinks();
        if (objectArray != null && objectArray.length > 0) {
            printStream.println("  <Links>");
            for (Object object : objectArray) {
                this.processProfileLink((MIRProfileLink)object, printStream);
            }
            printStream.println("  </Links>");
        }
        if (mIRProfileEntity.getContentProfile() != null && (mIRProfileEntity2 = (mIRProfile = MIRProfiler.getProfile(mIRProfileEntity.getContentProfile())).getRootProfileEntity()) != null) {
            printStream.println("  <LinkedEntity profile =\"" + mIRProfileEntity.getContentProfile() + "\" name=\"" + mIRProfileEntity2.getName() + "\"/>");
        }
        if ((mIRProfileGroupArray = mIRProfileEntity.getProfileGroups()) != null && mIRProfileGroupArray.length > 0) {
            printStream.println("  <Groups>");
            for (MIRProfileGroup mIRProfileGroup : mIRProfileGroupArray) {
                this.processProfileGroup(mIRProfileGroup, printStream);
            }
            printStream.println("  </Groups>");
        }
        printStream.println(" </Entity>");
    }

    private void processProfileProperty(MIRProfileProperty mIRProfileProperty, PrintStream printStream) {
        printStream.println("    <prop name=\"" + mIRProfileProperty.getName() + "\"/>");
    }

    private void processProfileGroup(MIRProfileGroup mIRProfileGroup, PrintStream printStream) {
        printStream.println("    <group name=\"" + mIRProfileGroup.getName() + "\">");
        MIRProfileLink[] mIRProfileLinkArray = mIRProfileGroup.getProfileLinks();
        if (mIRProfileLinkArray != null) {
            for (MIRProfileLink mIRProfileLink : mIRProfileLinkArray) {
                this.processProfileLink(mIRProfileLink, printStream);
            }
        }
        printStream.println("    </group>");
    }

    private void processProfileLink(MIRProfileLink mIRProfileLink, PrintStream printStream) {
        MIRProfileEntity[] mIRProfileEntityArray = mIRProfileLink.getChildren();
        if (mIRProfileEntityArray != null && mIRProfileEntityArray.length > 0) {
            printStream.println("    <link name=\"" + mIRProfileLink.getRoleName() + "\" path=\"" + mIRProfileLink.getPath() + "\" isChild=\"" + mIRProfileLink.isChildLinkType() + "\">");
            for (int i = 0; i < mIRProfileEntityArray.length; ++i) {
                MIRProfileEntity mIRProfileEntity = mIRProfileEntityArray[i];
                printStream.println("      <EntityRef name=\"" + mIRProfileEntity.getName() + "\"/>");
            }
            printStream.println("    </link>");
        }
    }

    private void processProfile(MIRProfile mIRProfile, PrintStream printStream) throws MIRException {
        System.out.printf("\nDesign-time metamodel generation for profile '%s' (id = %d)\n", mIRProfile.getName(), mIRProfile.getProfileId());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MIRProfileEntity> arrayList2 = new ArrayList<MIRProfileEntity>();
        this.harvestProfileEntities(arrayList, arrayList2, mIRProfile);
        System.out.println("Looked at the following profiles:");
        for (String object : arrayList) {
            System.out.println(object);
        }
        printStream.println("<Entities>");
        for (MIRProfileEntity mIRProfileEntity : arrayList2) {
            this.processProfileEntity(mIRProfileEntity, printStream);
        }
        printStream.println("</Entities>");
    }

    public void processProfile(String string, PrintStream printStream) throws MIRException {
        MIRProfiler.loadProfiles();
        MIRProfile mIRProfile = MIRProfiler.getProfile(string);
        if (mIRProfile == null) {
            System.out.println("Failed to find MIRProfile object for " + string);
            return;
        }
        this.processProfile(mIRProfile, printStream);
    }

    public void processProfile(int n, PrintStream printStream) throws MIRException {
        MIRProfiler.loadProfiles();
        MIRProfile mIRProfile = MIRProfiler.getProfile(n);
        if (mIRProfile == null) {
            System.out.println("Failed to find MIRProfile object for profile ID=" + n);
            return;
        }
        this.processProfile(mIRProfile, printStream);
    }

    public void processModel(File file, File file2) throws MIRException {
        this.createProfiler(file);
        this.printModel(file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createProfiler(File file) throws MIRException {
        MIRMixCache mIRMixCache = null;
        MIRModel mIRModel = null;
        if (!file.exists()) {
            throw new MIRException(PRFLR.INPUT_FILE_NOT_FOUND.getMessage(file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            File file2 = MIRMixManager.getMultiModelFile(file);
            File file3 = MIRMixManager.getModelFile(file);
            if (file2.exists()) {
                mIRMixCache = new MIRMixCache(file);
                mIRModel = mIRMixCache.loadDirectoryStructure();
            } else {
                if (!file3.exists()) throw new MIRException(PRFLR.INPUT_FILE_NOT_FOUND.getMessage(file2.getAbsolutePath()));
                mIRMixCache = new MIRMixCache(file);
                mIRModel = mIRMixCache.readFile(file3);
            }
        } else {
            mIRMixCache = new MIRMixCache(file);
            mIRModel = mIRMixCache.readFile(file);
        }
        this.createProfiler(mIRModel, mIRMixCache);
    }

    private void createProfiler(MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        MIRContentLoopDetector mIRContentLoopDetector;
        boolean bl;
        MIRDirectoryStructureModel mIRDirectoryStructureModel;
        if (mIRModel instanceof MIRDirectoryStructureModel && (mIRDirectoryStructureModel = (MIRDirectoryStructureModel)mIRModel).getType() == 4 && (bl = (mIRContentLoopDetector = new MIRContentLoopDetector()).detectLoops(mIRDirectoryStructureModel, true))) {
            this.profiler = ProfilerFactory.createExtended(mIRModel, mIRMixCache);
        }
        if (this.profiler == null) {
            this.profiler = ProfilerFactory.create(mIRModel, mIRMixCache);
        }
        if (this.profileId != null) {
            this.profiler.setRootProfile(this.profileId);
        }
        this.profiler.setOptions(this.options);
    }

    public void processModel(MIRModel mIRModel, MIRMixCache mIRMixCache, File file) throws MIRException {
        this.createProfiler(mIRModel, mIRMixCache);
        this.printModel(file);
    }

    public void processBrowseResults(File file) throws MIRException {
        this.createProfiler(file);
        ProfiledObject profiledObject = this.profiler.getRootObject();
        if (profiledObject == null) {
            System.out.println("Failed to retrieve root object from profiler!");
            return;
        }
        BrowseResultProcessor browseResultProcessor = new BrowseResultProcessor(this.profiler, profiledObject);
        browseResultProcessor.processBrowseResult(profiledObject, null);
        Iterator<ProfileLink> iterator = this.profiler.createIterator(profiledObject);
        if (iterator == null) {
            System.out.println("Failed to create the iterator for the root object. Please check the input model or the profile for errors.");
            return;
        }
        while (iterator.hasNext()) {
            ProfileLink profileLink = iterator.next();
            browseResultProcessor.process(profileLink);
        }
    }

    private void printModel(File file) throws MIRException {
        File[] fileArray;
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : fileArray = file.listFiles()) {
                    if (FileUtil.delete(file2)) continue;
                    System.out.println("Failed to delete " + file);
                }
            } else {
                file.delete();
            }
        }
        if ((fileArray = this.profiler.getRootObject()) == null) {
            System.out.println("Failed to retrieve root object from profiler!");
            return;
        }
        MIRProfile mIRProfile = this.profiler.getRootProfile();
        XMLProcessor xMLProcessor = new XMLProcessor(this.profiler, file, this.useProfiledObjectIdentity);
        if (this.profiler instanceof ProfilerSimpleImpl) {
            this.profiler.iterate((ProfiledObject)fileArray, xMLProcessor);
        } else {
            Iterator<ProfileLink> iterator = this.profiler.createIterator((ProfiledObject)fileArray);
            if (iterator == null) {
                System.out.println("Failed to create the iterator for the root object. Please check the input model or the profile for errors.");
                return;
            }
            while (iterator.hasNext()) {
                ProfileLink profileLink = iterator.next();
                xMLProcessor.process(profileLink);
            }
        }
        xMLProcessor.close();
    }

    public void setUseProfiledObjectIdentity(boolean bl) {
        this.useProfiledObjectIdentity = bl;
    }
}

