/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common;

import MITI.MIRException;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.bridges.mimb.MIRModelBridges;
import MITI.bridges.profiles.ProfileIds;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BridgeProfiles {
    private static final Map<String, Integer> bridge2ETLSummaryProfileMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> bridge2ProfileMap;

    private static String getBridgeId(String string) {
        String string2 = new String(string);
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.endsWith("Export") || string2.endsWith("Import")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2;
    }

    public static int getRootProfileIDFromBridgeID(String string, boolean bl) {
        Integer n = null;
        String string2 = BridgeProfiles.getBridgeId(string);
        if (bl) {
            n = bridge2ETLSummaryProfileMap.get(string2);
            if (n == null) {
                n = bridge2ProfileMap.get(string2);
            }
        } else {
            n = bridge2ProfileMap.get(string2);
        }
        if (n == null) {
            throw new IllegalArgumentException("Bridge '" + string2 + "' has no default profile.");
        }
        return n;
    }

    private static void validate(File file) throws MIRException {
        MIRModelBridges mIRModelBridges = MIRModelBridges.load(file);
        HashSet<String> hashSet = new HashSet<String>();
        Collection<BridgeLibrary> collection = mIRModelBridges.getBridges(false);
        for (BridgeLibrary object : collection) {
            hashSet.add(object.getBridgeId());
        }
        for (String string : hashSet) {
            BridgeProfiles.getRootProfileIDFromBridgeID(string, false);
        }
        for (String string : bridge2ProfileMap.keySet()) {
            if (hashSet.contains(string)) continue;
            throw new MIRException("Bridge identifier '" + string + "' is not current");
        }
    }

    public static void main(String[] stringArray) throws MIRException {
        String string = "";
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        File file = new File(string);
        if (string.isEmpty() || !file.isDirectory()) {
            throw new IllegalArgumentException("Specify MIMB Home directory as first argument.");
        }
        BridgeProfiles.validate(file);
        System.out.println("validated successfully.");
    }

    static {
        bridge2ETLSummaryProfileMap.put("AscentialDataStage", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("InformaticaDeveloper", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("InformaticaDeveloperRepository", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("InformaticaPowerCenter", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("InformaticaPowerCenterRepository", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("MicrosoftExcel", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("MicrosoftSqlServerIs", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("MicrosoftSqlServerRepositoryIs", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("MicrosoftSqlServerRepositoryIsDb", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("OracleDataIntegrator", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("OracleDataIntegrator10", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("OracleWarehouseBuilderOmb", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("Talend", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("PentahoDataIntegration", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("SapBoDataServices", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ETLSummaryProfileMap.put("SasDi", ProfileIds.META_INTEGRATION_ETL_SUMMARY__REPOSITORY);
        bridge2ProfileMap = new HashMap<String, Integer>();
        bridge2ProfileMap.put("Alteryx", ProfileIds.ALTERYX__REPOSITORY);
        bridge2ProfileMap.put("AlteryxRepository", ProfileIds.ALTERYX__REPOSITORY);
        bridge2ProfileMap.put("AmazonGlue", 0);
        bridge2ProfileMap.put("AmazonS3", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("ApacheAtlas", ProfileIds.ATLAS__REPOSITORY);
        bridge2ProfileMap.put("ApacheCassandra", ProfileIds.CASSANDRA__DATABASE);
        bridge2ProfileMap.put("ApacheDruid", ProfileIds.APACHEDRUID__DRUID_REPOSITORY);
        bridge2ProfileMap.put("ApacheHDFS", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("ApacheHive", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("ApacheHiveMetastore", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("ApacheKafka", ProfileIds.APACHEKAFKA__CLUSTER);
        bridge2ProfileMap.put("ApacheOrc", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("ApacheSpark", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("ApacheSqoop", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("ApacheWebHCat", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("AscentialDataStage", ProfileIds.IBM_INFOSPHERE_DATASTAGE__REPOSITORY);
        bridge2ProfileMap.put("Avro", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("BoAnalytic", ProfileIds.SAP_BUSINESSOBJECTS__ANALYTIC);
        bridge2ProfileMap.put("BoCrystalReportRasFile", ProfileIds.SAP_BUSINESSOBJECTS__CRYSTALREPORT);
        bridge2ProfileMap.put("BoCrystalReportRasRepo", ProfileIds.SAP_BUSINESSOBJECTS__CRYSTALREPORT);
        bridge2ProfileMap.put("BoDesigner", ProfileIds.SAP_BUSINESSOBJECTS__UNIVERSE);
        bridge2ProfileMap.put("BoDesignerRepo", ProfileIds.SAP_BUSINESSOBJECTS__UNIVERSE);
        bridge2ProfileMap.put("BoDesignerUnv", ProfileIds.SAP_BUSINESSOBJECTS__UNIVERSE);
        bridge2ProfileMap.put("BoInformationDesignToolRepo", ProfileIds.SAP_BUSINESSOBJECTS__UNIVERSE);
        bridge2ProfileMap.put("BoInformationDesignToolUnx", ProfileIds.SAP_BUSINESSOBJECTS__UNIVERSE);
        bridge2ProfileMap.put("BoReporter", ProfileIds.SAP_BUSINESSOBJECTS__DESKTOPINTELLIGENCE);
        bridge2ProfileMap.put("BoReporterFile", ProfileIds.SAP_BUSINESSOBJECTS__DESKTOPINTELLIGENCE);
        bridge2ProfileMap.put("BoReporterRepo", ProfileIds.SAP_BUSINESSOBJECTS__DESKTOPINTELLIGENCE);
        bridge2ProfileMap.put("BoRepository11", ProfileIds.SAP_BUSINESSOBJECTS__REPOSITORY);
        bridge2ProfileMap.put("BoRepository5to6", ProfileIds.SAP_BUSINESSOBJECTS__REPOSITORY);
        bridge2ProfileMap.put("BoWebIntelligence", ProfileIds.SAP_BUSINESSOBJECTS__WEBINTELLIGENCE);
        bridge2ProfileMap.put("CaAdw", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("CaCoolGen", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("CaErwin3Erx", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin4Xml", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin7ModelManager", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin7Xml", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin8ModelManager", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin8Xml", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin9Mart", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaErwin9Xml", ProfileIds.CA_ERWIN_DATA_MODELER__MODEL);
        bridge2ProfileMap.put("CaGroundWorks", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("CaMart9", ProfileIds.CA_ERWIN_DATA_MODELER__MART);
        bridge2ProfileMap.put("CaModelManager7", ProfileIds.CA_ERWIN_DATA_MODELER__MART);
        bridge2ProfileMap.put("CaModelManager8", ProfileIds.CA_ERWIN_DATA_MODELER__MART);
        bridge2ProfileMap.put("CaParadigmPlus", 0);
        bridge2ProfileMap.put("CaRepositoryDsOdbc", 0);
        bridge2ProfileMap.put("CaTerrainDb2", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("CaTerrainMap", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("ClouderaImpala", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("ClouderaNavigator", ProfileIds.CLOUDERANAVIGATOR__REPOSITORY);
        bridge2ProfileMap.put("CobolCopybook", ProfileIds.COBOL_COPYBOOK__COBOL);
        bridge2ProfileMap.put("CognosDataModule", ProfileIds.COGNOS_BI_REPORTING__DATAMODULE);
        bridge2ProfileMap.put("CognosExploration", ProfileIds.COGNOS_BI_REPORTING__DASHBOARD);
        bridge2ProfileMap.put("CognosImpromptu", 0);
        bridge2ProfileMap.put("CognosPowerPlayTransformer", ProfileIds.COGNOS_BI_REPORTING__POWERPLAY);
        bridge2ProfileMap.put("CognosRnFrameworkManager1", ProfileIds.COGNOS_BI_REPORTING__FRAMEWORKMANAGER);
        bridge2ProfileMap.put("CognosRnFrameworkManager2", ProfileIds.COGNOS_BI_REPORTING__FRAMEWORKMANAGER);
        bridge2ProfileMap.put("CognosRnModelRepository", ProfileIds.COGNOS_BI_REPORTING__FRAMEWORKMANAGER);
        bridge2ProfileMap.put("CognosRnQueryStudio", ProfileIds.COGNOS_BI_REPORTING__QUERYSTUDIO);
        bridge2ProfileMap.put("CognosRnReportRepository", ProfileIds.COGNOS_BI_REPORTING__REPORTSTUDIO);
        bridge2ProfileMap.put("CognosRnReportStudio", ProfileIds.COGNOS_BI_REPORTING__REPORTSTUDIO);
        bridge2ProfileMap.put("CognosRnRepository", ProfileIds.COGNOS_BI_REPORTING__REPOSITORY);
        bridge2ProfileMap.put("CouchDb", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("DdlScript", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("DdlScriptApacheHiveQL", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("DdlScriptMicrosoftSqlServer", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("DdlScriptOracle", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("DdlScriptTeradata", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("Denodo", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("EmbarcaderoErStudio", ProfileIds.EMBARCADERO_ER_STUDIO__DIAGRAM);
        bridge2ProfileMap.put("EmbarcaderoErStudioRepository", ProfileIds.EMBARCADERO_ER_STUDIO__REPOSITORY);
        bridge2ProfileMap.put("ExcelFile", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("FlatFile", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("FileSystem", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("GoogleBigQuery", ProfileIds.GOOGLE_BIGQUERY__PROJECT);
        bridge2ProfileMap.put("GoogleStorage", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("HBase", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("Hl7XmlDtd", 0);
        bridge2ProfileMap.put("HyperionEis", 0);
        bridge2ProfileMap.put("HyperionEssbase", 0);
        bridge2ProfileMap.put("IbmDb2CubeViews", 0);
        bridge2ProfileMap.put("IbmInfoSphereDiscovery", 0);
        bridge2ProfileMap.put("IbmRationalDataArchitect", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("IbmRationalRose40", 0);
        bridge2ProfileMap.put("IbmRationalRose98", 0);
        bridge2ProfileMap.put("IbmRationalRoseDm", 0);
        bridge2ProfileMap.put("IbmRationalSoftwareArchitect", 0);
        bridge2ProfileMap.put("IbmWisCm8Xml", 0);
        bridge2ProfileMap.put("IbmWisCm9Xml", 0);
        bridge2ProfileMap.put("InformaticaDeveloper", ProfileIds.INFORMATICA_POWERDEVELOPER__REPOSITORY);
        bridge2ProfileMap.put("InformaticaDeveloperRepository", ProfileIds.INFORMATICA_POWERDEVELOPER__REPOSITORY);
        bridge2ProfileMap.put("InformaticaPowerCenter", ProfileIds.INFORMATICA_POWERCENTER__REPOSITORY);
        bridge2ProfileMap.put("InformaticaPowerCenterRepository", ProfileIds.INFORMATICA_POWERCENTER__REPOSITORY);
        bridge2ProfileMap.put("InitiateMdm", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("Jdbc", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcActianVectorwise", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcAmazonAthena", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcAmazonAurora", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcGreenplum", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcHpVertica", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcIbmDb2Udb", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcSpanner", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcPresto", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcMicrosoftSqlServer", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcMicrosoftAzureSqlDatabase", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcMicrosoftAzureSqlDataWarehouse", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcMySQL", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcNetezza", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcOracle", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcPostgreSql", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcRedShift", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcSAPHana", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcSnowflake", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcSybase", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("JdbcTeradata", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("Json", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("KafkaSchemaRegistry", ProfileIds.KAFKASCHEMAREGISTRY__KAFKASCHEMAREGISTRY);
        bridge2ProfileMap.put("KalidoDiw", 0);
        bridge2ProfileMap.put("Looker", ProfileIds.LOOKER__SERVER);
        bridge2ProfileMap.put("MarkLogic", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("MerantAppMaster", 0);
        bridge2ProfileMap.put("MetaIntegrationCustomScript", 0);
        bridge2ProfileMap.put("MetaIntegrationDatabase", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("MetaIntegrationDataDocumenter", ProfileIds.META_INTEGRATION__PHYSICAL_DATA_MODEL);
        bridge2ProfileMap.put("MetaIntegrationDataMapping", ProfileIds.META_INTEGRATION);
        bridge2ProfileMap.put("MetaIntegrationDataSet", ProfileIds.META_INTEGRATION);
        bridge2ProfileMap.put("MetaIntegrationMultiModelXml", ProfileIds.META_INTEGRATION);
        bridge2ProfileMap.put("MetaIntegrationRepository", ProfileIds.META_INTEGRATION);
        bridge2ProfileMap.put("MetaIntegrationXml", ProfileIds.META_INTEGRATION);
        bridge2ProfileMap.put("MicrosoftAdomd", 0);
        bridge2ProfileMap.put("MicrosoftAzureBlobStorage", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("MicrosoftAzureCosmosDB", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("MicrosoftAzureDataFactory", ProfileIds.MICROSOFT_AZURE_DATA_FACTORY__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftAzureDataLakeStorage", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("MicrosoftAzureDataLakeStorageGen2", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("MicrosoftAzurePowerBI", ProfileIds.MICROSOFT_POWER_BI__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftExcel", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("MicrosoftPowerBIFile", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__POWERBI_REPORT);
        bridge2ProfileMap.put("MicrosoftPowerBIReportServer", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerDso", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerDso70", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerDso80", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerDso90", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerDsv", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__DATA_SOURCE_VIEW);
        bridge2ProfileMap.put("MicrosoftSqlServerIs", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerMdsMdc", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2005", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2008", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2012", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2014", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2016", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAs2017", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2005", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2008", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2012", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2014", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2016", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryAsRs2017", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2005", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2008", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2012", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2014", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2016", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIs2017", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryIsDb", ProfileIds.MICROSOFT_SQL_SERVER_IS__PACKAGE);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryRs", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPORTING_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryRs2005", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPORTING_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepositoryRs2012", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPORTING_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerRepoXif", 0);
        bridge2ProfileMap.put("MicrosoftSqlServerRs", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPORTING_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerXMLA", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__ANALYSIS_SERVICES);
        bridge2ProfileMap.put("MicrosoftSqlServerAs", ProfileIds.MICROSOFT_SQL_SERVER_ASRS__REPOSITORY);
        bridge2ProfileMap.put("MicroStrategy", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategyC", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy70", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy750", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy752", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy800", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy900", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy1050", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MicroStrategy1100", ProfileIds.MICROSTRATEGY__PROJECT_SOURCE);
        bridge2ProfileMap.put("MongoDB", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("NcrTeradataMds", 0);
        bridge2ProfileMap.put("NcrTeradataMds50", 0);
        bridge2ProfileMap.put("NcrTeradataMds51", 0);
        bridge2ProfileMap.put("NcrTeradataMds60", 0);
        bridge2ProfileMap.put("OmgCwmXmi", 0);
        bridge2ProfileMap.put("OmgCwmXmiPre10", 0);
        bridge2ProfileMap.put("OmgUml2Xmi", ProfileIds.UML_OBJECT_MODEL__UML);
        bridge2ProfileMap.put("OmgUmlXmi", ProfileIds.UML_OBJECT_MODEL__UML);
        bridge2ProfileMap.put("OmgUmlXmiArgoUml", ProfileIds.UML_OBJECT_MODEL__UML);
        bridge2ProfileMap.put("OpenApi", ProfileIds.OPENAPI__API);
        bridge2ProfileMap.put("OpenStackSwift", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("OracleBIAnswers", ProfileIds.ORACLE_BUSINESS_INTELLIGENCE__ANSWERS_REPORT);
        bridge2ProfileMap.put("OracleBIEE", ProfileIds.ORACLE_BUSINESS_INTELLIGENCE__WEB_CATALOG);
        bridge2ProfileMap.put("OracleBIServer", ProfileIds.ORACLE_BUSINESS_INTELLIGENCE__RPD_REPOSITORY);
        bridge2ProfileMap.put("OracleDAC", ProfileIds.INFORMATICA_POWERCENTER__REPOSITORY);
        bridge2ProfileMap.put("OracleDataIntegrator", ProfileIds.ORACLE_DATA_INTEGRATOR__REPOSITORY_ORGANIZATION);
        bridge2ProfileMap.put("OracleDataIntegrator10", ProfileIds.ORACLE_DATA_INTEGRATOR__REPOSITORY_ORGANIZATION);
        bridge2ProfileMap.put("OracleDataModeler4", ProfileIds.ORACLE_DATA_MODELER__DESIGN);
        bridge2ProfileMap.put("OracleDesigner", 0);
        bridge2ProfileMap.put("OracleFSAA", ProfileIds.OFSAA_DI__REPOSITORY);
        bridge2ProfileMap.put("OracleFSAAReporting", ProfileIds.OFSAA__BI);
        bridge2ProfileMap.put("OracleObjectStorageClassic", ProfileIds.FILE_SYSTEM__DIRECTORY);
        bridge2ProfileMap.put("OracleWarehouseBuilderOmb", 0);
        bridge2ProfileMap.put("Parquet", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("PentahoDataIntegration", ProfileIds.PENTAHODI__REPOSITORY);
        bridge2ProfileMap.put("PopkinSa", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("PopkinSaEncy", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("PopkinSaFile", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("PositionalFile", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("ProActivity", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("QlikSense", ProfileIds.QLIKSENSE__APP);
        bridge2ProfileMap.put("QlikSenseServer", ProfileIds.QLIKSENSE__HUB);
        bridge2ProfileMap.put("QlikView", ProfileIds.QLIKVIEW__QVW);
        bridge2ProfileMap.put("QlikViewFiles", ProfileIds.QLIKVIEW__APPLICATION);
        bridge2ProfileMap.put("SalesForceObjects", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("SapBw", ProfileIds.SAP_BUSINESS_WAREHOUSE__SAP_BW);
        bridge2ProfileMap.put("SapBoDataServices", ProfileIds.SAPBODATASERVICES__REPOSITORY);
        bridge2ProfileMap.put("SapMdm", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SapR3", ProfileIds.SAP_ERP_CENTRAL_COMPONENT__SAP_ERP_CENTRAL_COMPONENT);
        bridge2ProfileMap.put("SasBi", ProfileIds.SAS__REPOSITORY);
        bridge2ProfileMap.put("SasDb", ProfileIds.SAS__CONNECTION);
        bridge2ProfileMap.put("SasDi", ProfileIds.SAS__REPOSITORY);
        bridge2ProfileMap.put("SelectSe", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SilverrunRdm", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SilverrunRdm244", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SilverrunRdm262", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SilverrunRdm272", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SilverrunRdm284", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("SqlQuery", 0);
        bridge2ProfileMap.put("SqlScript", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptApacheHiveQL", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptIbmDb2", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptMicrosoftSqlServerTransactSQL", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptOraclePLSQL", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptPostgreSql", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptSas", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptSnowflake", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SqlScriptTeradata", ProfileIds.SQLSCRIPT__DIRECTORY);
        bridge2ProfileMap.put("SybasePowerDesignerCdm06", ProfileIds.SYBASE_POWERDESIGNER__CONCEPTUAL_DATA_MODEL);
        bridge2ProfileMap.put("SybasePowerDesignerCdm07", ProfileIds.SYBASE_POWERDESIGNER__CONCEPTUAL_DATA_MODEL);
        bridge2ProfileMap.put("SybasePowerDesignerLdm15", ProfileIds.SYBASE_POWERDESIGNER__LOGICAL_DATA_MODEL);
        bridge2ProfileMap.put("SybasePowerDesignerPdm06", ProfileIds.SYBASE_POWERDESIGNER__PHYSICAL_DATA_MODEL);
        bridge2ProfileMap.put("SybasePowerDesignerPdm07", ProfileIds.SYBASE_POWERDESIGNER__PHYSICAL_DATA_MODEL);
        bridge2ProfileMap.put("SyncsortDMExpress", 0);
        bridge2ProfileMap.put("SyncsortDMExpress624", 0);
        bridge2ProfileMap.put("Tableau", ProfileIds.TABLEAU__WORKBOOK);
        bridge2ProfileMap.put("TableauExtract", ProfileIds.RDBMS_RELATIONAL_DATABASE__DATABASE);
        bridge2ProfileMap.put("TableauServer", ProfileIds.TABLEAU__TABLEAUDIRECTORY);
        bridge2ProfileMap.put("Talend", ProfileIds.TALEND__REPOSITORY);
        bridge2ProfileMap.put("TalendDataPreparation", 0);
        bridge2ProfileMap.put("TalendMdm", ProfileIds.XML_SCHEMA__XSD);
        bridge2ProfileMap.put("TeradataTpt", ProfileIds.TERADATATPT__DIRECTORY);
        bridge2ProfileMap.put("ThoughtSpotBi", ProfileIds.THOUGHTSPOT__REPOSITORY);
        bridge2ProfileMap.put("TibcoSpotfireDocument", ProfileIds.TIBCO_SPOTFIRE__DOCUMENT);
        bridge2ProfileMap.put("TibcoSpotfireServer", ProfileIds.TIBCO_SPOTFIRE__SERVER);
        bridge2ProfileMap.put("TibcoSpotfireSbdf", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("TibcoSpotfireStdf", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("Trillium", 0);
        bridge2ProfileMap.put("VisibleAdvantage", ProfileIds.DATA_MODELING__BUSINESS);
        bridge2ProfileMap.put("W3cOwl", ProfileIds.UML_OBJECT_MODEL__UML);
        bridge2ProfileMap.put("W3cWsdl", ProfileIds.FILE_SYSTEM__WSDL);
        bridge2ProfileMap.put("W3cXml", ProfileIds.FILE_SYSTEM__FILE);
        bridge2ProfileMap.put("W3cXmlDtd", ProfileIds.XML_SCHEMA__XSD);
        bridge2ProfileMap.put("W3cXmlXsd", ProfileIds.XML_SCHEMA__XSD);
        bridge2ProfileMap.put("W3cXmlSchema", ProfileIds.FILE_SYSTEM__FILE);
    }
}

