/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.cluster.PrivilegeEventChannel;
import org.apache.jackrabbit.core.cluster.PrivilegeEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.privilege.ParseException;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionReader;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionWriter;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegeRegistry
implements PrivilegeEventListener {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeRegistry.class);
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    public static final String REP_WRITE = "{internal}write";
    public static final Name REP_WRITE_NAME = NAME_FACTORY.create("{internal}write");
    public static final String REP_PRIVILEGE_MANAGEMENT = "{internal}privilegeManagement";
    public static final Name REP_PRIVILEGE_MANAGEMENT_NAME = NAME_FACTORY.create("{internal}privilegeManagement");
    public static final int NO_PRIVILEGE = 0;
    private static final int READ = 1;
    private static final int MODIFY_PROPERTIES = 2;
    private static final int ADD_CHILD_NODES = 4;
    private static final int REMOVE_CHILD_NODES = 8;
    private static final int REMOVE_NODE = 16;
    private static final int READ_AC = 32;
    private static final int MODIFY_AC = 64;
    private static final int NODE_TYPE_MNGMT = 128;
    private static final int VERSION_MNGMT = 256;
    private static final int LOCK_MNGMT = 512;
    private static final int LIFECYCLE_MNGMT = 1024;
    private static final int RETENTION_MNGMT = 2048;
    private static final int WORKSPACE_MNGMT = 4096;
    private static final int NODE_TYPE_DEF_MNGMT = 8192;
    private static final int NAMESPACE_MNGMT = 16384;
    private static final int PRIVILEGE_MNGMT = 32768;
    private static final Map<Name, Integer> PRIVILEGE_NAMES = new HashMap<Name, Integer>();
    private static final String CUSTOM_PRIVILEGES_RESOURCE_NAME = "/privileges/custom_privileges.xml";
    protected final Map<Name, Definition> registeredPrivileges = new HashMap<Name, Definition>();
    private final Map<PrivilegeBits, Set<Name>> bitsToNames = new HashMap<PrivilegeBits, Set<Name>>();
    private final Map<Listener, Listener> listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));
    private final NamespaceRegistry namespaceRegistry;
    private final CustomPrivilegeStore customPrivilegesStore;
    private final NameResolver resolver;
    private PrivilegeBits nextBits = PrivilegeBits.getInstance(32768L).nextBits();
    private PrivilegeEventChannel eventChannel;

    public PrivilegeRegistry(NamespaceRegistry namespaceRegistry, FileSystem fs) throws RepositoryException {
        this.namespaceRegistry = namespaceRegistry;
        this.customPrivilegesStore = new CustomPrivilegeStore(new FileSystemResource(fs, CUSTOM_PRIVILEGES_RESOURCE_NAME));
        this.cacheDefinitions(this.createBuiltInPrivilegeDefinitions());
        try {
            Map customDefs = this.customPrivilegesStore.load();
            Map<Name, Definition> definitions = this.createCustomDefinitions(customDefs);
            this.cacheDefinitions(definitions);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to load custom privileges", (Throwable)e);
        }
        catch (FileSystemException e) {
            throw new RepositoryException("Failed to load custom privileges", (Throwable)e);
        }
        catch (ParseException e) {
            throw new RepositoryException("Failed to load custom privileges", (Throwable)e);
        }
        this.resolver = new DefaultNamePathResolver(namespaceRegistry);
    }

    public PrivilegeRegistry(NameResolver resolver) {
        this.cacheDefinitions(this.createBuiltInPrivilegeDefinitions());
        this.namespaceRegistry = null;
        this.customPrivilegesStore = null;
        this.resolver = resolver;
    }

    @Override
    public void externalRegisteredPrivileges(Collection<PrivilegeDefinition> definitions) throws RepositoryException {
        HashMap<Name, PrivilegeDefinition> defs = new HashMap<Name, PrivilegeDefinition>(definitions.size());
        for (PrivilegeDefinition d : definitions) {
            defs.put(d.getName(), d);
        }
        this.registerCustomDefinitions(defs);
    }

    public void setEventChannel(PrivilegeEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    public Privilege[] getRegisteredPrivileges() {
        try {
            return new PrivilegeManagerImpl(this, this.resolver).getRegisteredPrivileges();
        }
        catch (RepositoryException e) {
            throw new UnsupportedOperationException("No supported any more. Use PrivilegeManager#getRegisteredPrivileges() instead.");
        }
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        return new PrivilegeManagerImpl(this, this.resolver).getPrivilege(privilegeName);
    }

    public Privilege[] getPrivileges(int bits) {
        Set<Privilege> prvs = new PrivilegeManagerImpl(this, this.resolver).getPrivileges(PrivilegeBits.getInstance(bits));
        return prvs.toArray(new Privilege[prvs.size()]);
    }

    public static int getBits(Privilege[] privileges) throws AccessControlException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Privilege array is empty or null.");
        }
        HashMap<String, String> lookup = new HashMap<String, String>(2);
        lookup.put("rep", "internal");
        lookup.put("jcr", "http://www.jcp.org/jcr/1.0");
        int bits = 0;
        for (Privilege priv : privileges) {
            String prefix = Text.getNamespacePrefix((String)priv.getName());
            if (lookup.containsKey(prefix)) {
                Name n = NAME_FACTORY.create((String)lookup.get(prefix), Text.getLocalName((String)priv.getName()));
                if (PRIVILEGE_NAMES.containsKey(n)) {
                    bits |= PRIVILEGE_NAMES.get(n).intValue();
                    continue;
                }
                if (NameConstants.JCR_WRITE.equals(n)) {
                    bits = (int)((long)bits | PrivilegeRegistry.createJcrWriteDefinition().bits.longValue());
                    continue;
                }
                if (REP_WRITE_NAME.equals(n)) {
                    Definition jcrWrite = PrivilegeRegistry.createJcrWriteDefinition();
                    bits = (int)((long)bits | PrivilegeRegistry.createRepWriteDefinition((Definition)jcrWrite).bits.longValue());
                    continue;
                }
                if (NameConstants.JCR_ALL.equals(n)) {
                    for (Name pn : PRIVILEGE_NAMES.keySet()) {
                        bits |= PRIVILEGE_NAMES.get(pn).intValue();
                    }
                    continue;
                }
                throw new AccessControlException("Unknown privilege '" + priv.getName() + "'.");
            }
            throw new AccessControlException("Unknown privilege '" + priv.getName() + "'.");
        }
        return bits;
    }

    public static int calculatePermissions(PrivilegeBits privs, PrivilegeBits parentPrivs, boolean isAllow, boolean protectsPolicy) {
        return PrivilegeRegistry.calculatePermissions(privs.longValue(), parentPrivs.longValue(), isAllow, protectsPolicy);
    }

    public static int calculatePermissions(int privs, int parentPrivs, boolean isAllow, boolean protectsPolicy) {
        return PrivilegeRegistry.calculatePermissions((long)privs, (long)parentPrivs, isAllow, protectsPolicy);
    }

    private static int calculatePermissions(long privs, long parentPrivs, boolean isAllow, boolean protectsPolicy) {
        int perm = 0;
        if (protectsPolicy) {
            if ((parentPrivs & 0x20L) == 32L) {
                perm |= 1;
            }
            if ((parentPrivs & 0x40L) == 64L) {
                perm |= 4;
                perm |= 2;
                perm |= 8;
                perm |= 0x10;
                perm |= 0x80;
            }
        } else {
            if ((privs & 1L) == 1L) {
                perm |= 1;
            }
            if ((privs & 2L) == 2L) {
                perm |= 2;
                perm |= 0x10;
            }
            if ((parentPrivs & 4L) == 4L) {
                perm |= 4;
            }
            if (isAllow) {
                if ((parentPrivs & 8L) == 8L && (privs & 0x10L) == 16L) {
                    perm |= 8;
                }
            } else if ((parentPrivs & 8L) == 8L || (privs & 0x10L) == 16L) {
                perm |= 8;
            }
        }
        if ((parentPrivs & 4L) == 4L && (parentPrivs & 8L) == 8L) {
            perm |= 0x1000;
        }
        if ((privs & 0x20L) == 32L) {
            perm |= 0x20;
        }
        if ((privs & 0x40L) == 64L) {
            perm |= 0x40;
        }
        if ((privs & 0x400L) == 1024L) {
            perm |= 0x400;
        }
        if ((privs & 0x200L) == 512L) {
            perm |= 0x200;
        }
        if ((privs & 0x80L) == 128L) {
            perm |= 0x80;
        }
        if ((privs & 0x800L) == 2048L) {
            perm |= 0x800;
        }
        if ((privs & 0x100L) == 256L) {
            perm |= 0x100;
        }
        if ((privs & 0x1000L) == 4096L) {
            perm |= 0x8000;
        }
        if ((privs & 0x2000L) == 8192L) {
            perm |= 0x2000;
        }
        if ((privs & 0x4000L) == 16384L) {
            perm |= 0x4000;
        }
        if ((privs & 0x8000L) == 32768L) {
            perm |= 0x10000;
        }
        return perm;
    }

    public void registerDefinition(Name privilegeName, boolean isAbstract, Set<Name> declaredAggregateNames) throws RepositoryException {
        PrivilegeDefinitionImpl def = new PrivilegeDefinitionImpl(privilegeName, isAbstract, declaredAggregateNames);
        Map<Name, PrivilegeDefinitionImpl> stubs = Collections.singletonMap(privilegeName, def);
        this.registerCustomDefinitions(stubs);
        if (this.eventChannel != null) {
            this.eventChannel.registeredPrivileges(stubs.values());
        }
    }

    public PrivilegeDefinition[] getAll() {
        return (PrivilegeDefinition[])this.registeredPrivileges.values().toArray(new Definition[this.registeredPrivileges.size()]);
    }

    public PrivilegeDefinition get(Name name) {
        return (PrivilegeDefinition)this.registeredPrivileges.get(name);
    }

    public Name[] getNames(PrivilegeBits privilegeBits) {
        if (privilegeBits == null || privilegeBits.isEmpty()) {
            return Name.EMPTY_ARRAY;
        }
        if (this.bitsToNames.containsKey(privilegeBits)) {
            Set<Name> ips = this.bitsToNames.get(privilegeBits);
            return ips.toArray(new Name[ips.size()]);
        }
        HashSet<Object> names = new HashSet<Object>();
        long bits = privilegeBits.longValue();
        if ((bits & 1L) == 1L) {
            names.add(NameConstants.JCR_READ);
        }
        long repWrite = this.registeredPrivileges.get((Object)PrivilegeRegistry.REP_WRITE_NAME).bits.longValue();
        long jcrWrite = this.registeredPrivileges.get((Object)NameConstants.JCR_WRITE).bits.longValue();
        if ((bits & repWrite) == repWrite) {
            names.add(REP_WRITE_NAME);
        } else if ((bits & jcrWrite) == jcrWrite) {
            names.add(NameConstants.JCR_WRITE);
        } else {
            if ((bits & 2L) == 2L) {
                names.add(NameConstants.JCR_MODIFY_PROPERTIES);
            }
            if ((bits & 4L) == 4L) {
                names.add(NameConstants.JCR_ADD_CHILD_NODES);
            }
            if ((bits & 8L) == 8L) {
                names.add(NameConstants.JCR_REMOVE_CHILD_NODES);
            }
            if ((bits & 0x10L) == 16L) {
                names.add(NameConstants.JCR_REMOVE_NODE);
            }
            if ((bits & 0x80L) == 128L) {
                names.add(NameConstants.JCR_NODE_TYPE_MANAGEMENT);
            }
        }
        if ((bits & 0x20L) == 32L) {
            names.add(NameConstants.JCR_READ_ACCESS_CONTROL);
        }
        if ((bits & 0x40L) == 64L) {
            names.add(NameConstants.JCR_MODIFY_ACCESS_CONTROL);
        }
        if ((bits & 0x100L) == 256L) {
            names.add(NameConstants.JCR_VERSION_MANAGEMENT);
        }
        if ((bits & 0x200L) == 512L) {
            names.add(NameConstants.JCR_LOCK_MANAGEMENT);
        }
        if ((bits & 0x400L) == 1024L) {
            names.add(NameConstants.JCR_LIFECYCLE_MANAGEMENT);
        }
        if ((bits & 0x800L) == 2048L) {
            names.add(NameConstants.JCR_RETENTION_MANAGEMENT);
        }
        if ((bits & 0x1000L) == 4096L) {
            names.add(NameConstants.JCR_WORKSPACE_MANAGEMENT);
        }
        if ((bits & 0x2000L) == 8192L) {
            names.add(NameConstants.JCR_NODE_TYPE_DEFINITION_MANAGEMENT);
        }
        if ((bits & 0x4000L) == 16384L) {
            names.add(NameConstants.JCR_NAMESPACE_MANAGEMENT);
        }
        if ((bits & 0x8000L) == 32768L) {
            names.add(REP_PRIVILEGE_MANAGEMENT_NAME);
        }
        HashSet<Name> customNames = new HashSet<Name>();
        HashSet<Definition> aggr = new HashSet<Definition>();
        for (Definition def : this.registeredPrivileges.values()) {
            if (!def.isCustom || !privilegeBits.includes(def.bits)) continue;
            customNames.add(def.getName());
            if (def.getDeclaredAggregateNames().isEmpty()) continue;
            aggr.add(def);
        }
        for (Definition aggregate : aggr) {
            customNames.removeAll(aggregate.getDeclaredAggregateNames());
        }
        names.addAll(customNames);
        if (!names.isEmpty()) {
            this.bitsToNames.put(privilegeBits, names);
        }
        return names.toArray(new Name[names.size()]);
    }

    public PrivilegeBits getBits(PrivilegeDefinition ... definitions) {
        switch (definitions.length) {
            case 0: {
                return PrivilegeBits.EMPTY;
            }
            case 1: {
                if (definitions[0] instanceof Definition) {
                    return ((Definition)definitions[0]).bits;
                }
                return PrivilegeBits.EMPTY;
            }
        }
        PrivilegeBits bts = PrivilegeBits.getInstance();
        for (PrivilegeDefinition d : definitions) {
            if (!(d instanceof Definition)) continue;
            bts.add(((Definition)d).bits);
        }
        return bts;
    }

    public PrivilegeBits getBits(Name ... privilegeNames) {
        switch (privilegeNames.length) {
            case 0: {
                return PrivilegeBits.EMPTY;
            }
            case 1: {
                return this.getBits(privilegeNames[0]);
            }
        }
        PrivilegeBits bts = PrivilegeBits.getInstance();
        for (Name privName : privilegeNames) {
            bts.add(this.getBits(privName));
        }
        return bts;
    }

    public PrivilegeBits getBits(Name privilegeName) {
        Definition def = this.registeredPrivileges.get(privilegeName);
        return def == null ? PrivilegeBits.EMPTY : def.bits;
    }

    public void addListener(Listener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCustomDefinitions(Map<Name, PrivilegeDefinition> stubs) throws RepositoryException {
        if (this.customPrivilegesStore == null) {
            throw new UnsupportedOperationException("No privilege store defined.");
        }
        Map<Name, Definition> map = this.registeredPrivileges;
        synchronized (map) {
            Map<Name, Definition> definitions = this.createCustomDefinitions(stubs);
            try {
                this.customPrivilegesStore.append(definitions);
                this.cacheDefinitions(definitions);
            }
            catch (IOException e) {
                throw new RepositoryException("Failed to register custom privilegess.", (Throwable)e);
            }
            catch (FileSystemException e) {
                throw new RepositoryException("Failed to register custom privileges.", (Throwable)e);
            }
            catch (ParseException e) {
                throw new RepositoryException("Failed to register custom privileges.", (Throwable)e);
            }
        }
        for (Listener l : this.listeners.keySet()) {
            l.privilegesRegistered(stubs.keySet());
        }
    }

    private void cacheDefinitions(Map<Name, Definition> definitions) {
        this.registeredPrivileges.putAll(definitions);
        for (Definition def : definitions.values()) {
            this.bitsToNames.put(def.bits, Collections.singleton(def.getName()));
        }
        if (!definitions.containsKey(NameConstants.JCR_ALL)) {
            Definition all = this.registeredPrivileges.get(NameConstants.JCR_ALL);
            this.bitsToNames.remove(all.bits);
            HashSet<Name> allAggrNames = new HashSet<Name>(all.getDeclaredAggregateNames());
            allAggrNames.addAll(definitions.keySet());
            PrivilegeBits allbits = PrivilegeBits.getInstance(all.bits);
            for (Definition d : definitions.values()) {
                allbits.add(d.bits);
            }
            Definition newAll = new Definition(NameConstants.JCR_ALL, false, allAggrNames, allbits, false);
            this.registeredPrivileges.put(NameConstants.JCR_ALL, newAll);
            this.bitsToNames.put(newAll.bits, Collections.singleton(NameConstants.JCR_ALL));
        }
    }

    private Map<Name, Definition> createBuiltInPrivilegeDefinitions() {
        HashMap<Name, Definition> defs = new HashMap<Name, Definition>();
        int jcrAllBits = 0;
        for (Name privilegeName : PRIVILEGE_NAMES.keySet()) {
            int bits = PRIVILEGE_NAMES.get(privilegeName);
            Definition def = new Definition(privilegeName, false, bits);
            defs.put(privilegeName, def);
            jcrAllBits |= bits;
        }
        Definition jcrWrite = PrivilegeRegistry.createJcrWriteDefinition();
        defs.put(jcrWrite.getName(), jcrWrite);
        Definition repWrite = PrivilegeRegistry.createRepWriteDefinition(jcrWrite);
        defs.put(repWrite.getName(), repWrite);
        HashSet<Name> jcrAllAggregates = new HashSet<Name>(10);
        jcrAllAggregates.add(NameConstants.JCR_READ);
        jcrAllAggregates.add(NameConstants.JCR_READ_ACCESS_CONTROL);
        jcrAllAggregates.add(NameConstants.JCR_MODIFY_ACCESS_CONTROL);
        jcrAllAggregates.add(NameConstants.JCR_LOCK_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_VERSION_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_NODE_TYPE_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_RETENTION_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_LIFECYCLE_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_NODE_TYPE_DEFINITION_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_NAMESPACE_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_WORKSPACE_MANAGEMENT);
        jcrAllAggregates.add(NameConstants.JCR_WRITE);
        jcrAllAggregates.add(REP_WRITE_NAME);
        jcrAllAggregates.add(REP_PRIVILEGE_MANAGEMENT_NAME);
        Definition jcrAll = new Definition(NameConstants.JCR_ALL, false, jcrAllAggregates, jcrAllBits);
        defs.put(jcrAll.getName(), jcrAll);
        return defs;
    }

    private Map<Name, Definition> createCustomDefinitions(Map<Name, PrivilegeDefinition> toRegister) throws RepositoryException {
        HashMap<Name, Definition> definitions = new HashMap<Name, Definition>(toRegister.size());
        HashSet<PrivilegeDefinition> aggregates = new HashSet<PrivilegeDefinition>();
        for (PrivilegeDefinition stub : toRegister.values()) {
            Name name = stub.getName();
            if (name == null) {
                throw new RepositoryException("Name of custom privilege may not be null.");
            }
            if (this.registeredPrivileges.containsKey(name)) {
                throw new RepositoryException("Registered privilege with name " + name + " already exists.");
            }
            this.namespaceRegistry.getPrefix(name.getNamespaceURI());
            if (this.isReservedNamespaceURI(name.getNamespaceURI())) {
                throw new RepositoryException("Failed to register custom privilege: Reserved namespace URI: " + name.getNamespaceURI());
            }
            Set dagn = stub.getDeclaredAggregateNames();
            if (dagn.isEmpty()) {
                definitions.put(name, new Definition(stub, this.nextBits()));
                continue;
            }
            for (Name declaredAggregateName : dagn) {
                if (name.equals(declaredAggregateName)) {
                    throw new RepositoryException("Declared aggregate name '" + declaredAggregateName.toString() + "'refers to the same custom privilege.");
                }
                if (this.registeredPrivileges.containsKey(declaredAggregateName)) {
                    log.debug("Declared aggregate name '" + declaredAggregateName.toString() + "' referring to registered privilege.");
                    continue;
                }
                if (toRegister.containsKey(declaredAggregateName)) {
                    log.debug("Declared aggregate name '" + declaredAggregateName.toString() + "' referring to un-registered privilege.");
                    if (!this.isCircularAggregation(stub, declaredAggregateName, toRegister)) continue;
                    throw new RepositoryException("Detected circular aggregation within custom privilege caused by " + declaredAggregateName.toString());
                }
                throw new RepositoryException("Found unresolvable name of declared aggregate privilege " + declaredAggregateName.toString());
            }
            aggregates.add(stub);
        }
        while (aggregates.size() > 0) {
            int cnt = aggregates.size();
            Iterator itr = aggregates.iterator();
            while (itr.hasNext()) {
                PrivilegeDefinition stub = (PrivilegeDefinition)itr.next();
                PrivilegeBits bts = this.getAggregateBits(stub.getDeclaredAggregateNames(), definitions);
                if (bts.isEmpty()) continue;
                if (this.bitsToNames.containsKey(bts) && this.bitsToNames.get(bts).size() == 1) {
                    Name existingName = this.bitsToNames.get(bts).iterator().next();
                    throw new RepositoryException("Custom aggregate privilege '" + stub.getName() + "' is already covered by '" + existingName.toString() + "'");
                }
                for (Definition d : definitions.values()) {
                    if (!bts.equals(d.bits)) continue;
                    throw new RepositoryException("Custom aggregate privilege '" + stub.getName() + "' is already defined by '" + d.getName() + "'");
                }
                Definition def = new Definition(stub, bts);
                definitions.put(def.getName(), def);
                itr.remove();
            }
            if (cnt != aggregates.size()) continue;
            throw new RepositoryException("Invalid aggregate privilege definition. Failed to resolve aggregate names.");
        }
        return definitions;
    }

    private boolean isReservedNamespaceURI(String uri) {
        if (this.namespaceRegistry instanceof NamespaceRegistryImpl) {
            return ((NamespaceRegistryImpl)this.namespaceRegistry).isReservedURI(uri);
        }
        return "internal".equals(uri) || uri.startsWith("http://www.w3.org") || uri.startsWith("http://www.jcp.org");
    }

    private PrivilegeBits nextBits() {
        PrivilegeBits b = this.nextBits;
        this.nextBits = this.nextBits.nextBits();
        return b;
    }

    private PrivilegeBits getAggregateBits(Set<Name> declaredAggregateNames, Map<Name, Definition> toRegister) {
        PrivilegeBits bts = PrivilegeBits.getInstance();
        for (Name n : declaredAggregateNames) {
            if (this.registeredPrivileges.containsKey(n)) {
                bts.add(this.registeredPrivileges.get((Object)n).bits);
                continue;
            }
            if (toRegister.containsKey(n)) {
                Definition def = toRegister.get(n);
                bts.add(def.bits);
                continue;
            }
            return PrivilegeBits.EMPTY;
        }
        return bts.unmodifiable();
    }

    private boolean isCircularAggregation(PrivilegeDefinition def, Name declaredAggregateName, Map<Name, PrivilegeDefinition> toRegister) {
        PrivilegeDefinition d = toRegister.get(declaredAggregateName);
        if (d.getDeclaredAggregateNames().isEmpty()) {
            return false;
        }
        boolean isCircular = false;
        for (Name n : d.getDeclaredAggregateNames()) {
            if (def.getName().equals(n)) {
                return true;
            }
            if (!toRegister.containsKey(n)) continue;
            isCircular = this.isCircularAggregation(def, n, toRegister);
        }
        return isCircular;
    }

    private static Definition createJcrWriteDefinition() {
        HashSet<Name> jcrWriteAggregates = new HashSet<Name>(4);
        jcrWriteAggregates.add(NameConstants.JCR_MODIFY_PROPERTIES);
        jcrWriteAggregates.add(NameConstants.JCR_ADD_CHILD_NODES);
        jcrWriteAggregates.add(NameConstants.JCR_REMOVE_CHILD_NODES);
        jcrWriteAggregates.add(NameConstants.JCR_REMOVE_NODE);
        int jcrWriteBits = 0;
        for (Name privilegeName : jcrWriteAggregates) {
            jcrWriteBits |= PRIVILEGE_NAMES.get(privilegeName).intValue();
        }
        return new Definition(NameConstants.JCR_WRITE, false, jcrWriteAggregates, jcrWriteBits);
    }

    private static Definition createRepWriteDefinition(Definition jcrWrite) {
        HashSet<Name> repWriteAggregates = new HashSet<Name>(2);
        repWriteAggregates.add(NameConstants.JCR_WRITE);
        repWriteAggregates.add(NameConstants.JCR_NODE_TYPE_MANAGEMENT);
        long repWriteBits = jcrWrite.bits.longValue() | (long)PRIVILEGE_NAMES.get(NameConstants.JCR_NODE_TYPE_MANAGEMENT).intValue();
        return new Definition(REP_WRITE_NAME, false, repWriteAggregates, repWriteBits);
    }

    static {
        PRIVILEGE_NAMES.put(NameConstants.JCR_READ, 1);
        PRIVILEGE_NAMES.put(NameConstants.JCR_MODIFY_PROPERTIES, 2);
        PRIVILEGE_NAMES.put(NameConstants.JCR_ADD_CHILD_NODES, 4);
        PRIVILEGE_NAMES.put(NameConstants.JCR_REMOVE_CHILD_NODES, 8);
        PRIVILEGE_NAMES.put(NameConstants.JCR_REMOVE_NODE, 16);
        PRIVILEGE_NAMES.put(NameConstants.JCR_READ_ACCESS_CONTROL, 32);
        PRIVILEGE_NAMES.put(NameConstants.JCR_MODIFY_ACCESS_CONTROL, 64);
        PRIVILEGE_NAMES.put(NameConstants.JCR_NODE_TYPE_MANAGEMENT, 128);
        PRIVILEGE_NAMES.put(NameConstants.JCR_VERSION_MANAGEMENT, 256);
        PRIVILEGE_NAMES.put(NameConstants.JCR_LOCK_MANAGEMENT, 512);
        PRIVILEGE_NAMES.put(NameConstants.JCR_LIFECYCLE_MANAGEMENT, 1024);
        PRIVILEGE_NAMES.put(NameConstants.JCR_RETENTION_MANAGEMENT, 2048);
        PRIVILEGE_NAMES.put(NameConstants.JCR_WORKSPACE_MANAGEMENT, 4096);
        PRIVILEGE_NAMES.put(NameConstants.JCR_NODE_TYPE_DEFINITION_MANAGEMENT, 8192);
        PRIVILEGE_NAMES.put(NameConstants.JCR_NAMESPACE_MANAGEMENT, 16384);
        PRIVILEGE_NAMES.put(REP_PRIVILEGE_MANAGEMENT_NAME, 32768);
    }

    private final class CustomPrivilegeStore {
        private final FileSystemResource customPrivilegesResource;

        private CustomPrivilegeStore(FileSystemResource customPrivilegesResource) throws RepositoryException {
            this.customPrivilegesResource = customPrivilegesResource;
            try {
                if (!customPrivilegesResource.exists()) {
                    customPrivilegesResource.makeParentDirs();
                }
            }
            catch (FileSystemException e) {
                String error = "Internal error: Failed to access/create file system resource for custom privileges at " + customPrivilegesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Name, PrivilegeDefinition> load() throws FileSystemException, RepositoryException, ParseException, IOException {
            LinkedHashMap<Name, PrivilegeDefinition> stubs = new LinkedHashMap<Name, PrivilegeDefinition>();
            if (this.customPrivilegesResource.exists()) {
                try (InputStream in = this.customPrivilegesResource.getInputStream();){
                    PrivilegeDefinitionReader pr = new PrivilegeDefinitionReader(in, "text/xml");
                    for (PrivilegeDefinition def : pr.getPrivilegeDefinitions()) {
                        Name privName = def.getName();
                        if (stubs.containsKey(privName)) {
                            throw new RepositoryException("Duplicate entry for custom privilege with name " + privName.toString());
                        }
                        stubs.put(privName, def);
                    }
                }
            }
            return stubs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(Map<Name, Definition> newPrivilegeDefinitions) throws IOException, FileSystemException, RepositoryException, ParseException {
            Map<String, String> nsMapping;
            ArrayList<Object> jcrDefs;
            if (this.customPrivilegesResource.exists()) {
                try (InputStream in = this.customPrivilegesResource.getInputStream();){
                    PrivilegeDefinitionReader pr = new PrivilegeDefinitionReader(in, "text/xml");
                    jcrDefs = new ArrayList<PrivilegeDefinition>(Arrays.asList(pr.getPrivilegeDefinitions()));
                    nsMapping = pr.getNamespaces();
                }
            } else {
                jcrDefs = new ArrayList();
                nsMapping = new HashMap();
            }
            for (Definition d : newPrivilegeDefinitions.values()) {
                String uri = d.getName().getNamespaceURI();
                nsMapping.put(PrivilegeRegistry.this.namespaceRegistry.getPrefix(uri), uri);
                for (Name dan : d.getDeclaredAggregateNames()) {
                    uri = dan.getNamespaceURI();
                    nsMapping.put(PrivilegeRegistry.this.namespaceRegistry.getPrefix(uri), uri);
                }
                jcrDefs.add((Object)d);
            }
            try (OutputStream out = this.customPrivilegesResource.getOutputStream();){
                PrivilegeDefinitionWriter pdw = new PrivilegeDefinitionWriter("text/xml");
                pdw.writeDefinitions(out, jcrDefs.toArray(new PrivilegeDefinition[jcrDefs.size()]), nsMapping);
            }
        }
    }

    protected static final class Definition
    extends PrivilegeDefinitionImpl {
        public final PrivilegeBits bits;
        public final boolean isCustom;
        private int hashCode;

        private Definition(PrivilegeDefinition stub, PrivilegeBits bits) {
            this(stub.getName(), stub.isAbstract(), (Set<Name>)stub.getDeclaredAggregateNames(), bits, true);
        }

        private Definition(Name name, boolean isAbstract, long bits) {
            this(name, isAbstract, Collections.emptySet(), PrivilegeBits.getInstance(bits), false);
        }

        private Definition(Name name, boolean isAbstract, Set<Name> declaredAggregateNames, long bits) {
            this(name, isAbstract, declaredAggregateNames, PrivilegeBits.getInstance(bits), false);
        }

        private Definition(Name name, boolean isAbstract, Set<Name> declaredAggregateNames, PrivilegeBits bits, boolean isCustom) {
            super(name, isAbstract, declaredAggregateNames);
            if (bits == null || bits.isEmpty()) {
                throw new IllegalArgumentException("Failed to build bit representation of PrivilegeDefinition.");
            }
            this.bits = bits.unmodifiable();
            this.isCustom = isCustom;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int h = super.hashCode();
                this.hashCode = h = 37 * h + this.bits.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Definition) {
                Definition other = (Definition)((Object)obj);
                return this.bits.equals(other.bits) && super.equals((Object)other);
            }
            return false;
        }
    }

    protected static interface Listener {
        public void privilegesRegistered(Set<Name> var1);
    }
}

