/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.comments.client;

import com.sas.svcs.attachments.client.Attachment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Comment
implements Serializable {
    public static final short LOW_PRIORITY = 1;
    public static final short NORMAL_PRIORITY = 2;
    public static final short HIGH_PRIORITY = 3;
    private static final long serialVersionUID = 1L;
    private long id;
    private String uuid;
    private long objectType;
    private String objectId;
    private String elementId;
    private long parentId;
    private String parentUuid;
    private String author;
    private String subject;
    private String text;
    private Date createdOn;
    private Date retiredOn;
    private List attachments;
    private short priority = (short)2;

    public List getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List attach) {
        this.attachments = attach;
    }

    public void addAttachment(Attachment attachment) {
        if (null == this.attachments) {
            this.attachments = new ArrayList();
        }
        this.attachments.add(attachment);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public long getId() {
        return this.id;
    }

    @Deprecated
    public String getCommentId() {
        return this.uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Deprecated
    public void setCommentId(String uuid) {
        this.uuid = uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        if (null == this.text) {
            this.text = "";
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public long getObjectType() {
        return this.objectType;
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public long getParentId() {
        return this.parentId;
    }

    @Deprecated
    public String getParentCommentId() {
        return this.parentUuid;
    }

    public String getParentUuid() {
        return this.parentUuid;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    @Deprecated
    public void setParentCommentId(String parentUuid) {
        this.parentUuid = parentUuid;
    }

    public void setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
    }

    public Date getRetiredOn() {
        return this.retiredOn;
    }

    public void setRetiredOn(Date retiredOn) {
        this.retiredOn = retiredOn;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        if (priority != 3 && priority != 2 && priority != 1) {
            throw new IllegalArgumentException("Comment priority must be LOW_PRIORITY, NORMAL_PRIORITY, or HIGH_PRIORITY.");
        }
        this.priority = priority;
    }

    public boolean isHighPriority() {
        return this.priority == 3;
    }

    public boolean isLowPriority() {
        return this.priority == 1;
    }

    public boolean isNormalPriority() {
        return this.priority == 2;
    }

    public boolean hasAttachments() {
        return null != this.attachments && this.attachments.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Comment: ID=");
        sb.append(this.getId()).append('/').append(this.getUuid());
        sb.append(" [author=");
        sb.append(this.getAuthor());
        sb.append(", subject=");
        sb.append(this.getSubject());
        sb.append(", text=");
        sb.append(this.getText());
        sb.append(", objectId=");
        sb.append(this.getObjectId());
        sb.append(", objectType=");
        sb.append(this.getObjectType());
        sb.append(", parentId=");
        sb.append(this.getParentId()).append('/').append(this.getParentUuid());
        sb.append(", priority=");
        sb.append(this.getPriority());
        sb.append(", created=");
        sb.append(this.getCreatedOn());
        sb.append(", retired=");
        sb.append(this.getRetiredOn());
        sb.append(']');
        return sb.toString();
    }
}

