/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.crmf;

import com.rsa.cryptoj.f.hK;
import com.rsa.cryptoj.f.nd;
import com.rsa.cryptoj.f.ny;
import com.rsa.cryptoj.f.ob;
import com.rsa.cryptoj.f.qF;
import com.rsa.cryptoj.f.uW;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.crmf.CertTemplateSpec;
import com.rsa.jsafe.cert.crmf.ControlsSpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegInfoSpec
implements Cloneable {
    private static final String a = "Names must be a non-null, non-empty string and must not start with a numeric character.";
    private BigInteger b;
    private Map<String, String> c;
    private CertTemplateSpec d;
    private ControlsSpec e;
    private List<byte[]> f;
    private static final Pattern g = Pattern.compile("^[0-9].*");

    public RegInfoSpec() {
        nd.c();
    }

    public void setNameValuePairs(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Expected non-null, non-empty nameValuePairs Map");
        }
        for (String string : map.keySet()) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException(a);
            }
            if (!g.matcher(string).matches()) continue;
            throw new IllegalArgumentException(a);
        }
        this.c = Collections.unmodifiableMap(new LinkedHashMap<String, String>(map));
    }

    public void setCertRequest(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ControlsSpec controlsSpec) {
        if (bigInteger == null || certTemplateSpec == null) {
            throw new IllegalArgumentException("Input reqId and newTemplate cannot be null");
        }
        this.b = bigInteger;
        this.d = (CertTemplateSpec)certTemplateSpec.clone();
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public void addOtherRegInfo(byte[] byArray) throws InvalidEncodingException {
        try {
            qF.a("AttributeTypeAndValue", byArray, 0, false);
        }
        catch (ny ny2) {
            throw new InvalidEncodingException("Invalid control encoding.");
        }
        if (this.f == null) {
            this.f = new ArrayList<byte[]>();
        }
        this.f.add(uW.a(byArray));
    }

    public Map<String, String> getNameValuePairs() {
        if (this.c == null) {
            return null;
        }
        return this.c;
    }

    public BigInteger getCertRequestID() {
        return this.b;
    }

    public CertTemplateSpec getCertRequestTemplate() {
        if (this.d != null) {
            return (CertTemplateSpec)this.d.clone();
        }
        return null;
    }

    public ControlsSpec getCertRequestControls() {
        if (this.e != null) {
            return (ControlsSpec)this.e.clone();
        }
        return null;
    }

    public List<byte[]> getOtherRegInfos() {
        return uW.a(this.f);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = ob.a(n2, this.b);
        n2 = ob.a(n2, this.d);
        n2 = ob.a(n2, this.e);
        n2 = ob.a(n2, this.f);
        n2 = ob.a(n2, this.c);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegInfoSpec)) {
            return false;
        }
        RegInfoSpec regInfoSpec = (RegInfoSpec)object;
        return this.b == null ? regInfoSpec.b == null : (this.b.equals(regInfoSpec.b) && this.d == null ? regInfoSpec.d == null : (this.d.equals(regInfoSpec.d) && this.e == null ? regInfoSpec.e == null : (this.e.equals(regInfoSpec.e) && this.f == null ? regInfoSpec.f == null : (hK.b(this.f, regInfoSpec.f) && this.c == null ? regInfoSpec.c == null : ((Object)this.c).equals(regInfoSpec.c)))));
    }

    public Object clone() {
        RegInfoSpec regInfoSpec = null;
        try {
            regInfoSpec = (RegInfoSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object.");
        }
        if (this.c != null) {
            regInfoSpec.c = new HashMap<String, String>(this.c);
        }
        if (regInfoSpec.d != null) {
            regInfoSpec.d = (CertTemplateSpec)this.d.clone();
        }
        if (regInfoSpec.e != null) {
            regInfoSpec.e = (ControlsSpec)this.e.clone();
        }
        return regInfoSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RegInfoSpec [").append(hK.b);
        if (this.c != null) {
            stringBuffer.append("nameValuePairs: [").append(hK.b);
            for (Map.Entry<String, String> object : this.c.entrySet()) {
                stringBuffer.append(object.getKey()).append(" -> ").append(object.getValue()).append(hK.b);
            }
            stringBuffer.append("]").append(hK.b);
        }
        if (this.b != null) {
            stringBuffer.append("certReq: [").append(hK.b);
            stringBuffer.append("reqId: ").append(this.b).append(hK.b);
            stringBuffer.append("template: ").append(this.d).append(hK.b);
            if (this.e != null) {
                stringBuffer.append("controls : ").append(this.e).append(hK.b);
            }
            stringBuffer.append("]").append(hK.b);
        }
        if (this.f != null) {
            stringBuffer.append("otherRegInfo: [").append(hK.b);
            for (byte[] byArray : this.f) {
                stringBuffer.append("encoding = ").append(hK.a(byArray)).append(hK.b);
            }
            stringBuffer.append("]").append(hK.b);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

