/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;

public class IntegerContainer
extends ASN1Container {
    public IntegerContainer(int n2) {
        this(n2, true, 0, 0);
    }

    public IntegerContainer(int n2, boolean bl2, int n3, int n4) {
        super(n2, bl2, n3, 512);
        this.a(n4);
    }

    public IntegerContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5, boolean bl3) throws ASN_Exception {
        super(n2, bl2, n3, 512);
        this.dataLen = n5;
        if (byArray == null || !bl2) {
            return;
        }
        this.data = byArray;
        if (n4 < 0 || n4 >= byArray.length) {
            throw new ASN_Exception("IntegerContainer.IntegerContainer: dataOffset is out of range.");
        }
        this.dataOffset = n4;
        if (n5 < 0 || n4 + n5 > byArray.length) {
            throw new ASN_Exception("IntegerContainer.IntegerContainer: dataLen is out of range.");
        }
        this.a(bl3);
        this.q |= 0x20000;
    }

    protected IntegerContainer(int n2, boolean bl2, int n3, int n4, int n5) {
        super(n2, bl2, n3, n5);
        this.a(n4);
    }

    public int getValueAsInt() throws ASN_Exception {
        if (this.dataLen > 4) {
            throw new ASN_Exception("Cannot represent integer in 32 bits.");
        }
        int n2 = this.data[this.dataOffset] >= 0 ? 0 : -1;
        int n3 = 0;
        int n4 = this.dataOffset;
        while (n3 < this.dataLen) {
            n2 <<= 8;
            n2 |= this.data[n4] & 0xFF;
            ++n3;
            ++n4;
        }
        return n2;
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws ASN_Exception {
        super.addData(byArray, n2, n3, bl2, bl3);
        if (bl2) {
            this.a(true);
        }
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3, boolean bl4) throws ASN_Exception {
        super.addData(byArray, n2, n3, bl3, bl4);
        if (bl3) {
            this.a(bl2);
        }
    }

    protected void a(int n2) {
        this.data = new byte[4];
        this.data[0] = (byte)(n2 >>> 24);
        this.data[1] = (byte)(n2 >>> 16);
        this.data[2] = (byte)(n2 >>> 8);
        this.data[3] = (byte)n2;
        this.dataOffset = 0;
        this.dataLen = 4;
        this.p = true;
        boolean bl2 = n2 >= 0;
        this.a(bl2);
        this.q |= 0x20000;
    }

    int a(boolean bl2, byte[] byArray, int n2) throws ASN_Exception {
        if ((this.l & 0x10000) != 0 && this.m == 5) {
            if (bl2) {
                byArray[n2] = 5;
                byArray[n2 + 1] = 0;
            }
            return 2;
        }
        if ((this.l & 0xF0000) != 0) {
            return 0;
        }
        throw new ASN_Exception("INTEGER not allowed to have length 0.");
    }

    void a(boolean bl2) {
        int n2;
        if (bl2) {
            int n3 = this.dataOffset + this.dataLen;
            int n4 = this.dataOffset;
            while (n4 < n3 - 1 && this.data[n4] == 0 && this.data[n4 + 1] >= 0) {
                ++n4;
                ++this.dataOffset;
                --this.dataLen;
            }
            if (this.data[this.dataOffset] >= 0) {
                return;
            }
            byte[] byArray = new byte[this.dataLen + 1];
            System.arraycopy(this.data, this.dataOffset, byArray, 1, this.dataLen);
            if (this.p) {
                this.clearSensitiveData();
            }
            this.data = byArray;
            this.dataOffset = 0;
            ++this.dataLen;
            this.p = true;
            return;
        }
        if (this.data[this.dataOffset] >= 0) {
            byte[] byArray = new byte[this.dataLen];
            n2 = 1;
            int n5 = this.dataLen - 1;
            this.dataOffset += this.dataLen - 1;
            while (n5 >= 0) {
                byArray[n5] = (byte)(~this.data[this.dataOffset] + n2);
                if (byArray[n5] != 0) {
                    n2 = 0;
                }
                --n5;
                --this.dataOffset;
            }
            if (n2 == 1) {
                this.dataLen = 1;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    byArray[i2] = 0;
                }
                return;
            }
            if (this.p) {
                this.clearSensitiveData();
            }
            this.data = byArray;
            this.dataOffset = 0;
            this.p = true;
        }
        int n6 = this.dataLen - 1;
        n2 = 0;
        while (n2 < n6 && this.data[n2] == -1 && this.data[n2 + 1] < 0) {
            ++n2;
            ++this.dataOffset;
            --this.dataLen;
        }
    }

    boolean a(ASN1Container aSN1Container) {
        return aSN1Container instanceof IntegerContainer;
    }

    ASN1Container a() {
        try {
            return new IntegerContainer(this.l, true, this.m, null, 0, 0, true);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

