/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.functions;

import MITI.expression.functions.Argc;
import MITI.expression.functions.Function;
import java.util.ArrayList;

public class FunctionImplementation
extends Function {
    public static final String TYPE_TABLE = "table";
    public static final String TYPE_ARRAY = "array";
    private String mirName;
    private boolean isLookup;
    private boolean isDynamic;
    private boolean isMember;
    private String returnType = "";
    private ArrayList<Argc> returnTypeArgs;
    private ArrayList<Argc> returnValueArgs;
    private String returnLength = "";
    private ArrayList<Argument> args;

    public FunctionImplementation(String string, String string2, String string3, int n, int n2, String string4, String string5, String string6, boolean bl, boolean bl2) {
        super(string2, string3, n, n2);
        String[] stringArray;
        this.isDynamic = bl2;
        this.mirName = string;
        this.isMember = bl;
        this.args = new ArrayList();
        this.returnTypeArgs = new ArrayList();
        this.returnValueArgs = new ArrayList();
        if (string5 != null && string5.startsWith("$")) {
            for (String string7 : stringArray = string5.split(",")) {
                this.returnValueArgs.add(new Argc(string7.substring(1)));
            }
        }
        if (string4 != null) {
            if (string4.startsWith("$")) {
                for (String string7 : stringArray = string4.split(",")) {
                    this.returnTypeArgs.add(new Argc(string7.substring(1)));
                }
            } else {
                this.returnType = string4;
            }
        }
        if (string6 != null) {
            this.returnLength = string6;
        }
    }

    public String getMirName() {
        return this.mirName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getReturnLength() {
        return this.returnLength;
    }

    public boolean isLookupFunction() {
        return this.isLookup;
    }

    public boolean isDynamicFunction() {
        return this.isDynamic;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public boolean isDataArgument(int n) {
        Argc argc = new Argc(n);
        for (Argument argument : this.args) {
            if (argc.compareTo(argument.getPosition()) != 0) continue;
            return argument.isData();
        }
        return true;
    }

    public boolean isConditionArgument(int n) {
        Argc argc = new Argc(n);
        for (Argument argument : this.args) {
            if (argc.compareTo(argument.getPosition()) != 0) continue;
            return argument.isCondition();
        }
        return false;
    }

    public boolean isReturnTypeArgument(int n) {
        if (!this.returnTypeArgs.isEmpty()) {
            Argc argc = new Argc(n);
            for (Argc argc2 : this.returnTypeArgs) {
                if (argc.compareTo(argc2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReturnValueArgument(int n) {
        if (this.returnValueArgs.isEmpty()) {
            return false;
        }
        Argc argc = new Argc(n);
        for (Argc argc2 : this.returnValueArgs) {
            if (argc.compareTo(argc2) != 0) continue;
            return true;
        }
        return false;
    }

    public short getArgumentElementType(int n) {
        Argc argc = new Argc(n);
        for (Argument argument : this.args) {
            if (argc.compareTo(argument.getPosition()) != 0) continue;
            return argument.getElementType();
        }
        return 0;
    }

    protected void setLookupFunction(boolean bl) {
        this.isLookup = bl;
    }

    protected void addArgument(String string, boolean bl, boolean bl2, short s) {
        Argument argument = new Argument(string, bl, bl2, s);
        this.args.add(argument);
    }

    private class Argument {
        private Argc pos;
        private boolean data;
        private boolean conditional;
        private short elementType;

        Argument(String string, boolean bl, boolean bl2, short s) {
            this.pos = new Argc(string);
            this.data = bl;
            this.conditional = bl2;
            this.elementType = s;
        }

        Argc getPosition() {
            return this.pos;
        }

        boolean isData() {
            return this.data;
        }

        boolean isCondition() {
            return this.conditional;
        }

        short getElementType() {
            return this.elementType;
        }
    }
}

