/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.parser;

import MITI.expression.analyzer.engine.MIRParser;
import MITI.expression.analyzer.engine.MIRParserFlags;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.expression.analyzer.engine.MIRToken;
import MITI.expression.analyzer.parser.MIRGenericParser;
import MITI.expression.analyzer.parser.MIRMdxParser;
import MITI.expression.analyzer.parser.MIRParserHelper;
import MITI.expression.analyzer.parser.Position;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRStatementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class MIRBisonParser
extends MIRParserHelper {
    private static final boolean isDebug = Boolean.valueOf(System.getProperty("mimb.debug.exp"));
    private static final int CONTEXT_SIZE = 7;
    private MIRParser engine = null;
    MIRParserFlags flags;
    MIRParserOptions options;
    MIRExpression expression = null;
    boolean recoverFromSyntaxErrors;
    private ArrayList<MIRToken> contextTokens = new ArrayList();
    private Map<Integer, Integer> pairTokens = new HashMap<Integer, Integer>();
    private Map<MIRStatementNode, int[]> statements = new HashMap<MIRStatementNode, int[]>();
    private Stack<Set<Integer>> skipTokens = new Stack();

    protected MIRBisonParser() {
    }

    protected MIRBisonParser(MIRParser mIRParser) {
        this.engine = mIRParser;
        this.flags = this.engine.getFlags();
        this.options = this.engine.getOptions();
    }

    public void init() {
        this.cleanup();
        this.pairTokens.clear();
        this.pairTokens.put(40, 41);
        this.pairTokens.put(266, 313);
        this.pairTokens.put(265, 313);
        if (this.options.getLangType() == 1) {
            this.pairTokens.put(273, 313);
            this.pairTokens.put(341, 313);
            this.pairTokens.put(366, 313);
        } else if (this.options.getLangType() == 2) {
            this.pairTokens.put(273, 313);
        } else if (this.options.getLangType() == 4) {
            this.pairTokens.put(273, 437);
            this.pairTokens.put(341, 313);
            this.pairTokens.put(366, 313);
            this.pairTokens.put(462, 313);
        }
    }

    public MIRExpression parseExpression() {
        this.expression = new MIRExpression();
        if (!this.parse() || !this.recoverFromSyntaxErrors && this.engine.getErrorCount() > 0) {
            this.expression.delete();
            this.expression = null;
        }
        return this.expression;
    }

    public abstract boolean parse();

    public void addParsingError(String string, int n, int n2, int n3, int n4) {
        if (!this.recoverFromSyntaxErrors && this.engine.getErrorCount() > 0) {
            return;
        }
        String string2 = String.format("(%d,%d,%d,%d)", n, n2, n3, n4);
        StringBuilder stringBuilder = new StringBuilder();
        for (MIRToken mIRToken : this.contextTokens) {
            stringBuilder.append(mIRToken.getOriginalText());
        }
        this.engine.addParsingError(string2, string, stringBuilder.toString());
    }

    public void addExtraOption(String string) {
        this.engine.getExtraOptions().add(string);
    }

    public void ignoreLastError() {
        this.engine.removeLastError();
    }

    public MIRToken getNextToken() {
        MIRToken mIRToken = this.engine.getBisonToken();
        this.addContextToken(mIRToken);
        return mIRToken;
    }

    private void addContextToken(MIRToken mIRToken) {
        MIRToken mIRToken2 = new MIRToken(mIRToken);
        this.contextTokens.add(mIRToken2);
        if (this.contextTokens.size() > 7) {
            this.contextTokens.remove(0);
        }
    }

    public boolean skipUntil(int n, Integer ... integerArray) {
        return this.skipUntil(false, n, integerArray);
    }

    public boolean skipUntil(boolean bl, int n, Integer ... integerArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (!bl) {
            if (this.engine.getOptions().getLangType() == 2 || this.engine.getOptions().getLangType() == 4 || this.engine.getOptions().getLangType() == 1 || this.engine.getOptions().getLangType() == 20) {
                hashSet.addAll(Arrays.asList(314, 266, 265, 304, 303, 296, 310, 415, 416, 336, 417, 260, 349, 452, 306, 318, 271, 372, 273, 325, 449, 342, 462, 428, 346, 322, 295));
                if (this.engine.getOptions().getLangType() != 4) {
                    hashSet.addAll(Arrays.asList(422, 466));
                }
            } else {
                hashSet.add(314);
            }
        }
        hashSet.addAll(Arrays.asList(integerArray));
        if (hashSet.contains(n)) {
            this.skipTokens.clear();
            return false;
        }
        this.skipTokens.push(hashSet);
        return true;
    }

    public MIRToken readUntil(Integer n, int n2) {
        MIRToken mIRToken;
        if (n == null) {
            return null;
        }
        if (n == n2) {
            this.skipTokens.clear();
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        this.skipTokens.push(hashSet);
        MIRToken mIRToken2 = mIRToken = this.getNextToken();
        while (this.skipToken(mIRToken)) {
            mIRToken2.merge(mIRToken);
            mIRToken = this.getNextToken();
        }
        mIRToken.mergePositions(mIRToken2);
        this.engine.unput(mIRToken);
        return mIRToken2;
    }

    boolean skipToken(MIRToken mIRToken) {
        if (mIRToken.getCode() <= 0) {
            this.skipTokens.clear();
            return false;
        }
        if (this.isSpaceToken(mIRToken.getCode())) {
            return true;
        }
        if (!this.skipTokens.isEmpty()) {
            Set<Integer> set = this.skipTokens.peek();
            if (set.contains(mIRToken.getCode())) {
                this.skipTokens.pop();
            } else if (this.pairTokens.containsKey(mIRToken.getCode())) {
                set = new HashSet<Integer>();
                set.add(this.pairTokens.get(mIRToken.getCode()));
                this.skipTokens.push(set);
            }
        }
        return !this.skipTokens.isEmpty();
    }

    abstract boolean isSpaceToken(int var1);

    private void cleanup() {
        this.contextTokens.clear();
        this.skipTokens.clear();
        this.statements.clear();
    }

    public static MIRBisonParser createGenericParser(MIRParser mIRParser, boolean bl) {
        return MIRBisonParser.createParser(new MIRGenericParser(), mIRParser, bl);
    }

    public static MIRBisonParser createMdxParser(MIRParser mIRParser, boolean bl) {
        return MIRBisonParser.createParser(new MIRMdxParser(), mIRParser, bl);
    }

    private static MIRBisonParser createParser(MIRBisonParser mIRBisonParser, MIRParser mIRParser, boolean bl) {
        mIRBisonParser.engine = mIRParser;
        mIRBisonParser.flags = mIRParser.getFlags();
        mIRBisonParser.options = mIRParser.getOptions();
        mIRBisonParser.recoverFromSyntaxErrors = bl;
        return mIRBisonParser;
    }

    public static boolean isInDebugMode() {
        return isDebug;
    }

    public MIRExpressionNode getXmlColumns() {
        MIRElementNode mIRElementNode = null;
        if (this.engine.getOptions().getLangType() == 2) {
            mIRElementNode = this.createElementNode("id", "bigint");
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("parentid", "bigint"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("localname", "nvarchar"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("prefix", "nvarchar"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("namespaceuri", "nvarchar"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("datatype", "nvarchar"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("prev", "bigint"));
            MIRBisonParser.ADD_TO_LAST_NODE(mIRElementNode, this.createElementNode("text", "ntext"));
        }
        return mIRElementNode;
    }

    void registerStatement(MIRExpressionNode mIRExpressionNode, Position position, Position position2) {
        if (mIRExpressionNode instanceof MIRStatementNode) {
            if (position == null) {
                this.statements.put((MIRStatementNode)mIRExpressionNode, new int[]{1, 1, position2.getLine(), position2.getColumn()});
            } else {
                this.statements.put((MIRStatementNode)mIRExpressionNode, new int[]{position.getLine(), position.getColumn(), position2.getLine(), position2.getColumn()});
            }
        }
    }

    private MIRElementNode createElementNode(String string, String string2) {
        MIRElementNode mIRElementNode = new MIRElementNode();
        mIRElementNode.setName(string);
        mIRElementNode.setDataType(string2);
        MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
        mIRElementNamePart.setName(string);
        mIRElementNode.addElementNamePart(mIRElementNamePart);
        MIRBisonParser.SET_ELEMENT_NODE_KIND(mIRElementNode, (byte)2);
        MIRBisonParser.SET_ELEMENT_NODE_TYPE(mIRElementNode, (short)77);
        return mIRElementNode;
    }

    public int[] getStatementNodeLocation(MIRStatementNode mIRStatementNode) {
        return this.statements.get(mIRStatementNode);
    }

    public void flagNewStatement(int n, boolean bl) {
        this.flags.flagNewStatement(bl);
    }
}

