/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.engine;

import MITI.expression.analyzer.engine.CollationMode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperatorNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MIRParserOptions {
    private int toolType;
    private int langType;
    boolean supportDoubleQuoteString;
    boolean isOperation;
    private static Map<Integer, Set<String>> reservedFeatureKeywords = new HashMap<Integer, Set<String>>();
    private static Map<Integer, Set<String>> reservedClassifierKeywords = new HashMap<Integer, Set<String>>();

    public MIRParserOptions(int n, int n2) {
        this.toolType = n;
        this.langType = n2;
    }

    public int getToolType() {
        return this.toolType;
    }

    void setToolType(int n) {
        this.toolType = n;
    }

    public int getLangType() {
        return this.langType;
    }

    void setLangType(int n) {
        this.langType = n;
    }

    public boolean supportPoundDate() {
        return this.langType == 12;
    }

    public boolean supportQuoteString() {
        return true;
    }

    public boolean supportBackslashEscaping() {
        return this.toolType == 4 || this.toolType == 28 || this.langType == 10 || this.langType == 11 || this.langType == 20 || this.langType == 7 || this.langType == 23 || this.langType == 21 || this.langType == 9 && this.toolType == 13 || this.langType == 24;
    }

    public boolean supportDoubleQuoteString() {
        return this.langType == 7 || this.langType == 24 || this.langType == 9 && (this.toolType == 16 || this.toolType == 25) || this.supportDoubleQuoteString;
    }

    public boolean supportDoubleDotOperator() {
        return this.langType == 1 || this.langType == 5 || this.langType == 21;
    }

    public boolean supportDoubleQuoteName() {
        return true;
    }

    public boolean supportSquareBracketName() {
        return this.langType != 1 && this.langType != 5 && this.langType != 16 && this.langType != 11 && this.langType != 20 && this.langType != 7 && (this.langType != 0 || this.toolType != 0);
    }

    public boolean supportEscapeStringConstants() {
        return this.langType == 5 || this.langType == 21;
    }

    public boolean supportAtOperator() {
        return this.langType != 2;
    }

    public boolean supportNestedStarComments() {
        return this.langType == 2;
    }

    public boolean supportVariableBlockScope() {
        return this.langType != 2;
    }

    public boolean supportPseudoBacktickName() {
        return this.langType == 24;
    }

    public boolean supportVariableAssignmentThroughSelectInto() {
        return this.langType == 1 || this.langType == 4 || this.langType == 18 || (this.langType == 5 || this.langType == 21) && this.isOperation;
    }

    public boolean supportNamedParameters() {
        return this.langType != 9 || this.toolType != 22 && this.toolType != 10;
    }

    public boolean supportSetVarDecl() {
        return this.langType == 20 || this.langType == 18;
    }

    public String[] getFunctionAlias(String string) {
        if (this.langType == 11) {
            if ("explode".equals(string.toLowerCase())) {
                return new String[]{"col", ""};
            }
            if ("posexplode".equals(string.toLowerCase())) {
                return new String[]{"val", "pos"};
            }
        }
        return null;
    }

    public CollationMode getCollationMode() {
        return MIRParserOptions.getCollationMode(this.langType, this.toolType);
    }

    public static CollationMode getCollationMode(int n, int n2) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 26: {
                if (n2 == 10) {
                    return CollationMode.CaseInsensitive;
                }
                if (n2 == 30) {
                    return CollationMode.CaseInsensitive;
                }
                return CollationMode.CaseSensitive;
            }
            case 1: 
            case 3: 
            case 5: 
            case 20: 
            case 21: 
            case 25: {
                return CollationMode.QuotedCaseSensitive;
            }
            case 2: 
            case 4: 
            case 10: 
            case 23: 
            case 24: {
                return CollationMode.CaseInsensitive;
            }
            case 0: {
                if (n2 != 0) {
                    return CollationMode.QuotedCaseSensitive;
                }
                return CollationMode.CaseInsensitive;
            }
        }
        return CollationMode.CaseInsensitive;
    }

    public static boolean isConfigurableCollation(int n, int n2) {
        return n == 2 || n == 10 || n == 23 || n == 11 || n == 20 || n == 0;
    }

    public boolean supportPackages() {
        return this.langType == 1;
    }

    public String getParameterAlias(int n) {
        if (this.langType == 5 || this.langType == 21) {
            return "$" + String.valueOf(n + 1);
        }
        return null;
    }

    public boolean compareNames(String string, boolean bl, String string2, boolean bl2) {
        CollationMode collationMode = this.getCollationMode();
        if (collationMode == CollationMode.CaseSensitive) {
            return string.equals(string2);
        }
        if (collationMode == CollationMode.QuotedCaseSensitive) {
            if (bl || bl2) {
                return string.equals(string2);
            }
            return string.equalsIgnoreCase(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public boolean isReservedFeatureKeyword(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = reservedFeatureKeywords.get(this.langType);
        return set != null && set.contains(string);
    }

    public boolean isReservedClassifierKeyword(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = reservedClassifierKeywords.get(this.langType);
        return set != null && set.contains(string.toUpperCase());
    }

    public boolean supportCastColumnNameAlias() {
        return this.langType == 5;
    }

    public boolean supportTableValuedExpressions() {
        return this.langType == 9 && this.toolType == 22;
    }

    public boolean supportHierarchies() {
        switch (this.langType) {
            case 11: 
            case 17: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public String getPivotColumnName(String string, MIRExpressionNode mIRExpressionNode) {
        if (this.langType == 1 && mIRExpressionNode instanceof MIROperatorNode) {
            MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
            return (string + "_" + mIROperatorNode.getRightExpressionNode().getName()).toUpperCase();
        }
        return string;
    }

    public boolean supportStructuralOperations() {
        return this.langType == 20;
    }

    public boolean supportExpressionNameComputation() {
        return this.langType == 20;
    }

    static {
        reservedFeatureKeywords.put(1, new HashSet<String>(Arrays.asList("FIRST", "LAST", "COUNT", "ROWID", "NEXTVAL")));
        reservedClassifierKeywords.put(1, new HashSet<String>(Arrays.asList("PLS_INTEGER", "V$NLS_PARAMETERS")));
    }
}

