/*
 * Decompiled with CFR 0.152.
 */
package MITI.expression.analyzer.decoration;

import MITI.expression.analyzer.decoration.MIRDecor;
import MITI.expression.analyzer.decoration.MIRDecors;
import MITI.expression.analyzer.decoration.MIRStatementDecor;
import MITI.expression.functions.MIRFunctionMapping;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRQueryNode;
import MITI.sdk.MIRStatementNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class MIRExpressionTraversal {
    boolean supportFunctionCalls;
    boolean conditionalTraversal;
    MIRDecors decors;
    MIRFunctionMapping builtinFunctions;
    Map<MIRExpressionNode, ProcessedState> processedElements = new HashMap<MIRExpressionNode, ProcessedState>();

    abstract void processElementNode(MIRElementNode var1, boolean var2, boolean var3, List<MIRExpressionNode> var4);

    abstract void processOperationNode(MIROperationNode var1, boolean var2, boolean var3, List<MIRExpressionNode> var4);

    public MIRExpressionTraversal(MIRDecors mIRDecors, boolean bl, MIRFunctionMapping mIRFunctionMapping, boolean bl2) {
        this.decors = mIRDecors;
        this.supportFunctionCalls = bl;
        this.conditionalTraversal = bl2;
        this.builtinFunctions = mIRFunctionMapping;
    }

    public void traverseExpression(MIRExpression mIRExpression) {
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodes()) {
            this.traverseExpressionNode(mIRStatementNode, true, false);
        }
    }

    public void traverseExpression(MIRExpressionNode mIRExpressionNode) {
        this.traverseExpressionNode(mIRExpressionNode, true, false);
    }

    void traverseExpressionPath(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            return;
        }
        this.traverseExpressionNode(mIRExpressionNode, true, false);
        for (MIRStatementDecor mIRStatementDecor = this.decors.getDecor(mIRExpressionNode).getStatementDecor().getParent(); mIRStatementDecor != null; mIRStatementDecor = mIRStatementDecor.getParent()) {
            this.traverseStatementNode(mIRStatementDecor.getOutputStatement(), false, false);
        }
    }

    void traverseExpressionNode(MIRExpressionNode mIRExpressionNode, boolean bl, boolean bl2) {
        if (mIRExpressionNode == null) {
            return;
        }
        switch (mIRExpressionNode.getElementType()) {
            case 103: {
                this.traverseBranchingNode((MIRBranchingNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 104: {
                this.traverseConstantNode((MIRConstantNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 107: {
                this.traverseDelimiterNode((MIRDelimiterNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 111: {
                this.traverseElementNode((MIRElementNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 114: {
                this.traverseOperationNode((MIROperationNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 115: {
                this.traverseOperatorNode((MIROperatorNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 118: {
                this.traversePredicateNode((MIRPredicateNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 339: {
                this.traverseQueryNode((MIRQueryNode)mIRExpressionNode, bl, bl2);
                break;
            }
            case 134: {
                if (!bl && !bl2) break;
                this.traverseStatementNode((MIRStatementNode)mIRExpressionNode, bl, bl2);
                break;
            }
        }
    }

    private void traverseBranchingNode(MIRBranchingNode mIRBranchingNode, boolean bl, boolean bl2) {
        this.traverseExpressionNode(mIRBranchingNode.getConditionExpressionNode(), false, true);
        for (MIRExpressionNode mIRExpressionNode : mIRBranchingNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode, bl, bl2);
        }
    }

    private void traverseConstantNode(MIRConstantNode mIRConstantNode, boolean bl, boolean bl2) {
    }

    private void traverseDelimiterNode(MIRDelimiterNode mIRDelimiterNode, boolean bl, boolean bl2) {
        for (MIRExpressionNode mIRExpressionNode : mIRDelimiterNode.getExpressionNodeByPosition()) {
            this.traverseExpressionNode(mIRExpressionNode, bl, bl2);
        }
        this.traverseExpressionNode(mIRDelimiterNode.getConditionExpressionNode(), false, true);
    }

    private void traverseElementNode(MIRElementNode mIRElementNode, boolean bl, boolean bl2) {
        ProcessedState processedState = this.processedElements.get(mIRElementNode);
        if (processedState != null) {
            if (!(!processedState.isData && bl || !processedState.isCondition && bl2)) {
                return;
            }
            if (bl) {
                bl = !processedState.isData;
                processedState.isData = true;
            }
            if (bl2) {
                bl2 = !processedState.isCondition;
                processedState.isCondition = true;
            }
        } else {
            processedState = new ProcessedState(bl, bl2);
        }
        this.processedElements.put(mIRElementNode, processedState);
        if (mIRElementNode.getDestinationElementType() != 77 && mIRElementNode.getDestinationElementType() != 24) {
            return;
        }
        MIRDecor mIRDecor = this.decors.getDecor(mIRElementNode);
        if (this.conditionalTraversal && mIRElementNode.getKind() == 2) {
            int n;
            int n2 = n = mIRDecor != null ? mIRDecor.getStatementDecor().getStatementType() : -1;
            if (n == 5 || n == 36 || n == 8 || n == 9 || n == -1) {
                return;
            }
        }
        LinkedList<MIRExpressionNode> linkedList = new LinkedList<MIRExpressionNode>();
        this.processElementNode(mIRElementNode, bl, bl2, linkedList);
        for (MIRExpressionNode mIRExpressionNode : linkedList) {
            this.traverseExpressionNode(mIRExpressionNode, bl && mIRDecor.isData(), bl2 || mIRDecor.isCondition());
        }
    }

    private void traverseOperationNode(MIROperationNode mIROperationNode, boolean bl, boolean bl2) {
        ProcessedState processedState = this.processedElements.get(mIROperationNode);
        if (processedState != null) {
            if (!(!processedState.isData && bl || !processedState.isCondition && bl2)) {
                return;
            }
            if (bl) {
                bl = !processedState.isData;
                processedState.isData = true;
            }
            if (bl2) {
                bl2 = !processedState.isCondition;
                processedState.isCondition = true;
            }
        } else {
            processedState = new ProcessedState(bl, bl2);
        }
        this.processedElements.put(mIROperationNode, processedState);
        if (!this.supportFunctionCalls || this.builtinFunctions != null && this.builtinFunctions.getImplementation(mIROperationNode, mIROperationNode.getExpressionNodeCount()) != null) {
            for (MIRExpressionNode object2 : mIROperationNode.getExpressionNodeByPosition()) {
                if (this.conditionalTraversal && !bl2 && !this.decors.getDecor(object2).isCondition()) continue;
                this.traverseExpressionNode(object2, bl, bl2);
            }
        }
        LinkedList linkedList = new LinkedList();
        this.processOperationNode(mIROperationNode, bl, bl2, linkedList);
        MIRDecor mIRDecor = this.decors.getDecor(mIROperationNode);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MIRExpressionNode mIRExpressionNode = (MIRExpressionNode)iterator.next();
            this.traverseExpressionNode(mIRExpressionNode, bl && mIRDecor.isData(), bl2 || mIRDecor.isCondition());
        }
    }

    private void traverseOperatorNode(MIROperatorNode mIROperatorNode, boolean bl, boolean bl2) {
        this.traverseExpressionNode(mIROperatorNode.getLeftExpressionNode(), bl, bl2);
        this.traverseExpressionNode(mIROperatorNode.getRightExpressionNode(), bl, bl2);
        this.traverseExpressionNode(mIROperatorNode.getConditionExpressionNode(), false, true);
    }

    private void traversePredicateNode(MIRPredicateNode mIRPredicateNode, boolean bl, boolean bl2) {
        this.traverseExpressionNode(mIRPredicateNode.getExpressionNode(), bl, bl2);
    }

    private void traverseQueryNode(MIRQueryNode mIRQueryNode, boolean bl, boolean bl2) {
        this.traverseExpressionNode(mIRQueryNode.getClassifierElementNode(), bl, bl2);
        if (!this.conditionalTraversal) {
            this.traverseExpressionNode(mIRQueryNode.getFeatureDelimiterNode(), bl, bl2);
        }
        this.traverseExpressionNode(mIRQueryNode.getQueryStatementNode(), bl, bl2);
    }

    private void traverseStatementNode(MIRStatementNode mIRStatementNode, boolean bl, boolean bl2) {
        int n = -1;
        boolean bl3 = this.decors.getDecor(mIRStatementNode).isCondition();
        for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodeByPosition()) {
            ++n;
            boolean bl4 = bl2;
            if (this.conditionalTraversal) {
                if (mIRStatementNode.getStatementType() == 1) {
                    if ((mIRExpressionNode.getName().equals("SELECT") || mIRExpressionNode.getName().equals("EXPAND ON")) && !bl3 && !bl4) continue;
                    if (!bl2 && (mIRExpressionNode.getName().equals("WHERE") || mIRExpressionNode.getName().equals("ORDER BY") || mIRExpressionNode.getName().equals("GROUP BY"))) {
                        bl4 = true;
                    }
                }
                if (mIRStatementNode.getStatementType() == 15 || mIRStatementNode.getStatementType() == 3 && mIRExpressionNode.getName().equals("SET") || mIRStatementNode.getStatementType() == 2 && mIRExpressionNode.getName().equals("PARTITION") || (mIRStatementNode.getStatementType() == 8 || mIRStatementNode.getStatementType() == 3) && mIRExpressionNode.getName().equals("USING") || mIRStatementNode.getStatementType() == 9 && n == mIRStatementNode.getExpressionNodeCount() - 1 && !bl3 && !bl4 || mIRStatementNode.getStatementType() == 17 && mIRExpressionNode.getName().equals("*") && !bl3 && !bl4) {
                    continue;
                }
            } else if (mIRStatementNode.getStatementType() == 1 && mIRExpressionNode.getName().equals("WITH")) continue;
            this.traverseExpressionNode(mIRExpressionNode, bl, bl4);
        }
    }

    private static class ProcessedState {
        public boolean isData;
        public boolean isCondition;

        public ProcessedState(boolean bl, boolean bl2) {
            this.isData = bl;
            this.isCondition = bl2;
        }
    }
}

