/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.client;

import com.sas.svcs.security.authentication.client.CredentialCachingCallbackHandler;
import com.sas.svcs.security.authentication.client.LogonFailureException;
import com.sas.svcs.security.authentication.client.LogoutFailureException;
import com.sas.svcs.security.authentication.client.TicketCreationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class AuthenticationClient {
    private static final Logger logger = LogManager.getLogger(AuthenticationClient.class);
    protected static final String REST_ENDPOINT = "/v1/tickets";
    private CallbackHandler handler;
    RestTemplate template;
    String casUrl;
    String ticketGrantingTicket;
    String ticketGrantingTicketUrl;
    boolean scrubUrl = true;
    boolean appendAuthClientParameter;

    public AuthenticationClient(String casUrl, ClientHttpRequestFactory requestFactory) {
        this.casUrl = casUrl;
        this.template = null != requestFactory ? new RestTemplate(requestFactory) : new RestTemplate();
        this.template.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
    }

    public AuthenticationClient(String casUrl, String ticketGrantingTicket, ClientHttpRequestFactory requestFactory) {
        this(casUrl, requestFactory);
        this.setTicketGrantingTicket(ticketGrantingTicket);
    }

    public AuthenticationClient(String casUrl) {
        this(casUrl, (ClientHttpRequestFactory)null);
    }

    public AuthenticationClient(String casUrl, String ticketGrantingTicket) {
        this(casUrl, ticketGrantingTicket, null);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.template.setRequestFactory(requestFactory);
    }

    public void setScrubUrl(boolean scrubUrl) {
        this.scrubUrl = scrubUrl;
    }

    public void setAppendAuthClientParameter(boolean appendAuthClientParameter) {
        this.appendAuthClientParameter = appendAuthClientParameter;
    }

    public void logon(String userid, String password) {
        this.logon(userid, password, true);
    }

    public void logon(CallbackHandler handler) {
        NameCallback name = new NameCallback("Userid");
        PasswordCallback pwcb = new PasswordCallback("Password", false);
        try {
            handler.handle(new Callback[]{name, pwcb});
        }
        catch (IOException e) {
            logger.error("Error retrieving username/password from callback '" + handler.getClass().getName() + "'", (Throwable)e);
            throw new LogonFailureException("Error obtaining userid and password from handler to log on", (Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            logger.error("Error retrieving username/password from callback '" + handler.getClass().getName() + "'", (Throwable)e);
            throw new LogonFailureException("Error obtaining userid and password from handler to log on", (Throwable)e);
        }
        String userid = name.getName();
        if (null == userid) {
            logger.error("Handler '" + handler.getClass().getName() + "' did not provide userid to log on");
            throw new LogonFailureException("Could not obtain userid to log on");
        }
        this.doLogon(userid, new String(pwcb.getPassword()));
        this.handler = handler;
    }

    protected void doLogon(String userid, String password) {
        userid = this.encodeQueryParameter(userid);
        password = this.encodeQueryParameter(password);
        String parameters = "username=" + userid + "&password=" + password;
        if (this.appendAuthClientParameter) {
            parameters = parameters + "&authClientRequest=true";
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)parameters, (MultiValueMap)requestHeaders);
        ResponseEntity response = this.template.exchange(this.casUrl + REST_ENDPOINT, HttpMethod.POST, request, String.class, new Object[0]);
        if (HttpStatus.CREATED != response.getStatusCode()) {
            LogonFailureException.Status status;
            String message = "Unable to logon user: " + userid;
            switch (response.getStatusCode()) {
                case BAD_REQUEST: 
                case UNAUTHORIZED: {
                    message = message + " (bad credentials) ";
                    status = LogonFailureException.Status.BAD_REQUEST;
                    break;
                }
                case NOT_FOUND: {
                    message = message + " (server not responding) ";
                    status = LogonFailureException.Status.NOT_FOUND;
                    break;
                }
                case INTERNAL_SERVER_ERROR: {
                    message = message + " (error occurred on server) ";
                    status = LogonFailureException.Status.SERVER_ERROR;
                    break;
                }
                default: {
                    message = message + " (unrecognized error " + response.getStatusCode() + ") ";
                    status = LogonFailureException.Status.UNRECOGNIZED_ERROR;
                }
            }
            throw new LogonFailureException(status, message + (String)response.getBody());
        }
        HttpHeaders headers = response.getHeaders();
        this.ticketGrantingTicketUrl = this.scrubUrl(headers.getLocation().toString());
        int tgtLoc = this.ticketGrantingTicketUrl.lastIndexOf("/");
        if (tgtLoc > -1 && tgtLoc + 1 < this.ticketGrantingTicketUrl.length()) {
            this.ticketGrantingTicket = this.ticketGrantingTicketUrl.substring(tgtLoc + 1);
        }
        logger.debug("Created ticket granting ticket: " + this.ticketGrantingTicketUrl);
    }

    private String scrubUrl(String value) {
        if (!this.scrubUrl) {
            return value;
        }
        try {
            URL cas = new URL(this.casUrl);
            URL locationUrl = new URL(value);
            URL returnedUrl = new URL(cas.getProtocol(), cas.getHost(), cas.getPort(), locationUrl.getFile());
            return returnedUrl.toString();
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return value;
        }
    }

    public void logon(String userid, String password, boolean cacheCredentials) {
        if (cacheCredentials) {
            this.logon(new CredentialCachingCallbackHandler(userid, password));
        } else {
            this.doLogon(userid, password);
        }
    }

    public String acquireTicket(String service) {
        return this.acquireTicket(service, true);
    }

    public String acquireTicket(String service, boolean retry) {
        service = this.encodeQueryParameter(service);
        if (null == this.ticketGrantingTicketUrl) {
            throw new IllegalStateException("Cannot attempt to acquire service ticket '" + service + "', user has already been logged out");
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)("service=" + service), (MultiValueMap)requestHeaders);
        ResponseEntity response = this.template.exchange(this.ticketGrantingTicketUrl, HttpMethod.POST, request, String.class, new Object[0]);
        HttpStatus status = response.getStatusCode();
        if (HttpStatus.OK != status) {
            if (logger.isDebugEnabled()) {
                logger.debug("Non OK response encountered when acquiring ticket for service '" + service + "'");
            }
            if (null != this.handler && status.value() >= 400 && status.value() < 500 && retry) {
                block9: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ticket acquisition failed. Trying to log off then log on again with cached credentials");
                    }
                    try {
                        this.logout(true);
                    }
                    catch (Throwable t) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug("Exception logging out during ticket reacquisition", t);
                    }
                }
                try {
                    this.logon(this.handler);
                    return this.acquireTicket(service, false);
                }
                catch (LogonFailureException e) {
                    logger.error("Error trying to log on again with cached credentials.", (Throwable)e);
                    throw new TicketCreationException("Unable to acquire ticket, and could not log on again with cached credentials: " + response, e);
                }
            }
            throw new TicketCreationException("Unable to acquire ticket: " + response);
        }
        String body = (String)response.getBody();
        return body;
    }

    public void logout() {
        this.logout(false);
    }

    private void logout(boolean preserveHandler) {
        ResponseEntity response;
        HttpStatus status;
        if (null != this.ticketGrantingTicketUrl && HttpStatus.OK != (status = (response = this.template.exchange(this.ticketGrantingTicketUrl, HttpMethod.DELETE, null, Object.class, new Object[0])).getStatusCode()) && HttpStatus.NOT_FOUND != status) {
            throw new LogoutFailureException("Failed to logout: " + response);
        }
        if (!preserveHandler) {
            this.handler = null;
        }
        this.ticketGrantingTicketUrl = null;
        this.ticketGrantingTicket = null;
    }

    public String getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public void setTicketGrantingTicket(String ticketGrantingTicket) {
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.ticketGrantingTicketUrl = this.casUrl + REST_ENDPOINT + "/" + ticketGrantingTicket;
    }

    public String getCasUrl() {
        return this.casUrl;
    }

    private String encodeQueryParameter(String parameter) {
        return UriUtils.encodeQueryParam((String)parameter, (String)"UTF-8");
    }

    static class ErrorHandler
    extends DefaultResponseErrorHandler {
        ErrorHandler() {
        }

        protected boolean hasError(HttpStatus statusCode) {
            return statusCode.value() >= 500;
        }
    }
}

