/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.profilingxml.common.csv.CsvGenerator;
import MITI.bridges.profilingxml.common.csv.CsvProfileLinks;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.sdk.profiles.ProfiledAttribute;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntityGenerator
implements CsvGenerator<AggregationProfileLink> {
    private Profiler profiler;
    private MIRProfileEntity entity;
    private MIRModel model;
    private Map<String, Integer> header = new LinkedHashMap<String, Integer>();
    private long sequence;
    private static final String ID = "ObjectId";
    private static final String PARENT_ID = "ParentId";
    private static final String LINK_ID = "LinkId";
    private static final String SEQUENCE = "SequenceNumber";
    private static final String NATIVE_ID = "NativeId";
    private static final String OPERATION_UNIQUE_NAME = "OperationUniqueName";

    public EntityGenerator(Profiler profiler, MIRProfileEntity mIRProfileEntity, MIRModel mIRModel) {
        this.profiler = profiler;
        this.entity = mIRProfileEntity;
        this.model = mIRModel;
        this.sequence = 1L;
    }

    private void addHeader(String string) {
        this.header.putIfAbsent(string, this.header.size());
    }

    private void addData(String[] stringArray, String string, String string2) {
        Integer n = this.header.get(string);
        if (n != null) {
            stringArray[n.intValue()] = string2;
        }
    }

    @Override
    public Collection<String> generateHeader() throws MIRException {
        boolean bl = this.supportsOperationUniqueName(this.entity.getElementType());
        boolean bl2 = this.supportsNativeId(this.entity.getElementType());
        boolean bl3 = false;
        this.addHeader(ID);
        this.addHeader(PARENT_ID);
        this.addHeader(LINK_ID);
        this.addHeader(SEQUENCE);
        MIRProfileProperty[] mIRProfilePropertyArray = this.entity.getProfileAttributes();
        if (mIRProfilePropertyArray != null) {
            for (MIRProfileProperty mIRProfileProperty : mIRProfilePropertyArray) {
                String string = mIRProfileProperty.getName();
                String string2 = mIRProfileProperty.getPath();
                if (string2.equalsIgnoreCase("@nativeId")) {
                    bl3 = true;
                }
                this.addHeader(string);
            }
        }
        if (this.model != null) {
            List<MIRPropertyType> list = EntityGenerator.getUDPTypes(this.model, this.entity.getElementType());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MIRPropertyType mIRPropertyType = (MIRPropertyType)iterator.next();
                this.addHeader(mIRPropertyType.getName());
            }
        }
        if (bl2 && !bl3) {
            this.addHeader(NATIVE_ID);
        }
        if (bl) {
            this.addHeader(OPERATION_UNIQUE_NAME);
        }
        return this.header.keySet();
    }

    @Override
    public String[] generateData(AggregationProfileLink aggregationProfileLink) throws MIRException {
        ProfiledObject profiledObject = aggregationProfileLink.getSourceNode();
        ProfiledObject profiledObject2 = aggregationProfileLink.getDestinationNode();
        boolean bl = this.supportsOperationUniqueName(profiledObject2.getObjectDefinition().getObjectType());
        boolean bl2 = this.supportsNativeId(profiledObject2.getObjectDefinition().getObjectType());
        boolean bl3 = false;
        String[] stringArray = new String[this.header.size()];
        String string = null;
        Integer n = null;
        MIRProfileLink mIRProfileLink = aggregationProfileLink.getProfileLink();
        if (profiledObject != null) {
            string = String.valueOf(profiledObject.getObjectDefinition().getObjectId());
            n = CsvProfileLinks.get(mIRProfileLink);
        }
        String string2 = String.valueOf(profiledObject2.getObjectDefinition().getObjectId());
        this.addData(stringArray, ID, string2);
        this.addData(stringArray, PARENT_ID, string);
        this.addData(stringArray, LINK_ID, n != null ? n.toString() : "");
        this.addData(stringArray, SEQUENCE, String.valueOf(this.sequence));
        ProfiledAttribute[] profiledAttributeArray = this.profiler.getAttributes(profiledObject2);
        if (profiledAttributeArray != null) {
            for (ProfiledAttribute profiledAttribute : profiledAttributeArray) {
                String string3 = profiledAttribute.getDisplayName();
                String string4 = profiledAttribute.getId().toMPath();
                String string5 = profiledAttribute.getValue();
                if (string3.equalsIgnoreCase("Object Id")) continue;
                if (string4.equalsIgnoreCase("@nativeId")) {
                    bl3 = true;
                }
                this.addData(stringArray, string3, string5);
            }
        }
        if (bl2 && !bl3) {
            String string6 = this.profiler.getNativeId(profiledObject2);
            this.addData(stringArray, NATIVE_ID, string6);
        }
        if (bl) {
            MIRObject mIRObject = this.profiler.getMIRObject(profiledObject2.getObjectDefinition());
            String string7 = "";
            if (mIRObject != null) {
                string7 = MIRBridgeLib.getOperationUniqueName((MIROperation)mIRObject);
            } else {
                ProfiledAttribute[] profiledAttributeArray2 = this.profiler.getAttributes(profiledObject2);
                if (profiledAttributeArray2 != null) {
                    for (ProfiledAttribute profiledAttribute : profiledAttributeArray2) {
                        if (!profiledAttribute.getDisplayName().equals(OPERATION_UNIQUE_NAME)) continue;
                        string7 = profiledAttribute.getValue();
                    }
                }
            }
            this.addData(stringArray, OPERATION_UNIQUE_NAME, string7);
        }
        return stringArray;
    }

    private static List<MIRPropertyType> getUDPTypes(MIRModel mIRModel, short s) {
        ArrayList<MIRPropertyType> arrayList = new ArrayList<MIRPropertyType>();
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = MIRUdpLib.fetchPropertyElementTypeScope(mIRModel, s, false);
        if (mIRPropertyElementTypeScope != null) {
            for (MIRPropertyType mIRPropertyType : mIRPropertyElementTypeScope.getPropertyTypes()) {
                if (!mIRPropertyType.getUsage().equals("USER")) continue;
                arrayList.add(mIRPropertyType);
            }
        }
        return arrayList;
    }

    private boolean supportsNativeId(short s) {
        boolean bl = MIR_Object.isInstanceOf(s, (short)0);
        boolean bl2 = MIR_Object.isInstanceOf(s, (short)1);
        return bl || bl2;
    }

    private boolean supportsOperationUniqueName(short s) {
        boolean bl = MIR_Object.isInstanceOf(s, (short)67);
        return bl;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }
}

