/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.profilingxml.common.csv;

import MITI.MIRException;
import MITI.bridges.profilingxml.common.csv.CsvGenerator;
import MITI.bridges.profilingxml.common.csv.CsvProfileLinks;
import MITI.bridges.profilingxml.common.csv.EntityGenerator;
import MITI.bridges.profilingxml.common.csv.LineageLinkGenerator;
import MITI.bridges.profilingxml.common.csv.ModelInfoGenerator;
import MITI.bridges.profilingxml.common.csv.ProfiledCsvFileManager;
import MITI.bridges.profilingxml.common.csv.ProfiledCsvFileWriter;
import MITI.bridges.profilingxml.common.csv.ReferenceLinkGenerator;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class CsvProcessor
implements ProfileLinkProcessor,
Closeable {
    private Profiler profiler;
    private ProfiledCsvFileManager fileManager;
    private ProfiledCsvFileWriter writer;
    private ProfiledCsvFileWriter profileLinkWriter;
    private ProfiledCsvFileWriter modelInfoWriter;
    private CsvProfileLinks profileLinks;
    private long aggregationSequence;

    public CsvProcessor(Profiler profiler, File file) {
        this.fileManager = new ProfiledCsvFileManager(file);
        this.profiler = profiler;
        this.aggregationSequence = 1L;
        this.profileLinks = new CsvProfileLinks();
    }

    private void openOutputWriter(ProfileLink profileLink) throws MIRException {
        ProfiledObject profiledObject = profileLink.getSourceNode();
        ProfiledObject profiledObject2 = profileLink.getDestinationNode();
        int n = -1;
        if (profileLink instanceof AggregationProfileLink) {
            MIRProfileEntity mIRProfileEntity = null;
            MIRModel mIRModel = null;
            if (profiledObject2 != null) {
                n = profiledObject2.getObjectDefinition().getModelId();
                mIRProfileEntity = this.profiler.getProfileEntity(profiledObject2);
                MIRObject mIRObject = this.profiler.getMIRObject(profiledObject2.getObjectDefinition());
                if (mIRObject != null) {
                    mIRModel = mIRObject.getRootModel();
                }
            }
            if (n != -1 && mIRProfileEntity != null) {
                this.writer = this.fileManager.getEntityWriter(this.profiler, n, mIRProfileEntity, mIRModel);
                this.profileLinkWriter = this.fileManager.getProfileLinkWriter();
            }
        } else if (profileLink instanceof ReferenceProfileLink) {
            String string = profiledObject.getEntityName();
            if (profiledObject != null) {
                n = profiledObject.getObjectDefinition().getModelId();
            }
            if (n != -1) {
                this.writer = this.fileManager.getReferenceLinkWriter(n, string);
                this.profileLinkWriter = this.fileManager.getProfileLinkWriter();
            }
        } else if (profileLink instanceof LineageProfileLink) {
            ProfiledObject profiledObject3 = ((LineageProfileLink)profileLink).getTransformationModel();
            int n2 = -1;
            if (profiledObject2 != null) {
                n2 = profiledObject2.getObjectDefinition().getModelId();
            }
            boolean bl = profileLink instanceof SummaryLineageProfileLink;
            if (profiledObject3 != null) {
                int n3 = profiledObject3.getObjectDefinition().getModelId();
                this.writer = this.fileManager.getLineageLinkWriter(n3, bl);
            } else {
                this.writer = this.fileManager.getLineageLinkWriter(n2, bl);
            }
        }
    }

    private boolean isSameModel(LineageProfileLink lineageProfileLink) {
        boolean bl = true;
        int n = -1;
        if (lineageProfileLink.getSourceNode() != null) {
            n = lineageProfileLink.getSourceNode().getObjectDefinition().getModelId();
        }
        bl &= this.checkSameModelId(n, lineageProfileLink.getDestinationNode());
        return bl &= this.checkSameModelId(n, lineageProfileLink.getTransformation());
    }

    private boolean checkSameModelId(int n, ProfiledObject profiledObject) {
        if (profiledObject != null) {
            return n == profiledObject.getObjectDefinition().getModelId();
        }
        return true;
    }

    @Override
    public void close() {
        this.writer = null;
        this.profileLinkWriter = null;
        this.modelInfoWriter = null;
        this.fileManager.close();
    }

    @Override
    public void process(ProfileLink profileLink) throws MIRException {
        if (profileLink instanceof LineageProfileLink && profileLink.getLinkType() == ProfileLink.LINK_TYPE.SEMANTIC_LINK) {
            return;
        }
        this.openOutputWriter(profileLink);
        String[] stringArray = null;
        if (profileLink instanceof AggregationProfileLink) {
            CsvGenerator<AggregationProfileLink> csvGenerator;
            AggregationProfileLink aggregationProfileLink = (AggregationProfileLink)profileLink;
            ProfiledObject profiledObject = profileLink.getSourceNode();
            ProfiledObject profiledObject2 = profileLink.getDestinationNode();
            if (profiledObject != null && profiledObject2 != null && profiledObject.getObjectDefinition().getModelId() == profiledObject2.getObjectDefinition().getModelId() && profiledObject.getObjectDefinition().getObjectId() == profiledObject2.getObjectDefinition().getObjectId() && profiledObject2.getObjectDefinition().getGroupName() != null) {
                return;
            }
            if (this.isModel(profiledObject2)) {
                this.modelInfoWriter = this.fileManager.getModelInfoWriter(this.profiler);
                csvGenerator = (ModelInfoGenerator)this.modelInfoWriter.getGenerator();
                String[] stringArray2 = ((ModelInfoGenerator)csvGenerator).generateData(aggregationProfileLink);
                this.writeRow(this.modelInfoWriter, stringArray2);
                MIRProfileEntity mIRProfileEntity = this.profiler.getProfileEntity(profiledObject2);
                MIRProfile mIRProfile = mIRProfileEntity.getProfile();
                this.profileLinks.printProfileLinks(mIRProfile, this.profileLinkWriter);
            }
            csvGenerator = (EntityGenerator)this.writer.getGenerator();
            ((EntityGenerator)csvGenerator).setSequence(this.aggregationSequence++);
            stringArray = ((EntityGenerator)csvGenerator).generateData(aggregationProfileLink);
        } else if (profileLink instanceof ReferenceProfileLink) {
            ReferenceProfileLink referenceProfileLink = (ReferenceProfileLink)profileLink;
            ReferenceLinkGenerator referenceLinkGenerator = (ReferenceLinkGenerator)this.writer.getGenerator();
            stringArray = referenceLinkGenerator.generateData(referenceProfileLink);
        } else if (profileLink instanceof LineageProfileLink) {
            LineageLinkGenerator lineageLinkGenerator = (LineageLinkGenerator)this.writer.getGenerator();
            stringArray = lineageLinkGenerator.generateData((LineageProfileLink)profileLink);
        }
        if (stringArray != null) {
            this.writeRow(this.writer, stringArray);
        }
    }

    private void writeRow(ProfiledCsvFileWriter profiledCsvFileWriter, String[] stringArray) throws MIRException {
        try {
            profiledCsvFileWriter.printLine(stringArray);
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    private boolean isModel(ProfiledObject profiledObject) {
        short s = profiledObject.getObjectDefinition().getObjectType();
        boolean bl = MIR_Object.isInstanceOf(s, (short)218);
        return bl;
    }
}

