/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.updater;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ProviderNotAvailableException;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.InfoMessage;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.ShowReportMessage;
import com.sas.dpro.controller.HonorContractParmsImpl;
import com.sas.dpro.provider.CreateContainerContextParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.reporting.ReportInfo;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Updater
extends AbstractClient {
    public static final String ARG_DELETE_OLD_INSTALL = "-deleteOldInstall";
    public static final String ARG_EXTRA_CONTRACTS = "-extraContracts";
    public static final String ARG_HELP = "-help";
    public static final String ARG_INSTALL_TO_UPDATE_DIR = "-installToUpdateDir";
    public static final String ARG_LOGGING_LEVEL = "-loggingLevel";
    public static final String ARG_OUTPUT = "-output";
    public static final String ARG_PING_ATTEMPTS = "-pingAttempts";
    public static final String ARG_PORT = "-port";
    public static final String ARG_RESTART = "-restart";
    public static final String ARG_SLEEP_BEFORE_RESTART = "-sleepBeforeRestart";
    public static final String ARG_UPDATE = "-update";
    public static final String ARG_UPDATES_DIR = "-updatesDir";
    public static final String ARG_USAGE = "-usage";
    public static final int RC_OK = 0;
    public static final int RC_USAGE = 1;
    public static final int RC_OPTION_ERROR = 2;
    public static final int RC_CONTRACT_FAILED = 3;
    public static final int RC_CONTRACT_TIMEOUT = 4;
    public static final int RC_SHUTDOWN_DISABLED = 5;
    public static final int RC_STILL_ALIVE = 6;
    public static final int RC_NOT_RESTARTED = 7;
    public static final int RC_IO_ERROR = 8;
    public static final int RC_GENERAL_ERROR = 255;
    private static final int DEFAULT_MAX_PING_ATTEMPTS = 3;
    private static final String LOCALHOST = "localhost";
    private static final String LOGGER_FILE_NAME = "Updater.log";
    private static final int STARTUP_PING_DELAY = 8;
    private static final String CONTRACT_UPDATE_DPRO_INSTALL = "Contract/updater/UpdateDPROInstall_contract.xml";
    private List extraContracts;
    private int maxPingAttempts = 3;
    private PrintWriter out;
    private static final String MSG = "com.sas.dpro.updater.Updater";
    private ResourceBundle loggerMsg = ResourceBundle.getBundle("com.sas.dpro.updater.Updater");
    private static final String ERROR_MSG = "com.sas.dpro.updater.UpdaterErrors";
    private ResourceBundle errorMsg;
    private static final String APP_DATA_SUBDIR = "SASDProUpdater/2.1";

    public Updater() {
        super(Logger.getLogger(MSG), APP_DATA_SUBDIR, false);
        this.extraContracts = new ArrayList(1);
        this.configureLogger();
        this.initialize();
    }

    protected void addExtraContract(String contract) {
        this.extraContracts.add(contract);
    }

    private void cleanup() {
        if (this.out != null) {
            this.out.close();
        }
    }

    private void cleanupAndExit(int rc) {
        String desc = this.loggerMsg.getString("ExitingWithRC.fmt.txt");
        desc = MessageFormat.format(desc, "" + rc);
        this.output(desc);
        this.cleanup();
        System.exit(rc);
    }

    @Override
    public String getDefaultReportType() {
        return "_text";
    }

    @Override
    protected String getDPROClientTypeString() {
        return "updater";
    }

    public ResourceBundle getErrorBundle() {
        if (this.errorMsg == null) {
            this.errorMsg = ResourceBundle.getBundle(ERROR_MSG);
        }
        return this.errorMsg;
    }

    @Override
    protected String getLoggerFileName() {
        return LOGGER_FILE_NAME;
    }

    @Override
    protected void handleHandleMessageError(String desc, Exception e) {
        System.err.println(desc);
        e.printStackTrace();
    }

    public void handleInvalidOptionValue(String option, String value) {
        ResourceBundle msg = this.getErrorBundle();
        String desc = msg.getString("InvalidOptionValue.fmt.txt");
        if (value != null) {
            value = "\"" + value + "\"";
        }
        desc = MessageFormat.format(desc, value, option);
        this.logger.severe(desc);
        this.output(desc);
    }

    private void handleRunActionFailed(ContractCompletedMessage ccm, int depth) {
        ResourceBundle msg = this.getErrorBundle();
        String depthStr = "";
        for (int i = 0; i < depth; ++i) {
            depthStr = depthStr + "   ";
        }
        ErrorInfo ei = ccm.getErrorInfo();
        ContractCompletedMessage[] ccms = ei.getContractCompletedMessages();
        if (ccms != null) {
            String desc = msg.getString("RunActionErrors.txt");
            this.output(depthStr + desc);
            int index = 1;
            for (int i = 0; i < ccms.length; ++i) {
                if (ccms[i].isTimeout()) {
                    String temp = msg.getString("RunActionErrors.Timeout.txt");
                    this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                    ++index;
                    continue;
                }
                if (!ccms[i].isError()) continue;
                ErrorInfo ei2 = ccms[i].getErrorInfo();
                String temp = ei2.getErrorMessage();
                temp = temp + "\n=> " + ei2.getErrorStackTrace();
                ContractCompletedMessage[] ccms2 = ei2.getContractCompletedMessages();
                if (ccms2 != null) {
                    temp = temp + "\n" + depthStr;
                    temp = temp + msg.getString("RunActionErrors.txt");
                    this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                    ++index;
                    int index2 = 1;
                    for (int j = 0; j < ccms2.length; ++j) {
                        int errorCount = this.handleTimeoutOrFailure(ccms2[j], depth + 1, index2);
                        if (errorCount <= 0) continue;
                        ++index2;
                    }
                    continue;
                }
                this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                ++index;
            }
        }
    }

    private void handleRunActionFailedPrintItem(ContractCompletedMessage ccm, int index, String text, String depthStr) {
        ResourceBundle msg = this.getErrorBundle();
        String desc = msg.getString("RunActionErrors.Item.fmt.txt");
        String provider = ccm.getHonorContractContext().getProviderName();
        String contract = ccm.getContract();
        if (contract == null) {
            contract = msg.getString("RunActionErrors.NoContract.txt");
        }
        desc = MessageFormat.format(desc, "" + index, provider, contract, text);
        this.output(depthStr + desc);
    }

    private int handleTimeoutOrFailure(ContractCompletedMessage msg, int depth, int index) {
        ResourceBundle errorMsg = this.getErrorBundle();
        String depthStr = "";
        for (int i = 0; i < depth; ++i) {
            depthStr = depthStr + "   ";
        }
        int errorCount = 0;
        if (msg.isTimeout()) {
            String desc = errorMsg.getString("DumpResults.Timeout.fmt.txt");
            desc = MessageFormat.format(desc, msg.getContract());
            String text = depthStr;
            if (index > 0) {
                text = text + index + ". ";
            }
            this.output(text + desc);
            this.output("");
            ++errorCount;
        } else if (msg.isError()) {
            ErrorInfo ei = msg.getErrorInfo();
            String errorMessage = ei.getErrorMessage();
            String type = ei.getErrorType();
            boolean output = false;
            if (errorMessage != null && type != null) {
                String text = depthStr;
                if (index > 0) {
                    text = text + index + ". ";
                }
                if (type.startsWith("com.sas.dpro.common.RunActionFailedException")) {
                    this.output(text + errorMessage);
                    this.handleRunActionFailed(msg, depth + 1);
                    output = true;
                }
            }
            if (!output) {
                this.output(depthStr + ei.getErrorStackTrace());
            }
            this.output("");
            ++errorCount;
        }
        return errorCount;
    }

    public void handleUnknownOption(String option) {
        ResourceBundle msg = this.getErrorBundle();
        String desc = msg.getString("UnknownOption.fmt.txt");
        desc = MessageFormat.format(desc, option);
        this.logger.severe(desc);
        this.output(desc);
    }

    public void handleUnspecifiedOption(String option) {
        ResourceBundle msg = this.getErrorBundle();
        String desc = msg.getString("UnspecifiedOption.fmt.txt");
        desc = MessageFormat.format(desc, option);
        this.logger.severe(desc);
        this.output(desc);
    }

    public void handleUnspecifiedUpdateOption(String option) {
        ResourceBundle msg = this.getErrorBundle();
        String desc = msg.getString("UnspecifiedUpdateOption.fmt.txt");
        desc = MessageFormat.format(desc, option);
        this.logger.severe(desc);
        this.output(desc);
    }

    private void logCompletedMessage(String method, int rc) {
        String desc = this.loggerMsg.getString("CallCompleted.fmt.txt");
        desc = MessageFormat.format(desc, method, "" + rc);
        this.logger.finest(desc);
    }

    private void output(String text) {
        System.out.println(text);
        if (this.out != null) {
            this.out.println(text);
        }
        this.logger.severe(text);
    }

    private int pingDProServer(String providerName, int seconds, boolean desiredAliveState) throws IOException {
        Provider localP = null;
        try {
            localP = ProviderFactory.getProvider("server-local");
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
            return 255;
        }
        CreateContainerContextParmsImpl ccp = new CreateContainerContextParmsImpl(this.getClientDPROVersion());
        ContainerContext cont = localP.createContainerContext(ccp);
        ServiceRequestParmsImpl srp = new ServiceRequestParmsImpl();
        srp.setClientDPROVersion(this.getClientDPROVersion());
        srp.setContainerContext(cont);
        srp.setFailIfFailure(true);
        srp.setFailIfTimeout(true);
        srp.setReturnServiceResults(true);
        srp.setServiceName("PingDProServer");
        SerializableHashMap serviceParms = new SerializableHashMap();
        serviceParms.put("server", providerName);
        ServiceParmsImpl sp = new ServiceParmsImpl();
        sp.params = serviceParms;
        srp.setServiceParameters(sp);
        srp.setTimeout(1000L);
        boolean alive = !desiredAliveState;
        int attempts = 0;
        while (alive != desiredAliveState && attempts < this.maxPingAttempts) {
            ++attempts;
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                String desc = this.loggerMsg.getString("PingAttempt.fmt.txt");
                desc = MessageFormat.format(desc, "" + attempts);
                this.logger.info(desc);
                ServiceResults sr = localP.serviceRequest(srp);
                int rc = sr.getReturnCode();
                alive = rc == 0;
            }
            catch (ServiceFailedException sfe) {
                sfe.printStackTrace();
            }
        }
        int rc = 0;
        String desc = null;
        if (alive == desiredAliveState) {
            desc = this.loggerMsg.getString(alive ? "ServerAvailable.txt" : "ServerShutDown.txt");
            this.logger.info(desc);
        } else {
            ResourceBundle errorMsg = this.getErrorBundle();
            if (alive) {
                rc = 6;
                desc = errorMsg.getString("ServerNotShutDown.txt");
            } else {
                rc = 7;
                desc = errorMsg.getString("ServerNotStarted.txt");
            }
            this.logger.severe(desc);
        }
        localP.closeContainer(cont);
        return rc;
    }

    public void printUsage() {
        String desc = this.loggerMsg.getString("Usage.txt");
        this.output(desc);
    }

    @Override
    public String promptForInput(InputPromptInfo info) throws IOException {
        throw new IOException("promptForInput is Unsupported");
    }

    public int runContract(String contract) {
        String desc = this.loggerMsg.getString("RunningContract.fmt.txt");
        desc = MessageFormat.format(desc, contract);
        this.logger.info(desc);
        HonorContractParmsImpl parms = new HonorContractParmsImpl();
        parms.setClientDPROVersion(this.getClientDPROVersion());
        parms.setContract(contract);
        parms.setMessageGranularity(2);
        parms.setOriginalContractSessionID(-1L);
        this.controller.honorContract(parms);
        Message message = null;
        String fmtStr = this.loggerMsg.getString("MessageReceived.fmt.txt");
        do {
            message = this.controller.getNextMessage();
            String temp = MessageFormat.format(fmtStr, message.toString());
            this.logger.severe(temp);
            if (!(message instanceof InfoMessage)) continue;
            InfoMessage im = (InfoMessage)message;
            this.logger.info(im.getMessage());
            this.output(im.getMessage());
        } while (!(message instanceof ContractCompletedMessage));
        ContractCompletedMessage ccm = (ContractCompletedMessage)message;
        if (ccm.isTimeout()) {
            ResourceBundle errorMsg = this.getErrorBundle();
            desc = errorMsg.getString("ContractTimedOut.fmt.txt");
            desc = MessageFormat.format(desc, contract);
            this.logger.severe(desc);
            this.output(desc);
            return 4;
        }
        if (ccm.isError()) {
            ErrorInfo info = ccm.getErrorInfo();
            ResourceBundle errorMsg = this.getErrorBundle();
            desc = errorMsg.getString("ContractFailed.fmt.txt");
            desc = MessageFormat.format(desc, contract, info.getErrorStackTrace());
            this.logger.severe(desc);
            this.output(info.getErrorStackTrace());
            String type = info.getErrorType();
            if (type.startsWith("com.sas.dpro.common.RunActionFailedException")) {
                this.handleTimeoutOrFailure(ccm, 0, 0);
            }
            return 3;
        }
        desc = this.loggerMsg.getString("DoneRunningContract.fmt.txt");
        desc = MessageFormat.format(desc, contract);
        this.logger.info(desc);
        return 0;
    }

    public int runExtraContracts() {
        for (String contract : this.extraContracts) {
            int rc = this.runContract(contract);
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }

    public void setMaxPingAttempts(int maxPingAttempts) {
        this.maxPingAttempts = maxPingAttempts;
        String desc = this.loggerMsg.getString("Setting.MaxPingAttempts.fmt.txt");
        desc = MessageFormat.format(desc, "" + maxPingAttempts);
        this.logger.info(desc);
    }

    private void setOutputFile(String fileName) {
        if (fileName == null) {
            this.out = null;
        } else {
            try {
                this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.out = null;
            }
        }
    }

    @Override
    public void showReport(ShowReportMessage srm, ReportInfo ri) throws IOException, UnsupportedOperationException {
        ResourceBundle msg = this.getErrorBundle();
        String key = "Error.ShowingReportsUnsupported.txt";
        String desc = msg.getString(key);
        throw new UnsupportedOperationException(desc);
    }

    public int startServer(String installDir, int port, boolean doWait) throws IOException {
        block14: {
            String desc = this.loggerMsg.getString("StartingServer.fmt.txt");
            desc = MessageFormat.format(desc, installDir, "" + port);
            this.logger.info(desc);
            String[] cmdArray = null;
            cmdArray = DProUtil.osIsWindows() ? new String[]{"Admin\\bin\\DeploymentTesterServer.bat"} : new String[]{"Admin/bin/DeploymentTesterServer.sh", "start"};
            File temp = new File(installDir, cmdArray[0]);
            cmdArray[0] = temp.getAbsolutePath();
            desc = this.loggerMsg.getString("ServerStartupCommand.fmt.txt");
            String command = ExternalProcessUtil.createCommandString(cmdArray);
            desc = MessageFormat.format(desc, command);
            this.logger.info(desc);
            Process proc = null;
            ProcessBuilder pb = new ProcessBuilder(cmdArray);
            pb.directory(new File(installDir));
            pb.redirectErrorStream(true);
            StringWriter sw = null;
            try (PrintWriter outputWriter = null;){
                desc = DProUtil.formatString(this.loggerMsg, "LaunchingStartupProcess.fmt.txt", pb.directory().getAbsolutePath());
                this.logger.info(desc);
                boolean isWindows = DProUtil.osIsWindows();
                if (doWait && !isWindows) {
                    desc = this.loggerMsg.getString("Waiting.txt");
                    this.logger.info(desc);
                    sw = new StringWriter();
                    outputWriter = new PrintWriter(sw);
                }
                proc = pb.start();
                if (doWait) {
                    if (isWindows) {
                        desc = this.loggerMsg.getString("NotWaiting.Windows.txt");
                        this.logger.info(desc);
                        break block14;
                    }
                    int rc = -1;
                    try {
                        rc = ExternalProcessUtil.waitFor(proc, outputWriter, outputWriter, null, null);
                    }
                    catch (IOException ioe) {
                        proc.destroy();
                        throw ioe;
                    }
                    catch (Exception e) {
                        proc.destroy();
                        throw new IOException(e.getMessage());
                    }
                    desc = this.loggerMsg.getString("WaitingComplete.rc.fmt.txt");
                    desc = MessageFormat.format(desc, "" + rc);
                    this.output(desc);
                    desc = this.loggerMsg.getString("WaitingComplete.output.fmt.txt");
                    desc = MessageFormat.format(desc, sw.toString());
                    this.output(desc);
                    break block14;
                }
                desc = this.loggerMsg.getString("NotWaiting.Unspecified.txt");
                this.logger.info(desc);
            }
        }
        String host = LOCALHOST;
        String providerName = ProviderFactory.createProviderName(host, port);
        int rc = this.pingDProServer(providerName, 8, true);
        return rc;
    }

    public int stopServer(int port) throws IOException {
        String desc = this.loggerMsg.getString("StoppingServer.fmt.txt");
        desc = MessageFormat.format(desc, "" + port);
        this.logger.info(desc);
        String host = LOCALHOST;
        String providerName = ProviderFactory.createProviderName(host, port);
        Provider p = null;
        try {
            p = ProviderFactory.getProvider(providerName);
        }
        catch (ProviderNotAvailableException pnae) {
            desc = this.loggerMsg.getString("ServerAlreadyDown.txt");
            this.logger.info(desc);
            return 0;
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
            return 255;
        }
        try {
            p.shutdownServer();
            ResourceBundle errorMsg = this.getErrorBundle();
            desc = errorMsg.getString("ErrorShuttingDownServer.fmt.txt");
            desc = MessageFormat.format(desc, providerName, null);
            this.output(desc);
            return 255;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void main(String[] args) {
        String desc;
        Updater updater = new Updater();
        boolean restart = false;
        int sleepBeforeRestart = -1;
        int port = -1;
        int maxPingAttempts = -1;
        boolean doWait = false;
        boolean doUpdates = false;
        String installToUpdateDir = null;
        String updatesDir = null;
        boolean deleteOldInstall = false;
        for (int i = 0; i < args.length; ++i) {
            if (ARG_DELETE_OLD_INSTALL.equals(args[i])) {
                deleteOldInstall = true;
                updater.logger.finest("-deleteOldInstall specified");
                continue;
            }
            if (ARG_EXTRA_CONTRACTS.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_EXTRA_CONTRACTS);
                    updater.cleanupAndExit(2);
                }
                updater.addExtraContract(args[i++]);
                while (i < args.length && args[i].charAt(0) != '-') {
                    updater.addExtraContract(args[i++]);
                    updater.logger.finest("Extra contract to run: " + args[i - 1]);
                }
                --i;
                continue;
            }
            if (ARG_INSTALL_TO_UPDATE_DIR.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_INSTALL_TO_UPDATE_DIR);
                    updater.cleanupAndExit(2);
                }
                installToUpdateDir = args[i];
                updater.logger.finest("-installToUpdateDir " + args[i] + " specified");
                continue;
            }
            if (ARG_LOGGING_LEVEL.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_LOGGING_LEVEL);
                    updater.cleanupAndExit(2);
                }
                Level level = Level.parse(args[i]);
                updater.setLoggingLevel(level);
                updater.logger.finest("-loggingLevel " + args[i] + " specified");
                continue;
            }
            if (ARG_OUTPUT.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_OUTPUT);
                    updater.cleanupAndExit(2);
                }
                updater.setOutputFile(args[i]);
                updater.logger.finest("-output " + args[i] + " specified");
                continue;
            }
            if (ARG_PING_ATTEMPTS.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_PING_ATTEMPTS);
                    updater.cleanupAndExit(2);
                }
                try {
                    maxPingAttempts = Integer.parseInt(args[i]);
                    if (maxPingAttempts < 0 || maxPingAttempts > 99999) {
                        throw new NumberFormatException();
                    }
                    updater.logger.finest("-pingAttempts " + maxPingAttempts + " specified");
                }
                catch (NumberFormatException nfe) {
                    updater.handleInvalidOptionValue(ARG_PING_ATTEMPTS, args[i]);
                    updater.cleanupAndExit(2);
                }
                continue;
            }
            if (ARG_PORT.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_PORT);
                    updater.cleanupAndExit(2);
                }
                try {
                    port = Integer.parseInt(args[i]);
                    updater.logger.finest("-port " + port + " specified");
                }
                catch (NumberFormatException nfe) {
                    updater.handleInvalidOptionValue(ARG_PORT, args[i]);
                    updater.cleanupAndExit(2);
                }
                continue;
            }
            if (ARG_RESTART.equals(args[i])) {
                updater.logger.finest("-restart specified");
                restart = true;
                continue;
            }
            if (ARG_SLEEP_BEFORE_RESTART.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_SLEEP_BEFORE_RESTART);
                    updater.cleanupAndExit(2);
                }
                sleepBeforeRestart = Integer.parseInt(args[i]);
                updater.logger.finest("-sleepBeforeRestart " + sleepBeforeRestart + " specified");
                restart = true;
                continue;
            }
            if (ARG_UPDATE.equals(args[i])) {
                updater.logger.finest("-update specified");
                doUpdates = true;
                continue;
            }
            if (ARG_UPDATES_DIR.equals(args[i])) {
                if (++i == args.length) {
                    updater.handleUnspecifiedOption(ARG_UPDATES_DIR);
                    updater.cleanupAndExit(2);
                }
                updatesDir = args[i];
                updater.logger.finest("-updatesDir " + updatesDir + " specified");
                continue;
            }
            if (ARG_USAGE.equals(args[i]) || ARG_HELP.equals(args[i])) {
                updater.printUsage();
                updater.cleanupAndExit(1);
                continue;
            }
            if (args[i].startsWith("-V") && args[i].indexOf(61) > -1) {
                int equalIndex = args[i].indexOf(61);
                String var = args[i].substring(2, equalIndex);
                String value = args[i].substring(equalIndex + 1);
                desc = updater.loggerMsg.getString("Setting.Variable.fmt.txt");
                desc = MessageFormat.format(desc, var, value);
                updater.logger.info(desc);
                updater.controller.setGlobalVariableValue(var, value);
                continue;
            }
            updater.handleUnknownOption(args[i]);
            updater.cleanupAndExit(2);
        }
        if (port == -1) {
            updater.handleUnspecifiedOption(ARG_PORT);
            updater.cleanupAndExit(2);
        }
        if (maxPingAttempts != -1) {
            updater.setMaxPingAttempts(maxPingAttempts);
        }
        if (doUpdates) {
            if (installToUpdateDir == null) {
                updater.handleUnspecifiedUpdateOption(ARG_INSTALL_TO_UPDATE_DIR);
                updater.cleanupAndExit(2);
            }
            if (updatesDir == null) {
                updater.handleUnspecifiedUpdateOption(ARG_UPDATES_DIR);
                updater.cleanupAndExit(2);
            }
            updater.controller.setGlobalVariableValue("installToUpdateDir", installToUpdateDir);
            updater.controller.setGlobalVariableValue("updatesDir", updatesDir);
            updater.controller.setGlobalVariableValue("deleteOldInstall", "" + deleteOldInstall);
        }
        int rc = 255;
        try {
            rc = updater.stopServer(port);
            updater.logCompletedMessage("stopServer(" + port + ')', rc);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            rc = 8;
        }
        if (rc == 0 && doUpdates) {
            String method = "runContract(Contract/updater/UpdateDPROInstall_contract.xml)";
            try {
                rc = updater.runContract(CONTRACT_UPDATE_DPRO_INSTALL);
                updater.logCompletedMessage(method, rc);
            }
            catch (Exception e) {
                ResourceBundle errorMsg = updater.getErrorBundle();
                desc = errorMsg.getString("UnhandledError.fmt.txt");
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                desc = MessageFormat.format(desc, method, text);
                updater.output(desc);
                rc = 255;
            }
        }
        if (rc == 0) {
            rc = updater.runExtraContracts();
            updater.logCompletedMessage("runExtraContracts()", rc);
        }
        if (rc == 0 && sleepBeforeRestart > 0) {
            updater.logger.info("Sleeping for " + sleepBeforeRestart + " seconds before restarting...");
            try {
                Thread.sleep(sleepBeforeRestart * 1000);
            }
            catch (InterruptedException ie) {
                updater.logger.log(Level.SEVERE, "Interrupted while sleeping", ie);
            }
        }
        if (restart && rc == 0) {
            try {
                rc = updater.startServer(installToUpdateDir, port, doWait);
                updater.logCompletedMessage("startServer(" + installToUpdateDir + ',' + port + ')', rc);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                rc = 8;
            }
        }
        updater.cleanupAndExit(rc);
    }
}

