/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.CreateContainerContextParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.provider.UpdatesRequestError;
import com.sas.dpro.provider.UpdatesRequestParmsImpl;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Update
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Update";
    public static final String PARAM_CLEAN_UPDATES = "clean";
    public static final String PARAM_DO_UPDATES = "doUpdates";
    public static final String PARAM_MAX_PING_ATTEMPTS = "maxPingAttempts";
    public static final String PARAM_RESTART = "restart";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_UPDATE_FILES = "_updateFiles";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.standard.Update.debug";
    private static final String MSG = "com.sas.dpro.service.standard.Update";

    public Update() {
        super(SERVICE_NAME);
    }

    private void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            System.err.println("[DEBUG Update]: " + text);
        }
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        this.debugPrint("runServiceImpl: Entering");
        String providerName = (String)this.getParameter(PARAM_SERVER);
        String pingAttemptsStr = (String)this.getParameter(PARAM_MAX_PING_ATTEMPTS);
        boolean restart = this.getBooleanParameter(PARAM_RESTART, false);
        boolean doUpdates = this.getBooleanParameter(PARAM_DO_UPDATES, false);
        boolean cleanUpdates = this.getBooleanParameter(PARAM_CLEAN_UPDATES, true);
        FileList updateFiles = (FileList)this.getParameter(PARAM_UPDATE_FILES);
        int maxPingAttempts = 3;
        if (pingAttemptsStr != null) {
            try {
                maxPingAttempts = Integer.parseInt(pingAttemptsStr);
                if (maxPingAttempts <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.InvalidPingAttempt.fmt.txt");
                desc = MessageFormat.format(desc, this.getName(), pingAttemptsStr);
                throw new ServiceFailedException(desc, nfe);
            }
        }
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            this.debugPrint("... server: " + providerName);
            this.debugPrint("... ping attempts: " + pingAttemptsStr);
            this.debugPrint("... restart: " + restart);
            this.debugPrint("... doUpdates: " + doUpdates);
            this.debugPrint("... clean: " + cleanUpdates);
            this.debugPrint("... files:");
            if (updateFiles == null) {
                this.debugPrint("... ... null");
            } else {
                for (int i = 0; i < updateFiles.getSize(); ++i) {
                    this.debugPrint("... ... " + (i + 1) + ". " + updateFiles.get(i));
                }
            }
        }
        try {
            Provider p = ProviderFactory.getProvider(providerName);
            String dproVersion = DProUtil.getLocalDPROVersion();
            ContainerContext updatesCC = null;
            if (doUpdates) {
                FileListImpl flTemp = new FileListImpl(updateFiles.getRoot(), updateFiles.getProvider(), updateFiles.getID());
                flTemp.add("UpdateApplyOrder.txt");
                String updatesPrefix = "updates/";
                try {
                    this.debugPrint("... Creating UpdateApplyOrder.txt");
                    File updateOrderFile = new File(container.getDirectory(), "UpdateApplyOrder.txt");
                    PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(updateOrderFile), "UTF-8")));
                    for (int i = 0; i < updateFiles.getSize(); ++i) {
                        w.println(updatesPrefix + updateFiles.get(i));
                    }
                    w.close();
                }
                catch (IOException ioe) {
                    ResourceBundle msg = this.getErrorBundle();
                    String desc = msg.getString("Error.WritingUpdateOrderFile.fmt.txt");
                    String temp = ioe.getMessage();
                    if (temp == null) {
                        temp = ioe.toString();
                    }
                    desc = MessageFormat.format(desc, temp);
                    throw new ServiceFailedException(desc, ioe);
                }
                this.debugPrint("... Creating DPRO_Updates.zip");
                Provider localP = ProviderFactory.getProvider(null);
                ServiceRequestParmsImpl parms = new ServiceRequestParmsImpl();
                parms.setClientDPROVersion(dproVersion);
                parms.setContainerContext(container);
                parms.setFailIfFailure(true);
                parms.setFailIfTimeout(true);
                parms.setReturnServiceResults(false);
                parms.setServiceName("Zip");
                SerializableHashMap sm = new SerializableHashMap();
                sm.put("destFile", "DPRO_Updates.zip");
                sm.put("_fileLists", new FileList[]{flTemp, updateFiles});
                sm.put("_fileListPrefixes", new String[]{null, updatesPrefix});
                ServiceParmsImpl sp = new ServiceParmsImpl();
                sp.params = sm;
                parms.setServiceParameters(sp);
                parms.setTimeout(-1L);
                localP.serviceRequest(parms);
                this.debugPrint("... Creating container on remote Provider");
                CreateContainerContextParmsImpl cccp = new CreateContainerContextParmsImpl();
                cccp.setClientDPROVersion(dproVersion);
                cccp.setContractID("_updatesTemp");
                cccp.setContractSessionID(0L);
                cccp.setDirectory(null);
                updatesCC = p.createContainerContext(cccp);
                this.debugPrint("... Moving DPRO_Updates.zip to container on remote Provider");
                parms = new ServiceRequestParmsImpl();
                parms.setClientDPROVersion(dproVersion);
                parms.setContainerContext(container);
                parms.setFailIfFailure(true);
                parms.setFailIfTimeout(true);
                parms.setReturnServiceResults(false);
                parms.setServiceName("Copy");
                sm = new SerializableHashMap();
                sm.put("fromFile", "DPRO_Updates.zip");
                sm.put("toDir", ".");
                sm.put("toContainer", updatesCC);
                sm.put("move", "true");
                sm.put("failIfFilesDontExist", "true");
                sm.put("ignorePaths", "false");
                sp = new ServiceParmsImpl();
                sp.params = sm;
                parms.setServiceParameters(sp);
                parms.setTimeout(-1L);
                localP.serviceRequest(parms);
            }
            UpdatesRequestParmsImpl urp = new UpdatesRequestParmsImpl(dproVersion);
            urp.setMaxPingAttempts(maxPingAttempts);
            urp.setRemoveOldInstallWhenUpdating(cleanUpdates);
            urp.setRestartServer(restart);
            urp.setUpdateContainerContext(updatesCC);
            this.debugPrint("... Sending Provider a \"install updates\" request");
            this.debugPrint("... Data: " + ((Object)urp).toString());
            UpdatesRequestError urr = p.installUpdates(urp);
            if (urr != null) {
                this.debugPrint("... Error occurred installing updates!");
                String desc = null;
                ResourceBundle msg = this.getErrorBundle();
                switch (urr.getUpdatesNotInstalledReason()) {
                    case 0: {
                        String key = "Error.AlreadyShuttingDown.fmt.txt";
                        desc = DProUtil.formatString(msg, key, this.getName(), providerName);
                        break;
                    }
                    case 1: {
                        String key = "Error.ShutdownDisabled.fmt.txt";
                        desc = DProUtil.formatString(msg, key, this.getName(), providerName);
                        break;
                    }
                    default: {
                        String key = "Error.Unknown.fmt.txt";
                        desc = DProUtil.formatString(msg, key, this.getName(), providerName, urr.getUnknownErrorDesc());
                    }
                }
                this.debugPrint("... ... Description: " + desc);
                throw new ServiceFailedException(desc);
            }
            this.debugPrint("... ... (!) p.installUpdates() returned null!");
        }
        catch (InvalidProviderNameException ipne) {
            String desc = this.getErrorBundle().getString("Error.InvalidProviderName.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), providerName);
            throw new ServiceFailedException(desc, ipne);
        }
        catch (RemoteException re) {
            this.debugPrint("... Remote exception (should be stating server went down)");
            this.debugPrint("... ... " + re.getMessage());
        }
        this.debugPrint("runServiceImpl: Exiting");
        ServiceInfo info = this.createServiceInfo();
        ServiceResultsImpl res = new ServiceResultsImpl(info, container);
        return res;
    }
}

