/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Sleep
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Sleep";
    public static final String PARAM_HOURS = "hours";
    public static final String PARAM_MILLISECONDS = "milliseconds";
    public static final String PARAM_MINUTES = "minutes";
    public static final String PARAM_SECONDS = "seconds";
    public static final String PARAM_FAIL_ON_ERROR = "failOnError";
    private static final String MSG = "com.sas.dpro.service.standard.Sleep";

    public Sleep() {
        super(SERVICE_NAME);
    }

    private ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    private long getIntegerValue(String param) throws ServiceFailedException {
        long val = 0L;
        String strVal = (String)this.getParameter(param);
        if (strVal != null) {
            try {
                val = Long.parseLong(strVal);
                if (val < 0L) {
                    ResourceBundle msg = this.getErrorBundle();
                    String desc = msg.getString("Error.IntegerExpected.fmt.txt");
                    desc = MessageFormat.format(desc, param);
                    throw new ServiceFailedException(desc);
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.IntegerExpected.fmt.txt");
                desc = MessageFormat.format(desc, param);
                throw new ServiceFailedException(desc);
            }
        }
        return val;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        block2: {
            long sleepTime = 0L;
            sleepTime += this.getIntegerValue(PARAM_MILLISECONDS);
            sleepTime += this.getIntegerValue(PARAM_SECONDS) * 1000L;
            sleepTime += this.getIntegerValue(PARAM_MINUTES) * 1000L * 60L;
            sleepTime += this.getIntegerValue(PARAM_HOURS) * 1000L * 60L * 60L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {
                if (!this.getBooleanParameter(PARAM_FAIL_ON_ERROR, false)) break block2;
                ResourceBundle msg = this.getErrorBundle();
                String desc = msg.getString("Error.Interrupted.txt");
                throw new ServiceFailedException(desc, ie);
            }
        }
        int rc = 0;
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, rc);
        return results;
    }
}

